/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.compat.annotation.UnsupportedAppUsage;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.Spanned;
import java.lang.reflect.Array;
import java.util.Arrays;

@RavenwoodKeepWholeClass
public class SpanSet<E> {
    private final Class<? extends E> classType;
    int numberOfSpans;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    E[] spans;
    int[] spanStarts;
    int[] spanEnds;
    int[] spanFlags;

    SpanSet(Class<? extends E> type) {
        this.classType = type;
        this.numberOfSpans = 0;
    }

    public void init(Spanned spanned, int start, int limit) {
        E[] allSpans = spanned.getSpans(start, limit, this.classType);
        int length = allSpans.length;
        if (length > 0 && (this.spans == null || this.spans.length < length)) {
            this.spans = (Object[])Array.newInstance(this.classType, length);
            this.spanStarts = new int[length];
            this.spanEnds = new int[length];
            this.spanFlags = new int[length];
        }
        int prevNumberOfSpans = this.numberOfSpans;
        this.numberOfSpans = 0;
        for (int i = 0; i < length; ++i) {
            int spanEnd;
            E span = allSpans[i];
            int spanStart = spanned.getSpanStart(span);
            if (spanStart == (spanEnd = spanned.getSpanEnd(span))) continue;
            int spanFlag = spanned.getSpanFlags(span);
            this.spans[this.numberOfSpans] = span;
            this.spanStarts[this.numberOfSpans] = spanStart;
            this.spanEnds[this.numberOfSpans] = spanEnd;
            this.spanFlags[this.numberOfSpans] = spanFlag;
            ++this.numberOfSpans;
        }
        if (this.numberOfSpans < prevNumberOfSpans) {
            Arrays.fill(this.spans, this.numberOfSpans, prevNumberOfSpans, null);
        }
    }

    public boolean hasSpansIntersecting(int start, int end) {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            if (this.spanStarts[i] >= end || this.spanEnds[i] <= start) continue;
            return true;
        }
        return false;
    }

    int getNextTransition(int start, int limit) {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            int spanStart = this.spanStarts[i];
            int spanEnd = this.spanEnds[i];
            if (spanStart > start && spanStart < limit) {
                limit = spanStart;
            }
            if (spanEnd <= start || spanEnd >= limit) continue;
            limit = spanEnd;
        }
        return limit;
    }

    public void recycle() {
        if (this.spans != null) {
            Arrays.fill(this.spans, 0, this.numberOfSpans, null);
        }
    }
}

