/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.NonNull;
import android.annotation.SystemApi;

@SystemApi
public class EnableRequestAttributes {
    private boolean mIsEnabled;
    private boolean mIsDemoMode;
    private boolean mIsEmergencyMode;

    private EnableRequestAttributes(@NonNull Builder builder) {
        this.mIsEnabled = builder.mIsEnabled;
        this.mIsDemoMode = builder.mIsDemoMode;
        this.mIsEmergencyMode = builder.mIsEmergencyMode;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isDemoMode() {
        return this.mIsDemoMode;
    }

    public boolean isEmergencyMode() {
        return this.mIsEmergencyMode;
    }

    public static class Builder {
        private boolean mIsEnabled;
        private boolean mIsDemoMode = false;
        private boolean mIsEmergencyMode = false;

        public Builder(boolean isEnabled) {
            this.mIsEnabled = isEnabled;
        }

        @NonNull
        public Builder setDemoMode(boolean isDemoMode) {
            if (this.mIsEnabled) {
                this.mIsDemoMode = isDemoMode;
            }
            return this;
        }

        @NonNull
        public Builder setEmergencyMode(boolean isEmergencyMode) {
            if (this.mIsEnabled) {
                this.mIsEmergencyMode = isEmergencyMode;
            }
            return this;
        }

        @NonNull
        public EnableRequestAttributes build() {
            return new EnableRequestAttributes(this);
        }
    }
}

