/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsRegistrationCallback;

public interface IImsRegistration
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsRegistration";

    public int getRegistrationTechnology() throws RemoteException;

    public void addRegistrationCallback(IImsRegistrationCallback var1) throws RemoteException;

    public void removeRegistrationCallback(IImsRegistrationCallback var1) throws RemoteException;

    public void addEmergencyRegistrationCallback(IImsRegistrationCallback var1) throws RemoteException;

    public void removeEmergencyRegistrationCallback(IImsRegistrationCallback var1) throws RemoteException;

    public void triggerFullNetworkRegistration(int var1, String var2) throws RemoteException;

    public void triggerUpdateSipDelegateRegistration() throws RemoteException;

    public void triggerSipDelegateDeregistration() throws RemoteException;

    public void triggerDeregistration(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsRegistration {
        static final int TRANSACTION_getRegistrationTechnology = 1;
        static final int TRANSACTION_addRegistrationCallback = 2;
        static final int TRANSACTION_removeRegistrationCallback = 3;
        static final int TRANSACTION_addEmergencyRegistrationCallback = 4;
        static final int TRANSACTION_removeEmergencyRegistrationCallback = 5;
        static final int TRANSACTION_triggerFullNetworkRegistration = 6;
        static final int TRANSACTION_triggerUpdateSipDelegateRegistration = 7;
        static final int TRANSACTION_triggerSipDelegateDeregistration = 8;
        static final int TRANSACTION_triggerDeregistration = 9;

        public Stub() {
            this.attachInterface(this, IImsRegistration.DESCRIPTOR);
        }

        public static IImsRegistration asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsRegistration.DESCRIPTOR);
            if (iin != null && iin instanceof IImsRegistration) {
                return (IImsRegistration)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getRegistrationTechnology";
                }
                case 2: {
                    return "addRegistrationCallback";
                }
                case 3: {
                    return "removeRegistrationCallback";
                }
                case 4: {
                    return "addEmergencyRegistrationCallback";
                }
                case 5: {
                    return "removeEmergencyRegistrationCallback";
                }
                case 6: {
                    return "triggerFullNetworkRegistration";
                }
                case 7: {
                    return "triggerUpdateSipDelegateRegistration";
                }
                case 8: {
                    return "triggerSipDelegateDeregistration";
                }
                case 9: {
                    return "triggerDeregistration";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsRegistration.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _result = this.getRegistrationTechnology();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    IImsRegistrationCallback _arg0 = IImsRegistrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addRegistrationCallback(_arg0);
                    break;
                }
                case 3: {
                    IImsRegistrationCallback _arg0 = IImsRegistrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeRegistrationCallback(_arg0);
                    break;
                }
                case 4: {
                    IImsRegistrationCallback _arg0 = IImsRegistrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addEmergencyRegistrationCallback(_arg0);
                    break;
                }
                case 5: {
                    IImsRegistrationCallback _arg0 = IImsRegistrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeEmergencyRegistrationCallback(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.triggerFullNetworkRegistration(_arg0, _arg1);
                    break;
                }
                case 7: {
                    this.triggerUpdateSipDelegateRegistration();
                    break;
                }
                case 8: {
                    this.triggerSipDelegateDeregistration();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.triggerDeregistration(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IImsRegistration {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsRegistration.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRegistrationTechnology() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeStrongInterface(c);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeStrongInterface(c);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeStrongInterface(c);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeStrongInterface(c);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerFullNetworkRegistration(int sipCode, String sipReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeInt(sipCode);
                    _data.writeString(sipReason);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void triggerUpdateSipDelegateRegistration() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void triggerSipDelegateDeregistration() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerDeregistration(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsRegistration.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsRegistration {
        @Override
        public int getRegistrationTechnology() throws RemoteException {
            return 0;
        }

        @Override
        public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        }

        @Override
        public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        }

        @Override
        public void addEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        }

        @Override
        public void removeEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        }

        @Override
        public void triggerFullNetworkRegistration(int sipCode, String sipReason) throws RemoteException {
        }

        @Override
        public void triggerUpdateSipDelegateRegistration() throws RemoteException {
        }

        @Override
        public void triggerSipDelegateDeregistration() throws RemoteException {
        }

        @Override
        public void triggerDeregistration(int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

