/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.CallQuality;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsConferenceState;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.ImsSuppServiceNotification;
import android.telephony.ims.RtpHeaderExtension;
import com.android.ims.internal.IImsCallSession;
import java.util.ArrayList;
import java.util.List;

public interface IImsCallSessionListener
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsCallSessionListener";

    public void callSessionInitiating(ImsCallProfile var1) throws RemoteException;

    public void callSessionInitiatingFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionProgressing(ImsStreamMediaProfile var1) throws RemoteException;

    public void callSessionInitiated(ImsCallProfile var1) throws RemoteException;

    public void callSessionInitiatedFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionTerminated(ImsReasonInfo var1) throws RemoteException;

    public void callSessionHeld(ImsCallProfile var1) throws RemoteException;

    public void callSessionHoldFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionHoldReceived(ImsCallProfile var1) throws RemoteException;

    public void callSessionResumed(ImsCallProfile var1) throws RemoteException;

    public void callSessionResumeFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionResumeReceived(ImsCallProfile var1) throws RemoteException;

    public void callSessionMergeStarted(IImsCallSession var1, ImsCallProfile var2) throws RemoteException;

    public void callSessionMergeComplete(IImsCallSession var1) throws RemoteException;

    public void callSessionMergeFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionUpdated(ImsCallProfile var1) throws RemoteException;

    public void callSessionUpdateFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionUpdateReceived(ImsCallProfile var1) throws RemoteException;

    public void callSessionConferenceExtended(IImsCallSession var1, ImsCallProfile var2) throws RemoteException;

    public void callSessionConferenceExtendFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionConferenceExtendReceived(IImsCallSession var1, ImsCallProfile var2) throws RemoteException;

    public void callSessionInviteParticipantsRequestDelivered() throws RemoteException;

    public void callSessionInviteParticipantsRequestFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionRemoveParticipantsRequestDelivered() throws RemoteException;

    public void callSessionRemoveParticipantsRequestFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionConferenceStateUpdated(ImsConferenceState var1) throws RemoteException;

    public void callSessionUssdMessageReceived(int var1, String var2) throws RemoteException;

    public void callSessionHandover(int var1, int var2, ImsReasonInfo var3) throws RemoteException;

    public void callSessionHandoverFailed(int var1, int var2, ImsReasonInfo var3) throws RemoteException;

    public void callSessionMayHandover(int var1, int var2) throws RemoteException;

    public void callSessionTtyModeReceived(int var1) throws RemoteException;

    public void callSessionMultipartyStateChanged(boolean var1) throws RemoteException;

    public void callSessionSuppServiceReceived(ImsSuppServiceNotification var1) throws RemoteException;

    public void callSessionRttModifyRequestReceived(ImsCallProfile var1) throws RemoteException;

    public void callSessionRttModifyResponseReceived(int var1) throws RemoteException;

    public void callSessionRttMessageReceived(String var1) throws RemoteException;

    public void callSessionRttAudioIndicatorChanged(ImsStreamMediaProfile var1) throws RemoteException;

    public void callSessionTransferred() throws RemoteException;

    public void callSessionTransferFailed(ImsReasonInfo var1) throws RemoteException;

    public void callSessionDtmfReceived(char var1) throws RemoteException;

    public void callQualityChanged(CallQuality var1) throws RemoteException;

    public void callSessionRtpHeaderExtensionsReceived(List<RtpHeaderExtension> var1) throws RemoteException;

    public void callSessionSendAnbrQuery(int var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsCallSessionListener {
        static final int TRANSACTION_callSessionInitiating = 1;
        static final int TRANSACTION_callSessionInitiatingFailed = 2;
        static final int TRANSACTION_callSessionProgressing = 3;
        static final int TRANSACTION_callSessionInitiated = 4;
        static final int TRANSACTION_callSessionInitiatedFailed = 5;
        static final int TRANSACTION_callSessionTerminated = 6;
        static final int TRANSACTION_callSessionHeld = 7;
        static final int TRANSACTION_callSessionHoldFailed = 8;
        static final int TRANSACTION_callSessionHoldReceived = 9;
        static final int TRANSACTION_callSessionResumed = 10;
        static final int TRANSACTION_callSessionResumeFailed = 11;
        static final int TRANSACTION_callSessionResumeReceived = 12;
        static final int TRANSACTION_callSessionMergeStarted = 13;
        static final int TRANSACTION_callSessionMergeComplete = 14;
        static final int TRANSACTION_callSessionMergeFailed = 15;
        static final int TRANSACTION_callSessionUpdated = 16;
        static final int TRANSACTION_callSessionUpdateFailed = 17;
        static final int TRANSACTION_callSessionUpdateReceived = 18;
        static final int TRANSACTION_callSessionConferenceExtended = 19;
        static final int TRANSACTION_callSessionConferenceExtendFailed = 20;
        static final int TRANSACTION_callSessionConferenceExtendReceived = 21;
        static final int TRANSACTION_callSessionInviteParticipantsRequestDelivered = 22;
        static final int TRANSACTION_callSessionInviteParticipantsRequestFailed = 23;
        static final int TRANSACTION_callSessionRemoveParticipantsRequestDelivered = 24;
        static final int TRANSACTION_callSessionRemoveParticipantsRequestFailed = 25;
        static final int TRANSACTION_callSessionConferenceStateUpdated = 26;
        static final int TRANSACTION_callSessionUssdMessageReceived = 27;
        static final int TRANSACTION_callSessionHandover = 28;
        static final int TRANSACTION_callSessionHandoverFailed = 29;
        static final int TRANSACTION_callSessionMayHandover = 30;
        static final int TRANSACTION_callSessionTtyModeReceived = 31;
        static final int TRANSACTION_callSessionMultipartyStateChanged = 32;
        static final int TRANSACTION_callSessionSuppServiceReceived = 33;
        static final int TRANSACTION_callSessionRttModifyRequestReceived = 34;
        static final int TRANSACTION_callSessionRttModifyResponseReceived = 35;
        static final int TRANSACTION_callSessionRttMessageReceived = 36;
        static final int TRANSACTION_callSessionRttAudioIndicatorChanged = 37;
        static final int TRANSACTION_callSessionTransferred = 38;
        static final int TRANSACTION_callSessionTransferFailed = 39;
        static final int TRANSACTION_callSessionDtmfReceived = 40;
        static final int TRANSACTION_callQualityChanged = 41;
        static final int TRANSACTION_callSessionRtpHeaderExtensionsReceived = 42;
        static final int TRANSACTION_callSessionSendAnbrQuery = 43;

        public Stub() {
            this.attachInterface(this, IImsCallSessionListener.DESCRIPTOR);
        }

        public static IImsCallSessionListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsCallSessionListener.DESCRIPTOR);
            if (iin != null && iin instanceof IImsCallSessionListener) {
                return (IImsCallSessionListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "callSessionInitiating";
                }
                case 2: {
                    return "callSessionInitiatingFailed";
                }
                case 3: {
                    return "callSessionProgressing";
                }
                case 4: {
                    return "callSessionInitiated";
                }
                case 5: {
                    return "callSessionInitiatedFailed";
                }
                case 6: {
                    return "callSessionTerminated";
                }
                case 7: {
                    return "callSessionHeld";
                }
                case 8: {
                    return "callSessionHoldFailed";
                }
                case 9: {
                    return "callSessionHoldReceived";
                }
                case 10: {
                    return "callSessionResumed";
                }
                case 11: {
                    return "callSessionResumeFailed";
                }
                case 12: {
                    return "callSessionResumeReceived";
                }
                case 13: {
                    return "callSessionMergeStarted";
                }
                case 14: {
                    return "callSessionMergeComplete";
                }
                case 15: {
                    return "callSessionMergeFailed";
                }
                case 16: {
                    return "callSessionUpdated";
                }
                case 17: {
                    return "callSessionUpdateFailed";
                }
                case 18: {
                    return "callSessionUpdateReceived";
                }
                case 19: {
                    return "callSessionConferenceExtended";
                }
                case 20: {
                    return "callSessionConferenceExtendFailed";
                }
                case 21: {
                    return "callSessionConferenceExtendReceived";
                }
                case 22: {
                    return "callSessionInviteParticipantsRequestDelivered";
                }
                case 23: {
                    return "callSessionInviteParticipantsRequestFailed";
                }
                case 24: {
                    return "callSessionRemoveParticipantsRequestDelivered";
                }
                case 25: {
                    return "callSessionRemoveParticipantsRequestFailed";
                }
                case 26: {
                    return "callSessionConferenceStateUpdated";
                }
                case 27: {
                    return "callSessionUssdMessageReceived";
                }
                case 28: {
                    return "callSessionHandover";
                }
                case 29: {
                    return "callSessionHandoverFailed";
                }
                case 30: {
                    return "callSessionMayHandover";
                }
                case 31: {
                    return "callSessionTtyModeReceived";
                }
                case 32: {
                    return "callSessionMultipartyStateChanged";
                }
                case 33: {
                    return "callSessionSuppServiceReceived";
                }
                case 34: {
                    return "callSessionRttModifyRequestReceived";
                }
                case 35: {
                    return "callSessionRttModifyResponseReceived";
                }
                case 36: {
                    return "callSessionRttMessageReceived";
                }
                case 37: {
                    return "callSessionRttAudioIndicatorChanged";
                }
                case 38: {
                    return "callSessionTransferred";
                }
                case 39: {
                    return "callSessionTransferFailed";
                }
                case 40: {
                    return "callSessionDtmfReceived";
                }
                case 41: {
                    return "callQualityChanged";
                }
                case 42: {
                    return "callSessionRtpHeaderExtensionsReceived";
                }
                case 43: {
                    return "callSessionSendAnbrQuery";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsCallSessionListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionInitiating(_arg0);
                    break;
                }
                case 2: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionInitiatingFailed(_arg0);
                    break;
                }
                case 3: {
                    ImsStreamMediaProfile _arg0 = data.readTypedObject(ImsStreamMediaProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionProgressing(_arg0);
                    break;
                }
                case 4: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionInitiated(_arg0);
                    break;
                }
                case 5: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionInitiatedFailed(_arg0);
                    break;
                }
                case 6: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionTerminated(_arg0);
                    break;
                }
                case 7: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionHeld(_arg0);
                    break;
                }
                case 8: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionHoldFailed(_arg0);
                    break;
                }
                case 9: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionHoldReceived(_arg0);
                    break;
                }
                case 10: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionResumed(_arg0);
                    break;
                }
                case 11: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionResumeFailed(_arg0);
                    break;
                }
                case 12: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionResumeReceived(_arg0);
                    break;
                }
                case 13: {
                    IImsCallSession _arg0 = IImsCallSession.Stub.asInterface(data.readStrongBinder());
                    ImsCallProfile _arg1 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionMergeStarted(_arg0, _arg1);
                    break;
                }
                case 14: {
                    IImsCallSession _arg0 = IImsCallSession.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.callSessionMergeComplete(_arg0);
                    break;
                }
                case 15: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionMergeFailed(_arg0);
                    break;
                }
                case 16: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionUpdated(_arg0);
                    break;
                }
                case 17: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionUpdateFailed(_arg0);
                    break;
                }
                case 18: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionUpdateReceived(_arg0);
                    break;
                }
                case 19: {
                    IImsCallSession _arg0 = IImsCallSession.Stub.asInterface(data.readStrongBinder());
                    ImsCallProfile _arg1 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionConferenceExtended(_arg0, _arg1);
                    break;
                }
                case 20: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionConferenceExtendFailed(_arg0);
                    break;
                }
                case 21: {
                    IImsCallSession _arg0 = IImsCallSession.Stub.asInterface(data.readStrongBinder());
                    ImsCallProfile _arg1 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionConferenceExtendReceived(_arg0, _arg1);
                    break;
                }
                case 22: {
                    this.callSessionInviteParticipantsRequestDelivered();
                    break;
                }
                case 23: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionInviteParticipantsRequestFailed(_arg0);
                    break;
                }
                case 24: {
                    this.callSessionRemoveParticipantsRequestDelivered();
                    break;
                }
                case 25: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionRemoveParticipantsRequestFailed(_arg0);
                    break;
                }
                case 26: {
                    ImsConferenceState _arg0 = data.readTypedObject(ImsConferenceState.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionConferenceStateUpdated(_arg0);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.callSessionUssdMessageReceived(_arg0, _arg1);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ImsReasonInfo _arg2 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionHandover(_arg0, _arg1, _arg2);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ImsReasonInfo _arg2 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionHandoverFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.callSessionMayHandover(_arg0, _arg1);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.callSessionTtyModeReceived(_arg0);
                    break;
                }
                case 32: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.callSessionMultipartyStateChanged(_arg0);
                    break;
                }
                case 33: {
                    ImsSuppServiceNotification _arg0 = data.readTypedObject(ImsSuppServiceNotification.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionSuppServiceReceived(_arg0);
                    break;
                }
                case 34: {
                    ImsCallProfile _arg0 = data.readTypedObject(ImsCallProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionRttModifyRequestReceived(_arg0);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.callSessionRttModifyResponseReceived(_arg0);
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.callSessionRttMessageReceived(_arg0);
                    break;
                }
                case 37: {
                    ImsStreamMediaProfile _arg0 = data.readTypedObject(ImsStreamMediaProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionRttAudioIndicatorChanged(_arg0);
                    break;
                }
                case 38: {
                    this.callSessionTransferred();
                    break;
                }
                case 39: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionTransferFailed(_arg0);
                    break;
                }
                case 40: {
                    char _arg0 = (char)data.readInt();
                    data.enforceNoDataAvail();
                    this.callSessionDtmfReceived(_arg0);
                    break;
                }
                case 41: {
                    CallQuality _arg0 = data.readTypedObject(CallQuality.CREATOR);
                    data.enforceNoDataAvail();
                    this.callQualityChanged(_arg0);
                    break;
                }
                case 42: {
                    ArrayList<RtpHeaderExtension> _arg0 = data.createTypedArrayList(RtpHeaderExtension.CREATOR);
                    data.enforceNoDataAvail();
                    this.callSessionRtpHeaderExtensionsReceived(_arg0);
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.callSessionSendAnbrQuery(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 42;
        }

        private static class Proxy
        implements IImsCallSessionListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsCallSessionListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionInitiating(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionInitiatingFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionProgressing(ImsStreamMediaProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionInitiated(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionInitiatedFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionTerminated(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionHeld(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionHoldFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionHoldReceived(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionResumed(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionResumeFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionResumeReceived(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionMergeStarted(IImsCallSession newSession, ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeStrongInterface(newSession);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionMergeComplete(IImsCallSession session) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeStrongInterface(session);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionMergeFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionUpdated(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionUpdateFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionUpdateReceived(ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionConferenceExtended(IImsCallSession newSession, ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeStrongInterface(newSession);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionConferenceExtendFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionConferenceExtendReceived(IImsCallSession newSession, ImsCallProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeStrongInterface(newSession);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void callSessionInviteParticipantsRequestDelivered() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionInviteParticipantsRequestFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void callSessionRemoveParticipantsRequestDelivered() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionRemoveParticipantsRequestFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionConferenceStateUpdated(ImsConferenceState state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionUssdMessageReceived(int mode, String ussdMessage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeString(ussdMessage);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionHandover(int srcNetworkType, int targetNetworkType, ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(srcNetworkType);
                    _data.writeInt(targetNetworkType);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionHandoverFailed(int srcNetworkType, int targetNetworkType, ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(srcNetworkType);
                    _data.writeInt(targetNetworkType);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionMayHandover(int srcNetworkType, int targetNetworkType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(srcNetworkType);
                    _data.writeInt(targetNetworkType);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionTtyModeReceived(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean bl = this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionMultipartyStateChanged(boolean isMultiParty) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeBoolean(isMultiParty);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionSuppServiceReceived(ImsSuppServiceNotification suppSrvNotification) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(suppSrvNotification, 0);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionRttModifyRequestReceived(ImsCallProfile callProfile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(callProfile, 0);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionRttModifyResponseReceived(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionRttMessageReceived(String rttMessage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeString(rttMessage);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionRttAudioIndicatorChanged(ImsStreamMediaProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void callSessionTransferred() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionTransferFailed(ImsReasonInfo reasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(reasonInfo, 0);
                    boolean bl = this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionDtmfReceived(char dtmf) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(dtmf);
                    boolean bl = this.mRemote.transact(40, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callQualityChanged(CallQuality callQuality) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedObject(callQuality, 0);
                    boolean bl = this.mRemote.transact(41, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionRtpHeaderExtensionsReceived(List<RtpHeaderExtension> extensions) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeTypedList(extensions, 0);
                    boolean bl = this.mRemote.transact(42, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSessionSendAnbrQuery(int mediaType, int direction, int bitsPerSecond) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsCallSessionListener.DESCRIPTOR);
                    _data.writeInt(mediaType);
                    _data.writeInt(direction);
                    _data.writeInt(bitsPerSecond);
                    boolean bl = this.mRemote.transact(43, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsCallSessionListener {
        @Override
        public void callSessionInitiating(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionInitiatingFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionProgressing(ImsStreamMediaProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionInitiated(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionInitiatedFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionTerminated(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionHeld(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionHoldFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionHoldReceived(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionResumed(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionResumeFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionResumeReceived(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionMergeStarted(IImsCallSession newSession, ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionMergeComplete(IImsCallSession session) throws RemoteException {
        }

        @Override
        public void callSessionMergeFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionUpdated(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionUpdateFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionUpdateReceived(ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionConferenceExtended(IImsCallSession newSession, ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionConferenceExtendFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionConferenceExtendReceived(IImsCallSession newSession, ImsCallProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionInviteParticipantsRequestDelivered() throws RemoteException {
        }

        @Override
        public void callSessionInviteParticipantsRequestFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionRemoveParticipantsRequestDelivered() throws RemoteException {
        }

        @Override
        public void callSessionRemoveParticipantsRequestFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionConferenceStateUpdated(ImsConferenceState state) throws RemoteException {
        }

        @Override
        public void callSessionUssdMessageReceived(int mode, String ussdMessage) throws RemoteException {
        }

        @Override
        public void callSessionHandover(int srcNetworkType, int targetNetworkType, ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionHandoverFailed(int srcNetworkType, int targetNetworkType, ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionMayHandover(int srcNetworkType, int targetNetworkType) throws RemoteException {
        }

        @Override
        public void callSessionTtyModeReceived(int mode) throws RemoteException {
        }

        @Override
        public void callSessionMultipartyStateChanged(boolean isMultiParty) throws RemoteException {
        }

        @Override
        public void callSessionSuppServiceReceived(ImsSuppServiceNotification suppSrvNotification) throws RemoteException {
        }

        @Override
        public void callSessionRttModifyRequestReceived(ImsCallProfile callProfile) throws RemoteException {
        }

        @Override
        public void callSessionRttModifyResponseReceived(int status) throws RemoteException {
        }

        @Override
        public void callSessionRttMessageReceived(String rttMessage) throws RemoteException {
        }

        @Override
        public void callSessionRttAudioIndicatorChanged(ImsStreamMediaProfile profile) throws RemoteException {
        }

        @Override
        public void callSessionTransferred() throws RemoteException {
        }

        @Override
        public void callSessionTransferFailed(ImsReasonInfo reasonInfo) throws RemoteException {
        }

        @Override
        public void callSessionDtmfReceived(char dtmf) throws RemoteException {
        }

        @Override
        public void callQualityChanged(CallQuality callQuality) throws RemoteException {
        }

        @Override
        public void callSessionRtpHeaderExtensionsReceived(List<RtpHeaderExtension> extensions) throws RemoteException {
        }

        @Override
        public void callSessionSendAnbrQuery(int mediaType, int direction, int bitsPerSecond) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

