/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.ImsCallProfile;
import java.util.Objects;

@SystemApi
public class SrvccCall
implements Parcelable {
    private static final String TAG = "SrvccCall";
    private ImsCallProfile mImsCallProfile;
    private String mCallId;
    private int mCallState;
    @NonNull
    public static final Parcelable.Creator<SrvccCall> CREATOR = new Parcelable.Creator<SrvccCall>(){

        @Override
        public SrvccCall createFromParcel(Parcel in) {
            return new SrvccCall(in);
        }

        public SrvccCall[] newArray(int size) {
            return new SrvccCall[size];
        }
    };

    private SrvccCall(Parcel in) {
        this.readFromParcel(in);
    }

    public SrvccCall(@NonNull String callId, int callState, @NonNull ImsCallProfile imsCallProfile) {
        if (callId == null) {
            throw new IllegalArgumentException("callId is null");
        }
        if (imsCallProfile == null) {
            throw new IllegalArgumentException("imsCallProfile is null");
        }
        this.mCallId = callId;
        this.mCallState = callState;
        this.mImsCallProfile = imsCallProfile;
    }

    @NonNull
    public ImsCallProfile getImsCallProfile() {
        return this.mImsCallProfile;
    }

    @NonNull
    public String getCallId() {
        return this.mCallId;
    }

    public int getPreciseCallState() {
        return this.mCallState;
    }

    @NonNull
    public String toString() {
        return "{ callId=" + this.mCallId + ", callState=" + this.mCallState + ", imsCallProfile=" + this.mImsCallProfile + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SrvccCall that = (SrvccCall)o;
        return this.mImsCallProfile.equals(that.mImsCallProfile) && this.mCallId.equals(that.mCallId) && this.mCallState == that.mCallState;
    }

    public int hashCode() {
        int result = Objects.hash(this.mImsCallProfile, this.mCallId);
        result = 31 * result + this.mCallState;
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.mCallId);
        out.writeInt(this.mCallState);
        out.writeParcelable(this.mImsCallProfile, 0);
    }

    private void readFromParcel(Parcel in) {
        this.mCallId = in.readString();
        this.mCallState = in.readInt();
        this.mImsCallProfile = in.readParcelable(ImsCallProfile.class.getClassLoader(), ImsCallProfile.class);
    }
}

