/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Binder;
import android.telephony.ims.SipDialogState;
import com.android.internal.telephony.ISipDialogStateCallback;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
public abstract class SipDialogStateCallback {
    private CallbackBinder mCallback;

    public void attachExecutor(@NonNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("SipDialogStateCallback Executor must be non-null");
        }
        this.mCallback = new CallbackBinder(this, executor);
    }

    public abstract void onActiveSipDialogsChanged(@NonNull List<SipDialogState> var1);

    public abstract void onError();

    public void binderDied() {
        if (this.mCallback != null) {
            this.mCallback.getExecutor().execute(() -> this.onError());
        }
    }

    public CallbackBinder getCallbackBinder() {
        return this.mCallback;
    }

    private static class CallbackBinder
    extends ISipDialogStateCallback.Stub {
        private WeakReference<SipDialogStateCallback> mSipDialogStateCallbackWeakRef;
        private Executor mExecutor;

        private CallbackBinder(SipDialogStateCallback callback, Executor executor) {
            this.mSipDialogStateCallbackWeakRef = new WeakReference<SipDialogStateCallback>(callback);
            this.mExecutor = executor;
        }

        Executor getExecutor() {
            return this.mExecutor;
        }

        @Override
        public void onActiveSipDialogsChanged(List<SipDialogState> dialogs) {
            SipDialogStateCallback callback = (SipDialogStateCallback)this.mSipDialogStateCallbackWeakRef.get();
            if (callback == null || dialogs == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> callback.onActiveSipDialogsChanged(dialogs)));
        }
    }
}

