/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class MediaQualityStatus
implements Parcelable {
    public static final int MEDIA_SESSION_TYPE_AUDIO = 1;
    public static final int MEDIA_SESSION_TYPE_VIDEO = 2;
    private final String mImsCallSessionId;
    private final int mMediaSessionType;
    private final int mTransportType;
    private final int mRtpPacketLossRate;
    private final int mRtpJitterMillis;
    private final long mRtpInactivityTimeMillis;
    @NonNull
    public static final Parcelable.Creator<MediaQualityStatus> CREATOR = new Parcelable.Creator<MediaQualityStatus>(){

        @Override
        public MediaQualityStatus createFromParcel(@NonNull Parcel in) {
            return new MediaQualityStatus(in);
        }

        public MediaQualityStatus[] newArray(int size) {
            return new MediaQualityStatus[size];
        }
    };

    public MediaQualityStatus(@NonNull String imsCallSessionId, int mediaSessionType, int transportType, int rtpPacketLossRate, int rtpJitterMillis, long rptInactivityTimeMillis) {
        this.mImsCallSessionId = imsCallSessionId;
        this.mMediaSessionType = mediaSessionType;
        this.mTransportType = transportType;
        this.mRtpPacketLossRate = rtpPacketLossRate;
        this.mRtpJitterMillis = rtpJitterMillis;
        this.mRtpInactivityTimeMillis = rptInactivityTimeMillis;
    }

    @NonNull
    public String getCallSessionId() {
        return this.mImsCallSessionId;
    }

    public int getMediaSessionType() {
        return this.mMediaSessionType;
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    public int getRtpPacketLossRate() {
        return this.mRtpPacketLossRate;
    }

    public int getRtpJitterMillis() {
        return this.mRtpJitterMillis;
    }

    public long getRtpInactivityMillis() {
        return this.mRtpInactivityTimeMillis;
    }

    private MediaQualityStatus(@NonNull Parcel in) {
        this.mImsCallSessionId = in.readString();
        this.mMediaSessionType = in.readInt();
        this.mTransportType = in.readInt();
        this.mRtpPacketLossRate = in.readInt();
        this.mRtpJitterMillis = in.readInt();
        this.mRtpInactivityTimeMillis = in.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mImsCallSessionId);
        dest.writeInt(this.mMediaSessionType);
        dest.writeInt(this.mTransportType);
        dest.writeInt(this.mRtpPacketLossRate);
        dest.writeInt(this.mRtpJitterMillis);
        dest.writeLong(this.mRtpInactivityTimeMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaQualityStatus that = (MediaQualityStatus)o;
        return this.mImsCallSessionId != null && this.mImsCallSessionId.equals(that.mImsCallSessionId) && this.mMediaSessionType == that.mMediaSessionType && this.mTransportType == that.mTransportType && this.mRtpPacketLossRate == that.mRtpPacketLossRate && this.mRtpJitterMillis == that.mRtpJitterMillis && this.mRtpInactivityTimeMillis == that.mRtpInactivityTimeMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mImsCallSessionId, this.mMediaSessionType, this.mTransportType, this.mRtpPacketLossRate, this.mRtpJitterMillis, this.mRtpInactivityTimeMillis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaThreshold{mImsCallSessionId=");
        sb.append(this.mImsCallSessionId);
        sb.append(", mMediaSessionType=");
        sb.append(this.mMediaSessionType);
        sb.append(", mTransportType=");
        sb.append(this.mTransportType);
        sb.append(", mRtpPacketLossRate=");
        sb.append(this.mRtpPacketLossRate);
        sb.append(", mRtpJitterMillis=");
        sb.append(this.mRtpJitterMillis);
        sb.append(", mRtpInactivityTimeMillis=");
        sb.append(this.mRtpInactivityTimeMillis);
        sb.append("}");
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaSessionType {
    }
}

