/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.emergency;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EmergencyNumber
implements Parcelable,
Comparable<EmergencyNumber> {
    private static final String LOG_TAG = "EmergencyNumber";
    public static final int EMERGENCY_SERVICE_CATEGORY_UNSPECIFIED = 0;
    public static final int EMERGENCY_SERVICE_CATEGORY_POLICE = 1;
    public static final int EMERGENCY_SERVICE_CATEGORY_AMBULANCE = 2;
    public static final int EMERGENCY_SERVICE_CATEGORY_FIRE_BRIGADE = 4;
    public static final int EMERGENCY_SERVICE_CATEGORY_MARINE_GUARD = 8;
    public static final int EMERGENCY_SERVICE_CATEGORY_MOUNTAIN_RESCUE = 16;
    public static final int EMERGENCY_SERVICE_CATEGORY_MIEC = 32;
    public static final int EMERGENCY_SERVICE_CATEGORY_AIEC = 64;
    private static final Set<Integer> EMERGENCY_SERVICE_CATEGORY_SET = new HashSet<Integer>();
    public static final int EMERGENCY_NUMBER_SOURCE_NETWORK_SIGNALING = 1;
    public static final int EMERGENCY_NUMBER_SOURCE_SIM = 2;
    public static final int EMERGENCY_NUMBER_SOURCE_DATABASE = 16;
    public static final int EMERGENCY_NUMBER_SOURCE_TEST = 32;
    public static final int EMERGENCY_NUMBER_SOURCE_MODEM_CONFIG = 4;
    public static final int EMERGENCY_NUMBER_SOURCE_DEFAULT = 8;
    private static final Set<Integer> EMERGENCY_NUMBER_SOURCE_SET;
    public static final int EMERGENCY_CALL_ROUTING_UNKNOWN = 0;
    public static final int EMERGENCY_CALL_ROUTING_EMERGENCY = 1;
    public static final int EMERGENCY_CALL_ROUTING_NORMAL = 2;
    private final String mNumber;
    private final String mCountryIso;
    private final String mMnc;
    private final int mEmergencyServiceCategoryBitmask;
    private final List<String> mEmergencyUrns;
    private final int mEmergencyNumberSourceBitmask;
    private final int mEmergencyCallRouting;
    private static final int[] EMERGENCY_NUMBER_SOURCE_PRECEDENCE;
    @NonNull
    public static final Parcelable.Creator<EmergencyNumber> CREATOR;

    public EmergencyNumber(@NonNull String number, @NonNull String countryIso, @NonNull String mnc, int emergencyServiceCategories, @NonNull List<String> emergencyUrns, int emergencyNumberSources, int emergencyCallRouting) {
        this.mNumber = number;
        this.mCountryIso = countryIso;
        this.mMnc = mnc;
        this.mEmergencyServiceCategoryBitmask = emergencyServiceCategories;
        this.mEmergencyUrns = emergencyUrns;
        this.mEmergencyNumberSourceBitmask = emergencyNumberSources;
        this.mEmergencyCallRouting = emergencyCallRouting;
    }

    public EmergencyNumber(Parcel source) {
        this.mNumber = source.readString();
        this.mCountryIso = source.readString();
        this.mMnc = source.readString();
        this.mEmergencyServiceCategoryBitmask = source.readInt();
        this.mEmergencyUrns = source.createStringArrayList();
        this.mEmergencyNumberSourceBitmask = source.readInt();
        this.mEmergencyCallRouting = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNumber);
        dest.writeString(this.mCountryIso);
        dest.writeString(this.mMnc);
        dest.writeInt(this.mEmergencyServiceCategoryBitmask);
        dest.writeStringList(this.mEmergencyUrns);
        dest.writeInt(this.mEmergencyNumberSourceBitmask);
        dest.writeInt(this.mEmergencyCallRouting);
    }

    @NonNull
    public String getNumber() {
        return this.mNumber;
    }

    @NonNull
    public String getCountryIso() {
        return this.mCountryIso;
    }

    @NonNull
    public String getMnc() {
        return this.mMnc;
    }

    public int getEmergencyServiceCategoryBitmask() {
        return this.mEmergencyServiceCategoryBitmask;
    }

    public int getEmergencyServiceCategoryBitmaskInternalDial() {
        if (this.mEmergencyNumberSourceBitmask == 16) {
            return 0;
        }
        return this.mEmergencyServiceCategoryBitmask;
    }

    @NonNull
    public List<Integer> getEmergencyServiceCategories() {
        ArrayList<Integer> categories = new ArrayList<Integer>();
        if (this.serviceUnspecified()) {
            categories.add(0);
            return categories;
        }
        for (Integer category : EMERGENCY_SERVICE_CATEGORY_SET) {
            if (!this.isInEmergencyServiceCategories(category)) continue;
            categories.add(category);
        }
        return categories;
    }

    @NonNull
    public List<String> getEmergencyUrns() {
        return Collections.unmodifiableList(this.mEmergencyUrns);
    }

    private boolean serviceUnspecified() {
        return this.mEmergencyServiceCategoryBitmask == 0;
    }

    public boolean isInEmergencyServiceCategories(int categories) {
        if (categories == 0) {
            return this.serviceUnspecified();
        }
        if (this.serviceUnspecified()) {
            return true;
        }
        return (this.mEmergencyServiceCategoryBitmask & categories) == categories;
    }

    public int getEmergencyNumberSourceBitmask() {
        return this.mEmergencyNumberSourceBitmask;
    }

    @NonNull
    public List<Integer> getEmergencyNumberSources() {
        ArrayList<Integer> sources = new ArrayList<Integer>();
        for (Integer source : EMERGENCY_NUMBER_SOURCE_SET) {
            if ((this.mEmergencyNumberSourceBitmask & source) != source) continue;
            sources.add(source);
        }
        return sources;
    }

    public boolean isFromSources(int sources) {
        return (this.mEmergencyNumberSourceBitmask & sources) == sources;
    }

    public int getEmergencyCallRouting() {
        return this.mEmergencyCallRouting;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return String.format("[EmergencyNumber: %s, countryIso=%s, mnc=%s, src=%s, routing=%s, categories=%s, urns=%s]", this.mNumber, this.mCountryIso, this.mMnc, this.sourceBitmaskToString(this.mEmergencyNumberSourceBitmask), this.routingToString(this.mEmergencyCallRouting), this.categoriesToString(this.mEmergencyServiceCategoryBitmask), this.mEmergencyUrns == null ? "" : this.mEmergencyUrns.stream().collect(Collectors.joining(",")));
    }

    private String categoriesToString(int categories) {
        StringBuilder sb = new StringBuilder();
        if ((categories & 0x40) == 64) {
            sb.append("auto ");
        }
        if ((categories & 2) == 2) {
            sb.append("ambulance ");
        }
        if ((categories & 4) == 4) {
            sb.append("fire ");
        }
        if ((categories & 8) == 8) {
            sb.append("marine ");
        }
        if ((categories & 0x10) == 16) {
            sb.append("mountain ");
        }
        if ((categories & 1) == 1) {
            sb.append("police ");
        }
        if ((categories & 0x20) == 32) {
            sb.append("manual ");
        }
        return sb.toString();
    }

    private String routingToString(int routing) {
        String string2;
        switch (routing) {
            case 1: {
                string2 = "emergency";
                break;
            }
            case 2: {
                string2 = "normal";
                break;
            }
            case 0: {
                string2 = "unknown";
                break;
            }
            default: {
                string2 = "\ud83e\udd37";
            }
        }
        return string2;
    }

    private String sourceBitmaskToString(int sourceBitmask) {
        StringBuilder sb = new StringBuilder();
        if ((sourceBitmask & 1) == 1) {
            sb.append("net ");
        }
        if ((sourceBitmask & 2) == 2) {
            sb.append("sim ");
        }
        if ((sourceBitmask & 0x10) == 16) {
            sb.append("db ");
        }
        if ((sourceBitmask & 4) == 4) {
            sb.append("mdm ");
        }
        if ((sourceBitmask & 8) == 8) {
            sb.append("def ");
        }
        if ((sourceBitmask & 0x20) == 32) {
            sb.append("tst ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!EmergencyNumber.class.isInstance(o)) {
            return false;
        }
        EmergencyNumber other = (EmergencyNumber)o;
        return this.mNumber.equals(other.mNumber) && this.mCountryIso.equals(other.mCountryIso) && this.mMnc.equals(other.mMnc) && this.mEmergencyServiceCategoryBitmask == other.mEmergencyServiceCategoryBitmask && this.mEmergencyUrns.equals(other.mEmergencyUrns) && this.mEmergencyNumberSourceBitmask == other.mEmergencyNumberSourceBitmask && this.mEmergencyCallRouting == other.mEmergencyCallRouting;
    }

    public int hashCode() {
        return Objects.hash(this.mNumber, this.mCountryIso, this.mMnc, this.mEmergencyServiceCategoryBitmask, this.mEmergencyUrns, this.mEmergencyNumberSourceBitmask, this.mEmergencyCallRouting);
    }

    private int getDisplayPriorityScore() {
        int score = 0;
        if (this.isFromSources(1)) {
            score += 16;
        }
        if (this.isFromSources(2)) {
            score += 8;
        }
        if (this.isFromSources(16)) {
            score += 4;
        }
        if (this.isFromSources(8)) {
            score += 2;
        }
        if (this.isFromSources(4)) {
            ++score;
        }
        return score;
    }

    @Override
    public int compareTo(@NonNull EmergencyNumber emergencyNumber) {
        if (this.getDisplayPriorityScore() > emergencyNumber.getDisplayPriorityScore()) {
            return -1;
        }
        if (this.getDisplayPriorityScore() < emergencyNumber.getDisplayPriorityScore()) {
            return 1;
        }
        if (this.getNumber().compareTo(emergencyNumber.getNumber()) != 0) {
            return this.getNumber().compareTo(emergencyNumber.getNumber());
        }
        if (this.getCountryIso().compareTo(emergencyNumber.getCountryIso()) != 0) {
            return this.getCountryIso().compareTo(emergencyNumber.getCountryIso());
        }
        if (this.getMnc().compareTo(emergencyNumber.getMnc()) != 0) {
            return this.getMnc().compareTo(emergencyNumber.getMnc());
        }
        if (this.getEmergencyServiceCategoryBitmask() != emergencyNumber.getEmergencyServiceCategoryBitmask()) {
            return this.getEmergencyServiceCategoryBitmask() > emergencyNumber.getEmergencyServiceCategoryBitmask() ? -1 : 1;
        }
        if (this.getEmergencyUrns().toString().compareTo(emergencyNumber.getEmergencyUrns().toString()) != 0) {
            return this.getEmergencyUrns().toString().compareTo(emergencyNumber.getEmergencyUrns().toString());
        }
        if (this.getEmergencyCallRouting() != emergencyNumber.getEmergencyCallRouting()) {
            return this.getEmergencyCallRouting() > emergencyNumber.getEmergencyCallRouting() ? -1 : 1;
        }
        return 0;
    }

    public static void mergeSameNumbersInEmergencyNumberList(List<EmergencyNumber> emergencyNumberList) {
        EmergencyNumber.mergeSameNumbersInEmergencyNumberList(emergencyNumberList, false);
    }

    public static void mergeSameNumbersInEmergencyNumberList(@NonNull List<EmergencyNumber> emergencyNumberList, boolean mergeServiceCategoriesAndUrns) {
        int i;
        if (emergencyNumberList == null) {
            return;
        }
        HashSet<Integer> duplicatedEmergencyNumberPosition = new HashSet<Integer>();
        for (i = 0; i < emergencyNumberList.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!EmergencyNumber.areSameEmergencyNumbers(emergencyNumberList.get(i), emergencyNumberList.get(j), mergeServiceCategoriesAndUrns)) continue;
                Rlog.e(LOG_TAG, "Found unexpected duplicate numbers " + emergencyNumberList.get(i) + " vs " + emergencyNumberList.get(j));
                emergencyNumberList.set(i, EmergencyNumber.mergeSameEmergencyNumbers(emergencyNumberList.get(i), emergencyNumberList.get(j), mergeServiceCategoriesAndUrns));
                duplicatedEmergencyNumberPosition.add(j);
            }
        }
        for (i = emergencyNumberList.size() - 1; i >= 0; --i) {
            if (!duplicatedEmergencyNumberPosition.contains(i)) continue;
            emergencyNumberList.remove(i);
        }
        Collections.sort(emergencyNumberList);
    }

    public static boolean areSameEmergencyNumbers(@NonNull EmergencyNumber first, @NonNull EmergencyNumber second, boolean ignoreServiceCategoryAndUrns) {
        if (!first.getNumber().equals(second.getNumber())) {
            return false;
        }
        if (!first.getCountryIso().equals(second.getCountryIso())) {
            return false;
        }
        if (!first.getMnc().equals(second.getMnc())) {
            return false;
        }
        if (!ignoreServiceCategoryAndUrns) {
            if (first.getEmergencyServiceCategoryBitmask() != second.getEmergencyServiceCategoryBitmask()) {
                return false;
            }
            if (!first.getEmergencyUrns().equals(second.getEmergencyUrns())) {
                return false;
            }
        }
        return !(first.isFromSources(32) ^ second.isFromSources(32));
    }

    public static EmergencyNumber mergeSameEmergencyNumbers(@NonNull EmergencyNumber first, @NonNull EmergencyNumber second) {
        if (EmergencyNumber.areSameEmergencyNumbers(first, second, false)) {
            int routing = first.getEmergencyCallRouting();
            if (second.isFromSources(16)) {
                routing = second.getEmergencyCallRouting();
            }
            return new EmergencyNumber(first.getNumber(), first.getCountryIso(), first.getMnc(), first.getEmergencyServiceCategoryBitmask(), first.getEmergencyUrns(), first.getEmergencyNumberSourceBitmask() | second.getEmergencyNumberSourceBitmask(), routing);
        }
        return null;
    }

    private static List<String> mergeEmergencyUrns(@NonNull List<String> firstEmergencyUrns, @NonNull List<String> secondEmergencyUrns) {
        ArrayList<String> mergedUrns = new ArrayList<String>();
        mergedUrns.addAll(firstEmergencyUrns);
        for (String urn : secondEmergencyUrns) {
            if (firstEmergencyUrns.contains(urn)) continue;
            mergedUrns.add(urn);
        }
        return mergedUrns;
    }

    private static void fillServiceCategoryAndUrns(@NonNull EmergencyNumber num, @NonNull SparseIntArray serviceCategoryArray, @NonNull SparseArray<List<String>> urnsArray) {
        int numberSrc = num.getEmergencyNumberSourceBitmask();
        int[] nArray = EMERGENCY_NUMBER_SOURCE_PRECEDENCE;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer source = nArray[i];
            if ((numberSrc & source) != source) continue;
            if (!num.isInEmergencyServiceCategories(0)) {
                serviceCategoryArray.put(source, num.getEmergencyServiceCategoryBitmask());
            }
            urnsArray.put(source, num.getEmergencyUrns());
            break;
        }
    }

    @NonNull
    public static EmergencyNumber mergeSameEmergencyNumbers(@NonNull EmergencyNumber first, @NonNull EmergencyNumber second, boolean mergeServiceCategoriesAndUrns) {
        if (!mergeServiceCategoriesAndUrns) {
            return EmergencyNumber.mergeSameEmergencyNumbers(first, second);
        }
        int routing = first.getEmergencyCallRouting();
        int serviceCategory = first.getEmergencyServiceCategoryBitmask();
        List<String> mergedEmergencyUrns = new ArrayList<String>();
        SparseIntArray serviceCategoryArray = new SparseIntArray(2);
        SparseArray<List<String>> urnsArray = new SparseArray<List<String>>(2);
        EmergencyNumber.fillServiceCategoryAndUrns(first, serviceCategoryArray, urnsArray);
        EmergencyNumber.fillServiceCategoryAndUrns(second, serviceCategoryArray, urnsArray);
        if (second.isFromSources(16)) {
            routing = second.getEmergencyCallRouting();
        }
        for (int sourceOfCategory : EMERGENCY_NUMBER_SOURCE_PRECEDENCE) {
            if (serviceCategoryArray.indexOfKey(sourceOfCategory) < 0) continue;
            serviceCategory = serviceCategoryArray.get(sourceOfCategory);
            break;
        }
        for (int sourceOfUrn : EMERGENCY_NUMBER_SOURCE_PRECEDENCE) {
            if (!urnsArray.contains(sourceOfUrn)) continue;
            mergedEmergencyUrns = EmergencyNumber.mergeEmergencyUrns(mergedEmergencyUrns, urnsArray.get(sourceOfUrn));
        }
        return new EmergencyNumber(first.getNumber(), first.getCountryIso(), first.getMnc(), serviceCategory, mergedEmergencyUrns, first.getEmergencyNumberSourceBitmask() | second.getEmergencyNumberSourceBitmask(), routing);
    }

    public static boolean validateEmergencyNumberAddress(String address) {
        if (address == null) {
            return false;
        }
        for (char c : address.toCharArray()) {
            if (PhoneNumberUtils.isDialable(c)) continue;
            return false;
        }
        return true;
    }

    static {
        EMERGENCY_SERVICE_CATEGORY_SET.add(1);
        EMERGENCY_SERVICE_CATEGORY_SET.add(2);
        EMERGENCY_SERVICE_CATEGORY_SET.add(4);
        EMERGENCY_SERVICE_CATEGORY_SET.add(8);
        EMERGENCY_SERVICE_CATEGORY_SET.add(16);
        EMERGENCY_SERVICE_CATEGORY_SET.add(32);
        EMERGENCY_SERVICE_CATEGORY_SET.add(64);
        EMERGENCY_NUMBER_SOURCE_SET = new HashSet<Integer>();
        EMERGENCY_NUMBER_SOURCE_SET.add(1);
        EMERGENCY_NUMBER_SOURCE_SET.add(2);
        EMERGENCY_NUMBER_SOURCE_SET.add(16);
        EMERGENCY_NUMBER_SOURCE_SET.add(4);
        EMERGENCY_NUMBER_SOURCE_SET.add(8);
        EMERGENCY_NUMBER_SOURCE_PRECEDENCE = new int[4];
        EmergencyNumber.EMERGENCY_NUMBER_SOURCE_PRECEDENCE[0] = 1;
        EmergencyNumber.EMERGENCY_NUMBER_SOURCE_PRECEDENCE[1] = 2;
        EmergencyNumber.EMERGENCY_NUMBER_SOURCE_PRECEDENCE[2] = 16;
        EmergencyNumber.EMERGENCY_NUMBER_SOURCE_PRECEDENCE[3] = 4;
        CREATOR = new Parcelable.Creator<EmergencyNumber>(){

            @Override
            public EmergencyNumber createFromParcel(Parcel in) {
                return new EmergencyNumber(in);
            }

            public EmergencyNumber[] newArray(int size) {
                return new EmergencyNumber[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmergencyCallRouting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmergencyNumberSources {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmergencyServiceCategories {
    }
}

