/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public abstract class Qos
implements Parcelable {
    final int type;
    static final int QOS_TYPE_EPS = 1;
    static final int QOS_TYPE_NR = 2;
    final QosBandwidth downlink;
    final QosBandwidth uplink;

    Qos(int type, QosBandwidth downlink, QosBandwidth uplink) {
        this.type = type;
        this.downlink = downlink;
        this.uplink = uplink;
    }

    public QosBandwidth getDownlinkBandwidth() {
        return this.downlink;
    }

    public QosBandwidth getUplinkBandwidth() {
        return this.uplink;
    }

    protected Qos(@NonNull Parcel source) {
        this.type = source.readInt();
        this.downlink = source.readParcelable(QosBandwidth.class.getClassLoader(), QosBandwidth.class);
        this.uplink = source.readParcelable(QosBandwidth.class.getClassLoader(), QosBandwidth.class);
    }

    public void writeToParcel(int type, Parcel dest, int flags) {
        dest.writeInt(type);
        dest.writeParcelable(this.downlink, flags);
        dest.writeParcelable(this.uplink, flags);
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.downlink, this.uplink);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Qos other = (Qos)o;
        return this.type == other.type && this.downlink.equals(other.downlink) && this.uplink.equals(other.uplink);
    }

    public static class QosBandwidth
    implements Parcelable {
        int maxBitrateKbps;
        int guaranteedBitrateKbps;
        @NonNull
        public static final Parcelable.Creator<QosBandwidth> CREATOR = new Parcelable.Creator<QosBandwidth>(){

            @Override
            public QosBandwidth createFromParcel(Parcel source) {
                return new QosBandwidth(source);
            }

            public QosBandwidth[] newArray(int size) {
                return new QosBandwidth[size];
            }
        };

        public QosBandwidth(int maxBitrateKbps, int guaranteedBitrateKbps) {
            this.maxBitrateKbps = maxBitrateKbps;
            this.guaranteedBitrateKbps = guaranteedBitrateKbps;
        }

        private QosBandwidth(Parcel source) {
            this.maxBitrateKbps = source.readInt();
            this.guaranteedBitrateKbps = source.readInt();
        }

        public int getMaxBitrateKbps() {
            return this.maxBitrateKbps;
        }

        public int getGuaranteedBitrateKbps() {
            return this.guaranteedBitrateKbps;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.maxBitrateKbps);
            dest.writeInt(this.guaranteedBitrateKbps);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.maxBitrateKbps, this.guaranteedBitrateKbps);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof QosBandwidth)) {
                return false;
            }
            QosBandwidth other = (QosBandwidth)o;
            return this.maxBitrateKbps == other.maxBitrateKbps && this.guaranteedBitrateKbps == other.guaranteedBitrateKbps;
        }

        public String toString() {
            return "Bandwidth { maxBitrateKbps=" + this.maxBitrateKbps + " guaranteedBitrateKbps=" + this.guaranteedBitrateKbps + "}";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QosType {
    }
}

