/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.Compatibility;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.BarringInfo;
import android.telephony.CallQuality;
import android.telephony.CarrierConfigManager;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.CellularIdentifierDisclosure;
import android.telephony.LinkCapacityEstimate;
import android.telephony.PhoneCapability;
import android.telephony.PhoneStateListener;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseDataConnectionState;
import android.telephony.SecurityAlgorithmUpdate;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.TelephonyManager;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.MediaQualityStatus;
import android.telephony.satellite.NtnSignalStrength;
import android.telephony.satellite.SatelliteStateChangeListener;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.listeners.ListenerExecutor;
import com.android.internal.telephony.ICarrierConfigChangeListener;
import com.android.internal.telephony.ICarrierPrivilegesCallback;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISatelliteStateChangeListener;
import com.android.internal.telephony.ITelephonyRegistry;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

@SystemApi
@FlaggedApi(value="com.android.server.telecom.flags.telecom_resolve_hidden_dependencies")
public class TelephonyRegistryManager {
    private static final String TAG = "TelephonyRegistryManager";
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;
    private final ConcurrentHashMap<SubscriptionManager.OnSubscriptionsChangedListener, IOnSubscriptionsChangedListener> mSubscriptionChangedListenerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<SubscriptionManager.OnOpportunisticSubscriptionsChangedListener, IOnSubscriptionsChangedListener> mOpportunisticSubscriptionChangedListenerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<CarrierConfigManager.CarrierConfigChangeListener, ICarrierConfigChangeListener> mCarrierConfigChangeListenerMap = new ConcurrentHashMap();
    private static final long LISTEN_CODE_CHANGE = 147600208L;
    public static final int SIM_ACTIVATION_TYPE_VOICE = 0;
    public static final int SIM_ACTIVATION_TYPE_DATA = 1;
    @NonNull
    @GuardedBy(value={"sSatelliteStateChangeListeners"})
    private static final Map<SatelliteStateChangeListener, WeakReference<SatelliteStateChangeListenerWrapper>> sSatelliteStateChangeListeners;
    @NonNull
    @GuardedBy(value={"sCarrierPrivilegeCallbacks"})
    private static final WeakHashMap<TelephonyManager.CarrierPrivilegesCallback, WeakReference<CarrierPrivilegesCallbackWrapper>> sCarrierPrivilegeCallbacks;

    public TelephonyRegistryManager(@NonNull Context context) {
        this.mContext = context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    public void addOnSubscriptionsChangedListener(final @NonNull SubscriptionManager.OnSubscriptionsChangedListener listener, final @NonNull Executor executor) {
        if (this.mSubscriptionChangedListenerMap.get(listener) != null) {
            Log.d(TAG, "addOnSubscriptionsChangedListener listener already present");
            return;
        }
        IOnSubscriptionsChangedListener.Stub callback = new IOnSubscriptionsChangedListener.Stub(this){

            @Override
            public void onSubscriptionsChanged() {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onSubscriptionsChanged());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        this.mSubscriptionChangedListenerMap.put(listener, callback);
        try {
            sRegistry.addOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), callback);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void removeOnSubscriptionsChangedListener(@NonNull SubscriptionManager.OnSubscriptionsChangedListener listener) {
        if (this.mSubscriptionChangedListenerMap.get(listener) == null) {
            return;
        }
        try {
            sRegistry.removeOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mSubscriptionChangedListenerMap.get(listener));
            this.mSubscriptionChangedListenerMap.remove(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void addOnOpportunisticSubscriptionsChangedListener(final @NonNull SubscriptionManager.OnOpportunisticSubscriptionsChangedListener listener, final @NonNull Executor executor) {
        if (this.mOpportunisticSubscriptionChangedListenerMap.get(listener) != null) {
            Log.d(TAG, "addOnOpportunisticSubscriptionsChangedListener listener already present");
            return;
        }
        IOnSubscriptionsChangedListener.Stub callback = new IOnSubscriptionsChangedListener.Stub(this){

            @Override
            public void onSubscriptionsChanged() {
                long identity = Binder.clearCallingIdentity();
                try {
                    Log.d(TelephonyRegistryManager.TAG, "onOpportunisticSubscriptionsChanged callback received.");
                    executor.execute(() -> listener.onOpportunisticSubscriptionsChanged());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        this.mOpportunisticSubscriptionChangedListenerMap.put(listener, callback);
        try {
            sRegistry.addOnOpportunisticSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), callback);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void removeOnOpportunisticSubscriptionsChangedListener(@NonNull SubscriptionManager.OnOpportunisticSubscriptionsChangedListener listener) {
        if (this.mOpportunisticSubscriptionChangedListenerMap.get(listener) == null) {
            return;
        }
        try {
            sRegistry.removeOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mOpportunisticSubscriptionChangedListenerMap.get(listener));
            this.mOpportunisticSubscriptionChangedListenerMap.remove(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void listenFromListener(int subId, @NonNull boolean renounceFineLocationAccess, @NonNull boolean renounceCoarseLocationAccess, @NonNull String pkg, @NonNull String featureId, @NonNull PhoneStateListener listener, @NonNull int events, boolean notifyNow) {
        if (listener == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        try {
            int[] eventsList = this.getEventsFromBitmask(events).stream().mapToInt(i -> i).toArray();
            if (Compatibility.isChangeEnabled(147600208L)) {
                listener.mSubId = eventsList.length == 0 ? -1 : subId;
            } else if (listener.mSubId != null) {
                subId = listener.mSubId;
            }
            sRegistry.listenWithEventList(renounceFineLocationAccess, renounceCoarseLocationAccess, subId, pkg, featureId, listener.callback, eventsList, notifyNow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void listenFromCallback(boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, int subId, @NonNull String pkg, @NonNull String featureId, @NonNull TelephonyCallback telephonyCallback, @NonNull int[] events, boolean notifyNow) {
        try {
            sRegistry.listenWithEventList(renounceFineLocationAccess, renounceCoarseLocationAccess, subId, pkg, featureId, telephonyCallback.callback, events, notifyNow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierNetworkChange(boolean active) {
        try {
            sRegistry.notifyCarrierNetworkChange(active);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierNetworkChange(int phoneId, int subId, boolean active) {
        try {
            sRegistry.notifyCarrierNetworkChangeForPhoneAndSubId(phoneId, subId, active);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierNetworkChange(int subscriptionId, boolean active) {
        try {
            sRegistry.notifyCarrierNetworkChangeForPhoneAndSubId(-1, subscriptionId, active);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallStateChanged(int slotIndex, int subId, int state, @Nullable String incomingNumber) {
        try {
            sRegistry.notifyCallState(slotIndex, subId, state, incomingNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void notifyCallStateChangedForAllSubscriptions(int state, @Nullable String incomingNumber) {
        try {
            sRegistry.notifyCallStateForAllSubs(state, incomingNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySubscriptionInfoChanged() {
        try {
            sRegistry.notifySubscriptionInfoChanged();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyOpportunisticSubscriptionInfoChanged() {
        try {
            sRegistry.notifyOpportunisticSubscriptionInfoChanged();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyServiceStateChanged(int slotIndex, int subId, @NonNull ServiceState state) {
        try {
            sRegistry.notifyServiceStateForPhoneId(slotIndex, subId, state);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySignalStrengthChanged(int slotIndex, int subId, @NonNull SignalStrength signalStrength) {
        try {
            sRegistry.notifySignalStrengthForPhoneId(slotIndex, subId, signalStrength);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyMessageWaitingChanged(int slotIndex, int subId, boolean msgWaitingInd) {
        try {
            sRegistry.notifyMessageWaitingChangedForPhoneId(slotIndex, subId, msgWaitingInd);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallForwardingChanged(int subId, boolean callForwardInd) {
        try {
            sRegistry.notifyCallForwardingChangedForSubscriber(subId, callForwardInd);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataActivityChanged(int subId, int dataActivityType) {
        try {
            sRegistry.notifyDataActivityForSubscriber(subId, dataActivityType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataActivityChanged(int slotIndex, int subId, int dataActivityType) {
        try {
            sRegistry.notifyDataActivityForSubscriberWithSlot(slotIndex, subId, dataActivityType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataConnectionForSubscriber(int slotIndex, int subId, @NonNull PreciseDataConnectionState preciseState) {
        try {
            sRegistry.notifyDataConnectionForSubscriber(slotIndex, subId, preciseState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallQualityChanged(int slotIndex, int subId, @NonNull CallQuality callQuality, int networkType) {
        try {
            sRegistry.notifyCallQualityChanged(callQuality, slotIndex, subId, networkType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyMediaQualityStatusChanged(int slotIndex, int subId, @NonNull MediaQualityStatus status) {
        try {
            sRegistry.notifyMediaQualityStatusChanged(slotIndex, subId, status);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyEmergencyNumberList(int slotIndex, int subId) {
        try {
            sRegistry.notifyEmergencyNumberList(slotIndex, subId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void notifyOutgoingEmergencyCall(int simSlotIndex, int subscriptionId, @NonNull EmergencyNumber emergencyNumber) {
        try {
            sRegistry.notifyOutgoingEmergencyCall(simSlotIndex, subscriptionId, emergencyNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyOutgoingEmergencySms(int phoneId, int subId, @NonNull EmergencyNumber emergencyNumber) {
        try {
            sRegistry.notifyOutgoingEmergencySms(phoneId, subId, emergencyNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyRadioPowerStateChanged(int slotIndex, int subId, int radioPowerState) {
        try {
            sRegistry.notifyRadioPowerStateChanged(slotIndex, subId, radioPowerState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyPhoneCapabilityChanged(@NonNull PhoneCapability phoneCapability) {
        try {
            sRegistry.notifyPhoneCapabilityChanged(phoneCapability);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataActivationStateChanged(int slotIndex, int subId, int activationState) {
        try {
            sRegistry.notifySimActivationStateChangedForPhoneId(slotIndex, subId, 1, activationState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyVoiceActivationStateChanged(int slotIndex, int subId, int activationState) {
        try {
            sRegistry.notifySimActivationStateChangedForPhoneId(slotIndex, subId, 0, activationState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyUserMobileDataStateChanged(int slotIndex, int subId, boolean state) {
        try {
            sRegistry.notifyUserMobileDataStateChangedForPhoneId(slotIndex, subId, state);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDisplayInfoChanged(int slotIndex, int subscriptionId, @NonNull TelephonyDisplayInfo telephonyDisplayInfo) {
        try {
            sRegistry.notifyDisplayInfoChanged(slotIndex, subscriptionId, telephonyDisplayInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyImsDisconnectCause(int subId, @NonNull ImsReasonInfo imsReasonInfo) {
        try {
            sRegistry.notifyImsDisconnectCause(subId, imsReasonInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySrvccStateChanged(int subId, int state) {
        try {
            sRegistry.notifySrvccStateChanged(subId, state);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyPreciseCallState(int slotIndex, int subId, int[] callStates, String[] imsCallIds, int[] imsServiceTypes, int[] imsCallTypes) {
        try {
            sRegistry.notifyPreciseCallState(slotIndex, subId, callStates, imsCallIds, imsServiceTypes, imsCallTypes);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDisconnectCause(int slotIndex, int subId, int cause, int preciseCause) {
        try {
            sRegistry.notifyDisconnectCause(slotIndex, subId, cause, preciseCause);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCellLocation(int subId, @NonNull CellIdentity cellLocation) {
        try {
            sRegistry.notifyCellLocationForSubscriber(subId, cellLocation);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCellInfoChanged(int subId, @NonNull List<CellInfo> cellInfo) {
        try {
            sRegistry.notifyCellInfoForSubscriber(subId, cellInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyActiveDataSubIdChanged(int activeDataSubId) {
        try {
            sRegistry.notifyActiveDataSubIdChanged(activeDataSubId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyRegistrationFailed(int slotIndex, int subId, @NonNull CellIdentity cellIdentity, @NonNull String chosenPlmn, int domain, int causeCode, int additionalCauseCode) {
        try {
            sRegistry.notifyRegistrationFailed(slotIndex, subId, cellIdentity, chosenPlmn, domain, causeCode, additionalCauseCode);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyBarringInfoChanged(int slotIndex, int subId, @NonNull BarringInfo barringInfo) {
        try {
            sRegistry.notifyBarringInfoChanged(slotIndex, subId, barringInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyPhysicalChannelConfigForSubscriber(int slotIndex, int subId, List<PhysicalChannelConfig> configs) {
        try {
            sRegistry.notifyPhysicalChannelConfigForSubscriber(slotIndex, subId, configs);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataEnabled(int slotIndex, int subId, boolean enabled, int reason) {
        try {
            sRegistry.notifyDataEnabled(slotIndex, subId, enabled, reason);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyAllowedNetworkTypesChanged(int slotIndex, int subId, int reason, long allowedNetworkType) {
        try {
            sRegistry.notifyAllowedNetworkTypesChanged(slotIndex, subId, reason, allowedNetworkType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyLinkCapacityEstimateChanged(int slotIndex, int subId, List<LinkCapacityEstimate> linkCapacityEstimateList) {
        try {
            sRegistry.notifyLinkCapacityEstimateChanged(slotIndex, subId, linkCapacityEstimateList);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySimultaneousCellularCallingSubscriptionsChanged(@NonNull Set<Integer> subIds) {
        try {
            sRegistry.notifySimultaneousCellularCallingSubscriptionsChanged(subIds.stream().mapToInt(i -> i).toArray());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierRoamingNtnModeChanged(int subId, boolean active) {
        try {
            sRegistry.notifyCarrierRoamingNtnModeChanged(subId, active);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierRoamingNtnEligibleStateChanged(int subId, boolean eligible) {
        try {
            sRegistry.notifyCarrierRoamingNtnEligibleStateChanged(subId, eligible);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierRoamingNtnAvailableServicesChanged(int subId, int[] availableServices) {
        try {
            sRegistry.notifyCarrierRoamingNtnAvailableServicesChanged(subId, availableServices);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierRoamingNtnSignalStrengthChanged(int subId, @NonNull NtnSignalStrength ntnSignalStrength) {
        try {
            sRegistry.notifyCarrierRoamingNtnSignalStrengthChanged(subId, ntnSignalStrength);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySecurityAlgorithmsChanged(int slotIndex, int subId, SecurityAlgorithmUpdate update) {
        try {
            sRegistry.notifySecurityAlgorithmsChanged(slotIndex, subId, update);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCellularIdentifierDisclosedChanged(int slotIndex, int subId, CellularIdentifierDisclosure disclosure) {
        try {
            sRegistry.notifyCellularIdentifierDisclosedChanged(slotIndex, subId, disclosure);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Set<Integer> getEventsFromCallback(@NonNull TelephonyCallback telephonyCallback) {
        ArraySet<Integer> eventList = new ArraySet<Integer>();
        if (telephonyCallback instanceof TelephonyCallback.ServiceStateListener) {
            eventList.add(1);
        }
        if (telephonyCallback instanceof TelephonyCallback.MessageWaitingIndicatorListener) {
            eventList.add(3);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallForwardingIndicatorListener) {
            eventList.add(4);
        }
        if (telephonyCallback instanceof TelephonyCallback.CellLocationListener) {
            eventList.add(5);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallStateListener) {
            eventList.add(6);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataConnectionStateListener) {
            eventList.add(7);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataActivityListener) {
            eventList.add(8);
        }
        if (telephonyCallback instanceof TelephonyCallback.SignalStrengthsListener) {
            eventList.add(9);
        }
        if (telephonyCallback instanceof TelephonyCallback.CellInfoListener) {
            eventList.add(11);
        }
        if (telephonyCallback instanceof TelephonyCallback.PreciseCallStateListener) {
            eventList.add(12);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallDisconnectCauseListener) {
            eventList.add(26);
        }
        if (telephonyCallback instanceof TelephonyCallback.ImsCallDisconnectCauseListener) {
            eventList.add(28);
        }
        if (telephonyCallback instanceof TelephonyCallback.PreciseDataConnectionStateListener) {
            eventList.add(13);
        }
        if (telephonyCallback instanceof TelephonyCallback.SrvccStateListener) {
            eventList.add(16);
        }
        if (telephonyCallback instanceof TelephonyCallback.VoiceActivationStateListener) {
            eventList.add(18);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataActivationStateListener) {
            eventList.add(19);
        }
        if (telephonyCallback instanceof TelephonyCallback.UserMobileDataStateListener) {
            eventList.add(20);
        }
        if (telephonyCallback instanceof TelephonyCallback.DisplayInfoListener) {
            eventList.add(21);
        }
        if (telephonyCallback instanceof TelephonyCallback.EmergencyNumberListListener) {
            eventList.add(25);
        }
        if (telephonyCallback instanceof TelephonyCallback.OutgoingEmergencyCallListener) {
            eventList.add(29);
        }
        if (telephonyCallback instanceof TelephonyCallback.OutgoingEmergencySmsListener) {
            eventList.add(30);
        }
        if (telephonyCallback instanceof TelephonyCallback.PhoneCapabilityListener) {
            eventList.add(22);
        }
        if (telephonyCallback instanceof TelephonyCallback.ActiveDataSubscriptionIdListener) {
            eventList.add(23);
        }
        if (telephonyCallback instanceof TelephonyCallback.RadioPowerStateListener) {
            eventList.add(24);
        }
        if (telephonyCallback instanceof TelephonyCallback.CarrierNetworkListener) {
            eventList.add(17);
        }
        if (telephonyCallback instanceof TelephonyCallback.RegistrationFailedListener) {
            eventList.add(31);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallAttributesListener) {
            eventList.add(27);
        }
        if (telephonyCallback instanceof TelephonyCallback.BarringInfoListener) {
            eventList.add(32);
        }
        if (telephonyCallback instanceof TelephonyCallback.PhysicalChannelConfigListener) {
            eventList.add(33);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataEnabledListener) {
            eventList.add(34);
        }
        if (telephonyCallback instanceof TelephonyCallback.AllowedNetworkTypesListener) {
            eventList.add(35);
        }
        if (telephonyCallback instanceof TelephonyCallback.LinkCapacityEstimateChangedListener) {
            eventList.add(37);
        }
        if (telephonyCallback instanceof TelephonyCallback.MediaQualityStatusChangedListener) {
            eventList.add(39);
        }
        if (telephonyCallback instanceof TelephonyCallback.EmergencyCallbackModeListener) {
            eventList.add(40);
        }
        if (telephonyCallback instanceof TelephonyCallback.SimultaneousCellularCallingSupportListener) {
            eventList.add(41);
        }
        if (telephonyCallback instanceof TelephonyCallback.CarrierRoamingNtnListener) {
            eventList.add(42);
            eventList.add(43);
            eventList.add(44);
            eventList.add(45);
        }
        if (telephonyCallback instanceof TelephonyCallback.CellularIdentifierDisclosedListener) {
            eventList.add(47);
        }
        if (telephonyCallback instanceof TelephonyCallback.SecurityAlgorithmsListener) {
            eventList.add(46);
        }
        return eventList;
    }

    @NonNull
    private Set<Integer> getEventsFromBitmask(int eventMask) {
        ArraySet<Integer> eventList = new ArraySet<Integer>();
        if ((eventMask & 1) != 0) {
            eventList.add(1);
        }
        if ((eventMask & 2) != 0) {
            eventList.add(2);
        }
        if ((eventMask & 4) != 0) {
            eventList.add(3);
        }
        if ((eventMask & 8) != 0) {
            eventList.add(4);
        }
        if ((eventMask & 0x10) != 0) {
            eventList.add(5);
        }
        if ((eventMask & 0x20) != 0) {
            eventList.add(36);
        }
        if ((eventMask & 0x40) != 0) {
            eventList.add(7);
        }
        if ((eventMask & 0x80) != 0) {
            eventList.add(8);
        }
        if ((eventMask & 0x100) != 0) {
            eventList.add(9);
        }
        if ((eventMask & 0x400) != 0) {
            eventList.add(11);
        }
        if ((eventMask & 0x800) != 0) {
            eventList.add(12);
        }
        if ((eventMask & 0x1000) != 0) {
            eventList.add(13);
        }
        if ((eventMask & 0x2000) != 0) {
            eventList.add(14);
        }
        if ((eventMask & 0x8000) != 0) {
            eventList.add(15);
        }
        if ((eventMask & 0x4000) != 0) {
            eventList.add(16);
        }
        if ((eventMask & 0x10000) != 0) {
            eventList.add(17);
        }
        if ((eventMask & 0x20000) != 0) {
            eventList.add(18);
        }
        if ((eventMask & 0x40000) != 0) {
            eventList.add(19);
        }
        if ((eventMask & 0x80000) != 0) {
            eventList.add(20);
        }
        if ((eventMask & 0x100000) != 0) {
            eventList.add(21);
        }
        if ((eventMask & 0x200000) != 0) {
            eventList.add(22);
        }
        if ((eventMask & 0x400000) != 0) {
            eventList.add(23);
        }
        if ((eventMask & 0x800000) != 0) {
            eventList.add(24);
        }
        if ((eventMask & 0x1000000) != 0) {
            eventList.add(25);
        }
        if ((eventMask & 0x2000000) != 0) {
            eventList.add(26);
        }
        if ((eventMask & 0x4000000) != 0) {
            eventList.add(27);
        }
        if ((eventMask & 0x8000000) != 0) {
            eventList.add(28);
        }
        if ((eventMask & 0x10000000) != 0) {
            eventList.add(29);
        }
        if ((eventMask & 0x20000000) != 0) {
            eventList.add(30);
        }
        if ((eventMask & 0x40000000) != 0) {
            eventList.add(31);
        }
        if ((eventMask & Integer.MIN_VALUE) != 0) {
            eventList.add(32);
        }
        return eventList;
    }

    public void registerTelephonyCallback(boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, @NonNull Executor executor, int subId, String pkgName, String attributionTag, @NonNull TelephonyCallback callback, boolean notifyNow) {
        if (callback == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        callback.init(executor);
        this.listenFromCallback(renounceFineLocationAccess, renounceCoarseLocationAccess, subId, pkgName, attributionTag, callback, this.getEventsFromCallback(callback).stream().mapToInt(i -> i).toArray(), notifyNow);
    }

    public void unregisterTelephonyCallback(int subId, String pkgName, String attributionTag, @NonNull TelephonyCallback callback, boolean notifyNow) {
        this.listenFromCallback(false, false, subId, pkgName, attributionTag, callback, new int[0], notifyNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSatelliteStateChangeListener(@NonNull Executor executor, @NonNull SatelliteStateChangeListener listener) {
        if (listener == null || executor == null) {
            throw new IllegalArgumentException("Listener and executor must be non-null");
        }
        Map<SatelliteStateChangeListener, WeakReference<SatelliteStateChangeListenerWrapper>> map = sSatelliteStateChangeListeners;
        synchronized (map) {
            WeakReference<SatelliteStateChangeListenerWrapper> existing = sSatelliteStateChangeListeners.get(listener);
            if (existing != null && existing.get() != null) {
                Log.d(TAG, "addSatelliteStateChangeListener: listener already registered");
                return;
            }
            SatelliteStateChangeListenerWrapper wrapper = new SatelliteStateChangeListenerWrapper(executor, listener);
            try {
                sRegistry.addSatelliteStateChangeListener(wrapper, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
                sSatelliteStateChangeListeners.put(listener, new WeakReference<SatelliteStateChangeListenerWrapper>(wrapper));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSatelliteStateChangeListener(@NonNull SatelliteStateChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        Map<SatelliteStateChangeListener, WeakReference<SatelliteStateChangeListenerWrapper>> map = sSatelliteStateChangeListeners;
        synchronized (map) {
            WeakReference<SatelliteStateChangeListenerWrapper> ref = sSatelliteStateChangeListeners.get(listener);
            if (ref == null) {
                return;
            }
            SatelliteStateChangeListenerWrapper wrapper = (SatelliteStateChangeListenerWrapper)ref.get();
            if (wrapper == null) {
                return;
            }
            try {
                sRegistry.removeSatelliteStateChangeListener(wrapper, this.mContext.getOpPackageName());
                sSatelliteStateChangeListeners.remove(listener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void notifySatelliteStateChanged(boolean isEnabled) {
        try {
            sRegistry.notifySatelliteStateChanged(isEnabled);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCarrierPrivilegesCallback(int logicalSlotIndex, @NonNull Executor executor, @NonNull TelephonyManager.CarrierPrivilegesCallback callback) {
        if (callback == null || executor == null) {
            throw new IllegalArgumentException("callback and executor must be non-null");
        }
        WeakHashMap<TelephonyManager.CarrierPrivilegesCallback, WeakReference<CarrierPrivilegesCallbackWrapper>> weakHashMap = sCarrierPrivilegeCallbacks;
        synchronized (weakHashMap) {
            WeakReference<CarrierPrivilegesCallbackWrapper> existing = sCarrierPrivilegeCallbacks.get(callback);
            if (existing != null && existing.get() != null) {
                Log.d(TAG, "addCarrierPrivilegesCallback: callback already registered");
                return;
            }
            CarrierPrivilegesCallbackWrapper wrapper = new CarrierPrivilegesCallbackWrapper(callback, executor);
            sCarrierPrivilegeCallbacks.put(callback, new WeakReference<CarrierPrivilegesCallbackWrapper>(wrapper));
            try {
                sRegistry.addCarrierPrivilegesCallback(logicalSlotIndex, wrapper, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCarrierPrivilegesCallback(@NonNull TelephonyManager.CarrierPrivilegesCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        WeakHashMap<TelephonyManager.CarrierPrivilegesCallback, WeakReference<CarrierPrivilegesCallbackWrapper>> weakHashMap = sCarrierPrivilegeCallbacks;
        synchronized (weakHashMap) {
            WeakReference<CarrierPrivilegesCallbackWrapper> ref = sCarrierPrivilegeCallbacks.remove(callback);
            if (ref == null) {
                return;
            }
            CarrierPrivilegesCallbackWrapper wrapper = (CarrierPrivilegesCallbackWrapper)ref.get();
            if (wrapper == null) {
                return;
            }
            try {
                sRegistry.removeCarrierPrivilegesCallback(wrapper, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void notifyCarrierPrivilegesChanged(int logicalSlotIndex, @NonNull Set<String> privilegedPackageNames, @NonNull Set<Integer> privilegedUids) {
        if (privilegedPackageNames == null || privilegedUids == null) {
            throw new IllegalArgumentException("privilegedPackageNames and privilegedUids must be non-null");
        }
        try {
            List<String> pkgList = List.copyOf(privilegedPackageNames);
            int[] uids = privilegedUids.stream().mapToInt(Number::intValue).toArray();
            sRegistry.notifyCarrierPrivilegesChanged(logicalSlotIndex, pkgList, uids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierServiceChanged(int logicalSlotIndex, @Nullable String packageName, int uid) {
        try {
            sRegistry.notifyCarrierServiceChanged(logicalSlotIndex, packageName, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addCarrierConfigChangedListener(final @NonNull Executor executor, final @NonNull CarrierConfigManager.CarrierConfigChangeListener listener) {
        Objects.requireNonNull(executor, "Executor should be non-null.");
        Objects.requireNonNull(listener, "Listener should be non-null.");
        if (this.mCarrierConfigChangeListenerMap.get(listener) != null) {
            Log.e(TAG, "registerCarrierConfigChangeListener: listener already present");
            return;
        }
        ICarrierConfigChangeListener.Stub callback = new ICarrierConfigChangeListener.Stub(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCarrierConfigChanged(int slotIndex, int subId, int carrierId, int specificCarrierId) {
                Log.d(TelephonyRegistryManager.TAG, "onCarrierConfigChanged call in ICarrierConfigChangeListener callback");
                long identify = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onCarrierConfigChanged(slotIndex, subId, carrierId, specificCarrierId));
                }
                finally {
                    Binder.restoreCallingIdentity(identify);
                }
            }
        };
        try {
            sRegistry.addCarrierConfigChangeListener(callback, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            this.mCarrierConfigChangeListenerMap.put(listener, callback);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void removeCarrierConfigChangedListener(@NonNull CarrierConfigManager.CarrierConfigChangeListener listener) {
        Objects.requireNonNull(listener, "Listener should be non-null.");
        if (this.mCarrierConfigChangeListenerMap.get(listener) == null) {
            Log.e(TAG, "removeCarrierConfigChangedListener: listener was not present");
            return;
        }
        try {
            sRegistry.removeCarrierConfigChangeListener(this.mCarrierConfigChangeListenerMap.get(listener), this.mContext.getOpPackageName());
            this.mCarrierConfigChangeListenerMap.remove(listener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierConfigChanged(int slotIndex, int subId, int carrierId, int specificCarrierId) {
        if (!SubscriptionManager.isValidPhoneId(slotIndex)) {
            Log.e(TAG, "notifyCarrierConfigChanged, ignored: invalid slotIndex " + slotIndex);
            return;
        }
        try {
            sRegistry.notifyCarrierConfigChanged(slotIndex, subId, carrierId, specificCarrierId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void notifyCallbackModeStarted(int phoneId, int subId, int type, long durationMillis) {
        try {
            Log.d(TAG, "notifyCallbackModeStarted:type=" + type);
            sRegistry.notifyCallbackModeStarted(phoneId, subId, type, durationMillis);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallbackModeRestarted(int phoneId, int subId, int type, long durationMillis) {
        try {
            Log.d(TAG, "notifyCallbackModeRestarted:type=" + type);
            sRegistry.notifyCallbackModeRestarted(phoneId, subId, type, durationMillis);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallbackModeStopped(int phoneId, int subId, int type, int reason) {
        try {
            Log.d(TAG, "notifyCallbackModeStopped:type=" + type + ", reason=" + reason);
            sRegistry.notifyCallbackModeStopped(phoneId, subId, type, reason);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    static {
        sSatelliteStateChangeListeners = new ArrayMap<SatelliteStateChangeListener, WeakReference<SatelliteStateChangeListenerWrapper>>();
        sCarrierPrivilegeCallbacks = new WeakHashMap();
    }

    private static class SatelliteStateChangeListenerWrapper
    extends ISatelliteStateChangeListener.Stub
    implements ListenerExecutor {
        @NonNull
        private final WeakReference<SatelliteStateChangeListener> mListener;
        @NonNull
        private final Executor mExecutor;

        SatelliteStateChangeListenerWrapper(@NonNull Executor executor, @NonNull SatelliteStateChangeListener listener) {
            this.mExecutor = executor;
            this.mListener = new WeakReference<SatelliteStateChangeListener>(listener);
        }

        @Override
        public void onSatelliteEnabledStateChanged(boolean isEnabled) {
            Binder.withCleanCallingIdentity(() -> this.executeSafely(this.mExecutor, this.mListener::get, sscl -> sscl.onEnabledStateChanged(isEnabled)));
        }
    }

    private static class CarrierPrivilegesCallbackWrapper
    extends ICarrierPrivilegesCallback.Stub
    implements ListenerExecutor {
        @NonNull
        private final WeakReference<TelephonyManager.CarrierPrivilegesCallback> mCallback;
        @NonNull
        private final Executor mExecutor;

        CarrierPrivilegesCallbackWrapper(@NonNull TelephonyManager.CarrierPrivilegesCallback callback, @NonNull Executor executor) {
            this.mCallback = new WeakReference<TelephonyManager.CarrierPrivilegesCallback>(callback);
            this.mExecutor = executor;
        }

        @Override
        public void onCarrierPrivilegesChanged(@NonNull List<String> privilegedPackageNames, @NonNull int[] privilegedUids) {
            Set<String> privilegedPkgNamesSet = Set.copyOf(privilegedPackageNames);
            Set privilegedUidsSet = Arrays.stream(privilegedUids).boxed().collect(Collectors.toSet());
            Binder.withCleanCallingIdentity(() -> this.executeSafely(this.mExecutor, this.mCallback::get, cpc -> cpc.onCarrierPrivilegesChanged(privilegedPkgNamesSet, privilegedUidsSet)));
        }

        @Override
        public void onCarrierServiceChanged(@Nullable String packageName, int uid) {
            Binder.withCleanCallingIdentity(() -> this.executeSafely(this.mExecutor, this.mCallback::get, cpc -> cpc.onCarrierServiceChanged(packageName, uid)));
        }
    }
}

