/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.VopsSupportInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class NrVopsSupportInfo
extends VopsSupportInfo {
    public static final int NR_STATUS_VOPS_NOT_SUPPORTED = 0;
    public static final int NR_STATUS_VOPS_3GPP_SUPPORTED = 1;
    public static final int NR_STATUS_VOPS_NON_3GPP_SUPPORTED = 2;
    public static final int NR_STATUS_EMC_NOT_SUPPORTED = 0;
    public static final int NR_STATUS_EMC_5GCN_ONLY = 1;
    public static final int NR_STATUS_EMC_EUTRA_5GCN_ONLY = 2;
    public static final int NR_STATUS_EMC_NR_EUTRA_5GCN = 3;
    public static final int NR_STATUS_EMF_NOT_SUPPORTED = 0;
    public static final int NR_STATUS_EMF_5GCN_ONLY = 1;
    public static final int NR_STATUS_EMF_EUTRA_5GCN_ONLY = 2;
    public static final int NR_STATUS_EMF_NR_EUTRA_5GCN = 3;
    private final int mVopsSupport;
    private final int mEmcSupport;
    private final int mEmfSupport;
    @NonNull
    public static final Parcelable.Creator<NrVopsSupportInfo> CREATOR = new Parcelable.Creator<NrVopsSupportInfo>(){

        @Override
        public NrVopsSupportInfo createFromParcel(Parcel in) {
            in.readInt();
            return new NrVopsSupportInfo(in);
        }

        public NrVopsSupportInfo[] newArray(int size) {
            return new NrVopsSupportInfo[size];
        }
    };

    public NrVopsSupportInfo(int vops, int emc, int emf) {
        this.mVopsSupport = vops;
        this.mEmcSupport = emc;
        this.mEmfSupport = emf;
    }

    public int getVopsSupport() {
        return this.mVopsSupport;
    }

    public int getEmcSupport() {
        return this.mEmcSupport;
    }

    public int getEmfSupport() {
        return this.mEmfSupport;
    }

    @Override
    public boolean isVopsSupported() {
        return this.mVopsSupport != 0;
    }

    @Override
    public boolean isEmergencyServiceSupported() {
        return this.mEmcSupport != 0;
    }

    @Override
    public boolean isEmergencyServiceFallbackSupported() {
        return this.mEmfSupport != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        super.writeToParcel(out, flags, 6);
        out.writeInt(this.mVopsSupport);
        out.writeInt(this.mEmcSupport);
        out.writeInt(this.mEmfSupport);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof NrVopsSupportInfo)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        NrVopsSupportInfo other = (NrVopsSupportInfo)o;
        return this.mVopsSupport == other.mVopsSupport && this.mEmcSupport == other.mEmcSupport && this.mEmfSupport == other.mEmfSupport;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mVopsSupport, this.mEmcSupport, this.mEmfSupport);
    }

    @NonNull
    public String toString() {
        return "NrVopsSupportInfo :  mVopsSupport = " + this.mVopsSupport + " mEmcSupport = " + this.mEmcSupport + " mEmfSupport = " + this.mEmfSupport;
    }

    protected static NrVopsSupportInfo createFromParcelBody(Parcel in) {
        return new NrVopsSupportInfo(in);
    }

    private NrVopsSupportInfo(Parcel in) {
        this.mVopsSupport = in.readInt();
        this.mEmcSupport = in.readInt();
        this.mEmfSupport = in.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NrEmfStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NrEmcStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NrVopsStatus {
    }
}

