/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.telephony.IMms;

public class MmsManager {
    private static final String TAG = "MmsManager";
    private final Context mContext;

    public MmsManager(@NonNull Context context) {
        this.mContext = context;
    }

    public void sendMultimediaMessage(int subId, @NonNull Uri contentUri, @Nullable String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent, long messageId) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.sendMessage(subId, -10000, ActivityThread.currentPackageName(), contentUri, locationUrl, configOverrides, sentIntent, messageId, this.mContext.getAttributionTag());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void downloadMultimediaMessage(int subId, @NonNull String locationUrl, @NonNull Uri contentUri, @Nullable Bundle configOverrides, @Nullable PendingIntent downloadedIntent, long messageId) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.downloadMessage(subId, -10000, ActivityThread.currentPackageName(), locationUrl, contentUri, configOverrides, downloadedIntent, messageId, this.mContext.getAttributionTag());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

