/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class CallForwardingInfo
implements Parcelable {
    private static final String TAG = "CallForwardingInfo";
    public static final int REASON_UNCONDITIONAL = 0;
    public static final int REASON_BUSY = 1;
    public static final int REASON_NO_REPLY = 2;
    public static final int REASON_NOT_REACHABLE = 3;
    public static final int REASON_ALL = 4;
    public static final int REASON_ALL_CONDITIONAL = 5;
    private boolean mEnabled;
    private int mReason;
    private String mNumber;
    private int mTimeSeconds;
    @NonNull
    public static final Parcelable.Creator<CallForwardingInfo> CREATOR = new Parcelable.Creator<CallForwardingInfo>(){

        @Override
        public CallForwardingInfo createFromParcel(Parcel in) {
            return new CallForwardingInfo(in);
        }

        public CallForwardingInfo[] newArray(int size) {
            return new CallForwardingInfo[size];
        }
    };

    public CallForwardingInfo(boolean enabled, int reason, @Nullable String number, int timeSeconds) {
        this.mEnabled = enabled;
        this.mReason = reason;
        this.mNumber = number;
        this.mTimeSeconds = timeSeconds;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public int getReason() {
        return this.mReason;
    }

    @Nullable
    public String getNumber() {
        return this.mNumber;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getTimeoutSeconds() {
        return this.mTimeSeconds;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mNumber);
        out.writeBoolean(this.mEnabled);
        out.writeInt(this.mReason);
        out.writeInt(this.mTimeSeconds);
    }

    private CallForwardingInfo(Parcel in) {
        this.mNumber = in.readString();
        this.mEnabled = in.readBoolean();
        this.mReason = in.readInt();
        this.mTimeSeconds = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallForwardingInfo)) {
            return false;
        }
        CallForwardingInfo other = (CallForwardingInfo)o;
        return this.mEnabled == other.mEnabled && this.mNumber == other.mNumber && this.mReason == other.mReason && this.mTimeSeconds == other.mTimeSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.mEnabled, this.mNumber, this.mReason, this.mTimeSeconds);
    }

    public String toString() {
        return "[CallForwardingInfo: enabled=" + this.mEnabled + ", reason= " + this.mReason + ", timeSec= " + this.mTimeSeconds + " seconds, number=" + Rlog.pii(TAG, (Object)this.mNumber) + "]";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallForwardingReason {
    }
}

