/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.ParcelableCallAnalytics;
import android.telecom.TimedEvent;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class TelecomAnalytics
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<TelecomAnalytics> CREATOR = new Parcelable.Creator<TelecomAnalytics>(){

        @Override
        public TelecomAnalytics createFromParcel(Parcel in) {
            return new TelecomAnalytics(in);
        }

        public TelecomAnalytics[] newArray(int size) {
            return new TelecomAnalytics[size];
        }
    };
    private List<SessionTiming> mSessionTimings;
    private List<ParcelableCallAnalytics> mCallAnalytics;

    public TelecomAnalytics(List<SessionTiming> sessionTimings, List<ParcelableCallAnalytics> callAnalytics) {
        this.mSessionTimings = sessionTimings;
        this.mCallAnalytics = callAnalytics;
    }

    private TelecomAnalytics(Parcel in) {
        this.mSessionTimings = new ArrayList<SessionTiming>();
        in.readTypedList(this.mSessionTimings, SessionTiming.CREATOR);
        this.mCallAnalytics = new ArrayList<ParcelableCallAnalytics>();
        in.readTypedList(this.mCallAnalytics, ParcelableCallAnalytics.CREATOR);
    }

    public List<SessionTiming> getSessionTimings() {
        return this.mSessionTimings;
    }

    public List<ParcelableCallAnalytics> getCallAnalytics() {
        return this.mCallAnalytics;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedList(this.mSessionTimings);
        out.writeTypedList(this.mCallAnalytics);
    }

    public static class SessionTiming
    extends TimedEvent<Integer>
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<SessionTiming> CREATOR = new Parcelable.Creator<SessionTiming>(){

            @Override
            public SessionTiming createFromParcel(Parcel in) {
                return new SessionTiming(in);
            }

            public SessionTiming[] newArray(int size) {
                return new SessionTiming[size];
            }
        };
        public static final int ICA_ANSWER_CALL = 1;
        public static final int ICA_REJECT_CALL = 2;
        public static final int ICA_DISCONNECT_CALL = 3;
        public static final int ICA_HOLD_CALL = 4;
        public static final int ICA_UNHOLD_CALL = 5;
        public static final int ICA_MUTE = 6;
        public static final int ICA_SET_AUDIO_ROUTE = 7;
        public static final int ICA_CONFERENCE = 8;
        public static final int CSW_HANDLE_CREATE_CONNECTION_COMPLETE = 100;
        public static final int CSW_SET_ACTIVE = 101;
        public static final int CSW_SET_RINGING = 102;
        public static final int CSW_SET_DIALING = 103;
        public static final int CSW_SET_DISCONNECTED = 104;
        public static final int CSW_SET_ON_HOLD = 105;
        public static final int CSW_REMOVE_CALL = 106;
        public static final int CSW_SET_IS_CONFERENCED = 107;
        public static final int CSW_ADD_CONFERENCE_CALL = 108;
        private int mId;
        private long mTime;

        public SessionTiming(int id2, long time) {
            this.mId = id2;
            this.mTime = time;
        }

        private SessionTiming(Parcel in) {
            this.mId = in.readInt();
            this.mTime = in.readLong();
        }

        @Override
        public Integer getKey() {
            return this.mId;
        }

        @Override
        public long getTime() {
            return this.mTime;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mId);
            out.writeLong(this.mTime);
        }
    }
}

