/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualizationservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.system.virtualizationservice.AssignableDevice;
import android.system.virtualizationservice.IVirtualMachine;
import android.system.virtualizationservice.VirtualMachineConfig;
import android.system.virtualizationservice.VirtualMachineDebugInfo;

public interface IVirtualizationService
extends IInterface {
    public static final String DESCRIPTOR = "android.system.virtualizationservice.IVirtualizationService";
    public static final String FEATURE_DICE_CHANGES = "com.android.kvm.DICE_CHANGES";
    public static final String FEATURE_LLPVM_CHANGES = "com.android.kvm.LLPVM_CHANGES";
    public static final String FEATURE_MULTI_TENANT = "com.android.kvm.MULTI_TENANT";
    public static final String FEATURE_NETWORK = "com.android.kvm.NETWORK";
    public static final String FEATURE_REMOTE_ATTESTATION = "com.android.kvm.REMOTE_ATTESTATION";
    public static final String FEATURE_VENDOR_MODULES = "com.android.kvm.VENDOR_MODULES";

    public IVirtualMachine createVm(VirtualMachineConfig var1, ParcelFileDescriptor var2, ParcelFileDescriptor var3, ParcelFileDescriptor var4, ParcelFileDescriptor var5) throws RemoteException;

    public byte[] allocateInstanceId() throws RemoteException;

    public void initializeWritablePartition(ParcelFileDescriptor var1, long var2, int var4) throws RemoteException;

    public void setEncryptedStorageSize(ParcelFileDescriptor var1, long var2) throws RemoteException;

    public void createOrUpdateIdsigFile(ParcelFileDescriptor var1, ParcelFileDescriptor var2) throws RemoteException;

    public VirtualMachineDebugInfo[] debugListVms() throws RemoteException;

    public AssignableDevice[] getAssignableDevices() throws RemoteException;

    public String[] getSupportedOSList() throws RemoteException;

    public String getDebugPolicy() throws RemoteException;

    public boolean isFeatureEnabled(String var1) throws RemoteException;

    public void enableTestAttestation() throws RemoteException;

    public boolean isRemoteAttestationSupported() throws RemoteException;

    public boolean isUpdatableVmSupported() throws RemoteException;

    public void removeVmInstance(byte[] var1) throws RemoteException;

    public void claimVmInstance(byte[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualizationService {
        static final int TRANSACTION_createVm = 1;
        static final int TRANSACTION_allocateInstanceId = 2;
        static final int TRANSACTION_initializeWritablePartition = 3;
        static final int TRANSACTION_setEncryptedStorageSize = 4;
        static final int TRANSACTION_createOrUpdateIdsigFile = 5;
        static final int TRANSACTION_debugListVms = 6;
        static final int TRANSACTION_getAssignableDevices = 7;
        static final int TRANSACTION_getSupportedOSList = 8;
        static final int TRANSACTION_getDebugPolicy = 9;
        static final int TRANSACTION_isFeatureEnabled = 10;
        static final int TRANSACTION_enableTestAttestation = 11;
        static final int TRANSACTION_isRemoteAttestationSupported = 12;
        static final int TRANSACTION_isUpdatableVmSupported = 13;
        static final int TRANSACTION_removeVmInstance = 14;
        static final int TRANSACTION_claimVmInstance = 15;

        public Stub() {
            this.attachInterface(this, IVirtualizationService.DESCRIPTOR);
        }

        public static IVirtualizationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualizationService.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualizationService) {
                return (IVirtualizationService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualizationService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    VirtualMachineConfig _arg0 = data.readTypedObject(VirtualMachineConfig.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg3 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg4 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    IVirtualMachine _result = this.createVm(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    byte[] _result = this.allocateInstanceId();
                    reply.writeNoException();
                    reply.writeFixedArray(_result, 1, 64);
                    break;
                }
                case 3: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.initializeWritablePartition(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setEncryptedStorageSize(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.createOrUpdateIdsigFile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    Parcelable[] _result = this.debugListVms();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 7: {
                    Parcelable[] _result = this.getAssignableDevices();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 8: {
                    String[] _result = this.getSupportedOSList();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 9: {
                    String _result = this.getDebugPolicy();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isFeatureEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    this.enableTestAttestation();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    boolean _result = this.isRemoteAttestationSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    boolean _result = this.isUpdatableVmSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    byte[] _arg0 = data.createFixedArray(byte[].class, 64);
                    data.enforceNoDataAvail();
                    this.removeVmInstance(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    byte[] _arg0 = data.createFixedArray(byte[].class, 64);
                    data.enforceNoDataAvail();
                    this.claimVmInstance(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IVirtualizationService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualizationService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualMachine createVm(VirtualMachineConfig config, ParcelFileDescriptor consoleOutFd, ParcelFileDescriptor consoleInFd, ParcelFileDescriptor osLogFd, ParcelFileDescriptor dumpDtFd) throws RemoteException {
                IVirtualMachine _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeTypedObject(consoleOutFd, 0);
                    _data.writeTypedObject(consoleInFd, 0);
                    _data.writeTypedObject(osLogFd, 0);
                    _data.writeTypedObject(dumpDtFd, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualMachine.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] allocateInstanceId() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createFixedArray(byte[].class, 64);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeWritablePartition(ParcelFileDescriptor imageFd, long sizeBytes, int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeTypedObject(imageFd, 0);
                    _data.writeLong(sizeBytes);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEncryptedStorageSize(ParcelFileDescriptor imageFd, long size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeTypedObject(imageFd, 0);
                    _data.writeLong(size);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createOrUpdateIdsigFile(ParcelFileDescriptor inputFd, ParcelFileDescriptor idsigFd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeTypedObject(inputFd, 0);
                    _data.writeTypedObject(idsigFd, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VirtualMachineDebugInfo[] debugListVms() throws RemoteException {
                VirtualMachineDebugInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(VirtualMachineDebugInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AssignableDevice[] getAssignableDevices() throws RemoteException {
                AssignableDevice[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(AssignableDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSupportedOSList() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDebugPolicy() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFeatureEnabled(String feature) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeString(feature);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTestAttestation() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRemoteAttestationSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUpdatableVmSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeVmInstance(byte[] instanceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeFixedArray(instanceId, 0, 64);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void claimVmInstance(byte[] instanceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualizationService.DESCRIPTOR);
                    _data.writeFixedArray(instanceId, 0, 64);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualizationService {
        @Override
        public IVirtualMachine createVm(VirtualMachineConfig config, ParcelFileDescriptor consoleOutFd, ParcelFileDescriptor consoleInFd, ParcelFileDescriptor osLogFd, ParcelFileDescriptor dumpDtFd) throws RemoteException {
            return null;
        }

        @Override
        public byte[] allocateInstanceId() throws RemoteException {
            return null;
        }

        @Override
        public void initializeWritablePartition(ParcelFileDescriptor imageFd, long sizeBytes, int type) throws RemoteException {
        }

        @Override
        public void setEncryptedStorageSize(ParcelFileDescriptor imageFd, long size) throws RemoteException {
        }

        @Override
        public void createOrUpdateIdsigFile(ParcelFileDescriptor inputFd, ParcelFileDescriptor idsigFd) throws RemoteException {
        }

        @Override
        public VirtualMachineDebugInfo[] debugListVms() throws RemoteException {
            return null;
        }

        @Override
        public AssignableDevice[] getAssignableDevices() throws RemoteException {
            return null;
        }

        @Override
        public String[] getSupportedOSList() throws RemoteException {
            return null;
        }

        @Override
        public String getDebugPolicy() throws RemoteException {
            return null;
        }

        @Override
        public boolean isFeatureEnabled(String feature) throws RemoteException {
            return false;
        }

        @Override
        public void enableTestAttestation() throws RemoteException {
        }

        @Override
        public boolean isRemoteAttestationSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isUpdatableVmSupported() throws RemoteException {
            return false;
        }

        @Override
        public void removeVmInstance(byte[] instanceId) throws RemoteException {
        }

        @Override
        public void claimVmInstance(byte[] instanceId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

