/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.app.wallpaper.WallpaperDescription;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.SurfaceControl;
import java.util.ArrayList;
import java.util.List;

public interface IWallpaperEngine
extends IInterface {
    public void setDesiredSize(int var1, int var2) throws RemoteException;

    public void setDisplayPadding(Rect var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:34:1:34:25")
    public void setVisibility(boolean var1) throws RemoteException;

    public void onScreenTurningOn() throws RemoteException;

    public void onScreenTurnedOn() throws RemoteException;

    public void setInAmbientMode(boolean var1, long var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:39:1:39:25")
    public void dispatchPointer(MotionEvent var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:41:1:41:25")
    public void dispatchWallpaperCommand(String var1, int var2, int var3, int var4, Bundle var5) throws RemoteException;

    public void requestWallpaperColors() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/wallpaper/IWallpaperEngine.aidl:45:1:45:25")
    public void destroy() throws RemoteException;

    public void setZoomOut(float var1) throws RemoteException;

    public void resizePreview(Rect var1) throws RemoteException;

    public void removeLocalColorsAreas(List<RectF> var1) throws RemoteException;

    public void addLocalColorsAreas(List<RectF> var1) throws RemoteException;

    public SurfaceControl mirrorSurfaceControl() throws RemoteException;

    public void applyDimming(float var1) throws RemoteException;

    public void setWallpaperFlags(int var1) throws RemoteException;

    public WallpaperDescription onApplyWallpaper(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWallpaperEngine {
        public static final String DESCRIPTOR = "android.service.wallpaper.IWallpaperEngine";
        static final int TRANSACTION_setDesiredSize = 1;
        static final int TRANSACTION_setDisplayPadding = 2;
        static final int TRANSACTION_setVisibility = 3;
        static final int TRANSACTION_onScreenTurningOn = 4;
        static final int TRANSACTION_onScreenTurnedOn = 5;
        static final int TRANSACTION_setInAmbientMode = 6;
        static final int TRANSACTION_dispatchPointer = 7;
        static final int TRANSACTION_dispatchWallpaperCommand = 8;
        static final int TRANSACTION_requestWallpaperColors = 9;
        static final int TRANSACTION_destroy = 10;
        static final int TRANSACTION_setZoomOut = 11;
        static final int TRANSACTION_resizePreview = 12;
        static final int TRANSACTION_removeLocalColorsAreas = 13;
        static final int TRANSACTION_addLocalColorsAreas = 14;
        static final int TRANSACTION_mirrorSurfaceControl = 15;
        static final int TRANSACTION_applyDimming = 16;
        static final int TRANSACTION_setWallpaperFlags = 17;
        static final int TRANSACTION_onApplyWallpaper = 18;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWallpaperEngine asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWallpaperEngine) {
                return (IWallpaperEngine)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setDesiredSize";
                }
                case 2: {
                    return "setDisplayPadding";
                }
                case 3: {
                    return "setVisibility";
                }
                case 4: {
                    return "onScreenTurningOn";
                }
                case 5: {
                    return "onScreenTurnedOn";
                }
                case 6: {
                    return "setInAmbientMode";
                }
                case 7: {
                    return "dispatchPointer";
                }
                case 8: {
                    return "dispatchWallpaperCommand";
                }
                case 9: {
                    return "requestWallpaperColors";
                }
                case 10: {
                    return "destroy";
                }
                case 11: {
                    return "setZoomOut";
                }
                case 12: {
                    return "resizePreview";
                }
                case 13: {
                    return "removeLocalColorsAreas";
                }
                case 14: {
                    return "addLocalColorsAreas";
                }
                case 15: {
                    return "mirrorSurfaceControl";
                }
                case 16: {
                    return "applyDimming";
                }
                case 17: {
                    return "setWallpaperFlags";
                }
                case 18: {
                    return "onApplyWallpaper";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDesiredSize(_arg0, _arg1);
                    break;
                }
                case 2: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDisplayPadding(_arg0);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setVisibility(_arg0);
                    break;
                }
                case 4: {
                    this.onScreenTurningOn();
                    break;
                }
                case 5: {
                    this.onScreenTurnedOn();
                    break;
                }
                case 6: {
                    boolean _arg0 = data.readBoolean();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setInAmbientMode(_arg0, _arg1);
                    break;
                }
                case 7: {
                    MotionEvent _arg0 = data.readTypedObject(MotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchPointer(_arg0);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 9: {
                    this.requestWallpaperColors();
                    break;
                }
                case 10: {
                    this.destroy();
                    break;
                }
                case 11: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setZoomOut(_arg0);
                    break;
                }
                case 12: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.resizePreview(_arg0);
                    break;
                }
                case 13: {
                    ArrayList<RectF> _arg0 = data.createTypedArrayList(RectF.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeLocalColorsAreas(_arg0);
                    break;
                }
                case 14: {
                    ArrayList<RectF> _arg0 = data.createTypedArrayList(RectF.CREATOR);
                    data.enforceNoDataAvail();
                    this.addLocalColorsAreas(_arg0);
                    break;
                }
                case 15: {
                    SurfaceControl _result = this.mirrorSurfaceControl();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.applyDimming(_arg0);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWallpaperFlags(_arg0);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    WallpaperDescription _result = this.onApplyWallpaper(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements IWallpaperEngine {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDesiredSize(int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayPadding(Rect padding) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(padding, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onScreenTurningOn() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onScreenTurnedOn() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInAmbientMode(boolean inAmbientDisplay, long animationDuration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inAmbientDisplay);
                    _data.writeLong(animationDuration);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchPointer(MotionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestWallpaperColors() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void destroy() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setZoomOut(float scale) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(scale);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resizePreview(Rect positionInWindow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(positionInWindow, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeLocalColorsAreas(List<RectF> regions) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(regions, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLocalColorsAreas(List<RectF> regions) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(regions, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl mirrorSurfaceControl() throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyDimming(float dimAmount) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(dimAmount);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperFlags(int which) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WallpaperDescription onApplyWallpaper(int which) throws RemoteException {
                WallpaperDescription _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WallpaperDescription.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWallpaperEngine {
        @Override
        public void setDesiredSize(int width, int height) throws RemoteException {
        }

        @Override
        public void setDisplayPadding(Rect padding) throws RemoteException {
        }

        @Override
        public void setVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void onScreenTurningOn() throws RemoteException {
        }

        @Override
        public void onScreenTurnedOn() throws RemoteException {
        }

        @Override
        public void setInAmbientMode(boolean inAmbientDisplay, long animationDuration) throws RemoteException {
        }

        @Override
        public void dispatchPointer(MotionEvent event) throws RemoteException {
        }

        @Override
        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras) throws RemoteException {
        }

        @Override
        public void requestWallpaperColors() throws RemoteException {
        }

        @Override
        public void destroy() throws RemoteException {
        }

        @Override
        public void setZoomOut(float scale) throws RemoteException {
        }

        @Override
        public void resizePreview(Rect positionInWindow) throws RemoteException {
        }

        @Override
        public void removeLocalColorsAreas(List<RectF> regions) throws RemoteException {
        }

        @Override
        public void addLocalColorsAreas(List<RectF> regions) throws RemoteException {
        }

        @Override
        public SurfaceControl mirrorSurfaceControl() throws RemoteException {
            return null;
        }

        @Override
        public void applyDimming(float dimAmount) throws RemoteException {
        }

        @Override
        public void setWallpaperFlags(int which) throws RemoteException {
        }

        @Override
        public WallpaperDescription onApplyWallpaper(int which) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

