/*
 * Decompiled with CFR 0.152.
 */
package android.service.selectiontoolbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.IBinder;
import android.service.selectiontoolbar.SelectionToolbarRenderService;
import android.view.MotionEvent;
import android.widget.LinearLayout;
import java.io.PrintWriter;

@SuppressLint(value={"ViewConstructor"})
public class FloatingToolbarRoot
extends LinearLayout {
    private static final boolean DEBUG = false;
    private static final String TAG = "FloatingToolbarRoot";
    private final IBinder mTargetInputToken;
    private final SelectionToolbarRenderService.TransferTouchListener mTransferTouchListener;
    private final Rect mContentRect = new Rect();
    private int mLastDownX = -1;
    private int mLastDownY = -1;

    public FloatingToolbarRoot(Context context, IBinder targetInputToken, SelectionToolbarRenderService.TransferTouchListener transferTouchListener) {
        super(context);
        this.mTargetInputToken = targetInputToken;
        this.mTransferTouchListener = transferTouchListener;
        this.setFocusable(false);
    }

    public void setContentRect(Rect contentRect) {
        this.mContentRect.set(contentRect);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getActionMasked() == 0) {
            this.mLastDownX = (int)event.getX();
            this.mLastDownY = (int)event.getY();
            if (!this.mContentRect.contains(this.mLastDownX, this.mLastDownY)) {
                this.mTransferTouchListener.onTransferTouch(this.getViewRootImpl().getInputToken(), this.mTargetInputToken);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.println("FloatingToolbarRoot:");
        pw.print(prefix + "  ");
        pw.print("last down X: ");
        pw.println(this.mLastDownX);
        pw.print(prefix + "  ");
        pw.print("last down Y: ");
        pw.println(this.mLastDownY);
    }
}

