/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.NonNull;
import android.app.NotificationManager;
import android.service.notification.ZenPolicy;

public class ZenAdapters {
    @NonNull
    public static ZenPolicy notificationPolicyToZenPolicy(@NonNull NotificationManager.Policy policy) {
        ZenPolicy.Builder zenPolicyBuilder = new ZenPolicy.Builder().allowAlarms(policy.allowAlarms()).allowCalls(policy.allowCalls() ? ZenAdapters.prioritySendersToPeopleType(policy.allowCallsFrom()) : 4).allowConversations(policy.allowConversations() ? ZenAdapters.notificationPolicyConversationSendersToZenPolicy(policy.allowConversationsFrom()) : 3).allowEvents(policy.allowEvents()).allowMedia(policy.allowMedia()).allowMessages(policy.allowMessages() ? ZenAdapters.prioritySendersToPeopleType(policy.allowMessagesFrom()) : 4).allowReminders(policy.allowReminders()).allowRepeatCallers(policy.allowRepeatCallers()).allowSystem(policy.allowSystem()).allowPriorityChannels(policy.allowPriorityChannels());
        if (policy.suppressedVisualEffects != -1) {
            zenPolicyBuilder.showBadges(policy.showBadges()).showFullScreenIntent(policy.showFullScreenIntents()).showInAmbientDisplay(policy.showAmbient()).showInNotificationList(policy.showInNotificationList()).showLights(policy.showLights()).showPeeking(policy.showPeeking()).showStatusBarIcons(policy.showStatusBarIcons());
        }
        return zenPolicyBuilder.build();
    }

    public static int peopleTypeToPrioritySenders(int zpPeopleType, int defaultResult) {
        switch (zpPeopleType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return defaultResult;
    }

    public static int prioritySendersToPeopleType(int npPrioritySenders) {
        switch (npPrioritySenders) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    public static int zenPolicyConversationSendersToNotificationPolicy(int zpConversationSenders, int defaultResult) {
        switch (zpConversationSenders) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return defaultResult;
    }

    private static int notificationPolicyConversationSendersToZenPolicy(int npPriorityConversationSenders) {
        switch (npPriorityConversationSenders) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }
}

