/*
 * Decompiled with CFR 0.152.
 */
package android.service.gatekeeper;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.gatekeeper.GateKeeperResponse;

public interface IGateKeeperService
extends IInterface {
    public static final String DESCRIPTOR = "android.service.gatekeeper.IGateKeeperService";

    public GateKeeperResponse enroll(int var1, byte[] var2, byte[] var3, byte[] var4) throws RemoteException;

    public GateKeeperResponse verify(int var1, byte[] var2, byte[] var3) throws RemoteException;

    public GateKeeperResponse verifyChallenge(int var1, long var2, byte[] var4, byte[] var5) throws RemoteException;

    public long getSecureUserId(int var1) throws RemoteException;

    public void clearSecureUserId(int var1) throws RemoteException;

    public void reportDeviceSetupComplete() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGateKeeperService {
        static final int TRANSACTION_enroll = 1;
        static final int TRANSACTION_verify = 2;
        static final int TRANSACTION_verifyChallenge = 3;
        static final int TRANSACTION_getSecureUserId = 4;
        static final int TRANSACTION_clearSecureUserId = 5;
        static final int TRANSACTION_reportDeviceSetupComplete = 6;

        public Stub() {
            this.attachInterface(this, IGateKeeperService.DESCRIPTOR);
        }

        public static IGateKeeperService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IGateKeeperService.DESCRIPTOR);
            if (iin != null && iin instanceof IGateKeeperService) {
                return (IGateKeeperService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "enroll";
                }
                case 2: {
                    return "verify";
                }
                case 3: {
                    return "verifyChallenge";
                }
                case 4: {
                    return "getSecureUserId";
                }
                case 5: {
                    return "clearSecureUserId";
                }
                case 6: {
                    return "reportDeviceSetupComplete";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IGateKeeperService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    GateKeeperResponse _result = this.enroll(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    GateKeeperResponse _result = this.verify(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    byte[] _arg2 = data.createByteArray();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    GateKeeperResponse _result = this.verifyChallenge(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getSecureUserId(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearSecureUserId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.reportDeviceSetupComplete();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IGateKeeperService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IGateKeeperService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GateKeeperResponse enroll(int userId, byte[] currentPasswordHandle, byte[] currentPassword, byte[] desiredPassword) throws RemoteException {
                GateKeeperResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGateKeeperService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeByteArray(currentPasswordHandle);
                    _data.writeByteArray(currentPassword);
                    _data.writeByteArray(desiredPassword);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 32);
                    _reply.readException();
                    _result = _reply.readTypedObject(GateKeeperResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GateKeeperResponse verify(int userId, byte[] enrolledPasswordHandle, byte[] providedPassword) throws RemoteException {
                GateKeeperResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGateKeeperService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeByteArray(enrolledPasswordHandle);
                    _data.writeByteArray(providedPassword);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 32);
                    _reply.readException();
                    _result = _reply.readTypedObject(GateKeeperResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GateKeeperResponse verifyChallenge(int userId, long challenge, byte[] enrolledPasswordHandle, byte[] providedPassword) throws RemoteException {
                GateKeeperResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGateKeeperService.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeLong(challenge);
                    _data.writeByteArray(enrolledPasswordHandle);
                    _data.writeByteArray(providedPassword);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 32);
                    _reply.readException();
                    _result = _reply.readTypedObject(GateKeeperResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSecureUserId(int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGateKeeperService.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 32);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearSecureUserId(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGateKeeperService.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 32);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportDeviceSetupComplete() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGateKeeperService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 32);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGateKeeperService {
        @Override
        public GateKeeperResponse enroll(int userId, byte[] currentPasswordHandle, byte[] currentPassword, byte[] desiredPassword) throws RemoteException {
            return null;
        }

        @Override
        public GateKeeperResponse verify(int userId, byte[] enrolledPasswordHandle, byte[] providedPassword) throws RemoteException {
            return null;
        }

        @Override
        public GateKeeperResponse verifyChallenge(int userId, long challenge, byte[] enrolledPasswordHandle, byte[] providedPassword) throws RemoteException {
            return null;
        }

        @Override
        public long getSecureUserId(int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public void clearSecureUserId(int userId) throws RemoteException {
        }

        @Override
        public void reportDeviceSetupComplete() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

