/*
 * Decompiled with CFR 0.152.
 */
package android.service.dreams;

import android.annotation.RequiresPermission;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IDreamManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/dreams/IDreamManager.aidl:27:1:27:25")
    public void dream() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/dreams/IDreamManager.aidl:29:1:29:25")
    public void awaken() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/service/dreams/IDreamManager.aidl:31:1:31:69")
    public void setDreamComponents(ComponentName[] var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/service/dreams/IDreamManager.aidl:33:1:33:69")
    public ComponentName[] getDreamComponents() throws RemoteException;

    public ComponentName getDefaultDreamComponentForUser(int var1) throws RemoteException;

    public void testDream(int var1, ComponentName var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/dreams/IDreamManager.aidl:37:1:37:25")
    public boolean isDreaming() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/service/dreams/IDreamManager.aidl:39:1:39:25")
    public boolean isDreamingOrInPreview() throws RemoteException;

    public boolean canStartDreaming(boolean var1) throws RemoteException;

    @Deprecated
    public void finishSelf(IBinder var1, boolean var2) throws RemoteException;

    @Deprecated
    public void startDozing(IBinder var1, int var2, int var3, float var4, int var5, boolean var6) throws RemoteException;

    public void stopDozing(IBinder var1) throws RemoteException;

    public void forceAmbientDisplayEnabled(boolean var1) throws RemoteException;

    public ComponentName[] getDreamComponentsForUser(int var1) throws RemoteException;

    public void setDreamComponentsForUser(int var1, ComponentName[] var2) throws RemoteException;

    public void setSystemDreamComponent(ComponentName var1) throws RemoteException;

    public void registerDreamOverlayService(ComponentName var1) throws RemoteException;

    public void startDreamActivity(Intent var1) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setDreamIsObscured(boolean var1) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setDevicePostured(boolean var1) throws RemoteException;

    public void startDozingOneway(IBinder var1, int var2, int var3, float var4, int var5, boolean var6) throws RemoteException;

    public void finishSelfOneway(IBinder var1, boolean var2) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setScreensaverEnabled(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDreamManager {
        public static final String DESCRIPTOR = "android.service.dreams.IDreamManager";
        static final int TRANSACTION_dream = 1;
        static final int TRANSACTION_awaken = 2;
        static final int TRANSACTION_setDreamComponents = 3;
        static final int TRANSACTION_getDreamComponents = 4;
        static final int TRANSACTION_getDefaultDreamComponentForUser = 5;
        static final int TRANSACTION_testDream = 6;
        static final int TRANSACTION_isDreaming = 7;
        static final int TRANSACTION_isDreamingOrInPreview = 8;
        static final int TRANSACTION_canStartDreaming = 9;
        static final int TRANSACTION_finishSelf = 10;
        static final int TRANSACTION_startDozing = 11;
        static final int TRANSACTION_stopDozing = 12;
        static final int TRANSACTION_forceAmbientDisplayEnabled = 13;
        static final int TRANSACTION_getDreamComponentsForUser = 14;
        static final int TRANSACTION_setDreamComponentsForUser = 15;
        static final int TRANSACTION_setSystemDreamComponent = 16;
        static final int TRANSACTION_registerDreamOverlayService = 17;
        static final int TRANSACTION_startDreamActivity = 18;
        static final int TRANSACTION_setDreamIsObscured = 19;
        static final int TRANSACTION_setDevicePostured = 20;
        static final int TRANSACTION_startDozingOneway = 21;
        static final int TRANSACTION_finishSelfOneway = 22;
        static final int TRANSACTION_setScreensaverEnabled = 23;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDreamManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDreamManager) {
                return (IDreamManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dream";
                }
                case 2: {
                    return "awaken";
                }
                case 3: {
                    return "setDreamComponents";
                }
                case 4: {
                    return "getDreamComponents";
                }
                case 5: {
                    return "getDefaultDreamComponentForUser";
                }
                case 6: {
                    return "testDream";
                }
                case 7: {
                    return "isDreaming";
                }
                case 8: {
                    return "isDreamingOrInPreview";
                }
                case 9: {
                    return "canStartDreaming";
                }
                case 10: {
                    return "finishSelf";
                }
                case 11: {
                    return "startDozing";
                }
                case 12: {
                    return "stopDozing";
                }
                case 13: {
                    return "forceAmbientDisplayEnabled";
                }
                case 14: {
                    return "getDreamComponentsForUser";
                }
                case 15: {
                    return "setDreamComponentsForUser";
                }
                case 16: {
                    return "setSystemDreamComponent";
                }
                case 17: {
                    return "registerDreamOverlayService";
                }
                case 18: {
                    return "startDreamActivity";
                }
                case 19: {
                    return "setDreamIsObscured";
                }
                case 20: {
                    return "setDevicePostured";
                }
                case 21: {
                    return "startDozingOneway";
                }
                case 22: {
                    return "finishSelfOneway";
                }
                case 23: {
                    return "setScreensaverEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.dream();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.awaken();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ComponentName[] _arg0 = data.createTypedArray(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDreamComponents(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    Parcelable[] _result = this.getDreamComponents();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ComponentName _result = this.getDefaultDreamComponentForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.testDream(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    boolean _result = this.isDreaming();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    boolean _result = this.isDreamingOrInPreview();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.canStartDreaming(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.finishSelf(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    float _arg3 = data.readFloat();
                    int _arg4 = data.readInt();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.startDozing(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stopDozing(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceAmbientDisplayEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getDreamComponentsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    ComponentName[] _arg1 = data.createTypedArray(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDreamComponentsForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSystemDreamComponent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerDreamOverlayService(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    Intent _arg0 = data.readTypedObject(Intent.CREATOR);
                    data.enforceNoDataAvail();
                    this.startDreamActivity(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDreamIsObscured(_arg0);
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDevicePostured(_arg0);
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    float _arg3 = data.readFloat();
                    int _arg4 = data.readInt();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.startDozingOneway(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.finishSelfOneway(_arg0, _arg1);
                    break;
                }
                case 23: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setScreensaverEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 22;
        }

        private static class Proxy
        implements IDreamManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dream() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void awaken() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDreamComponents(ComponentName[] componentNames) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(componentNames, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName[] getDreamComponents() throws RemoteException {
                ComponentName[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getDefaultDreamComponentForUser(int userId) throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void testDream(int userId, ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(componentName, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDreaming() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDreamingOrInPreview() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canStartDreaming(boolean isScreenOn) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isScreenOn);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSelf(IBinder token, boolean immediate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(immediate);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDozing(IBinder token, int screenState, int reason, float screenBrightnessFloat, int screenBrightnessInt, boolean useNormalBrightnessForDoze) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(screenState);
                    _data.writeInt(reason);
                    _data.writeFloat(screenBrightnessFloat);
                    _data.writeInt(screenBrightnessInt);
                    _data.writeBoolean(useNormalBrightnessForDoze);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDozing(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceAmbientDisplayEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName[] getDreamComponentsForUser(int userId) throws RemoteException {
                ComponentName[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDreamComponentsForUser(int userId, ComponentName[] componentNames) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedArray(componentNames, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemDreamComponent(ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDreamOverlayService(ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDreamActivity(Intent intent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDreamIsObscured(boolean isObscured) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isObscured);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDevicePostured(boolean isPostured) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isPostured);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDozingOneway(IBinder token, int screenState, int reason, float screenBrightnessFloat, int screenBrightnessInt, boolean useNormalBrightnessForDoze) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(screenState);
                    _data.writeInt(reason);
                    _data.writeFloat(screenBrightnessFloat);
                    _data.writeInt(screenBrightnessInt);
                    _data.writeBoolean(useNormalBrightnessForDoze);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSelfOneway(IBinder token, boolean immediate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(immediate);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScreensaverEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDreamManager {
        @Override
        public void dream() throws RemoteException {
        }

        @Override
        public void awaken() throws RemoteException {
        }

        @Override
        public void setDreamComponents(ComponentName[] componentNames) throws RemoteException {
        }

        @Override
        public ComponentName[] getDreamComponents() throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getDefaultDreamComponentForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void testDream(int userId, ComponentName componentName) throws RemoteException {
        }

        @Override
        public boolean isDreaming() throws RemoteException {
            return false;
        }

        @Override
        public boolean isDreamingOrInPreview() throws RemoteException {
            return false;
        }

        @Override
        public boolean canStartDreaming(boolean isScreenOn) throws RemoteException {
            return false;
        }

        @Override
        public void finishSelf(IBinder token, boolean immediate) throws RemoteException {
        }

        @Override
        public void startDozing(IBinder token, int screenState, int reason, float screenBrightnessFloat, int screenBrightnessInt, boolean useNormalBrightnessForDoze) throws RemoteException {
        }

        @Override
        public void stopDozing(IBinder token) throws RemoteException {
        }

        @Override
        public void forceAmbientDisplayEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public ComponentName[] getDreamComponentsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setDreamComponentsForUser(int userId, ComponentName[] componentNames) throws RemoteException {
        }

        @Override
        public void setSystemDreamComponent(ComponentName componentName) throws RemoteException {
        }

        @Override
        public void registerDreamOverlayService(ComponentName componentName) throws RemoteException {
        }

        @Override
        public void startDreamActivity(Intent intent) throws RemoteException {
        }

        @Override
        public void setDreamIsObscured(boolean isObscured) throws RemoteException {
        }

        @Override
        public void setDevicePostured(boolean isPostured) throws RemoteException {
        }

        @Override
        public void startDozingOneway(IBinder token, int screenState, int reason, float screenBrightnessFloat, int screenBrightnessInt, boolean useNormalBrightnessForDoze) throws RemoteException {
        }

        @Override
        public void finishSelfOneway(IBinder token, boolean immediate) throws RemoteException {
        }

        @Override
        public void setScreensaverEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

