/*
 * Decompiled with CFR 0.152.
 */
package android.service.credentials;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.slice.Slice;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.credentials.BeginGetCredentialOption;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class CredentialEntry
implements Parcelable {
    @Nullable
    private final String mBeginGetCredentialOptionId;
    @NonNull
    private final String mType;
    @NonNull
    private final Slice mSlice;
    @NonNull
    public static final Parcelable.Creator<CredentialEntry> CREATOR = new Parcelable.Creator<CredentialEntry>(){

        @Override
        public CredentialEntry createFromParcel(@NonNull Parcel in) {
            return new CredentialEntry(in);
        }

        public CredentialEntry[] newArray(int size) {
            return new CredentialEntry[size];
        }
    };

    public CredentialEntry(@NonNull String beginGetCredentialOptionId, @NonNull String type, @NonNull Slice slice) {
        this.mBeginGetCredentialOptionId = Preconditions.checkStringNotEmpty(beginGetCredentialOptionId, "beginGetCredentialOptionId must not be null, or empty");
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be null, or empty");
        this.mSlice = Objects.requireNonNull(slice, "slice must not be null");
    }

    public CredentialEntry(@NonNull BeginGetCredentialOption beginGetCredentialOption, @NonNull Slice slice) {
        Objects.requireNonNull(beginGetCredentialOption, "beginGetCredentialOption must not be null");
        this.mBeginGetCredentialOptionId = Preconditions.checkStringNotEmpty(beginGetCredentialOption.getId(), "Id in beginGetCredentialOption must not be null");
        this.mType = Preconditions.checkStringNotEmpty(beginGetCredentialOption.getType(), "type in beginGetCredentialOption must not be null");
        this.mSlice = Objects.requireNonNull(slice, "slice must not be null");
    }

    public CredentialEntry(@NonNull String type, @NonNull Slice slice) {
        this.mBeginGetCredentialOptionId = null;
        this.mType = Objects.requireNonNull(type, "type must not be null");
        this.mSlice = Objects.requireNonNull(slice, "slice must not be null");
    }

    private CredentialEntry(@NonNull Parcel in) {
        Objects.requireNonNull(in, "parcel must not be null");
        this.mType = in.readString8();
        this.mSlice = in.readTypedObject(Slice.CREATOR);
        this.mBeginGetCredentialOptionId = in.readString8();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeTypedObject(this.mSlice, flags);
        dest.writeString8(this.mBeginGetCredentialOptionId);
    }

    @NonNull
    public String getBeginGetCredentialOptionId() {
        return this.mBeginGetCredentialOptionId;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @NonNull
    public Slice getSlice() {
        return this.mSlice;
    }
}

