/*
 * Decompiled with CFR 0.152.
 */
package android.service.chooser;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.service.chooser.ChooserSession;
import android.service.chooser.ChooserSessionToken;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@FlaggedApi(value="android.service.chooser.interactive_chooser")
public class ChooserManager {
    private static final String TAG = "ChooserManager";
    private final Map<ChooserSessionToken, ChooserSession> mSessions = Collections.synchronizedMap(new HashMap());

    @NonNull
    public ChooserSession startSession(@NonNull Context context, @NonNull Intent chooserIntent) {
        Objects.requireNonNull(context, "context should not be null");
        Objects.requireNonNull(chooserIntent, "chooserIntent should not be null");
        if (!"android.intent.action.CHOOSER".equals(chooserIntent.getAction())) {
            throw new IllegalArgumentException("A chooser intent is expected");
        }
        chooserIntent = new Intent(chooserIntent);
        chooserIntent.removeFlags(1006817280);
        Bundle binderExtras = new Bundle();
        ChooserSession chooserSession = new ChooserSession();
        binderExtras.putBinder("com.android.extra.EXTRA_CHOOSER_INTERACTIVE_CALLBACK", chooserSession.getBinder());
        chooserIntent.putExtras(binderExtras);
        ActivityOptions options = ActivityOptions.makeBasic();
        if (Flags.touchPassThroughOptIn()) {
            options.setAllowPassThroughOnTouchOutside(true);
        }
        context.startActivity(chooserIntent, options.toBundle());
        this.mSessions.put(chooserSession.getToken(), chooserSession);
        return chooserSession;
    }

    @Nullable
    public ChooserSession getSession(@NonNull ChooserSessionToken token) {
        Objects.requireNonNull(token, "Token should not be null");
        ChooserSession session = this.mSessions.get(token);
        if (session != null && session.getState() == 2) {
            this.mSessions.remove(token);
            return null;
        }
        return session;
    }
}

