/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.RemoteException;
import android.service.autofill.IInlineSuggestionUiCallback;
import android.util.Log;
import android.util.MathUtils;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;

@SuppressLint(value={"ViewConstructor"})
public class InlineSuggestionRoot
extends FrameLayout {
    private static final String TAG = "InlineSuggestionRoot";
    @NonNull
    private final IInlineSuggestionUiCallback mCallback;
    private final int mTouchSlop;
    private float mDownX;
    private float mDownY;

    public InlineSuggestionRoot(@NonNull Context context, @NonNull IInlineSuggestionUiCallback callback) {
        super(context);
        this.mCallback = callback;
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.setFocusable(false);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mDownX = event.getX();
                this.mDownY = event.getY();
            }
            case 2: {
                boolean isSecure;
                float distance = MathUtils.dist(this.mDownX, this.mDownY, event.getX(), event.getY());
                boolean bl = isSecure = (event.getFlags() & 2) == 0;
                if (isSecure && !(distance > (float)this.mTouchSlop)) break;
                try {
                    this.mCallback.onTransferTouchFocusToImeWindow(this.getViewRootImpl().getInputToken(), this.getContext().getDisplayId());
                    break;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "RemoteException transferring touch focus to IME");
                }
            }
        }
        return super.dispatchTouchEvent(event);
    }
}

