/*
 * Decompiled with CFR 0.152.
 */
package android.security.attestationverification;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelDuration;
import android.os.RemoteException;
import android.security.attestationverification.AttestationProfile;
import android.security.attestationverification.VerificationToken;
import com.android.internal.infra.AndroidFuture;

public interface IAttestationVerificationManagerService
extends IInterface {
    public static final String DESCRIPTOR = "android.security.attestationverification.IAttestationVerificationManagerService";

    public void verifyAttestation(AttestationProfile var1, int var2, Bundle var3, byte[] var4, AndroidFuture var5) throws RemoteException;

    public void verifyToken(VerificationToken var1, ParcelDuration var2, AndroidFuture var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAttestationVerificationManagerService {
        static final int TRANSACTION_verifyAttestation = 1;
        static final int TRANSACTION_verifyToken = 2;

        public Stub() {
            this.attachInterface(this, IAttestationVerificationManagerService.DESCRIPTOR);
        }

        public static IAttestationVerificationManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAttestationVerificationManagerService.DESCRIPTOR);
            if (iin != null && iin instanceof IAttestationVerificationManagerService) {
                return (IAttestationVerificationManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "verifyAttestation";
                }
                case 2: {
                    return "verifyToken";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAttestationVerificationManagerService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AttestationProfile _arg0 = data.readTypedObject(AttestationProfile.CREATOR);
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    byte[] _arg3 = data.createByteArray();
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.verifyAttestation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    VerificationToken _arg0 = data.readTypedObject(VerificationToken.CREATOR);
                    ParcelDuration _arg1 = data.readTypedObject(ParcelDuration.CREATOR);
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.verifyToken(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IAttestationVerificationManagerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAttestationVerificationManagerService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyAttestation(AttestationProfile profile, int localBindingType, Bundle requirements, byte[] attestation, AndroidFuture resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAttestationVerificationManagerService.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    _data.writeInt(localBindingType);
                    _data.writeTypedObject(requirements, 0);
                    _data.writeByteArray(attestation);
                    _data.writeTypedObject(resultCallback, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyToken(VerificationToken token, ParcelDuration maximumTokenAge, AndroidFuture resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAttestationVerificationManagerService.DESCRIPTOR);
                    _data.writeTypedObject(token, 0);
                    _data.writeTypedObject(maximumTokenAge, 0);
                    _data.writeTypedObject(resultCallback, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAttestationVerificationManagerService {
        @Override
        public void verifyAttestation(AttestationProfile profile, int localBindingType, Bundle requirements, byte[] attestation, AndroidFuture resultCallback) throws RemoteException {
        }

        @Override
        public void verifyToken(VerificationToken token, ParcelDuration maximumTokenAge, AndroidFuture resultCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

