/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.SafetyCenterStaticEntry;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterStaticEntryGroup
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<SafetyCenterStaticEntryGroup> CREATOR = new Parcelable.Creator<SafetyCenterStaticEntryGroup>(){

        @Override
        public SafetyCenterStaticEntryGroup createFromParcel(Parcel source) {
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            ArrayList<SafetyCenterStaticEntry> staticEntries = source.createTypedArrayList(SafetyCenterStaticEntry.CREATOR);
            return new SafetyCenterStaticEntryGroup(title, staticEntries);
        }

        public SafetyCenterStaticEntryGroup[] newArray(int size) {
            return new SafetyCenterStaticEntryGroup[size];
        }
    };
    @NonNull
    private final CharSequence mTitle;
    @NonNull
    private final List<SafetyCenterStaticEntry> mStaticEntries;

    public SafetyCenterStaticEntryGroup(@NonNull CharSequence title, @NonNull List<SafetyCenterStaticEntry> staticEntries) {
        this.mTitle = Objects.requireNonNull(title);
        this.mStaticEntries = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(staticEntries)));
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public List<SafetyCenterStaticEntry> getStaticEntries() {
        return this.mStaticEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterStaticEntryGroup)) {
            return false;
        }
        SafetyCenterStaticEntryGroup that = (SafetyCenterStaticEntryGroup)o;
        return TextUtils.equals(this.mTitle, that.mTitle) && Objects.equals(this.mStaticEntries, that.mStaticEntries);
    }

    public int hashCode() {
        return Objects.hash(this.mTitle, this.mStaticEntries);
    }

    public String toString() {
        return "SafetyCenterStaticEntryGroup{mTitle=" + this.mTitle + ", mStaticEntries=" + this.mStaticEntries + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        dest.writeTypedList(this.mStaticEntries);
    }
}

