/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.SecureRandom;
import java.util.Arrays;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class UwbAddress
implements Parcelable {
    public static final int SHORT_ADDRESS_BYTE_LENGTH = 2;
    public static final int EXTENDED_ADDRESS_BYTE_LENGTH = 8;
    private static final byte[] sShortForbiddenUwbAddress = new byte[]{-1, -1};
    private static final byte[] sExtendedForbiddenUwbAddress = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
    private final byte[] mAddressBytes;
    @NonNull
    public static final Parcelable.Creator<UwbAddress> CREATOR = new Parcelable.Creator<UwbAddress>(){

        @Override
        public UwbAddress createFromParcel(Parcel in) {
            byte[] address = new byte[in.readInt()];
            in.readByteArray(address);
            return UwbAddress.fromBytes(address);
        }

        public UwbAddress[] newArray(int size) {
            return new UwbAddress[size];
        }
    };

    private UwbAddress(byte[] address) {
        this.mAddressBytes = address;
    }

    @NonNull
    public static UwbAddress fromBytes(@NonNull byte[] address) {
        if (address.length != 2 && address.length != 8) {
            throw new IllegalArgumentException("Invalid UwbAddress length " + address.length);
        }
        return new UwbAddress(address);
    }

    @NonNull
    public static UwbAddress createRandomShortAddress() {
        SecureRandom secureRandom = new SecureRandom();
        return UwbAddress.fromBytes(UwbAddress.generateRandomByteArray(2, secureRandom));
    }

    @NonNull
    public static UwbAddress getRandomExtendedAddress() {
        SecureRandom secureRandom = new SecureRandom();
        return UwbAddress.fromBytes(UwbAddress.generateRandomByteArray(8, secureRandom));
    }

    private static byte[] generateRandomByteArray(int len, SecureRandom secureRandom) {
        byte[] bytes = new byte[len];
        do {
            secureRandom.nextBytes(bytes);
        } while (UwbAddress.isForbiddenAddress(bytes));
        return bytes;
    }

    private static boolean isForbiddenAddress(byte[] address) {
        if (address.length == 2) {
            return Arrays.equals(address, sShortForbiddenUwbAddress);
        }
        return Arrays.equals(address, sExtendedForbiddenUwbAddress);
    }

    @NonNull
    public byte[] getAddressBytes() {
        return this.mAddressBytes;
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("0x");
        for (byte addressByte : this.mAddressBytes) {
            builder.append(String.format("%02X", addressByte));
        }
        return builder.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UwbAddress) {
            return Arrays.equals(this.mAddressBytes, ((UwbAddress)obj).getAddressBytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mAddressBytes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAddressBytes.length);
        dest.writeByteArray(this.mAddressBytes);
    }
}

