/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.ble.cs.BleCsRangingCapabilities;
import android.ranging.ble.rssi.BleRssiRangingCapabilities;
import android.ranging.uwb.UwbRangingCapabilities;
import android.ranging.wifi.rtt.RttRangingCapabilities;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingCapabilities
implements Parcelable {
    @Nullable
    private final UwbRangingCapabilities mUwbCapabilities;
    @Nullable
    private final RttRangingCapabilities mRttRangingCapabilities;
    @Nullable
    private final BleCsRangingCapabilities mCsCapabilities;
    @Nullable
    private final BleRssiRangingCapabilities mBleRssiCapabilities;
    public static final int NOT_SUPPORTED = 0;
    public static final int DISABLED_USER = 1;
    public static final int DISABLED_REGULATORY = 2;
    public static final int ENABLED = 3;
    public static final int DISABLED_USER_RESTRICTIONS = 4;
    private final Map<Integer, Integer> mAvailabilities;
    @NonNull
    public static final Parcelable.Creator<RangingCapabilities> CREATOR = new Parcelable.Creator<RangingCapabilities>(){

        @Override
        public RangingCapabilities createFromParcel(Parcel in) {
            return new RangingCapabilities(in);
        }

        public RangingCapabilities[] newArray(int size) {
            return new RangingCapabilities[size];
        }
    };

    private RangingCapabilities(Builder builder) {
        this.mUwbCapabilities = (UwbRangingCapabilities)builder.mCapabilities.get(0);
        this.mRttRangingCapabilities = (RttRangingCapabilities)builder.mCapabilities.get(2);
        this.mCsCapabilities = (BleCsRangingCapabilities)builder.mCapabilities.get(1);
        this.mBleRssiCapabilities = (BleRssiRangingCapabilities)builder.mCapabilities.get(3);
        this.mAvailabilities = builder.mAvailabilities;
    }

    private RangingCapabilities(Parcel in) {
        this.mUwbCapabilities = in.readParcelable(UwbRangingCapabilities.class.getClassLoader(), UwbRangingCapabilities.class);
        this.mRttRangingCapabilities = in.readParcelable(RttRangingCapabilities.class.getClassLoader(), RttRangingCapabilities.class);
        this.mCsCapabilities = in.readParcelable(BleCsRangingCapabilities.class.getClassLoader(), BleCsRangingCapabilities.class);
        this.mBleRssiCapabilities = in.readParcelable(BleRssiRangingCapabilities.class.getClassLoader(), BleRssiRangingCapabilities.class);
        int size = in.readInt();
        this.mAvailabilities = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            int key = in.readInt();
            int value = in.readInt();
            this.mAvailabilities.put(key, value);
        }
    }

    @NonNull
    public Map<Integer, Integer> getTechnologyAvailability() {
        return this.mAvailabilities;
    }

    @Nullable
    public UwbRangingCapabilities getUwbCapabilities() {
        return this.mUwbCapabilities;
    }

    @Nullable
    public RttRangingCapabilities getRttRangingCapabilities() {
        return this.mRttRangingCapabilities;
    }

    @Nullable
    public BleCsRangingCapabilities getCsCapabilities() {
        return this.mCsCapabilities;
    }

    @Nullable
    public BleRssiRangingCapabilities getBleRssiCapabilities() {
        return this.mBleRssiCapabilities;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mUwbCapabilities, flags);
        dest.writeParcelable(this.mRttRangingCapabilities, flags);
        dest.writeParcelable(this.mCsCapabilities, flags);
        dest.writeParcelable(this.mBleRssiCapabilities, flags);
        dest.writeInt(this.mAvailabilities.size());
        for (Map.Entry<Integer, Integer> entry : this.mAvailabilities.entrySet()) {
            dest.writeInt(entry.getKey());
            dest.writeInt(entry.getValue());
        }
    }

    public String toString() {
        return "RangingCapabilities{ mUwbCapabilities=" + this.mUwbCapabilities + ", mRttRangingCapabilities=" + this.mRttRangingCapabilities + ", mCsCapabilities=" + this.mCsCapabilities + ", mBleRssiCapabilities=" + this.mBleRssiCapabilities + ", mAvailabilities=" + this.mAvailabilities + " }";
    }

    public static class Builder {
        private final HashMap<Integer, TechnologyCapabilities> mCapabilities = new HashMap();
        private final HashMap<Integer, Integer> mAvailabilities = new HashMap();

        public Builder addCapabilities(@NonNull TechnologyCapabilities capabilities) {
            this.mCapabilities.put(capabilities.getTechnology(), capabilities);
            return this;
        }

        public Builder addAvailability(int technology, int availability) {
            this.mAvailabilities.put(technology, availability);
            return this;
        }

        public RangingCapabilities build() {
            return new RangingCapabilities(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface RangingTechnologyAvailability {
    }

    public static interface TechnologyCapabilities {
        public int getTechnology();
    }
}

