/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.ranging.IRangingCallbacks;
import android.ranging.IRangingCapabilitiesCallback;
import android.ranging.RangingDevice;
import android.ranging.RangingPreference;
import android.ranging.SessionHandle;
import android.ranging.oob.IOobSendDataListener;
import android.ranging.oob.OobHandle;
import android.ranging.oob.OobResponderRangingConfig;
import android.ranging.raw.RawResponderRangingConfig;

public interface IRangingAdapter
extends IInterface {
    public static final String DESCRIPTOR = "android.ranging.IRangingAdapter";

    public void startRanging(AttributionSource var1, SessionHandle var2, RangingPreference var3, IRangingCallbacks var4) throws RemoteException;

    public void reconfigureRangingInterval(SessionHandle var1, int var2) throws RemoteException;

    public void addRawDevice(SessionHandle var1, RawResponderRangingConfig var2) throws RemoteException;

    public void addOobDevice(SessionHandle var1, OobResponderRangingConfig var2) throws RemoteException;

    public void removeDevice(SessionHandle var1, RangingDevice var2) throws RemoteException;

    public void stopRanging(SessionHandle var1) throws RemoteException;

    public void registerCapabilitiesCallback(IRangingCapabilitiesCallback var1) throws RemoteException;

    public void unregisterCapabilitiesCallback(IRangingCapabilitiesCallback var1) throws RemoteException;

    public void oobDataReceived(OobHandle var1, byte[] var2) throws RemoteException;

    public void deviceOobDisconnected(OobHandle var1) throws RemoteException;

    public void deviceOobReconnected(OobHandle var1) throws RemoteException;

    public void deviceOobClosed(OobHandle var1) throws RemoteException;

    public void registerOobSendDataListener(IOobSendDataListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRangingAdapter {
        static final int TRANSACTION_startRanging = 1;
        static final int TRANSACTION_reconfigureRangingInterval = 2;
        static final int TRANSACTION_addRawDevice = 3;
        static final int TRANSACTION_addOobDevice = 4;
        static final int TRANSACTION_removeDevice = 5;
        static final int TRANSACTION_stopRanging = 6;
        static final int TRANSACTION_registerCapabilitiesCallback = 7;
        static final int TRANSACTION_unregisterCapabilitiesCallback = 8;
        static final int TRANSACTION_oobDataReceived = 9;
        static final int TRANSACTION_deviceOobDisconnected = 10;
        static final int TRANSACTION_deviceOobReconnected = 11;
        static final int TRANSACTION_deviceOobClosed = 12;
        static final int TRANSACTION_registerOobSendDataListener = 13;

        public Stub() {
            this.attachInterface(this, IRangingAdapter.DESCRIPTOR);
        }

        public static IRangingAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRangingAdapter.DESCRIPTOR);
            if (iin != null && iin instanceof IRangingAdapter) {
                return (IRangingAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startRanging";
                }
                case 2: {
                    return "reconfigureRangingInterval";
                }
                case 3: {
                    return "addRawDevice";
                }
                case 4: {
                    return "addOobDevice";
                }
                case 5: {
                    return "removeDevice";
                }
                case 6: {
                    return "stopRanging";
                }
                case 7: {
                    return "registerCapabilitiesCallback";
                }
                case 8: {
                    return "unregisterCapabilitiesCallback";
                }
                case 9: {
                    return "oobDataReceived";
                }
                case 10: {
                    return "deviceOobDisconnected";
                }
                case 11: {
                    return "deviceOobReconnected";
                }
                case 12: {
                    return "deviceOobClosed";
                }
                case 13: {
                    return "registerOobSendDataListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRangingAdapter.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SessionHandle _arg1 = data.readTypedObject(SessionHandle.CREATOR);
                    RangingPreference _arg2 = data.readTypedObject(RangingPreference.CREATOR);
                    IRangingCallbacks _arg3 = IRangingCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startRanging(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reconfigureRangingInterval(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    RawResponderRangingConfig _arg1 = data.readTypedObject(RawResponderRangingConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.addRawDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    OobResponderRangingConfig _arg1 = data.readTypedObject(OobResponderRangingConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.addOobDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    RangingDevice _arg1 = data.readTypedObject(RangingDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopRanging(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IRangingCapabilitiesCallback _arg0 = IRangingCapabilitiesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCapabilitiesCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IRangingCapabilitiesCallback _arg0 = IRangingCapabilitiesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCapabilitiesCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    OobHandle _arg0 = data.readTypedObject(OobHandle.CREATOR);
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.oobDataReceived(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    OobHandle _arg0 = data.readTypedObject(OobHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.deviceOobDisconnected(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    OobHandle _arg0 = data.readTypedObject(OobHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.deviceOobReconnected(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    OobHandle _arg0 = data.readTypedObject(OobHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.deviceOobClosed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IOobSendDataListener _arg0 = IOobSendDataListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerOobSendDataListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 12;
        }

        private static class Proxy
        implements IRangingAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRangingAdapter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRanging(AttributionSource attributionSource, SessionHandle sessionHandle, RangingPreference rangingPreference, IRangingCallbacks callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(rangingPreference, 0);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconfigureRangingInterval(SessionHandle sessionHandle, int intervalSkipCount) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(intervalSkipCount);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRawDevice(SessionHandle sessionHandle, RawResponderRangingConfig rangingConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(rangingConfig, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOobDevice(SessionHandle sessionHandle, OobResponderRangingConfig rangingConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(rangingConfig, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeDevice(SessionHandle sessionHandle, RangingDevice rangingDevice) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(rangingDevice, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCapabilitiesCallback(IRangingCapabilitiesCallback rangingCapabilitiesCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(rangingCapabilitiesCallback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCapabilitiesCallback(IRangingCapabilitiesCallback rangingCapabilitiesCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(rangingCapabilitiesCallback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void oobDataReceived(OobHandle oobHandle, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(oobHandle, 0);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deviceOobDisconnected(OobHandle oobHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(oobHandle, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deviceOobReconnected(OobHandle oobHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(oobHandle, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deviceOobClosed(OobHandle oobHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeTypedObject(oobHandle, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerOobSendDataListener(IOobSendDataListener oobSendDataListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRangingAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(oobSendDataListener);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRangingAdapter {
        @Override
        public void startRanging(AttributionSource attributionSource, SessionHandle sessionHandle, RangingPreference rangingPreference, IRangingCallbacks callbacks) throws RemoteException {
        }

        @Override
        public void reconfigureRangingInterval(SessionHandle sessionHandle, int intervalSkipCount) throws RemoteException {
        }

        @Override
        public void addRawDevice(SessionHandle sessionHandle, RawResponderRangingConfig rangingConfig) throws RemoteException {
        }

        @Override
        public void addOobDevice(SessionHandle sessionHandle, OobResponderRangingConfig rangingConfig) throws RemoteException {
        }

        @Override
        public void removeDevice(SessionHandle sessionHandle, RangingDevice rangingDevice) throws RemoteException {
        }

        @Override
        public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void registerCapabilitiesCallback(IRangingCapabilitiesCallback rangingCapabilitiesCallback) throws RemoteException {
        }

        @Override
        public void unregisterCapabilitiesCallback(IRangingCapabilitiesCallback rangingCapabilitiesCallback) throws RemoteException {
        }

        @Override
        public void oobDataReceived(OobHandle oobHandle, byte[] data) throws RemoteException {
        }

        @Override
        public void deviceOobDisconnected(OobHandle oobHandle) throws RemoteException {
        }

        @Override
        public void deviceOobReconnected(OobHandle oobHandle) throws RemoteException {
        }

        @Override
        public void deviceOobClosed(OobHandle oobHandle) throws RemoteException {
        }

        @Override
        public void registerOobSendDataListener(IOobSendDataListener oobSendDataListener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

