/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.IMPCancellationSignal;
import android.provider.IOpenFileCallback;

public class OpenFileRequest
implements Parcelable {
    private final Uri mUri;
    private final IOpenFileCallback mCallback;
    private final IMPCancellationSignal mCancellationSignal;
    @NonNull
    public static final Parcelable.Creator<OpenFileRequest> CREATOR = new Parcelable.Creator<OpenFileRequest>(){

        @Override
        public OpenFileRequest createFromParcel(Parcel source) {
            return new OpenFileRequest(source);
        }

        public OpenFileRequest[] newArray(int size) {
            return new OpenFileRequest[size];
        }
    };

    public OpenFileRequest(@NonNull Uri uri, @NonNull IOpenFileCallback callback, @Nullable IMPCancellationSignal cancellationSignal) {
        this.mUri = uri;
        this.mCallback = callback;
        this.mCancellationSignal = cancellationSignal;
    }

    private OpenFileRequest(Parcel p) {
        this.mUri = Uri.CREATOR.createFromParcel(p);
        this.mCallback = IOpenFileCallback.Stub.asInterface(p.readStrongBinder());
        this.mCancellationSignal = IMPCancellationSignal.Stub.asInterface(p.readStrongBinder());
    }

    @NonNull
    public Uri getUri() {
        return this.mUri;
    }

    @NonNull
    public IOpenFileCallback getCallback() {
        return this.mCallback;
    }

    @Nullable
    public IMPCancellationSignal getCancellationSignal() {
        return this.mCancellationSignal;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mUri.writeToParcel(dest, flags);
        dest.writeStrongBinder(this.mCallback.asBinder());
        dest.writeStrongBinder(this.mCancellationSignal != null ? this.mCancellationSignal.asBinder() : null);
    }
}

