/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.UriPermission;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageDecoder;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.BaseColumns;
import android.provider.Column;
import android.provider.IMPCancellationSignal;
import android.provider.IOpenAssetFileCallback;
import android.provider.IOpenFileCallback;
import android.provider.OpenAssetFileRequest;
import android.provider.OpenFileRequest;
import android.provider.ParcelableException;
import android.provider.media.internal.flags.Flags;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Size;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaStore {
    private static final String TAG = "MediaStore";
    public static final String AUTHORITY = "media";
    @NonNull
    public static final Uri AUTHORITY_URI = Uri.parse("content://media");
    @SystemApi
    public static final String AUTHORITY_LEGACY = "media_legacy";
    @SystemApi
    @NonNull
    public static final Uri AUTHORITY_LEGACY_URI = Uri.parse("content://media_legacy");
    public static final String VOLUME_INTERNAL = "internal";
    public static final String VOLUME_EXTERNAL = "external";
    public static final String VOLUME_EXTERNAL_PRIMARY = "external_primary";
    public static final String VOLUME_DEMO = "demo";
    public static final String RESOLVE_PLAYLIST_MEMBERS_CALL = "resolve_playlist_members";
    public static final String RUN_IDLE_MAINTENANCE_CALL = "run_idle_maintenance";
    public static final String WAIT_FOR_IDLE_CALL = "wait_for_idle";
    public static final String SCAN_FILE_CALL = "scan_file";
    public static final String SCAN_VOLUME_CALL = "scan_volume";
    public static final String CREATE_WRITE_REQUEST_CALL = "create_write_request";
    public static final String CREATE_TRASH_REQUEST_CALL = "create_trash_request";
    public static final String CREATE_FAVORITE_REQUEST_CALL = "create_favorite_request";
    public static final String MARK_MEDIA_AS_FAVORITE = "mark_media_as_favorite";
    public static final String CREATE_DELETE_REQUEST_CALL = "create_delete_request";
    public static final String GET_VERSION_CALL = "get_version";
    public static final String GET_GENERATION_CALL = "get_generation";
    public static final String START_LEGACY_MIGRATION_CALL = "start_legacy_migration";
    public static final String FINISH_LEGACY_MIGRATION_CALL = "finish_legacy_migration";
    @Deprecated
    public static final String EXTERNAL_STORAGE_PROVIDER_AUTHORITY = "com.android.externalstorage.documents";
    public static final String GET_DOCUMENT_URI_CALL = "get_document_uri";
    public static final String GET_MEDIA_URI_CALL = "get_media_uri";
    public static final String ENSURE_PROVIDERS_CALL = "ensure_providers_call";
    public static final String GET_REDACTED_MEDIA_URI_CALL = "get_redacted_media_uri";
    public static final String GET_REDACTED_MEDIA_URI_LIST_CALL = "get_redacted_media_uri_list";
    public static final String EXTRA_URI_LIST = "uri_list";
    public static final String QUERY_ARG_REDACTED_URI = "android:query-arg-redacted-uri";
    public static final String EXTRA_URI = "uri";
    public static final String EXTRA_URI_PERMISSIONS = "uriPermissions";
    public static final String EXTRA_CLIP_DATA = "clip_data";
    public static final String EXTRA_CONTENT_VALUES = "content_values";
    public static final String EXTRA_RESULT = "result";
    public static final String EXTRA_FILE_DESCRIPTOR = "file_descriptor";
    public static final String EXTRA_LOCAL_PROVIDER = "local_provider";
    public static final String EXTRA_IS_STABLE_URIS_ENABLED = "is_stable_uris_enabled";
    public static final String IS_SYSTEM_GALLERY_CALL = "is_system_gallery";
    public static final String EXTRA_IS_SYSTEM_GALLERY_UID = "is_system_gallery_uid";
    public static final String EXTRA_IS_SYSTEM_GALLERY_RESPONSE = "is_system_gallery_response";
    public static final String IS_CURRENT_CLOUD_PROVIDER_CALL = "is_current_cloud_provider";
    public static final String IS_SUPPORTED_CLOUD_PROVIDER_CALL = "is_supported_cloud_provider";
    public static final String NOTIFY_CLOUD_MEDIA_CHANGED_EVENT_CALL = "notify_cloud_media_changed_event";
    public static final String SYNC_PROVIDERS_CALL = "sync_providers";
    public static final String GET_CLOUD_PROVIDER_CALL = "get_cloud_provider";
    public static final String GET_CLOUD_PROVIDER_RESULT = "get_cloud_provider_result";
    public static final String GET_CLOUD_PROVIDER_LABEL_CALL = "get_cloud_provider_label";
    public static final String SET_CLOUD_PROVIDER_RESULT = "set_cloud_provider_result";
    public static final String SET_CLOUD_PROVIDER_CALL = "set_cloud_provider";
    public static final String EXTRA_CLOUD_PROVIDER = "cloud_provider";
    public static final String EXTRA_CLOUD_PROVIDER_RESULT = "cloud_provider_result";
    public static final String GET_CLOUD_PROVIDER_DETAILS = "get_cloud_provider_details";
    public static final String GET_CLOUD_PROVIDER_DETAILS_RESULT = "get_cloud_provider_details_result";
    public static final String CREATE_SURFACE_CONTROLLER = "create_surface_controller";
    public static final String GRANT_MEDIA_READ_FOR_PACKAGE_CALL = "grant_media_read_for_package";
    public static final String REVOKE_READ_GRANT_FOR_PACKAGE_CALL = "revoke_media_read_for_package";
    public static final String REVOKED_ALL_READ_GRANTS_FOR_PACKAGE_CALL = "revoke_all_media_grants_for_package";
    public static final String BULK_UPDATE_OEM_METADATA_CALL = "bulk_update_oem_metadata";
    public static final String OPEN_FILE_CALL = "open_file_call";
    public static final String EXTRA_OPEN_FILE_REQUEST = "open_file_request";
    public static final String OPEN_ASSET_FILE_CALL = "open_asset_file_call";
    public static final String EXTRA_OPEN_ASSET_FILE_REQUEST = "open_asset_file_request";
    public static final String CREATE_CANCELLATION_SIGNAL_CALL = "create_cancellation_signal_call";
    public static final String CREATE_CANCELLATION_SIGNAL_RESULT = "create_cancellation_signal_result";
    public static final String USES_FUSE_PASSTHROUGH = "uses_fuse_passthrough";
    public static final String USES_FUSE_PASSTHROUGH_RESULT = "uses_fuse_passthrough_result";
    public static final String PICKER_MEDIA_INIT_CALL = "picker_media_init";
    public static final String PICKER_INTERNAL_SEARCH_MEDIA_INIT_CALL = "picker_internal_search_media_init";
    public static final String PICKER_MEDIA_SETS_INIT_CALL = "picker_media_sets_init_call";
    public static final String PICKER_MEDIA_IN_MEDIA_SET_INIT_CALL = "picker_media_in_media_set_init";
    public static final String PICKER_GET_SEARCH_PROVIDERS_CALL = "picker_internal_get_search_providers";
    public static final String PICKER_TRANSCODE_CALL = "picker_transcode";
    public static final String PICKER_TRANSCODE_RESULT = "picker_transcode_result";
    public static final String EXTRA_LOCAL_ONLY = "is_local_only";
    public static final String EXTRA_ALBUM_ID = "album_id";
    public static final String EXTRA_ALBUM_AUTHORITY = "album_authority";
    public static final String EXTRA_CALLING_PACKAGE_UID = "calling_package_uid";
    @VisibleForTesting
    public static final String SET_STABLE_URIS_FLAG = "set_stable_uris_flag";
    @VisibleForTesting
    public static final String RUN_IDLE_MAINTENANCE_FOR_STABLE_URIS = "idle_maintenance_for_stable_uris";
    @VisibleForTesting
    public static final String READ_BACKUP = "read_backup";
    @VisibleForTesting
    public static final String GET_OWNER_PACKAGE_NAME = "get_owner_package_name";
    @VisibleForTesting
    public static final String GET_BACKUP_FILES = "get_backup_files";
    @VisibleForTesting
    public static final String GET_RECOVERY_DATA = "get_recovery_data";
    @VisibleForTesting
    public static final String REMOVE_RECOVERY_DATA = "remove_recovery_data";
    @VisibleForTesting
    public static final String MEDIA_SERVICE_V2_CALL = "media_service_v2_call";
    @VisibleForTesting
    public static final String DELETE_BACKED_UP_FILE_PATHS = "delete_backed_up_file_paths";
    public static final String QUERY_FILE_ATTRS_FROM_LEVELDB = "query_file_attrs_from_leveldb";
    public static final String QUERY_ARG_MIME_TYPE = "android:query-arg-mime_type";
    public static final String QUERY_ARG_SIZE_BYTES = "android:query-arg-size_bytes";
    public static final String QUERY_ARG_ALBUM_ID = "android:query-arg-album_id";
    public static final String QUERY_ARG_ALBUM_AUTHORITY = "android:query-arg-album_authority";
    public static final String PARAM_DELETE_DATA = "deletedata";
    public static final String PARAM_INCLUDE_PENDING = "includePending";
    public static final String PARAM_PROGRESS = "progress";
    public static final String PARAM_REQUIRE_ORIGINAL = "requireOriginal";
    public static final String PARAM_LIMIT = "limit";
    public static final int MY_USER_ID = UserHandle.myUserId();
    public static final int MY_UID = Process.myUid();
    public static final int PER_USER_RANGE = 100000;
    private static final int PICK_IMAGES_MAX_LIMIT = 100;
    private static final String LOCAL_PICKER_PROVIDER_AUTHORITY = "com.android.providers.media.photopicker";
    @Deprecated
    public static final String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static final String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    public static final String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static final String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";
    public static final String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";
    public static final String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static final String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static final String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static final String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";
    @Deprecated
    public static final String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";
    public static final String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";
    public static final String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static final String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static final String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static final String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static final String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static final String META_DATA_STILL_IMAGE_CAMERA_PREWARM_SERVICE = "android.media.still_image_camera_preview_service";
    public static final String META_DATA_REVIEW_GALLERY_PREWARM_SERVICE = "android.media.review_gallery_prewarm_service";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";
    public static final String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    private static final long EXCLUDE_UNRELIABLE_STORAGE_VOLUMES = 391360514L;
    public static final String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static final String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";
    @FlaggedApi(value="android.provider.media.internal.flags.motion_photo_intent")
    public static final String ACTION_MOTION_PHOTO_CAPTURE = "android.provider.action.MOTION_PHOTO_CAPTURE";
    @FlaggedApi(value="android.provider.media.internal.flags.motion_photo_intent")
    public static final String ACTION_MOTION_PHOTO_CAPTURE_SECURE = "android.provider.action.MOTION_PHOTO_CAPTURE_SECURE";
    public static final String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static final String ACTION_REVIEW = "android.provider.action.REVIEW";
    public static final String ACTION_REVIEW_SECURE = "android.provider.action.REVIEW_SECURE";
    public static final String EXTRA_BRIGHTNESS = "android.provider.extra.BRIGHTNESS";
    public static final String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static final String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static final String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static final String EXTRA_OUTPUT = "output";
    public static final String ACTION_PICK_IMAGES = "android.provider.action.PICK_IMAGES";
    @SystemApi
    public static final String ACTION_USER_SELECT_IMAGES_FOR_APP = "android.provider.action.USER_SELECT_IMAGES_FOR_APP";
    public static final String ACTION_PICK_IMAGES_SETTINGS = "android.provider.action.PICK_IMAGES_SETTINGS";
    @FlaggedApi(value="android.provider.media.internal.flags.pick_ordered_images")
    public static final String EXTRA_PICK_IMAGES_IN_ORDER = "android.provider.extra.PICK_IMAGES_IN_ORDER";
    public static final String EXTRA_PICK_IMAGES_MAX = "android.provider.extra.PICK_IMAGES_MAX";
    @FlaggedApi(value="android.provider.media.internal.flags.picker_accent_color")
    public static final String EXTRA_PICK_IMAGES_ACCENT_COLOR = "android.provider.extra.PICK_IMAGES_ACCENT_COLOR";
    @FlaggedApi(value="android.provider.media.internal.flags.picker_default_tab")
    public static final String EXTRA_PICK_IMAGES_LAUNCH_TAB = "android.provider.extra.PICK_IMAGES_LAUNCH_TAB";
    @FlaggedApi(value="android.provider.media.internal.flags.picker_default_tab")
    public static final int PICK_IMAGES_TAB_ALBUMS = 0;
    @FlaggedApi(value="android.provider.media.internal.flags.picker_default_tab")
    public static final int PICK_IMAGES_TAB_IMAGES = 1;
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String EXTRA_PICK_IMAGES_HIGHLIGHT_SEARCH_RESULTS = "android.provider.extra.PICK_IMAGES_HIGHLIGHT_SEARCH_RESULTS";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String EXTRA_PICK_IMAGES_HIGHLIGHT_ALBUM = "android.provider.extra.PICK_IMAGES_HIGHLIGHT_ALBUM";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String KEY_PICK_IMAGES_HIGHLIGHT_SEARCH_TEXT_QUERY = "android.provider.media.key.PICK_IMAGES_HIGHLIGHT_SEARCH_TEXT_QUERY";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String KEY_PICK_IMAGES_HIGHLIGHT_ALBUM_ID = "android.provider.media.key.PICK_IMAGES_HIGHLIGHT_MEDIA_ALBUM_ID";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String KEY_PICK_IMAGES_HIGHLIGHT_TYPE = "android.provider.media.key.PICK_IMAGES_HIGHLIGHT_TYPE";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final int PICK_IMAGES_HIGHLIGHT_TYPE_COLLAPSED = 0;
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final int PICK_IMAGES_HIGHLIGHT_TYPE_EXPANDED = 1;
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String PICK_IMAGES_HIGHLIGHT_ALBUM_FAVORITES = "android.provider.media.PICK_IMAGES_HIGHLIGHT_ALBUM_FAVORITES";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String PICK_IMAGES_HIGHLIGHT_ALBUM_CAMERA = "android.provider.media.PICK_IMAGES_HIGHLIGHT_ALBUM_CAMERA";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String PICK_IMAGES_HIGHLIGHT_ALBUM_SCREENSHOTS = "android.provider.media.PICK_IMAGES_HIGHLIGHT_ALBUM_SCREENSHOTS";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String PICK_IMAGES_HIGHLIGHT_ALBUM_VIDEOS = "android.provider.media.PICK_IMAGES_HIGHLIGHT_ALBUM_VIDEOS";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_picker_highlight_search_results_apis")
    public static final String PICK_IMAGES_HIGHLIGHT_ALBUM_DOWNLOADS = "android.provider.media.PICK_IMAGES_HIGHLIGHT_ALBUM_DOWNLOADS";
    public static final String EXTRA_ACCEPT_ORIGINAL_MEDIA_FORMAT = "android.provider.extra.ACCEPT_ORIGINAL_MEDIA_FORMAT";
    public static final String EXTRA_MEDIA_CAPABILITIES = "android.provider.extra.MEDIA_CAPABILITIES";
    public static final String EXTRA_MEDIA_CAPABILITIES_UID = "android.provider.extra.MEDIA_CAPABILITIES_UID";
    @FlaggedApi(value="android.provider.media.internal.flags.picker_pre_selection_extra")
    public static final String EXTRA_PICKER_PRE_SELECTION_URIS = "android.provider.extra.PICKER_PRE_SELECTION_URIS";
    public static final String EXTRA_MODE = "android.provider.extra.MODE";
    public static final String UNKNOWN_STRING = "<unknown>";
    public static final String QUERY_ARG_RELATED_URI = "android:query-arg-related-uri";
    public static final String QUERY_ARG_ALLOW_MOVEMENT = "android:query-arg-allow-movement";
    @SystemApi
    public static final String QUERY_ARG_DEFER_SCAN = "android:query-arg-defer-scan";
    public static final String QUERY_ARG_INCLUDE_RECENTLY_UNMOUNTED_VOLUMES = "android:query-arg-recently-unmounted-volumes";
    public static final String QUERY_ARG_MATCH_PENDING = "android:query-arg-match-pending";
    public static final String QUERY_ARG_MATCH_TRASHED = "android:query-arg-match-trashed";
    public static final String QUERY_ARG_MATCH_FAVORITE = "android:query-arg-match-favorite";
    @FlaggedApi(value="android.provider.media.internal.flags.picker_recent_selection")
    public static final String QUERY_ARG_LATEST_SELECTION_ONLY = "android:query-arg-latest-selection-only";
    @FlaggedApi(value="android.provider.media.internal.flags.inferred_media_date")
    public static final String QUERY_ARG_MEDIA_STANDARD_SORT_ORDER = "android:query-arg-media-standard-sort-order";
    @FlaggedApi(value="android.provider.media.internal.flags.access_media_owner_package_name_permission")
    public static final String ACCESS_MEDIA_OWNER_PACKAGE_NAME_PERMISSION = "com.android.providers.media.permission.ACCESS_MEDIA_OWNER_PACKAGE_NAME";
    @FlaggedApi(value="android.provider.media.internal.flags.enable_oem_metadata")
    public static final String ACCESS_OEM_METADATA_PERMISSION = "com.android.providers.media.permission.ACCESS_OEM_METADATA";
    @SystemApi
    @FlaggedApi(value="android.provider.media.internal.flags.enable_oem_metadata_update")
    public static final String UPDATE_OEM_METADATA_PERMISSION = "com.android.providers.media.permission.UPDATE_OEM_METADATA";
    public static final int MATCH_DEFAULT = 0;
    public static final int MATCH_INCLUDE = 1;
    public static final int MATCH_EXCLUDE = 2;
    public static final int MATCH_ONLY = 3;
    private static final Pattern PATTERN_VOLUME_NAME = Pattern.compile("(?i)^/storage/([^/]+)");
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    public static final String MEDIA_IGNORE_FILENAME = ".nomedia";

    public static int getPickImagesMaxLimit() {
        return 100;
    }

    @Deprecated
    @NonNull
    public static Uri setIncludePending(@NonNull Uri uri) {
        return MediaStore.setIncludePending(uri.buildUpon()).build();
    }

    @Deprecated
    @NonNull
    public static Uri.Builder setIncludePending(@NonNull Uri.Builder uriBuilder) {
        return uriBuilder.appendQueryParameter(PARAM_INCLUDE_PENDING, "1");
    }

    @Deprecated
    public static boolean getIncludePending(@NonNull Uri uri) {
        return uri.getBooleanQueryParameter(PARAM_INCLUDE_PENDING, false);
    }

    @NonNull
    public static Uri setRequireOriginal(@NonNull Uri uri) {
        return uri.buildUpon().appendQueryParameter(PARAM_REQUIRE_ORIGINAL, "1").build();
    }

    public static boolean getRequireOriginal(@NonNull Uri uri) {
        return uri.getBooleanQueryParameter(PARAM_REQUIRE_ORIGINAL, false);
    }

    @NonNull
    public static ParcelFileDescriptor getOriginalMediaFormatFileDescriptor(@NonNull Context context, @NonNull ParcelFileDescriptor fileDescriptor) throws IOException {
        Bundle input = new Bundle();
        input.putParcelable(EXTRA_FILE_DESCRIPTOR, fileDescriptor);
        return context.getContentResolver().openTypedAssetFileDescriptor(Files.EXTERNAL_CONTENT_URI, "*/*", input).getParcelFileDescriptor();
    }

    @SystemApi
    @NonNull
    public static Uri rewriteToLegacy(@NonNull Uri uri) {
        return uri.buildUpon().authority(AUTHORITY_LEGACY).build();
    }

    public static void startLegacyMigration(@NonNull ContentResolver resolver, @NonNull String volumeName) {
        try {
            resolver.call(AUTHORITY_LEGACY, START_LEGACY_MIGRATION_CALL, volumeName, null);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to deliver legacy migration event", e);
        }
    }

    public static void finishLegacyMigration(@NonNull ContentResolver resolver, @NonNull String volumeName) {
        try {
            resolver.call(AUTHORITY_LEGACY, FINISH_LEGACY_MIGRATION_CALL, volumeName, null);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to deliver legacy migration event", e);
        }
    }

    @NonNull
    private static PendingIntent createRequest(@NonNull ContentResolver resolver, @NonNull String method, @NonNull Collection<Uri> uris, @Nullable ContentValues values) {
        Objects.requireNonNull(resolver);
        Objects.requireNonNull(uris);
        Iterator<Uri> it = uris.iterator();
        ClipData clipData = ClipData.newRawUri(null, it.next());
        while (it.hasNext()) {
            clipData.addItem(new ClipData.Item(it.next()));
        }
        Bundle extras = new Bundle();
        extras.putParcelable(EXTRA_CLIP_DATA, clipData);
        extras.putParcelable(EXTRA_CONTENT_VALUES, values);
        return (PendingIntent)resolver.call(AUTHORITY, method, null, extras).getParcelable(EXTRA_RESULT);
    }

    @NonNull
    public static PendingIntent createWriteRequest(@NonNull ContentResolver resolver, @NonNull Collection<Uri> uris) {
        return MediaStore.createRequest(resolver, CREATE_WRITE_REQUEST_CALL, uris, null);
    }

    @NonNull
    public static PendingIntent createTrashRequest(@NonNull ContentResolver resolver, @NonNull Collection<Uri> uris, boolean value) {
        ContentValues values = new ContentValues();
        if (value) {
            values.put("is_trashed", 1);
        } else {
            values.put("is_trashed", 0);
        }
        return MediaStore.createRequest(resolver, CREATE_TRASH_REQUEST_CALL, uris, values);
    }

    @NonNull
    public static PendingIntent createFavoriteRequest(@NonNull ContentResolver resolver, @NonNull Collection<Uri> uris, boolean value) {
        ContentValues values = new ContentValues();
        if (value) {
            values.put("is_favorite", 1);
        } else {
            values.put("is_favorite", 0);
        }
        return MediaStore.createRequest(resolver, CREATE_FAVORITE_REQUEST_CALL, uris, values);
    }

    @FlaggedApi(value="android.provider.media.internal.flags.enable_mark_is_favorite_status_api")
    public static void markIsFavoriteStatus(@NonNull ContentResolver resolver, @NonNull Collection<Uri> uris, boolean areFavorites) {
        Objects.requireNonNull(resolver);
        Objects.requireNonNull(uris);
        Iterator<Uri> it = uris.iterator();
        ClipData clipData = ClipData.newRawUri(null, it.next());
        while (it.hasNext()) {
            clipData.addItem(new ClipData.Item(it.next()));
        }
        Bundle extras = new Bundle();
        extras.putParcelable(EXTRA_CLIP_DATA, clipData);
        extras.putBoolean("is_favorite", areFavorites);
        resolver.call(AUTHORITY, MARK_MEDIA_AS_FAVORITE, null, extras);
    }

    @NonNull
    public static PendingIntent createDeleteRequest(@NonNull ContentResolver resolver, @NonNull Collection<Uri> uris) {
        return MediaStore.createRequest(resolver, CREATE_DELETE_REQUEST_CALL, uris, null);
    }

    @Deprecated
    @NonNull
    public static String getVolumeName(@NonNull File path) {
        Matcher matcher = PATTERN_VOLUME_NAME.matcher(path.getAbsolutePath());
        if (matcher.find()) {
            String volumeName = matcher.group(1);
            if (volumeName.equals("emulated")) {
                return VOLUME_EXTERNAL_PRIMARY;
            }
            return volumeName.toLowerCase(Locale.ROOT);
        }
        return VOLUME_INTERNAL;
    }

    @NonNull
    public static Set<String> getExternalVolumeNames(@NonNull Context context) {
        StorageManager sm = context.getSystemService(StorageManager.class);
        ArraySet<String> res = new ArraySet<String>();
        for (StorageVolume sv : sm.getStorageVolumes()) {
            Log.v(TAG, "Examining volume " + sv.getId() + " with name " + sv.getMediaStoreVolumeName() + " and state " + sv.getState());
            switch (sv.getState()) {
                case "mounted": 
                case "mounted_ro": {
                    String volumeName = sv.getMediaStoreVolumeName();
                    if (volumeName == null) break;
                    File directory = sv.getDirectory();
                    if (MediaStore.shouldExcludeUnReliableStorageVolumes() && directory != null && directory.getAbsolutePath() != null && directory.getAbsolutePath().startsWith("/mnt/")) {
                        Log.d(TAG, "skipping unreliable volume : " + volumeName);
                        break;
                    }
                    res.add(volumeName);
                    break;
                }
            }
        }
        return res;
    }

    private static boolean shouldExcludeUnReliableStorageVolumes() {
        return CompatChanges.isChangeEnabled(391360514L) && Flags.excludeUnreliableVolumes();
    }

    @FlaggedApi(value="android.provider.media.internal.flags.media_store_open_file")
    @Nullable
    public static ParcelFileDescriptor openFileDescriptor(@NonNull ContentResolver resolver, @NonNull Uri uri, @NonNull String mode, @Nullable CancellationSignal cancellationSignal) throws FileNotFoundException {
        Objects.requireNonNull(resolver, "resolver");
        Objects.requireNonNull(uri, EXTRA_URI);
        Objects.requireNonNull(mode, "mode");
        if (!"content".equals(uri.getScheme()) || !AUTHORITY.equals(uri.getAuthority())) {
            throw new IllegalArgumentException("Given Uri " + uri + " should be a media URI");
        }
        if (MediaStore.isNonCloudPickerUri(uri)) {
            return resolver.openFileDescriptor(uri, mode, cancellationSignal);
        }
        if (ParcelFileDescriptor.parseMode(mode) != 0x10000000) {
            throw new SecurityException("PhotoPicker Uris can only be accessed to read. Uri: " + uri);
        }
        try {
            ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
            try {
                IMPCancellationSignal remoteCancellationSignal = MediaStore.createRemoteCancellationSignalIfNeeded(client, cancellationSignal);
                final CompletableFuture future = new CompletableFuture();
                IOpenFileCallback.Stub callback = new IOpenFileCallback.Stub(){

                    @Override
                    public void onSuccess(ParcelFileDescriptor pfd) {
                        future.complete(pfd);
                    }

                    @Override
                    public void onFailure(ParcelableException exception) {
                        future.completeExceptionally(exception);
                    }
                };
                Bundle in = new Bundle();
                in.putParcelable(EXTRA_OPEN_FILE_REQUEST, new OpenFileRequest(uri, callback, remoteCancellationSignal));
                client.call(OPEN_FILE_CALL, null, in);
                ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)future.get();
                if (client != null) {
                    client.close();
                }
                return parcelFileDescriptor;
            }
            catch (Throwable remoteCancellationSignal) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            remoteCancellationSignal.addSuppressed(throwable);
                        }
                    }
                    throw remoteCancellationSignal;
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                catch (ExecutionException e) {
                    ParcelableException pe = (ParcelableException)e.getCause();
                    MediaStore.rethrowParcelableExceptionForOpenFile(pe);
                    throw new RuntimeException(pe.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            if (cancellationSignal != null) {
                cancellationSignal.setOnCancelListener(null);
            }
        }
    }

    @FlaggedApi(value="android.provider.media.internal.flags.media_store_open_file")
    @Nullable
    public static AssetFileDescriptor openAssetFileDescriptor(@NonNull ContentResolver resolver, @NonNull Uri uri, @NonNull String mode, @Nullable CancellationSignal cancellationSignal) throws FileNotFoundException {
        Objects.requireNonNull(resolver, "resolver");
        Objects.requireNonNull(uri, EXTRA_URI);
        Objects.requireNonNull(mode, "mode");
        if (!"content".equals(uri.getScheme()) || !AUTHORITY.equals(uri.getAuthority())) {
            throw new IllegalArgumentException("Given Uri " + uri + " should be a media URI");
        }
        if (MediaStore.isNonCloudPickerUri(uri)) {
            return resolver.openAssetFileDescriptor(uri, mode, cancellationSignal);
        }
        if (ParcelFileDescriptor.parseMode(mode) != 0x10000000) {
            throw new SecurityException("PhotoPicker Uris can only be accessed to read. Uri: " + uri);
        }
        return MediaStore.openTypedAssetFileDescriptorInternal(resolver, uri, "*/*", null, cancellationSignal);
    }

    @FlaggedApi(value="android.provider.media.internal.flags.media_store_open_file")
    @Nullable
    public static AssetFileDescriptor openTypedAssetFileDescriptor(@NonNull ContentResolver resolver, @NonNull Uri uri, @NonNull String mimeType, @Nullable Bundle opts, @Nullable CancellationSignal cancellationSignal) throws FileNotFoundException {
        Objects.requireNonNull(resolver, "resolver");
        Objects.requireNonNull(uri, EXTRA_URI);
        Objects.requireNonNull(mimeType, "mimeType");
        if (!"content".equals(uri.getScheme()) || !AUTHORITY.equals(uri.getAuthority())) {
            throw new IllegalArgumentException("Given Uri " + uri + " should be a media URI");
        }
        if (MediaStore.isNonCloudPickerUri(uri)) {
            return resolver.openTypedAssetFileDescriptor(uri, mimeType, opts, cancellationSignal);
        }
        return MediaStore.openTypedAssetFileDescriptorInternal(resolver, uri, mimeType, opts, cancellationSignal);
    }

    @Nullable
    private static AssetFileDescriptor openTypedAssetFileDescriptorInternal(@NonNull ContentResolver resolver, @NonNull Uri uri, @NonNull String mimeType, @Nullable Bundle opts, @Nullable CancellationSignal cancellationSignal) throws FileNotFoundException {
        try {
            ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
            try {
                IMPCancellationSignal remoteCancellationSignal = MediaStore.createRemoteCancellationSignalIfNeeded(client, cancellationSignal);
                final CompletableFuture future = new CompletableFuture();
                IOpenAssetFileCallback.Stub callback = new IOpenAssetFileCallback.Stub(){

                    @Override
                    public void onSuccess(AssetFileDescriptor afd) {
                        future.complete(afd);
                    }

                    @Override
                    public void onFailure(ParcelableException exception) {
                        future.completeExceptionally(exception);
                    }
                };
                Bundle in = new Bundle();
                in.putParcelable(EXTRA_OPEN_ASSET_FILE_REQUEST, new OpenAssetFileRequest(uri, mimeType, opts, callback, remoteCancellationSignal));
                client.call(OPEN_ASSET_FILE_CALL, null, in);
                AssetFileDescriptor assetFileDescriptor = (AssetFileDescriptor)future.get();
                if (client != null) {
                    client.close();
                }
                return assetFileDescriptor;
            }
            catch (Throwable remoteCancellationSignal) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            remoteCancellationSignal.addSuppressed(throwable);
                        }
                    }
                    throw remoteCancellationSignal;
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                catch (ExecutionException e) {
                    ParcelableException pe = (ParcelableException)e.getCause();
                    MediaStore.rethrowParcelableExceptionForOpenFile(pe);
                    throw new RuntimeException(pe.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            if (cancellationSignal != null) {
                cancellationSignal.setOnCancelListener(null);
            }
        }
    }

    private static boolean isNonCloudPickerUri(@NonNull Uri uri) {
        UriMatcher matcher = new UriMatcher(-1);
        matcher.addURI(AUTHORITY, "picker/#/*/media/*", 1);
        matcher.addURI(AUTHORITY, "picker_get_content/#/*/media/*", 2);
        return matcher.match(uri) == -1 || LOCAL_PICKER_PROVIDER_AUTHORITY.equals(uri.getPathSegments().get(2));
    }

    private static void rethrowParcelableExceptionForOpenFile(ParcelableException exception) throws FileNotFoundException {
        exception.maybeRethrow(FileNotFoundException.class);
        exception.maybeRethrow(IllegalArgumentException.class);
        exception.maybeRethrow(SecurityException.class);
        exception.maybeRethrow(OperationCanceledException.class);
    }

    private static IMPCancellationSignal createRemoteCancellationSignalIfNeeded(@NonNull ContentProviderClient client, @Nullable CancellationSignal cancellationSignal) throws RemoteException {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
            Bundle in = new Bundle();
            Bundle out = client.call(CREATE_CANCELLATION_SIGNAL_CALL, null, in);
            IMPCancellationSignal remoteCancellationSignal = IMPCancellationSignal.Stub.asInterface(out.getBinder(CREATE_CANCELLATION_SIGNAL_RESULT));
            cancellationSignal.setOnCancelListener(() -> {
                try {
                    remoteCancellationSignal.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            });
            return remoteCancellationSignal;
        }
        return null;
    }

    @NonNull
    public static Set<String> getRecentExternalVolumeNames(@NonNull Context context) {
        StorageManager sm = context.getSystemService(StorageManager.class);
        ArraySet<String> res = new ArraySet<String>();
        for (StorageVolume sv : sm.getRecentStorageVolumes()) {
            String volumeName = sv.getMediaStoreVolumeName();
            if (volumeName == null) continue;
            res.add(volumeName);
        }
        return res;
    }

    @NonNull
    public static String getVolumeName(@NonNull Uri uri) {
        List<String> segments = uri.getPathSegments();
        switch (uri.getAuthority()) {
            case "media": 
            case "media_legacy": {
                if (segments == null || segments.size() <= 0) break;
                return segments.get(0);
            }
        }
        throw new IllegalArgumentException("Missing volume name: " + uri);
    }

    public static boolean isKnownVolume(@NonNull String volumeName) {
        if (VOLUME_INTERNAL.equals(volumeName)) {
            return true;
        }
        if (VOLUME_EXTERNAL.equals(volumeName)) {
            return true;
        }
        if (VOLUME_EXTERNAL_PRIMARY.equals(volumeName)) {
            return true;
        }
        return VOLUME_DEMO.equals(volumeName);
    }

    @NonNull
    public static String checkArgumentVolumeName(@NonNull String volumeName) {
        if (TextUtils.isEmpty(volumeName)) {
            throw new IllegalArgumentException();
        }
        if (MediaStore.isKnownVolume(volumeName)) {
            return volumeName;
        }
        for (int i = 0; i < volumeName.length(); ++i) {
            char c = volumeName.charAt(i);
            if ('a' <= c && c <= 'f' || '0' <= c && c <= '9' || c == '-') continue;
            throw new IllegalArgumentException("Invalid volume name: " + volumeName);
        }
        return volumeName;
    }

    public static Uri getMediaScannerUri() {
        return AUTHORITY_URI.buildUpon().appendPath("none").appendPath("media_scanner").build();
    }

    @NonNull
    public static String getVersion(@NonNull Context context) {
        return MediaStore.getVersion(context, VOLUME_EXTERNAL_PRIMARY);
    }

    @NonNull
    public static String getVersion(@NonNull Context context, @NonNull String volumeName) {
        ContentResolver resolver = context.getContentResolver();
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putString("android.intent.extra.TEXT", volumeName);
            Bundle out = client.call(GET_VERSION_CALL, null, in);
            String string2 = out.getString("android.intent.extra.TEXT");
            if (client != null) {
                client.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static long getGeneration(@NonNull Context context, @NonNull String volumeName) {
        return MediaStore.getGeneration(context.getContentResolver(), volumeName);
    }

    public static long getGeneration(@NonNull ContentResolver resolver, @NonNull String volumeName) {
        Bundle in = new Bundle();
        in.putString("android.intent.extra.TEXT", volumeName);
        Bundle out = resolver.call(AUTHORITY, GET_GENERATION_CALL, null, in);
        if (out == null) {
            throw new IllegalStateException("Failed to get generation for volume '" + volumeName + "'. The ContentResolver call returned null.");
        }
        return out.getLong("android.intent.extra.INDEX");
    }

    @Nullable
    public static Uri getDocumentUri(@NonNull Context context, @NonNull Uri mediaUri) {
        ContentResolver resolver = context.getContentResolver();
        List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putParcelable(EXTRA_URI, mediaUri);
            in.putParcelableArrayList(EXTRA_URI_PERMISSIONS, new ArrayList<UriPermission>(uriPermissions));
            Bundle out = client.call(GET_DOCUMENT_URI_CALL, null, in);
            Uri uri = (Uri)out.getParcelable(EXTRA_URI);
            if (client != null) {
                client.close();
            }
            return uri;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    @Nullable
    public static Uri getMediaUri(@NonNull Context context, @NonNull Uri documentUri) {
        ContentResolver resolver = context.getContentResolver();
        List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle in = new Bundle();
            in.putParcelable(EXTRA_URI, documentUri);
            in.putParcelableArrayList(EXTRA_URI_PERMISSIONS, new ArrayList<UriPermission>(uriPermissions));
            Bundle out = client.call(GET_MEDIA_URI_CALL, null, in);
            Uri uri = (Uri)out.getParcelable(EXTRA_URI);
            if (client != null) {
                client.close();
            }
            return uri;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static boolean isCurrentSystemGallery(@NonNull ContentResolver resolver, int uid, @NonNull String packageName) {
        Bundle in = new Bundle();
        in.putInt(EXTRA_IS_SYSTEM_GALLERY_UID, uid);
        Bundle out = resolver.call(AUTHORITY, IS_SYSTEM_GALLERY_CALL, packageName, in);
        return out.getBoolean(EXTRA_IS_SYSTEM_GALLERY_RESPONSE);
    }

    private static Uri maybeRemoveUserId(@NonNull Uri uri) {
        if (uri.getUserInfo() == null) {
            return uri;
        }
        Uri.Builder builder = uri.buildUpon();
        builder.authority(uri.getHost());
        return builder.build();
    }

    private static List<Uri> maybeRemoveUserId(@NonNull List<Uri> uris) {
        ArrayList<Uri> newUriList = new ArrayList<Uri>();
        for (Uri uri : uris) {
            newUriList.add(MediaStore.maybeRemoveUserId(uri));
        }
        return newUriList;
    }

    private static int getUserIdFromUri(Uri uri) {
        String userId = uri.getUserInfo();
        return userId == null ? MY_USER_ID : Integer.parseInt(userId);
    }

    @RequiresApi(value=31)
    private static Uri maybeAddUserId(@NonNull Uri uri, String userId) {
        if (userId == null) {
            return uri;
        }
        return ContentProvider.createContentUriForUser(uri, UserHandle.of(Integer.parseInt(userId)));
    }

    @RequiresApi(value=31)
    private static List<Uri> maybeAddUserId(@NonNull List<Uri> uris, String userId) {
        if (userId == null) {
            return uris;
        }
        ArrayList<Uri> newUris = new ArrayList<Uri>();
        for (Uri uri : uris) {
            newUris.add(MediaStore.maybeAddUserId(uri, userId));
        }
        return newUris;
    }

    @RequiresApi(value=31)
    @Nullable
    public static Uri getRedactedUri(@NonNull ContentResolver resolver, @NonNull Uri uri) {
        String authority = uri.getAuthority();
        ContentProviderClient client = resolver.acquireContentProviderClient(authority);
        try {
            Bundle in = new Bundle();
            String userId = uri.getUserInfo();
            in.putParcelable(EXTRA_URI, MediaStore.maybeRemoveUserId(uri));
            Bundle out = client.call(GET_REDACTED_MEDIA_URI_CALL, null, in);
            Uri uri2 = MediaStore.maybeAddUserId((Uri)out.getParcelable(EXTRA_URI), userId);
            if (client != null) {
                client.close();
            }
            return uri2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    private static void verifyUrisBelongToSingleUserId(@NonNull List<Uri> uris) {
        int userId = MediaStore.getUserIdFromUri(uris.get(0));
        for (Uri uri : uris) {
            if (userId == MediaStore.getUserIdFromUri(uri)) continue;
            throw new IllegalArgumentException("All the uris should belong to a single user-id");
        }
    }

    @RequiresApi(value=31)
    @NonNull
    public static List<Uri> getRedactedUri(@NonNull ContentResolver resolver, @NonNull List<Uri> uris) {
        MediaStore.verifyUrisBelongToSingleUserId(uris);
        String authority = uris.get(0).getAuthority();
        ContentProviderClient client = resolver.acquireContentProviderClient(authority);
        try {
            String userId = uris.get(0).getUserInfo();
            Bundle in = new Bundle();
            in.putParcelableArrayList(EXTRA_URI_LIST, (ArrayList)MediaStore.maybeRemoveUserId(uris));
            Bundle out = client.call(GET_REDACTED_MEDIA_URI_LIST_CALL, null, in);
            List<Uri> list = MediaStore.maybeAddUserId(out.getParcelableArrayList(EXTRA_URI_LIST), userId);
            if (client != null) {
                client.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static void resolvePlaylistMembers(@NonNull ContentResolver resolver, @NonNull Uri playlistUri) {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, playlistUri);
        resolver.call(AUTHORITY, RESOLVE_PLAYLIST_MEMBERS_CALL, null, in);
    }

    public static void runIdleMaintenance(@NonNull ContentResolver resolver) {
        resolver.call(AUTHORITY, RUN_IDLE_MAINTENANCE_CALL, null, null);
    }

    public static void setStableUrisFlag(@NonNull ContentResolver resolver, @NonNull String volumeName, boolean isEnabled) {
        Bundle extras = new Bundle();
        extras.putBoolean(EXTRA_IS_STABLE_URIS_ENABLED, isEnabled);
        resolver.call(AUTHORITY, SET_STABLE_URIS_FLAG, volumeName, extras);
    }

    @VisibleForTesting
    public static void runIdleMaintenanceForStableUris(@NonNull ContentResolver resolver) {
        resolver.call(AUTHORITY, RUN_IDLE_MAINTENANCE_FOR_STABLE_URIS, null, null);
    }

    @VisibleForTesting
    public static String readBackup(@NonNull ContentResolver resolver, String volumeName, String filePath) {
        Bundle extras = new Bundle();
        extras.putString("_data", filePath);
        Bundle bundle = resolver.call(AUTHORITY, READ_BACKUP, volumeName, extras);
        return bundle.getString(READ_BACKUP);
    }

    @VisibleForTesting
    public static String getOwnerPackageName(@NonNull ContentResolver resolver, int ownerId) {
        Bundle bundle = resolver.call(AUTHORITY, GET_OWNER_PACKAGE_NAME, String.valueOf(ownerId), null);
        return bundle.getString(GET_OWNER_PACKAGE_NAME);
    }

    @VisibleForTesting
    public static void deleteBackedUpFilePaths(@NonNull ContentResolver resolver, String volumeName) {
        resolver.call(AUTHORITY, DELETE_BACKED_UP_FILE_PATHS, volumeName, null);
    }

    @VisibleForTesting
    public static String[] getBackupFiles(@NonNull ContentResolver resolver) {
        Bundle bundle = resolver.call(AUTHORITY, GET_BACKUP_FILES, null, null);
        return bundle.getStringArray(GET_BACKUP_FILES);
    }

    @VisibleForTesting
    public static String[] getRecoveryData(@NonNull ContentResolver resolver) {
        Bundle bundle = resolver.call(AUTHORITY, GET_RECOVERY_DATA, null, null);
        return bundle.getStringArray(GET_RECOVERY_DATA);
    }

    @VisibleForTesting
    public static void removeRecoveryData(@NonNull ContentResolver resolver) {
        resolver.call(AUTHORITY, REMOVE_RECOVERY_DATA, null, null);
    }

    @SystemApi
    public static void waitForIdle(@NonNull ContentResolver resolver) {
        resolver.call(AUTHORITY, WAIT_FOR_IDLE_CALL, null, null);
    }

    @SystemApi
    @SuppressLint(value={"StreamFiles"})
    @NonNull
    public static Uri scanFile(@NonNull ContentResolver resolver, @NonNull File file) {
        Bundle out = resolver.call(AUTHORITY, SCAN_FILE_CALL, file.getAbsolutePath(), null);
        return (Uri)out.getParcelable("android.intent.extra.STREAM");
    }

    @SystemApi
    public static void scanVolume(@NonNull ContentResolver resolver, @NonNull String volumeName) {
        resolver.call(AUTHORITY, SCAN_VOLUME_CALL, volumeName, null);
    }

    @RequiresApi(value=31)
    public static boolean canManageMedia(@NonNull Context context) {
        Objects.requireNonNull(context);
        String packageName = context.getOpPackageName();
        int uid = context.getApplicationInfo().uid;
        String permission2 = "android.permission.MANAGE_MEDIA";
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        int opMode = appOps.unsafeCheckOpNoThrow(AppOpsManager.permissionToOp("android.permission.MANAGE_MEDIA"), uid, packageName);
        switch (opMode) {
            case 3: {
                return 0 == context.checkPermission("android.permission.MANAGE_MEDIA", Process.myPid(), uid);
            }
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        Log.w(TAG, "Unknown AppOpsManager mode " + opMode);
        return false;
    }

    public static boolean isCurrentCloudMediaProviderAuthority(@NonNull ContentResolver resolver, @NonNull String authority) {
        return MediaStore.callForCloudProvider(resolver, IS_CURRENT_CLOUD_PROVIDER_CALL, authority);
    }

    public static boolean isSupportedCloudMediaProviderAuthority(@NonNull ContentResolver resolver, @NonNull String authority) {
        return MediaStore.callForCloudProvider(resolver, IS_SUPPORTED_CLOUD_PROVIDER_CALL, authority);
    }

    public static void notifyCloudMediaChangedEvent(@NonNull ContentResolver resolver, @NonNull String authority, @NonNull String currentMediaCollectionId) throws SecurityException {
        Bundle extras = new Bundle();
        extras.putString("android.provider.extra.MEDIA_COLLECTION_ID", currentMediaCollectionId);
        if (!MediaStore.callForCloudProvider(resolver, NOTIFY_CLOUD_MEDIA_CHANGED_EVENT_CALL, authority, extras)) {
            throw new SecurityException("Failed to notify cloud media changed event");
        }
    }

    private static boolean callForCloudProvider(ContentResolver resolver, String method, String callingAuthority) {
        return MediaStore.callForCloudProvider(resolver, method, callingAuthority, null);
    }

    private static boolean callForCloudProvider(ContentResolver resolver, String method, String callingAuthority, Bundle extras) {
        Objects.requireNonNull(resolver);
        Objects.requireNonNull(method);
        Objects.requireNonNull(callingAuthority);
        Bundle out = resolver.call(AUTHORITY, method, callingAuthority, extras);
        return out.getBoolean(EXTRA_CLOUD_PROVIDER_RESULT);
    }

    public static String getCurrentCloudProvider(@NonNull ContentResolver resolver) {
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);
        try {
            Bundle out = client.call(GET_CLOUD_PROVIDER_CALL, null, null);
            String string2 = out.getString(GET_CLOUD_PROVIDER_RESULT);
            if (client != null) {
                client.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static void grantMediaReadForPackage(@NonNull Context context, int packageUid, List<Uri> uris) {
        ContentResolver resolver = context.getContentResolver();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle extras = new Bundle();
            extras.putInt("android.intent.extra.UID", packageUid);
            extras.putParcelableArrayList(EXTRA_URI_LIST, new ArrayList<Uri>(uris));
            client.call(GRANT_MEDIA_READ_FOR_PACKAGE_CALL, null, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static void revokeAllMediaReadForPackages(@NonNull Context context, int packageUid) {
        ContentResolver resolver = context.getContentResolver();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle extras = new Bundle();
            extras.putInt("android.intent.extra.UID", packageUid);
            extras.putBoolean(REVOKED_ALL_READ_GRANTS_FOR_PACKAGE_CALL, true);
            client.call(REVOKE_READ_GRANT_FOR_PACKAGE_CALL, null, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static void revokeMediaReadForPackages(@NonNull Context context, int packageUid, @NonNull List<Uri> uris) {
        Objects.requireNonNull(uris);
        if (uris.isEmpty()) {
            return;
        }
        ContentResolver resolver = context.getContentResolver();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle extras = new Bundle();
            extras.putInt("android.intent.extra.UID", packageUid);
            extras.putParcelableArrayList(EXTRA_URI_LIST, new ArrayList<Uri>(uris));
            client.call(REVOKE_READ_GRANT_FOR_PACKAGE_CALL, null, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.provider.media.internal.flags.enable_oem_metadata_update")
    public static void bulkUpdateOemMetadataInNextScan(@NonNull Context context) {
        ContentResolver resolver = context.getContentResolver();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle extras = new Bundle();
            client.call(BULK_UPDATE_OEM_METADATA_CALL, null, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static class Files {
        public static final String TABLE = "files";
        public static final Uri EXTERNAL_CONTENT_URI = Files.getContentUri("external");

        public static Uri getContentUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("file").build();
        }

        public static Uri getContentUri(String volumeName, long rowId) {
            return ContentUris.withAppendedId(Files.getContentUri(volumeName), rowId);
        }

        @UnsupportedAppUsage
        public static Uri getMtpObjectsUri(@NonNull String volumeName) {
            return Files.getContentUri(volumeName);
        }

        @UnsupportedAppUsage
        public static Uri getMtpObjectsUri(@NonNull String volumeName, long fileId) {
            return Files.getContentUri(volumeName, fileId);
        }

        @UnsupportedAppUsage
        public static Uri getMtpReferencesUri(@NonNull String volumeName, long fileId) {
            return Files.getContentUri(volumeName, fileId);
        }

        public static Uri getDirectoryUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("dir").build();
        }

        public static Uri getContentUriForPath(String path) {
            return Files.getContentUri(MediaStore.getVolumeName(new File(path)));
        }

        public static interface FileColumns
        extends MediaColumns {
            @Deprecated
            @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
            public static final String STORAGE_ID = "storage_id";
            @Column(value=1, readOnly=true)
            @UnsupportedAppUsage
            public static final String FORMAT = "format";
            @Column(value=1, readOnly=true)
            public static final String PARENT = "parent";
            @Column(value=3)
            public static final String MIME_TYPE = "mime_type";
            public static final String TITLE = "title";
            @Column(value=1)
            public static final String MEDIA_TYPE = "media_type";
            public static final int MEDIA_TYPE_NONE = 0;
            public static final int MEDIA_TYPE_IMAGE = 1;
            public static final int MEDIA_TYPE_AUDIO = 2;
            public static final int MEDIA_TYPE_VIDEO = 3;
            @Deprecated
            public static final int MEDIA_TYPE_PLAYLIST = 4;
            public static final int MEDIA_TYPE_SUBTITLE = 5;
            public static final int MEDIA_TYPE_DOCUMENT = 6;
            public static final int MEDIA_TYPE_COUNT = 7;
            public static final String _MODIFIER = "_modifier";
            public static final int _MODIFIER_FUSE = 1;
            public static final int _MODIFIER_CR = 2;
            public static final int _MODIFIER_MEDIA_SCAN = 3;
            public static final int _MODIFIER_CR_PENDING_METADATA = 4;
            public static final int _MODIFIER_SCHEMA_UPDATE = 5;
            public static final String _TRANSCODE_STATUS = "_transcode_status";
            public static final int TRANSCODE_EMPTY = 0;
            public static final int TRANSCODE_COMPLETE = 1;
            public static final String _VIDEO_CODEC_TYPE = "_video_codec_type";
            public static final String REDACTED_URI_ID = "redacted_uri_id";
            public static final String _USER_ID = "_user_id";
            public static final String _SPECIAL_FORMAT = "_special_format";
            public static final int _SPECIAL_FORMAT_NONE = 0;
            public static final int _SPECIAL_FORMAT_GIF = 1;
            public static final int _SPECIAL_FORMAT_MOTION_PHOTO = 2;
            public static final int _SPECIAL_FORMAT_ANIMATED_WEBP = 3;
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        @Column(value=3)
        public static final String DATA = "_data";
        @Column(value=1, readOnly=true)
        public static final String SIZE = "_size";
        @Column(value=3)
        public static final String DISPLAY_NAME = "_display_name";
        @Column(value=1, readOnly=true)
        public static final String DATE_ADDED = "date_added";
        @Column(value=1, readOnly=true)
        public static final String DATE_MODIFIED = "date_modified";
        @Column(value=1, readOnly=true)
        public static final String DATE_TAKEN = "datetaken";
        @Column(value=1, readOnly=true)
        @FlaggedApi(value="android.provider.media.internal.flags.inferred_media_date")
        public static final String INFERRED_DATE = "inferred_date";
        @Column(value=3)
        public static final String MIME_TYPE = "mime_type";
        @Column(value=1)
        public static final String IS_DRM = "is_drm";
        @Column(value=1)
        public static final String IS_PENDING = "is_pending";
        @Column(value=1)
        public static final String IS_TRASHED = "is_trashed";
        @Column(value=1, readOnly=true)
        public static final String DATE_EXPIRES = "date_expires";
        @Column(value=1, readOnly=true)
        public static final String WIDTH = "width";
        @Column(value=1, readOnly=true)
        public static final String HEIGHT = "height";
        @Column(value=3, readOnly=true)
        public static final String RESOLUTION = "resolution";
        @Column(value=3, readOnly=true)
        public static final String OWNER_PACKAGE_NAME = "owner_package_name";
        @Column(value=3, readOnly=true)
        public static final String VOLUME_NAME = "volume_name";
        @Column(value=3)
        public static final String RELATIVE_PATH = "relative_path";
        @Column(value=1, readOnly=true)
        public static final String BUCKET_ID = "bucket_id";
        @Column(value=3, readOnly=true)
        public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
        @Column(value=1, readOnly=true)
        @Deprecated
        public static final String GROUP_ID = "group_id";
        @Column(value=3, readOnly=true)
        public static final String DOCUMENT_ID = "document_id";
        @Column(value=3, readOnly=true)
        public static final String INSTANCE_ID = "instance_id";
        @Column(value=3, readOnly=true)
        public static final String ORIGINAL_DOCUMENT_ID = "original_document_id";
        @Column(value=1, readOnly=true)
        public static final String ORIENTATION = "orientation";
        @Column(value=1)
        public static final String IS_FAVORITE = "is_favorite";
        @Column(value=1, readOnly=true)
        public static final String IS_DOWNLOAD = "is_download";
        @Column(value=1, readOnly=true)
        public static final String GENERATION_ADDED = "generation_added";
        @Column(value=1, readOnly=true)
        public static final String GENERATION_MODIFIED = "generation_modified";
        public static final int GENERATION_MODIFIED_UNCHANGED = -1;
        @Column(value=4, readOnly=true)
        public static final String XMP = "xmp";
        @Column(value=3, readOnly=true)
        public static final String CD_TRACK_NUMBER = "cd_track_number";
        @Column(value=3, readOnly=true)
        public static final String ALBUM = "album";
        @Column(value=3, readOnly=true)
        public static final String ARTIST = "artist";
        @Column(value=3, readOnly=true)
        public static final String AUTHOR = "author";
        @Column(value=3, readOnly=true)
        public static final String COMPOSER = "composer";
        @Column(value=3, readOnly=true)
        public static final String GENRE = "genre";
        @Column(value=3, readOnly=true)
        public static final String TITLE = "title";
        @Column(value=1, readOnly=true)
        public static final String YEAR = "year";
        @Column(value=1, readOnly=true)
        public static final String DURATION = "duration";
        @Column(value=1, readOnly=true)
        public static final String NUM_TRACKS = "num_tracks";
        @Column(value=3, readOnly=true)
        public static final String WRITER = "writer";
        @Column(value=3, readOnly=true)
        public static final String ALBUM_ARTIST = "album_artist";
        @Column(value=3, readOnly=true)
        public static final String DISC_NUMBER = "disc_number";
        @Column(value=3, readOnly=true)
        public static final String COMPILATION = "compilation";
        @Column(value=1, readOnly=true)
        public static final String BITRATE = "bitrate";
        @Column(value=2, readOnly=true)
        public static final String CAPTURE_FRAMERATE = "capture_framerate";
        @Column(value=4, readOnly=true)
        @FlaggedApi(value="android.provider.media.internal.flags.enable_oem_metadata")
        public static final String OEM_METADATA = "oem_metadata";
    }

    public static class Video {
        public static final String DEFAULT_SORT_ORDER = "_display_name";

        @Deprecated
        public static Cursor query(ContentResolver cr, Uri uri, String[] projection) {
            return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
        }

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            public static final String DEFAULT_SORT_ORDER = "video_id ASC";
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String VIDEO_ID = "video_id";
            @Column(value=1)
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            @Column(value=1, readOnly=true)
            public static final String WIDTH = "width";
            @Column(value=1, readOnly=true)
            public static final String HEIGHT = "height";

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, origId);
                InternalThumbnails.cancelThumbnail(cr, uri);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long videoId, int kind, BitmapFactory.Options options) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, videoId);
                return InternalThumbnails.getThumbnail(cr, uri, kind, options);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long videoId, long groupId) {
                Thumbnails.cancelThumbnailRequest(cr, videoId);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long videoId, long groupId, int kind, BitmapFactory.Options options) {
                return Thumbnails.getThumbnail(cr, videoId, kind, options);
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("video").appendPath("thumbnails").build();
            }

            @Deprecated
            @NonNull
            public static Size getKindSize(int kind) {
                return ThumbnailConstants.getKindSize(kind);
            }
        }

        public static class Media
        implements VideoColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static final String DEFAULT_SORT_ORDER = "title";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("video").appendPath(MediaStore.AUTHORITY).build();
            }

            @NonNull
            public static Uri getContentUri(@NonNull String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String DURATION = "duration";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String RESOLUTION = "resolution";
            @Column(value=3, readOnly=true)
            public static final String DESCRIPTION = "description";
            @Column(value=1)
            public static final String IS_PRIVATE = "isprivate";
            @Column(value=3)
            public static final String TAGS = "tags";
            @Column(value=3)
            public static final String CATEGORY = "category";
            @Column(value=3)
            public static final String LANGUAGE = "language";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LATITUDE = "latitude";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            @Deprecated
            @Column(value=1)
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String GROUP_ID = "group_id";
            @Column(value=1)
            public static final String BOOKMARK = "bookmark";
            @Column(value=1, readOnly=true)
            public static final String COLOR_STANDARD = "color_standard";
            @Column(value=1, readOnly=true)
            public static final String COLOR_TRANSFER = "color_transfer";
            @Column(value=1, readOnly=true)
            public static final String COLOR_RANGE = "color_range";
        }
    }

    public static class Audio {
        private static final Pattern PATTERN_TRIM_BEFORE = Pattern.compile("(?i)(^(the|an|a) |,\\s*(the|an|a)$|[^\\w\\s]|^\\s+|\\s+$)");
        private static final Pattern PATTERN_TRIM_AFTER = Pattern.compile("(^(00)+|(00)+$)");

        @Deprecated
        @Nullable
        public static String keyFor(@Nullable String name) {
            if (TextUtils.isEmpty(name)) {
                return "";
            }
            if (MediaStore.UNKNOWN_STRING.equals(name)) {
                return "01";
            }
            boolean sortFirst = name.startsWith("\u0001");
            if (TextUtils.isEmpty(name = PATTERN_TRIM_BEFORE.matcher(name).replaceAll(""))) {
                return "";
            }
            Collator c = Collator.getInstance(Locale.ROOT);
            c.setStrength(0);
            name = Audio.encodeToString(c.getCollationKey(name).toByteArray());
            name = PATTERN_TRIM_AFTER.matcher(name).replaceAll("");
            if (sortFirst) {
                name = "01" + name;
            }
            return name;
        }

        private static String encodeToString(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String ALBUM_ID = "album_id";
        }

        public static class Radio {
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";

            private Radio() {
            }
        }

        public static class Albums
        implements BaseColumns,
        AlbumColumns {
            public static final Uri INTERNAL_CONTENT_URI = Albums.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Albums.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static final String DEFAULT_SORT_ORDER = "album_key";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("albums").build();
            }
        }

        public static interface AlbumColumns {
            @Column(value=1, readOnly=true)
            public static final String ALBUM_ID = "album_id";
            @Column(value=3, readOnly=true)
            public static final String ALBUM = "album";
            @Column(value=1, readOnly=true)
            public static final String ARTIST_ID = "artist_id";
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_SONGS = "numsongs";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
            @Column(value=1, readOnly=true)
            public static final String FIRST_YEAR = "minyear";
            @Column(value=1, readOnly=true)
            public static final String LAST_YEAR = "maxyear";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ALBUM_KEY = "album_key";
            @Deprecated
            @Column(value=3)
            public static final String ALBUM_ART = "album_art";
        }

        public static class Artists
        implements BaseColumns,
        ArtistColumns {
            public static final Uri INTERNAL_CONTENT_URI = Artists.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Artists.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static final String DEFAULT_SORT_ORDER = "artist_key";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("artists").build();
            }

            public static class Albums
            implements BaseColumns,
            AlbumColumns {
                public static Uri getContentUri(String volumeName, long artistId) {
                    return ContentUris.withAppendedId(Artists.getContentUri(volumeName), artistId).buildUpon().appendPath("albums").build();
                }
            }
        }

        public static interface ArtistColumns {
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        @Deprecated
        public static class Playlists
        implements BaseColumns,
        PlaylistsColumns {
            public static final Uri INTERNAL_CONTENT_URI = Playlists.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Playlists.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("playlists").build();
            }

            public static class Members
            implements AudioColumns {
                @Column(value=1)
                public static final String _ID = "_id";
                public static final String CONTENT_DIRECTORY = "members";
                @Column(value=1)
                public static final String AUDIO_ID = "audio_id";
                @Column(value=1)
                public static final String PLAYLIST_ID = "playlist_id";
                @Column(value=1)
                public static final String PLAY_ORDER = "play_order";
                public static final String DEFAULT_SORT_ORDER = "play_order";

                public static Uri getContentUri(String volumeName, long playlistId) {
                    return ContentUris.withAppendedId(Playlists.getContentUri(volumeName), playlistId).buildUpon().appendPath(CONTENT_DIRECTORY).build();
                }

                public static boolean moveItem(ContentResolver res, long playlistId, int from, int to) {
                    Uri uri = Members.getContentUri(MediaStore.VOLUME_EXTERNAL, playlistId).buildUpon().appendEncodedPath(String.valueOf(from)).appendQueryParameter("move", "true").build();
                    ContentValues values = new ContentValues();
                    values.put("play_order", to);
                    return res.update(uri, values, null, null) != 0;
                }
            }
        }

        @Deprecated
        public static interface PlaylistsColumns
        extends MediaColumns {
            @Column(value=3)
            public static final String NAME = "name";
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1, readOnly=true)
            public static final String DATE_ADDED = "date_added";
            @Column(value=1, readOnly=true)
            public static final String DATE_MODIFIED = "date_modified";
        }

        public static class Genres
        implements BaseColumns,
        GenresColumns {
            public static final Uri INTERNAL_CONTENT_URI = Genres.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Genres.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("genres").build();
            }

            public static Uri getContentUriForAudioId(String volumeName, int audioId) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), audioId).buildUpon().appendPath("genres").build();
            }

            public static class Members
            implements AudioColumns {
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "title_key";
                @Column(value=1)
                public static final String AUDIO_ID = "audio_id";
                @Column(value=1)
                public static final String GENRE_ID = "genre_id";

                public static Uri getContentUri(String volumeName, long genreId) {
                    return ContentUris.withAppendedId(Genres.getContentUri(volumeName), genreId).buildUpon().appendPath(CONTENT_DIRECTORY).build();
                }
            }
        }

        public static interface GenresColumns {
            @Column(value=3)
            public static final String NAME = "name";
        }

        public static class Media
        implements AudioColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";
            public static final String DEFAULT_SORT_ORDER = "title_key";
            public static final String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
            public static final String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath(MediaStore.AUTHORITY).build();
            }

            @NonNull
            public static Uri getContentUri(@NonNull String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }

            @Deprecated
            @Nullable
            public static Uri getContentUriForPath(@NonNull String path) {
                return Media.getContentUri(MediaStore.getVolumeName(new File(path)));
            }
        }

        public static interface AudioColumns
        extends MediaColumns {
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String TITLE_KEY = "title_key";
            public static final String DURATION = "duration";
            @Column(value=1)
            public static final String BOOKMARK = "bookmark";
            @Column(value=1, readOnly=true)
            public static final String ARTIST_ID = "artist_id";
            public static final String ARTIST = "artist";
            @Column(value=3, readOnly=true)
            public static final String ALBUM_ARTIST = "album_artist";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            public static final String COMPOSER = "composer";
            @Column(value=1, readOnly=true)
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM = "album";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String ALBUM_KEY = "album_key";
            @Column(value=1, readOnly=true)
            public static final String TRACK = "track";
            @Column(value=1, readOnly=true)
            public static final String YEAR = "year";
            @Column(value=1, readOnly=true)
            public static final String IS_MUSIC = "is_music";
            @Column(value=1, readOnly=true)
            public static final String IS_PODCAST = "is_podcast";
            @Column(value=1, readOnly=true)
            public static final String IS_RINGTONE = "is_ringtone";
            @Column(value=1, readOnly=true)
            public static final String IS_ALARM = "is_alarm";
            @Column(value=1, readOnly=true)
            public static final String IS_NOTIFICATION = "is_notification";
            @Column(value=1, readOnly=true)
            public static final String IS_AUDIOBOOK = "is_audiobook";
            @Column(value=1, readOnly=true)
            public static final String IS_RECORDING = "is_recording";
            @Column(value=1, readOnly=true)
            public static final String GENRE_ID = "genre_id";
            @Column(value=3, readOnly=true)
            public static final String GENRE = "genre";
            @Deprecated
            @Column(value=3, readOnly=true)
            public static final String GENRE_KEY = "genre_key";
            @Column(value=3, readOnly=true)
            public static final String TITLE_RESOURCE_URI = "title_resource_uri";
            @Column(value=1, readOnly=true)
            @FlaggedApi(value="android.provider.media.internal.flags.audio_sample_columns")
            public static final String BITS_PER_SAMPLE = "bits_per_sample";
            @Column(value=1, readOnly=true)
            @FlaggedApi(value="android.provider.media.internal.flags.audio_sample_columns")
            public static final String SAMPLERATE = "samplerate";
        }
    }

    public static class Images {

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            public static final String DEFAULT_SORT_ORDER = "image_id ASC";
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String IMAGE_ID = "image_id";
            @Column(value=1)
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            @Deprecated
            @Column(value=4)
            public static final String THUMB_DATA = "thumb_data";
            @Column(value=1, readOnly=true)
            public static final String WIDTH = "width";
            @Column(value=1, readOnly=true)
            public static final String HEIGHT = "height";

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static Cursor queryMiniThumbnails(ContentResolver cr, Uri uri, int kind, String[] projection) {
                return cr.query(uri, projection, "kind = " + kind, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static Cursor queryMiniThumbnail(ContentResolver cr, long origId, int kind, String[] projection) {
                return cr.query(EXTERNAL_CONTENT_URI, projection, "image_id = " + origId + " AND " + KIND + " = " + kind, null, null);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, origId);
                InternalThumbnails.cancelThumbnail(cr, uri);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, imageId);
                return InternalThumbnails.getThumbnail(cr, uri, kind, options);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId, long groupId) {
                Thumbnails.cancelThumbnailRequest(cr, origId);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long imageId, long groupId, int kind, BitmapFactory.Options options) {
                return Thumbnails.getThumbnail(cr, imageId, kind, options);
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("images").appendPath("thumbnails").build();
            }

            @Deprecated
            @NonNull
            public static Size getKindSize(int kind) {
                return ThumbnailConstants.getKindSize(kind);
            }
        }

        public static class Media
        implements ImageColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static final String DEFAULT_SORT_ORDER = "bucket_display_name";

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection, String where, String orderBy) {
                return cr.query(uri, projection, where, null, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            @Deprecated
            public static Cursor query(ContentResolver cr, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy) {
                return cr.query(uri, projection, selection, selectionArgs, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            @Deprecated
            public static Bitmap getBitmap(ContentResolver cr, Uri url) throws FileNotFoundException, IOException {
                InputStream input = cr.openInputStream(url);
                Bitmap bitmap = BitmapFactory.decodeStream(input);
                input.close();
                return bitmap;
            }

            @Deprecated
            public static String insertImage(ContentResolver cr, String imagePath, String name, String description) throws FileNotFoundException {
                Bitmap source;
                try {
                    source = ImageDecoder.decodeBitmap(ImageDecoder.createSource(new File(imagePath)));
                }
                catch (IOException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
                return Media.insertImage(cr, source, name, description);
            }

            @Deprecated
            public static String insertImage(ContentResolver cr, Bitmap source, String title, String description) {
                if (TextUtils.isEmpty(title)) {
                    title = "Image";
                }
                long now = System_Delegate.currentTimeMillis();
                ContentValues values = new ContentValues();
                values.put("_display_name", title);
                values.put("mime_type", "image/jpeg");
                values.put("date_added", now / 1000L);
                values.put("date_modified", now / 1000L);
                values.put("is_pending", 1);
                Uri uri = cr.insert(EXTERNAL_CONTENT_URI, values);
                try {
                    try (OutputStream out = cr.openOutputStream(uri);){
                        source.compress(Bitmap.CompressFormat.JPEG, 90, out);
                    }
                    values.clear();
                    values.put("is_pending", 0);
                    cr.update(uri, values, null, null);
                    return uri.toString();
                }
                catch (Exception e) {
                    Log.w(MediaStore.TAG, "Failed to insert image", e);
                    cr.delete(uri, null, null);
                    return null;
                }
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("images").appendPath(MediaStore.AUTHORITY).build();
            }

            @NonNull
            public static Uri getContentUri(@NonNull String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }
        }

        public static interface ImageColumns
        extends MediaColumns {
            @Deprecated
            @Column(value=3)
            public static final String PICASA_ID = "picasa_id";
            @Column(value=1)
            public static final String IS_PRIVATE = "isprivate";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LATITUDE = "latitude";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String ORIENTATION = "orientation";
            @Deprecated
            @Column(value=1)
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String GROUP_ID = "group_id";
            @Column(value=3, readOnly=true)
            public static final String DESCRIPTION = "description";
            @Column(value=3, readOnly=true)
            public static final String EXPOSURE_TIME = "exposure_time";
            @Column(value=3, readOnly=true)
            public static final String F_NUMBER = "f_number";
            @Column(value=1, readOnly=true)
            public static final String ISO = "iso";
            @Column(value=1, readOnly=true)
            public static final String SCENE_CAPTURE_TYPE = "scene_capture_type";
        }
    }

    @Deprecated
    private static class InternalThumbnails
    implements BaseColumns {
        private static ArrayMap<Uri, CancellationSignal> sPending = new ArrayMap();

        private InternalThumbnails() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        @Nullable
        static Bitmap getThumbnail(@NonNull ContentResolver cr, @NonNull Uri uri, int kind, @Nullable BitmapFactory.Options opts) {
            Size size = ThumbnailConstants.getKindSize(kind);
            CancellationSignal signal = null;
            Object object = sPending;
            synchronized (object) {
                signal = sPending.get(uri);
                if (signal == null) {
                    signal = new CancellationSignal();
                    sPending.put(uri, signal);
                }
            }
            try {
                object = cr.loadThumbnail(uri, size, signal);
                return object;
            }
            catch (IOException e) {
                Log.w(MediaStore.TAG, "Failed to obtain thumbnail for " + uri, e);
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                ArrayMap<Uri, CancellationSignal> arrayMap = sPending;
                synchronized (arrayMap) {
                    sPending.remove(uri);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        static void cancelThumbnail(@NonNull ContentResolver cr, @NonNull Uri uri) {
            ArrayMap<Uri, CancellationSignal> arrayMap = sPending;
            synchronized (arrayMap) {
                CancellationSignal signal = sPending.get(uri);
                if (signal != null) {
                    signal.cancel();
                }
            }
        }
    }

    public static class Downloads
    implements DownloadColumns {
        @NonNull
        public static final Uri INTERNAL_CONTENT_URI = Downloads.getContentUri("internal");
        @NonNull
        public static final Uri EXTERNAL_CONTENT_URI = Downloads.getContentUri("external");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/download";

        private Downloads() {
        }

        @NonNull
        public static Uri getContentUri(@NonNull String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("downloads").build();
        }

        @NonNull
        public static Uri getContentUri(@NonNull String volumeName, long id2) {
            return ContentUris.withAppendedId(Downloads.getContentUri(volumeName), id2);
        }

        @NonNull
        public static Uri getContentUriForPath(@NonNull String path) {
            return Downloads.getContentUri(MediaStore.getVolumeName(new File(path)));
        }
    }

    public static interface DownloadColumns
    extends MediaColumns {
        @Column(value=3)
        public static final String DOWNLOAD_URI = "download_uri";
        @Column(value=3)
        public static final String REFERER_URI = "referer_uri";
        @Deprecated
        @Column(value=3)
        public static final String DESCRIPTION = "description";
    }

    public static class ThumbnailConstants {
        public static final int MINI_KIND = 1;
        public static final int FULL_SCREEN_KIND = 2;
        public static final int MICRO_KIND = 3;
        public static final Size MINI_SIZE = new Size(512, 384);
        public static final Size FULL_SCREEN_SIZE = new Size(1024, 786);
        public static final Size MICRO_SIZE = new Size(96, 96);

        @NonNull
        public static Size getKindSize(int kind) {
            if (kind == 3) {
                return MICRO_SIZE;
            }
            if (kind == 2) {
                return FULL_SCREEN_SIZE;
            }
            if (kind == 1) {
                return MINI_SIZE;
            }
            throw new IllegalArgumentException("Unsupported kind: " + kind);
        }
    }

    public static class PickerMediaColumns {
        @Column(value=3, readOnly=true)
        public static final String DATA = "_data";
        @Column(value=1, readOnly=true)
        public static final String SIZE = "_size";
        @Column(value=3, readOnly=true)
        public static final String DISPLAY_NAME = "_display_name";
        @Column(value=1, readOnly=true)
        public static final String DATE_TAKEN = "datetaken";
        @Column(value=3, readOnly=true)
        public static final String MIME_TYPE = "mime_type";
        @Column(value=1, readOnly=true)
        public static final String DURATION_MILLIS = "duration";
        @Column(value=1, readOnly=true)
        public static final String WIDTH = "width";
        @Column(value=1, readOnly=true)
        public static final String HEIGHT = "height";
        @Column(value=1, readOnly=true)
        public static final String ORIENTATION = "orientation";

        private PickerMediaColumns() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Match {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PickImagesHighlightAlbum {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PickImagesHighlightType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PickImagesTab {
    }
}

