/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.AppOpsManager;
import android.content.AttributionSourceState;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.permission.IPermissionChecker;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class PermissionCheckerManager {
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_SOFT_DENIED = 1;
    public static final int PERMISSION_HARD_DENIED = 2;
    @NonNull
    private final Context mContext;
    @NonNull
    private final IPermissionChecker mService;
    @NonNull
    private final PackageManager mPackageManager;

    public PermissionCheckerManager(@NonNull Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = IPermissionChecker.Stub.asInterface(ServiceManager.getServiceOrThrow("permission_checker"));
        this.mPackageManager = context.getPackageManager();
    }

    public int checkPermission(@NonNull String permission2, @NonNull AttributionSourceState attributionSource, @Nullable String message, boolean forDataDelivery, boolean startDataDelivery, boolean fromDatasource, int attributedOp) {
        Objects.requireNonNull(permission2);
        Objects.requireNonNull(attributionSource);
        if (AppOpsManager.permissionToOpCode(permission2) == -1) {
            if (fromDatasource) {
                if (attributionSource.next != null && attributionSource.next.length > 0) {
                    return this.mContext.checkPermission(permission2, attributionSource.next[0].pid, attributionSource.next[0].uid) == 0 ? 0 : 2;
                }
            } else {
                return this.mContext.checkPermission(permission2, attributionSource.pid, attributionSource.uid) == 0 ? 0 : 2;
            }
        }
        try {
            return this.mService.checkPermission(permission2, attributionSource, message, forDataDelivery, startDataDelivery, fromDatasource, attributedOp);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return 2;
        }
    }

    public void finishDataDelivery(int op, @NonNull AttributionSourceState attributionSource, boolean fromDatasource) {
        Objects.requireNonNull(attributionSource);
        try {
            this.mService.finishDataDelivery(op, attributionSource, fromDatasource);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public int checkOp(int op, @NonNull AttributionSourceState attributionSource, @Nullable String message, boolean forDataDelivery, boolean startDataDelivery) {
        Objects.requireNonNull(attributionSource);
        try {
            return this.mService.checkOp(op, attributionSource, message, forDataDelivery, startDataDelivery);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return 2;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }
}

