/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.VibratorInfo;
import android.util.Range;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
public class VibratorFrequencyProfile {
    private final VibratorInfo.FrequencyProfile mFrequencyProfile;
    private final SparseArray<Float> mFrequenciesOutputAcceleration;

    public VibratorFrequencyProfile(@NonNull VibratorInfo.FrequencyProfile frequencyProfile) {
        Objects.requireNonNull(frequencyProfile);
        Preconditions.checkArgument(!frequencyProfile.isEmpty(), "Frequency profile must not be empty");
        this.mFrequencyProfile = frequencyProfile;
        this.mFrequenciesOutputAcceleration = VibratorFrequencyProfile.generateFrequencyToAccelerationMap(this.mFrequencyProfile);
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    @NonNull
    public SparseArray<Float> getFrequenciesOutputAcceleration() {
        return this.mFrequenciesOutputAcceleration;
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public float getMaxOutputAccelerationGs() {
        return this.mFrequencyProfile.getMaxOutputAccelerationGs();
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    @Nullable
    public Range<Float> getFrequencyRange(float minOutputAccelerationGs) {
        return this.mFrequencyProfile.getFrequencyRangeHz(minOutputAccelerationGs);
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public float getOutputAccelerationGs(float frequencyHz) {
        return this.mFrequencyProfile.getOutputAccelerationGs(frequencyHz);
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public float getMinFrequencyHz() {
        return this.mFrequencyProfile.getMinFrequencyHz();
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public float getMaxFrequencyHz() {
        return this.mFrequencyProfile.getMaxFrequencyHz();
    }

    private static SparseArray<Float> generateFrequencyToAccelerationMap(VibratorInfo.FrequencyProfile frequencyProfile) {
        float[] frequencies = frequencyProfile.getFrequenciesHz();
        SparseArray<Float> frequencyToAcceleration = new SparseArray<Float>(frequencies.length);
        int lastFrequency = -1;
        for (int i = 0; i < frequencies.length; ++i) {
            int frequency = (int)frequencies[i];
            if (frequency == lastFrequency) continue;
            float acceleration = frequencyProfile.getOutputAccelerationGs(frequency);
            frequencyToAcceleration.put(frequency, Float.valueOf(acceleration));
            lastFrequency = frequency;
        }
        return frequencyToAcceleration;
    }
}

