/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.provider.DocumentsContract;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.Writer;
import java.util.Locale;
import java.util.UUID;

public class StorageVolume
implements Parcelable {
    @UnsupportedAppUsage
    private final String mId;
    @UnsupportedAppUsage
    private final File mPath;
    private final File mInternalPath;
    @UnsupportedAppUsage
    private final String mDescription;
    @UnsupportedAppUsage
    private final boolean mPrimary;
    @UnsupportedAppUsage
    private final boolean mRemovable;
    private final boolean mEmulated;
    private final boolean mExternallyManaged;
    private final boolean mAllowMassStorage;
    private final long mMaxFileSize;
    private final UserHandle mOwner;
    private final UUID mUuid;
    private final String mFsUuid;
    private final String mState;
    public static final String EXTRA_STORAGE_VOLUME = "android.os.storage.extra.STORAGE_VOLUME";
    public static final String EXTRA_DIRECTORY_NAME = "android.os.storage.extra.DIRECTORY_NAME";
    private static final String ACTION_OPEN_EXTERNAL_DIRECTORY = "android.os.storage.action.OPEN_EXTERNAL_DIRECTORY";
    public static final int STORAGE_ID_INVALID = 0;
    public static final int STORAGE_ID_PRIMARY = 65537;
    @NonNull
    public static final Parcelable.Creator<StorageVolume> CREATOR = new Parcelable.Creator<StorageVolume>(){

        @Override
        public StorageVolume createFromParcel(Parcel in) {
            return new StorageVolume(in);
        }

        public StorageVolume[] newArray(int size) {
            return new StorageVolume[size];
        }
    };

    public StorageVolume(String id2, File path, File internalPath, String description, boolean primary, boolean removable, boolean emulated, boolean externallyManaged, boolean allowMassStorage, long maxFileSize, UserHandle owner, UUID uuid, String fsUuid, String state) {
        this.mId = Preconditions.checkNotNull(id2);
        this.mPath = Preconditions.checkNotNull(path);
        this.mInternalPath = Preconditions.checkNotNull(internalPath);
        this.mDescription = Preconditions.checkNotNull(description);
        this.mPrimary = primary;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mExternallyManaged = externallyManaged;
        this.mAllowMassStorage = allowMassStorage;
        this.mMaxFileSize = maxFileSize;
        this.mOwner = Preconditions.checkNotNull(owner);
        this.mUuid = uuid;
        this.mFsUuid = fsUuid;
        this.mState = Preconditions.checkNotNull(state);
    }

    private StorageVolume(Parcel in) {
        this.mId = in.readString8();
        this.mPath = new File(in.readString8());
        this.mInternalPath = new File(in.readString8());
        this.mDescription = in.readString8();
        this.mPrimary = in.readInt() != 0;
        this.mRemovable = in.readInt() != 0;
        this.mEmulated = in.readInt() != 0;
        this.mExternallyManaged = in.readInt() != 0;
        this.mAllowMassStorage = in.readInt() != 0;
        this.mMaxFileSize = in.readLong();
        this.mOwner = in.readParcelable(null, UserHandle.class);
        this.mUuid = in.readInt() != 0 ? StorageManager.convert(in.readString8()) : null;
        this.mFsUuid = in.readString8();
        this.mState = in.readString8();
    }

    @SystemApi
    @NonNull
    public String getId() {
        return this.mId;
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="{@link StorageVolume#getDirectory()}")
    public String getPath() {
        return ((Object)this.mPath).toString();
    }

    public String getInternalPath() {
        return ((Object)this.mInternalPath).toString();
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="{@link StorageVolume#getDirectory()}")
    public File getPathFile() {
        return this.mPath;
    }

    @Nullable
    public File getDirectory() {
        switch (this.mState) {
            case "mounted": 
            case "mounted_ro": {
                return this.mPath;
            }
        }
        return null;
    }

    public String getDescription(Context context) {
        return this.mDescription;
    }

    public boolean isPrimary() {
        return this.mPrimary;
    }

    public boolean isRemovable() {
        return this.mRemovable;
    }

    public boolean isEmulated() {
        return this.mEmulated;
    }

    @SystemApi
    public boolean isExternallyManaged() {
        return this.mExternallyManaged;
    }

    @UnsupportedAppUsage
    public boolean allowMassStorage() {
        return this.mAllowMassStorage;
    }

    @UnsupportedAppUsage
    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    public UserHandle getOwner() {
        return this.mOwner;
    }

    @Nullable
    public UUID getStorageUuid() {
        return this.mUuid;
    }

    @Nullable
    public String getUuid() {
        return this.mFsUuid;
    }

    @Nullable
    public String getMediaStoreVolumeName() {
        if (this.isPrimary()) {
            return "external_primary";
        }
        return this.getNormalizedUuid();
    }

    @Nullable
    public static String normalizeUuid(@Nullable String fsUuid) {
        return fsUuid != null ? fsUuid.toLowerCase(Locale.US) : null;
    }

    @Nullable
    public String getNormalizedUuid() {
        return StorageVolume.normalizeUuid(this.mFsUuid);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getFatVolumeId() {
        if (this.mFsUuid == null || this.mFsUuid.length() != 9) {
            return -1;
        }
        try {
            return (int)Long.parseLong(this.mFsUuid.replace("-", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @UnsupportedAppUsage
    public String getUserLabel() {
        return this.mDescription;
    }

    public String getState() {
        return this.mState;
    }

    @Deprecated
    @Nullable
    public Intent createAccessIntent(String directoryName) {
        if (this.isPrimary() && directoryName == null || directoryName != null && !Environment.isStandardDirectory(directoryName)) {
            return null;
        }
        Intent intent = new Intent(ACTION_OPEN_EXTERNAL_DIRECTORY);
        intent.putExtra(EXTRA_STORAGE_VOLUME, this);
        intent.putExtra(EXTRA_DIRECTORY_NAME, directoryName);
        return intent;
    }

    @NonNull
    public Intent createOpenDocumentTreeIntent() {
        String rootId = this.isEmulated() ? "primary" : this.mFsUuid;
        Uri rootUri = DocumentsContract.buildRootUri("com.android.externalstorage.documents", rootId);
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE").putExtra("android.provider.extra.INITIAL_URI", rootUri).putExtra("android.provider.extra.SHOW_ADVANCED", true);
        return intent;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return ((Object)this.mPath).equals(volume.mPath);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.mPath).hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("StorageVolume: ").append(this.mDescription);
        if (this.mFsUuid != null) {
            buffer.append(" (").append(this.mFsUuid).append(")");
        }
        return buffer.toString();
    }

    public String dump() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter((Writer)writer, "    ", 80));
        return ((Object)writer).toString();
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("StorageVolume:");
        pw.increaseIndent();
        pw.printPair("mId", this.mId);
        pw.printPair("mPath", this.mPath);
        pw.printPair("mInternalPath", this.mInternalPath);
        pw.printPair("mDescription", this.mDescription);
        pw.printPair("mPrimary", this.mPrimary);
        pw.printPair("mRemovable", this.mRemovable);
        pw.printPair("mEmulated", this.mEmulated);
        pw.printPair("mExternallyManaged", this.mExternallyManaged);
        pw.printPair("mAllowMassStorage", this.mAllowMassStorage);
        pw.printPair("mMaxFileSize", this.mMaxFileSize);
        pw.printPair("mOwner", this.mOwner);
        pw.printPair("mFsUuid", this.mFsUuid);
        pw.printPair("mState", this.mState);
        pw.decreaseIndent();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString8(this.mId);
        parcel.writeString8(((Object)this.mPath).toString());
        parcel.writeString8(((Object)this.mInternalPath).toString());
        parcel.writeString8(this.mDescription);
        parcel.writeInt(this.mPrimary ? 1 : 0);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeInt(this.mExternallyManaged ? 1 : 0);
        parcel.writeInt(this.mAllowMassStorage ? 1 : 0);
        parcel.writeLong(this.mMaxFileSize);
        parcel.writeParcelable(this.mOwner, flags);
        if (this.mUuid != null) {
            parcel.writeInt(1);
            parcel.writeString8(StorageManager.convert(this.mUuid));
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString8(this.mFsUuid);
        parcel.writeString8(this.mState);
    }

    public static class Builder {
        private String mId;
        private File mPath;
        private String mDescription;
        private boolean mPrimary;
        private boolean mRemovable;
        private boolean mEmulated;
        private UserHandle mOwner;
        private UUID mStorageUuid;
        private String mUuid;
        private String mState;

        @SuppressLint(value={"StreamFiles"})
        public Builder(@NonNull String id2, @NonNull File path, @NonNull String description, @NonNull UserHandle owner, @NonNull String state) {
            this.mId = id2;
            this.mPath = path;
            this.mDescription = description;
            this.mOwner = owner;
            this.mState = state;
        }

        @NonNull
        public Builder setStorageUuid(@Nullable UUID storageUuid) {
            this.mStorageUuid = storageUuid;
            return this;
        }

        @NonNull
        public Builder setUuid(@Nullable String uuid) {
            this.mUuid = uuid;
            return this;
        }

        @NonNull
        public Builder setPrimary(boolean primary) {
            this.mPrimary = primary;
            return this;
        }

        @NonNull
        public Builder setRemovable(boolean removable) {
            this.mRemovable = removable;
            return this;
        }

        @NonNull
        public Builder setEmulated(boolean emulated) {
            this.mEmulated = emulated;
            return this;
        }

        @NonNull
        public StorageVolume build() {
            return new StorageVolume(this.mId, this.mPath, this.mPath, this.mDescription, this.mPrimary, this.mRemovable, this.mEmulated, false, false, 0L, this.mOwner, this.mStorageUuid, this.mUuid, this.mState);
        }
    }
}

