/*
 * Decompiled with CFR 0.152.
 */
package android.os.instrumentation;

import android.annotation.NonNull;
import android.os.instrumentation.MethodDescriptor;
import com.android.internal.hidden_from_bootclasspath.com.android.art.flags.Flags;
import java.lang.reflect.Executable;

public class MethodDescriptorParser {
    public static Executable parseMethodDescriptor(ClassLoader classLoader, @NonNull MethodDescriptor descriptor) {
        try {
            Class<?> javaClass = classLoader.loadClass(descriptor.fullyQualifiedClassName);
            Class[] parameters = new Class[descriptor.fullyQualifiedParameters.length];
            block22: for (int i = 0; i < descriptor.fullyQualifiedParameters.length; ++i) {
                String typeName = descriptor.fullyQualifiedParameters[i];
                boolean isArrayType = typeName.endsWith("[]");
                if (isArrayType) {
                    typeName = typeName.substring(0, typeName.length() - 2);
                }
                switch (typeName) {
                    case "boolean": {
                        parameters[i] = isArrayType ? Boolean.TYPE.arrayType() : Boolean.TYPE;
                        continue block22;
                    }
                    case "byte": {
                        parameters[i] = isArrayType ? Byte.TYPE.arrayType() : Byte.TYPE;
                        continue block22;
                    }
                    case "char": {
                        parameters[i] = isArrayType ? Character.TYPE.arrayType() : Character.TYPE;
                        continue block22;
                    }
                    case "short": {
                        parameters[i] = isArrayType ? Short.TYPE.arrayType() : Short.TYPE;
                        continue block22;
                    }
                    case "int": {
                        parameters[i] = isArrayType ? Integer.TYPE.arrayType() : Integer.TYPE;
                        continue block22;
                    }
                    case "long": {
                        parameters[i] = isArrayType ? Long.TYPE.arrayType() : Long.TYPE;
                        continue block22;
                    }
                    case "float": {
                        parameters[i] = isArrayType ? Float.TYPE.arrayType() : Float.TYPE;
                        continue block22;
                    }
                    case "double": {
                        parameters[i] = isArrayType ? Double.TYPE.arrayType() : Double.TYPE;
                        continue block22;
                    }
                    default: {
                        parameters[i] = isArrayType ? classLoader.loadClass(typeName).arrayType() : classLoader.loadClass(typeName);
                    }
                }
            }
            if (Flags.executableMethodFileOffsetsV2() && descriptor.methodName.equals("<init>")) {
                return javaClass.getDeclaredConstructor(parameters);
            }
            return javaClass.getDeclaredMethod(descriptor.methodName, parameters);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified method cannot be found. Is this descriptor valid? " + descriptor, e);
        }
    }
}

