/*
 * Decompiled with CFR 0.152.
 */
package android.os.instrumentation;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.instrumentation.ExecutableMethodFileOffsets;

public interface IOffsetCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.os.instrumentation.IOffsetCallback";

    public void onResult(ExecutableMethodFileOffsets var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOffsetCallback {
        static final int TRANSACTION_onResult = 1;

        public Stub() {
            this.attachInterface(this, IOffsetCallback.DESCRIPTOR);
        }

        public static IOffsetCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOffsetCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IOffsetCallback) {
                return (IOffsetCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOffsetCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ExecutableMethodFileOffsets _arg0 = data.readTypedObject(ExecutableMethodFileOffsets.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResult(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IOffsetCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOffsetCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(ExecutableMethodFileOffsets offsets) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOffsetCallback.DESCRIPTOR);
                    _data.writeTypedObject(offsets, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOffsetCallback {
        @Override
        public void onResult(ExecutableMethodFileOffsets offsets) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

