/*
 * Decompiled with CFR 0.152.
 */
package android.os.health;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.power.CpuHeadroomResult;
import android.hardware.power.GpuHeadroomResult;
import android.os.Bundle;
import android.os.CpuHeadroomParams;
import android.os.CpuHeadroomParamsInternal;
import android.os.GpuHeadroomParams;
import android.os.GpuHeadroomParamsInternal;
import android.os.IHintManager;
import android.os.IPowerStatsService;
import android.os.OutcomeReceiver;
import android.os.PowerMonitor;
import android.os.PowerMonitorReadings;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SynchronousResultReceiver;
import android.os.health.HealthStats;
import android.os.health.HealthStatsParceler;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class SystemHealthManager {
    private static final String TAG = "SystemHealthManager";
    @NonNull
    private final IBatteryStats mBatteryStats;
    @Nullable
    private final IPowerStatsService mPowerStats;
    @Nullable
    private final IHintManager mHintManager;
    @Nullable
    private final IHintManager.HintManagerClientData mHintManagerClientData;
    private List<PowerMonitor> mPowerMonitorsInfo;
    private final Object mPowerMonitorsLock = new Object();
    private static final long TAKE_UID_SNAPSHOT_TIMEOUT_MILLIS = 10000L;
    private final PendingUidSnapshots mPendingUidSnapshots = new PendingUidSnapshots();
    private static final Comparator<PowerMonitor> POWER_MONITOR_COMPARATOR = Comparator.comparingInt(pm -> pm.index);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public SystemHealthManager() {
        this(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")), IPowerStatsService.Stub.asInterface(ServiceManager.getService("powerstats")), IHintManager.Stub.asInterface(ServiceManager.getService("performance_hint")));
    }

    public SystemHealthManager(@NonNull IBatteryStats batteryStats, @Nullable IPowerStatsService powerStats, @Nullable IHintManager hintManager) {
        this.mBatteryStats = batteryStats;
        this.mPowerStats = powerStats;
        this.mHintManager = hintManager;
        IHintManager.HintManagerClientData data = null;
        if (this.mHintManager != null) {
            try {
                data = this.mHintManager.getClientData();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get hint manager client data", e);
            }
        }
        this.mHintManagerClientData = data;
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    public float getCpuHeadroom(@Nullable CpuHeadroomParams params) {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isCpuSupported) {
            throw new UnsupportedOperationException();
        }
        if (params != null) {
            if (params.mInternal.tids != null && (params.mInternal.tids.length == 0 || params.mInternal.tids.length > this.mHintManagerClientData.maxCpuHeadroomThreads)) {
                throw new IllegalArgumentException("Invalid number of TIDs: " + params.mInternal.tids.length);
            }
            if (params.mInternal.calculationWindowMillis < this.mHintManagerClientData.supportInfo.headroom.cpuMinCalculationWindowMillis || params.mInternal.calculationWindowMillis > this.mHintManagerClientData.supportInfo.headroom.cpuMaxCalculationWindowMillis) {
                throw new IllegalArgumentException("Invalid calculation window: " + params.mInternal.calculationWindowMillis + ", expect range: [" + this.mHintManagerClientData.supportInfo.headroom.cpuMinCalculationWindowMillis + ", " + this.mHintManagerClientData.supportInfo.headroom.cpuMaxCalculationWindowMillis + "]");
            }
        }
        try {
            CpuHeadroomResult ret = this.mHintManager.getCpuHeadroom(params != null ? params.mInternal : new CpuHeadroomParamsInternal());
            if (ret == null || ret.getTag() != 0) {
                return Float.NaN;
            }
            return ret.getGlobalHeadroom();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    public int getMaxCpuHeadroomTidsSize() {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isCpuSupported) {
            throw new UnsupportedOperationException();
        }
        return this.mHintManagerClientData.maxCpuHeadroomThreads;
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    public float getGpuHeadroom(@Nullable GpuHeadroomParams params) {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isGpuSupported) {
            throw new UnsupportedOperationException();
        }
        if (params != null && (params.mInternal.calculationWindowMillis < this.mHintManagerClientData.supportInfo.headroom.gpuMinCalculationWindowMillis || params.mInternal.calculationWindowMillis > this.mHintManagerClientData.supportInfo.headroom.gpuMaxCalculationWindowMillis)) {
            throw new IllegalArgumentException("Invalid calculation window: " + params.mInternal.calculationWindowMillis + ", expect range: [" + this.mHintManagerClientData.supportInfo.headroom.gpuMinCalculationWindowMillis + ", " + this.mHintManagerClientData.supportInfo.headroom.gpuMaxCalculationWindowMillis + "]");
        }
        try {
            GpuHeadroomResult ret = this.mHintManager.getGpuHeadroom(params != null ? params.mInternal : new GpuHeadroomParamsInternal());
            if (ret == null || ret.getTag() != 0) {
                return Float.NaN;
            }
            return ret.getGlobalHeadroom();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    @NonNull
    public Pair<Integer, Integer> getCpuHeadroomCalculationWindowRange() {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isCpuSupported) {
            throw new UnsupportedOperationException();
        }
        return new Pair<Integer, Integer>(this.mHintManagerClientData.supportInfo.headroom.cpuMinCalculationWindowMillis, this.mHintManagerClientData.supportInfo.headroom.cpuMaxCalculationWindowMillis);
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    @NonNull
    public Pair<Integer, Integer> getGpuHeadroomCalculationWindowRange() {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isGpuSupported) {
            throw new UnsupportedOperationException();
        }
        return new Pair<Integer, Integer>(this.mHintManagerClientData.supportInfo.headroom.gpuMinCalculationWindowMillis, this.mHintManagerClientData.supportInfo.headroom.gpuMaxCalculationWindowMillis);
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    public long getCpuHeadroomMinIntervalMillis() {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isCpuSupported) {
            throw new UnsupportedOperationException();
        }
        return this.mHintManagerClientData.supportInfo.headroom.cpuMinIntervalMillis;
    }

    @FlaggedApi(value="android.os.cpu_gpu_headrooms")
    public long getGpuHeadroomMinIntervalMillis() {
        if (this.mHintManager == null || this.mHintManagerClientData == null || !this.mHintManagerClientData.supportInfo.headroom.isGpuSupported) {
            throw new UnsupportedOperationException();
        }
        return this.mHintManagerClientData.supportInfo.headroom.gpuMinIntervalMillis;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static SystemHealthManager from(Context context) {
        return (SystemHealthManager)context.getSystemService("systemhealth");
    }

    public HealthStats takeUidSnapshot(int uid) {
        HealthStats[] result = this.takeUidSnapshots(new int[]{uid});
        if (result != null && result.length >= 1) {
            return result[0];
        }
        return null;
    }

    public HealthStats takeMyUidSnapshot() {
        return this.takeUidSnapshot(Process.myUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthStats[] takeUidSnapshots(int[] uids) {
        SynchronousResultReceiver.Result result;
        SynchronousResultReceiver resultReceiver;
        PendingUidSnapshots pendingUidSnapshots = this.mPendingUidSnapshots;
        synchronized (pendingUidSnapshots) {
            if (Arrays.equals(this.mPendingUidSnapshots.uids, uids)) {
                resultReceiver = this.mPendingUidSnapshots.resultReceiver;
            } else {
                this.mPendingUidSnapshots.uids = Arrays.copyOf(uids, uids.length);
                this.mPendingUidSnapshots.resultReceiver = resultReceiver = new SynchronousResultReceiver("takeUidSnapshots");
                try {
                    this.mBatteryStats.takeUidSnapshotsAsync(uids, resultReceiver);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        }
        try {
            result = resultReceiver.awaitResult(10000L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        finally {
            PendingUidSnapshots pendingUidSnapshots2 = this.mPendingUidSnapshots;
            synchronized (pendingUidSnapshots2) {
                if (this.mPendingUidSnapshots.resultReceiver == resultReceiver) {
                    this.mPendingUidSnapshots.uids = null;
                    this.mPendingUidSnapshots.resultReceiver = null;
                }
            }
        }
        switch (result.resultCode) {
            case 0: {
                HealthStatsParceler[] parcelers;
                HealthStats[] results = new HealthStats[uids.length];
                if (result.bundle != null && (parcelers = result.bundle.getParcelableArray("uid_snapshots", HealthStatsParceler.class)) != null && parcelers.length == uids.length) {
                    for (int i = 0; i < parcelers.length; ++i) {
                        results[i] = parcelers[i].getHealthStats();
                    }
                }
                return results;
            }
            case 2: {
                throw new SecurityException(result.bundle != null ? result.bundle.getString("exception") : null);
            }
            case 1: {
                throw new RuntimeException(result.bundle != null ? result.bundle.getString("exception") : null);
            }
        }
        throw new RuntimeException("Error code: " + result.resultCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.server.power.optimization.power_monitor_api")
    public void getSupportedPowerMonitors(final @Nullable Executor executor, final @NonNull Consumer<List<PowerMonitor>> onResult) {
        List<PowerMonitor> result;
        Object object = this.mPowerMonitorsLock;
        synchronized (object) {
            result = this.mPowerMonitorsInfo != null ? this.mPowerMonitorsInfo : (this.mPowerStats == null ? (this.mPowerMonitorsInfo = List.of()) : null);
        }
        if (result != null) {
            if (executor != null) {
                executor.execute(() -> onResult.accept(result));
            } else {
                onResult.accept(result);
            }
            return;
        }
        try {
            this.mPowerStats.getSupportedPowerMonitors(new ResultReceiver(null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    PowerMonitor[] array2 = resultData.getParcelableArray("monitors", PowerMonitor.class);
                    List<Object> result = array2 != null ? Arrays.asList(array2) : List.of();
                    Object object = SystemHealthManager.this.mPowerMonitorsLock;
                    synchronized (object) {
                        SystemHealthManager.this.mPowerMonitorsInfo = result;
                    }
                    if (executor != null) {
                        executor.execute(() -> onResult.accept(result));
                    } else {
                        onResult.accept(result);
                    }
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.server.power.optimization.power_monitor_api")
    public void getPowerMonitorReadings(@NonNull List<PowerMonitor> powerMonitors, final @Nullable Executor executor, final @NonNull OutcomeReceiver<PowerMonitorReadings, RuntimeException> onResult) {
        if (this.mPowerStats == null) {
            IllegalArgumentException error = new IllegalArgumentException("Unsupported power monitor");
            if (executor != null) {
                executor.execute(() -> onResult.onError(error));
            } else {
                onResult.onError(error);
            }
            return;
        }
        final PowerMonitor[] powerMonitorsArray = powerMonitors.toArray(new PowerMonitor[powerMonitors.size()]);
        Arrays.sort(powerMonitorsArray, POWER_MONITOR_COMPARATOR);
        int[] indices = new int[powerMonitors.size()];
        for (int i = 0; i < powerMonitors.size(); ++i) {
            indices[i] = powerMonitorsArray[i].index;
        }
        try {
            this.mPowerStats.getPowerMonitorReadings(indices, new ResultReceiver(this, null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        PowerMonitorReadings result = new PowerMonitorReadings(powerMonitorsArray, resultData.getLongArray("energy"), resultData.getLongArray("timestamps"), resultData.getInt("granularity"));
                        if (executor != null) {
                            executor.execute(() -> onResult.onResult(result));
                        } else {
                            onResult.onResult(result);
                        }
                    } else {
                        RuntimeException error = resultCode == 1 ? new IllegalArgumentException("Unsupported power monitor") : new IllegalStateException("Unrecognized result code " + resultCode);
                        if (executor != null) {
                            executor.execute(() -> onResult.onError(error));
                        } else {
                            onResult.onError(error);
                        }
                    }
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class PendingUidSnapshots {
        public int[] uids;
        public SynchronousResultReceiver resultReceiver;

        private PendingUidSnapshots() {
        }
    }
}

