/*
 * Decompiled with CFR 0.152.
 */
package android.os.flagging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os._Original_Build;
import android.os.flagging.AconfigStorageReadException;
import android.os.flagging.PlatformAconfigPackage;
import android.provider.internal.aconfig.storage.AconfigStorageException;
import android.provider.internal.aconfig.storage.FlagTable;
import android.provider.internal.aconfig.storage.FlagValueList;
import android.provider.internal.aconfig.storage.PackageTable;
import android.provider.internal.aconfig.storage.TableUtils;
import android.provider.internal.modules.utils.ravenwood.RavenwoodHelper;
import android.provider.x.android.provider.flags.Flags;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;

@FlaggedApi(value="android.provider.flags.new_storage_public_api")
@RavenwoodKeepWholeClass
public class AconfigPackage {
    private static final String TAG = "AconfigPackage";
    private static final String MAP_PATH = AconfigPackage.getStorageRootPath() + "/metadata/aconfig/maps/";
    private static final String BOOT_PATH = AconfigPackage.getStorageRootPath() + "/metadata/aconfig/boot/";
    private static final String PMAP_FILE_EXT = ".package.map";
    private static final boolean READ_PLATFORM_FROM_PLATFORM_API = AconfigPackage.getReadPlatformFromPlatformApi();
    private FlagTable mFlagTable;
    private FlagValueList mFlagValueList;
    private int mPackageBooleanStartOffset = -1;
    private int mPackageId = -1;
    private PlatformAconfigPackage mPlatformAconfigPackage = null;
    static final Map<String, TableUtils.StorageFilesBundle> sStorageFilesCache = new HashMap<String, TableUtils.StorageFilesBundle>();

    @RavenwoodReplace
    private static String getStorageRootPath() {
        return "";
    }

    private static String getStorageRootPath$ravenwood() {
        return RavenwoodHelper.getRavenwoodAconfigStoragePath();
    }

    @RavenwoodReplace
    private static boolean getReadPlatformFromPlatformApi() {
        return Flags.readPlatformFromPlatformApi() && _Original_Build.VERSION.SDK_INT > 35;
    }

    private static boolean getReadPlatformFromPlatformApi$ravenwood() {
        return false;
    }

    private AconfigPackage() {
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    @NonNull
    public static AconfigPackage load(@NonNull String packageName) {
        try {
            TableUtils.StorageFilesBundle files;
            AconfigPackage aconfigPackage = new AconfigPackage();
            if (READ_PLATFORM_FROM_PLATFORM_API) {
                aconfigPackage.mPlatformAconfigPackage = PlatformAconfigPackage.load(packageName);
                if (aconfigPackage.mPlatformAconfigPackage != null) {
                    return aconfigPackage;
                }
            }
            if ((files = sStorageFilesCache.get(packageName)) == null) {
                throw new AconfigStorageReadException(2, "package " + packageName + " cannot be found on the device");
            }
            PackageTable.Node pNode = files.packageTable.get(packageName);
            aconfigPackage.mFlagTable = files.flagTable;
            aconfigPackage.mFlagValueList = files.flagValueList;
            aconfigPackage.mPackageBooleanStartOffset = pNode.getBooleanStartIndex();
            aconfigPackage.mPackageId = pNode.getPackageId();
            return aconfigPackage;
        }
        catch (AconfigStorageReadException e) {
            throw e;
        }
        catch (AconfigStorageException e) {
            throw new AconfigStorageReadException(e.getErrorCode(), "Fail to create AconfigPackage", e);
        }
        catch (Exception e) {
            throw new AconfigStorageReadException(0, "Fail to create AconfigPackage", e);
        }
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public boolean getBooleanFlagValue(@NonNull String flagName, boolean defaultValue) {
        if (READ_PLATFORM_FROM_PLATFORM_API && this.mPlatformAconfigPackage != null) {
            return this.mPlatformAconfigPackage.getBooleanFlagValue(flagName, defaultValue);
        }
        FlagTable.Node fNode = this.mFlagTable.get(this.mPackageId, flagName);
        if (fNode == null) {
            return defaultValue;
        }
        return this.mFlagValueList.getBoolean(fNode.getFlagIndex() + this.mPackageBooleanStartOffset);
    }

    private static MappedByteBuffer mapStorageFile(String file) {
        MappedByteBuffer mappedByteBuffer;
        FileChannel channel = null;
        try {
            channel = FileChannel.open(Paths.get(file, new String[0]), StandardOpenOption.READ);
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        catch (Exception e) {
            try {
                throw new AconfigStorageReadException(4, "Fail to mmap storage", e);
            }
            catch (Throwable throwable) {
                AconfigPackage.quietlyDispose(channel);
                throw throwable;
            }
        }
        AconfigPackage.quietlyDispose(channel);
        return mappedByteBuffer;
    }

    private static void quietlyDispose(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        File mapDir = new File(MAP_PATH);
        String[] mapFiles = mapDir.list();
        if (mapFiles != null) {
            for (String file : mapFiles) {
                if (!file.endsWith(PMAP_FILE_EXT) || READ_PLATFORM_FROM_PLATFORM_API && PlatformAconfigPackage.PLATFORM_PACKAGE_MAP_FILES.contains(file)) continue;
                try {
                    PackageTable pTable = PackageTable.fromBytes(AconfigPackage.mapStorageFile(MAP_PATH + file));
                    String container = pTable.getHeader().getContainer();
                    FlagTable fTable = FlagTable.fromBytes(AconfigPackage.mapStorageFile(MAP_PATH + container + ".flag.map"));
                    FlagValueList fValueList = FlagValueList.fromBytes(AconfigPackage.mapStorageFile(BOOT_PATH + container + ".val"));
                    TableUtils.StorageFilesBundle files = new TableUtils.StorageFilesBundle(pTable, fTable, fValueList);
                    for (String packageName : pTable.getPackageList()) {
                        Log.i(TAG, packageName + " is mapped to " + container);
                        sStorageFilesCache.put(packageName, files);
                    }
                }
                catch (Exception e) {
                    Log.w(TAG, "failed to map some package from " + file + ": " + ((Object)e).toString());
                }
            }
        }
    }
}

