/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.media.AudioAttributes;
import android.os.CancellationSignal;
import android.os.Process;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.VendorVibrationSession;
import android.os.vibrator.VibrationConfig;
import android.os.vibrator.VibratorEnvelopeEffectInfo;
import android.os.vibrator.VibratorFrequencyProfile;
import android.os.vibrator.VibratorFrequencyProfileLegacy;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public abstract class Vibrator {
    private static final String TAG = "Vibrator";
    public static final int VIBRATION_INTENSITY_OFF = 0;
    public static final int VIBRATION_INTENSITY_LOW = 1;
    public static final int VIBRATION_INTENSITY_MEDIUM = 2;
    public static final int VIBRATION_INTENSITY_HIGH = 3;
    public static final int VIBRATION_EFFECT_SUPPORT_UNKNOWN = 0;
    public static final int VIBRATION_EFFECT_SUPPORT_YES = 1;
    public static final int VIBRATION_EFFECT_SUPPORT_NO = 2;
    private final String mPackageName;
    @Nullable
    private final Resources mResources;
    @Nullable
    private volatile VibrationConfig mVibrationConfig;
    private VibratorFrequencyProfile mVibratorFrequencyProfile;
    private VibratorEnvelopeEffectInfo mVibratorEnvelopeEffectInfo;

    @UnsupportedAppUsage
    public Vibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
        this.mResources = null;
    }

    protected Vibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
        this.mResources = context.getResources();
    }

    public VibratorInfo getInfo() {
        return VibratorInfo.EMPTY_VIBRATOR_INFO;
    }

    private VibrationConfig getConfig() {
        if (this.mVibrationConfig == null) {
            Resources resources = this.mResources;
            if (resources == null) {
                ContextImpl ctx = ActivityThread.currentActivityThread().getSystemContext();
                resources = ctx != null ? ((Context)ctx).getResources() : null;
            }
            this.mVibrationConfig = new VibrationConfig(resources);
        }
        return this.mVibrationConfig;
    }

    public int getDefaultVibrationIntensity(int usage) {
        return this.getConfig().getDefaultVibrationIntensity(usage);
    }

    public int getId() {
        return this.getInfo().getId();
    }

    public abstract boolean hasVibrator();

    public abstract boolean hasAmplitudeControl();

    public boolean hasFrequencyControl() {
        return this.getInfo().hasFrequencyControl();
    }

    public boolean areVibrationFeaturesSupported(@NonNull VibrationEffect effect) {
        return this.getInfo().areVibrationFeaturesSupported(effect);
    }

    @SystemApi
    @FlaggedApi(value="android.os.vibrator.vendor_vibration_effects")
    public boolean areVendorEffectsSupported() {
        return this.getInfo().hasCapability(2048L);
    }

    @SystemApi
    @FlaggedApi(value="android.os.vibrator.vendor_vibration_effects")
    public boolean areVendorSessionsSupported() {
        return false;
    }

    public boolean hasExternalControl() {
        return this.getInfo().hasCapability(8L);
    }

    public float getResonantFrequency() {
        return this.getInfo().getResonantFrequencyHz();
    }

    public float getQFactor() {
        return this.getInfo().getQFactor();
    }

    @SuppressLint(value={"UnflaggedApi"})
    @Nullable
    public VibratorFrequencyProfileLegacy getFrequencyProfileLegacy() {
        VibratorInfo.FrequencyProfileLegacy frequencyProfile = this.getInfo().getFrequencyProfileLegacy();
        if (frequencyProfile.isEmpty()) {
            return null;
        }
        return new VibratorFrequencyProfileLegacy(frequencyProfile);
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    @Nullable
    public VibratorFrequencyProfile getFrequencyProfile() {
        VibratorInfo.FrequencyProfile frequencyProfile = this.getInfo().getFrequencyProfile();
        if (frequencyProfile.isEmpty()) {
            return null;
        }
        if (this.mVibratorFrequencyProfile == null) {
            this.mVibratorFrequencyProfile = new VibratorFrequencyProfile(frequencyProfile);
        }
        return this.mVibratorFrequencyProfile;
    }

    public float getHapticChannelMaximumAmplitude() {
        return this.getConfig().getHapticChannelMaximumAmplitude();
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public boolean areEnvelopeEffectsSupported() {
        return this.getInfo().areEnvelopeEffectsSupported();
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    @NonNull
    public VibratorEnvelopeEffectInfo getEnvelopeEffectInfo() {
        if (this.mVibratorEnvelopeEffectInfo == null) {
            this.mVibratorEnvelopeEffectInfo = new VibratorEnvelopeEffectInfo(this.getInfo().getMaxEnvelopeEffectSize(), this.getInfo().getMinEnvelopeEffectControlPointDurationMillis(), this.getInfo().getMaxEnvelopeEffectControlPointDurationMillis());
        }
        return this.mVibratorEnvelopeEffectInfo;
    }

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int alwaysOnId, @Nullable VibrationEffect effect, @Nullable VibrationAttributes attributes) {
        return this.setAlwaysOnEffect(Process.myUid(), this.mPackageName, alwaysOnId, effect, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, @Nullable VibrationEffect effect, @Nullable VibrationAttributes attributes) {
        Log.w(TAG, "Always-on effects aren't supported");
        return false;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long milliseconds) {
        this.vibrate(milliseconds, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long milliseconds, AudioAttributes attributes) {
        try {
            VibrationEffect effect = VibrationEffect.createOneShot(milliseconds, -1);
            this.vibrate(effect, attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(pattern, repeat, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long[] pattern, int repeat, AudioAttributes attributes) {
        if (repeat < -1 || repeat >= pattern.length) {
            Log.e(TAG, "vibrate called with repeat index out of bounds (pattern.length=" + pattern.length + ", index=" + repeat + ")");
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.vibrate(VibrationEffect.createWaveform(pattern, repeat), attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe) {
        this.vibrate(vibe, new VibrationAttributes.Builder().build());
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe, AudioAttributes attributes) {
        this.vibrate(vibe, attributes == null ? new VibrationAttributes.Builder().build() : new VibrationAttributes.Builder(attributes).build());
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(@NonNull VibrationEffect vibe, @NonNull VibrationAttributes attributes) {
        this.vibrate(vibe, attributes, null);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(@NonNull VibrationEffect vibe, @NonNull VibrationAttributes attributes, String reason) {
        this.vibrate(Process.myUid(), this.mPackageName, vibe, reason, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void vibrate(int var1, String var2, @NonNull VibrationEffect var3, String var4, @NonNull VibrationAttributes var5);

    public void performHapticFeedback(int constant, int usage, String reason, int flags, int privFlags) {
        Log.w(TAG, "performHapticFeedback is not supported");
    }

    public void performHapticFeedbackForInputDevice(int constant, int inputDeviceId, int inputSource, String reason, int flags, int privFlags) {
        Log.w(TAG, "performHapticFeedbackForInputDevice is not supported");
    }

    @NonNull
    public int[] areEffectsSupported(int ... effectIds) {
        VibratorInfo info = this.getInfo();
        int[] supported = new int[effectIds.length];
        for (int i = 0; i < effectIds.length; ++i) {
            supported[i] = info.isEffectSupported(effectIds[i]);
        }
        return supported;
    }

    public int areAllEffectsSupported(int ... effectIds) {
        VibratorInfo info = this.getInfo();
        int allSupported = 1;
        block4: for (int effectId : effectIds) {
            switch (info.isEffectSupported(effectId)) {
                case 2: {
                    return 2;
                }
                case 1: {
                    continue block4;
                }
                default: {
                    allSupported = 0;
                }
            }
        }
        return allSupported;
    }

    @NonNull
    public boolean[] arePrimitivesSupported(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        boolean[] supported = new boolean[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            supported[i] = info.isPrimitiveSupported(primitiveIds[i]);
        }
        return supported;
    }

    public boolean areAllPrimitivesSupported(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        for (int primitiveId : primitiveIds) {
            if (info.isPrimitiveSupported(primitiveId)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public int[] getPrimitiveDurations(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        int[] durations = new int[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            durations[i] = info.getPrimitiveDuration(primitiveIds[i]);
        }
        return durations;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel();

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel(int var1);

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public boolean isVibrating() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void addVibratorStateListener(@NonNull OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void addVibratorStateListener(@NonNull Executor executor, @NonNull OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void removeVibratorStateListener(@NonNull OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    @FlaggedApi(value="android.os.vibrator.vendor_vibration_effects")
    @RequiresPermission(allOf={"android.permission.VIBRATE", "android.permission.VIBRATE_VENDOR_EFFECTS", "android.permission.START_VIBRATION_SESSIONS"})
    public void startVendorSession(@NonNull VibrationAttributes attrs, @Nullable String reason, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull VendorVibrationSession.Callback callback) {
        Log.w(TAG, "startVendorSession is not supported");
        executor.execute(() -> callback.onFinished(3));
    }

    @SystemApi
    public static interface OnVibratorStateChangedListener {
        public void onVibratorStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationIntensity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationEffectSupport {
    }
}

