/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.accounts.AccountManager;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.PropertyInvalidatedCache;
import android.app.admin.DevicePolicyManager;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.UserInfo;
import android.content.pm.UserProperties;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.IUserRestrictionsListener;
import android.os.NewUserRequest;
import android.os.NewUserResponse;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManagerCache;
import android.provider.Settings;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.util.AndroidException;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import com.android.internal.hidden_from_bootclasspath.android.multiuser.Flags;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@RavenwoodKeepPartialClass
public class UserManager {
    private static final String TAG = "UserManager";
    @UnsupportedAppUsage
    private final IUserManager mService;
    private final Context mContext;
    private final int mUserId;
    private String mProfileTypeOfProcessUser = null;
    private static Boolean sIsHeadlessSystemUser = null;
    private final Object mIpcDataCache = new UserManagerCache();
    public static final int MAX_USER_NAME_LENGTH = 100;
    public static final int MAX_ACCOUNT_STRING_LENGTH = 500;
    public static final int MAX_ACCOUNT_OPTIONS_LENGTH = 1000;
    @SystemApi
    public static final String USER_TYPE_FULL_SYSTEM = "android.os.usertype.full.SYSTEM";
    @SystemApi
    public static final String USER_TYPE_FULL_SECONDARY = "android.os.usertype.full.SECONDARY";
    @SystemApi
    public static final String USER_TYPE_FULL_GUEST = "android.os.usertype.full.GUEST";
    public static final String USER_TYPE_FULL_DEMO = "android.os.usertype.full.DEMO";
    public static final String USER_TYPE_FULL_RESTRICTED = "android.os.usertype.full.RESTRICTED";
    @FlaggedApi(value="android.os.allow_private_profile")
    public static final String USER_TYPE_PROFILE_MANAGED = "android.os.usertype.profile.MANAGED";
    @FlaggedApi(value="android.os.allow_private_profile")
    public static final String USER_TYPE_PROFILE_CLONE = "android.os.usertype.profile.CLONE";
    @FlaggedApi(value="android.os.allow_private_profile")
    public static final String USER_TYPE_PROFILE_PRIVATE = "android.os.usertype.profile.PRIVATE";
    public static final String USER_TYPE_PROFILE_TEST = "android.os.usertype.profile.TEST";
    public static final String USER_TYPE_PROFILE_COMMUNAL = "android.os.usertype.profile.COMMUNAL";
    @SystemApi
    @FlaggedApi(value="android.multiuser.allow_supervising_profile")
    public static final String USER_TYPE_PROFILE_SUPERVISING = "android.os.usertype.profile.SUPERVISING";
    @SystemApi
    public static final String USER_TYPE_SYSTEM_HEADLESS = "android.os.usertype.system.HEADLESS";
    public static final int QUIET_MODE_DISABLE_ONLY_IF_CREDENTIAL_NOT_REQUIRED = 1;
    public static final int QUIET_MODE_DISABLE_DONT_ASK_CREDENTIAL = 2;
    @SystemApi
    public static final int RESTRICTION_NOT_SET = 0;
    @SystemApi
    public static final int RESTRICTION_SOURCE_SYSTEM = 1;
    @SystemApi
    public static final int RESTRICTION_SOURCE_DEVICE_OWNER = 2;
    @SystemApi
    public static final int RESTRICTION_SOURCE_PROFILE_OWNER = 4;
    public static final String DISALLOW_MODIFY_ACCOUNTS = "no_modify_accounts";
    public static final String DISALLOW_CONFIG_WIFI = "no_config_wifi";
    public static final String DISALLOW_CHANGE_WIFI_STATE = "no_change_wifi_state";
    public static final String DISALLOW_WIFI_TETHERING = "no_wifi_tethering";
    public static final String DISALLOW_GRANT_ADMIN = "no_grant_admin";
    public static final String DISALLOW_SHARING_ADMIN_CONFIGURED_WIFI = "no_sharing_admin_configured_wifi";
    public static final String DISALLOW_WIFI_DIRECT = "no_wifi_direct";
    public static final String DISALLOW_ADD_WIFI_CONFIG = "no_add_wifi_config";
    public static final String DISALLOW_CONFIG_LOCALE = "no_config_locale";
    public static final String DISALLOW_INSTALL_APPS = "no_install_apps";
    public static final String DISALLOW_UNINSTALL_APPS = "no_uninstall_apps";
    public static final String DISALLOW_SHARE_LOCATION = "no_share_location";
    public static final String DISALLOW_AIRPLANE_MODE = "no_airplane_mode";
    public static final String DISALLOW_CONFIG_BRIGHTNESS = "no_config_brightness";
    public static final String DISALLOW_AMBIENT_DISPLAY = "no_ambient_display";
    public static final String DISALLOW_CONFIG_SCREEN_TIMEOUT = "no_config_screen_timeout";
    public static final String DISALLOW_INSTALL_UNKNOWN_SOURCES = "no_install_unknown_sources";
    public static final String DISALLOW_INSTALL_UNKNOWN_SOURCES_GLOBALLY = "no_install_unknown_sources_globally";
    public static final String DISALLOW_CONFIG_BLUETOOTH = "no_config_bluetooth";
    public static final String DISALLOW_BLUETOOTH = "no_bluetooth";
    public static final String DISALLOW_BLUETOOTH_SHARING = "no_bluetooth_sharing";
    public static final String DISALLOW_USB_FILE_TRANSFER = "no_usb_file_transfer";
    public static final String DISALLOW_CONFIG_CREDENTIALS = "no_config_credentials";
    public static final String DISALLOW_REMOVE_USER = "no_remove_user";
    @Deprecated
    public static final String DISALLOW_REMOVE_MANAGED_PROFILE = "no_remove_managed_profile";
    public static final String DISALLOW_DEBUGGING_FEATURES = "no_debugging_features";
    public static final String DISALLOW_CONFIG_VPN = "no_config_vpn";
    public static final String DISALLOW_CONFIG_LOCATION = "no_config_location";
    public static final String DISALLOW_CONFIG_DATE_TIME = "no_config_date_time";
    public static final String DISALLOW_CONFIG_TETHERING = "no_config_tethering";
    public static final String DISALLOW_NETWORK_RESET = "no_network_reset";
    public static final String DISALLOW_FACTORY_RESET = "no_factory_reset";
    public static final String DISALLOW_ADD_USER = "no_add_user";
    @Deprecated
    public static final String DISALLOW_ADD_MANAGED_PROFILE = "no_add_managed_profile";
    public static final String DISALLOW_ADD_CLONE_PROFILE = "no_add_clone_profile";
    @FlaggedApi(value="android.os.allow_private_profile")
    public static final String DISALLOW_ADD_PRIVATE_PROFILE = "no_add_private_profile";
    public static final String ENSURE_VERIFY_APPS = "ensure_verify_apps";
    public static final String DISALLOW_CONFIG_CELL_BROADCASTS = "no_config_cell_broadcasts";
    public static final String DISALLOW_CONFIG_MOBILE_NETWORKS = "no_config_mobile_networks";
    public static final String DISALLOW_APPS_CONTROL = "no_control_apps";
    public static final String DISALLOW_MOUNT_PHYSICAL_MEDIA = "no_physical_media";
    public static final String DISALLOW_UNMUTE_MICROPHONE = "no_unmute_microphone";
    public static final String DISALLOW_ADJUST_VOLUME = "no_adjust_volume";
    public static final String DISALLOW_OUTGOING_CALLS = "no_outgoing_calls";
    public static final String DISALLOW_SMS = "no_sms";
    public static final String DISALLOW_FUN = "no_fun";
    public static final String DISALLOW_CREATE_WINDOWS = "no_create_windows";
    public static final String DISALLOW_SYSTEM_ERROR_DIALOGS = "no_system_error_dialogs";
    public static final String DISALLOW_CROSS_PROFILE_COPY_PASTE = "no_cross_profile_copy_paste";
    public static final String DISALLOW_OUTGOING_BEAM = "no_outgoing_beam";
    public static final String DISALLOW_WALLPAPER = "no_wallpaper";
    public static final String DISALLOW_SET_WALLPAPER = "no_set_wallpaper";
    public static final String DISALLOW_SAFE_BOOT = "no_safe_boot";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String DISALLOW_RECORD_AUDIO = "no_record_audio";
    @SystemApi
    public static final String DISALLOW_RUN_IN_BACKGROUND = "no_run_in_background";
    public static final String DISALLOW_CAMERA = "no_camera";
    public static final String DISALLOW_UNMUTE_DEVICE = "disallow_unmute_device";
    public static final String DISALLOW_DATA_ROAMING = "no_data_roaming";
    public static final String DISALLOW_SET_USER_ICON = "no_set_user_icon";
    @Deprecated
    @SystemApi
    public static final String DISALLOW_OEM_UNLOCK = "no_oem_unlock";
    public static final String DISALLOW_UNIFIED_PASSWORD = "no_unified_password";
    public static final String ALLOW_PARENT_PROFILE_APP_LINKING = "allow_parent_profile_app_linking";
    public static final String DISALLOW_AUTOFILL = "no_autofill";
    public static final String DISALLOW_CONTENT_CAPTURE = "no_content_capture";
    public static final String DISALLOW_CONTENT_SUGGESTIONS = "no_content_suggestions";
    public static final String DISALLOW_USER_SWITCH = "no_user_switch";
    public static final String DISALLOW_SHARE_INTO_MANAGED_PROFILE = "no_sharing_into_profile";
    public static final String DISALLOW_PRINTING = "no_printing";
    public static final String DISALLOW_CONFIG_PRIVATE_DNS = "disallow_config_private_dns";
    public static final String DISALLOW_MICROPHONE_TOGGLE = "disallow_microphone_toggle";
    public static final String DISALLOW_CAMERA_TOGGLE = "disallow_camera_toggle";
    public static final String DISALLOW_BIOMETRIC = "disallow_biometric";
    public static final String DISALLOW_CONFIG_DEFAULT_APPS = "disallow_config_default_apps";
    public static final String KEY_RESTRICTIONS_PENDING = "restrictions_pending";
    public static final String DISALLOW_CELLULAR_2G = "no_cellular_2g";
    public static final String DISALLOW_ULTRA_WIDEBAND_RADIO = "no_ultra_wideband_radio";
    @FlaggedApi(value="android.nfc.enable_nfc_user_restriction")
    public static final String DISALLOW_NEAR_FIELD_COMMUNICATION_RADIO = "no_near_field_communication_radio";
    @FlaggedApi(value="android.nfc.enable_nfc_user_restriction")
    public static final String DISALLOW_CHANGE_NEAR_FIELD_COMMUNICATION_RADIO = "no_change_near_field_communication_radio";
    @FlaggedApi(value="com.android.net.thread.platform.flags.thread_user_restriction_enabled")
    public static final String DISALLOW_THREAD_NETWORK = "no_thread_network";
    public static final String DISALLOW_SIM_GLOBALLY = "no_sim_globally";
    public static final String DISALLOW_ASSIST_CONTENT = "no_assist_content";
    public static final String SYSTEM_USER_MODE_EMULATION_PROPERTY = "persist.debug.user_mode_emulation";
    public static final String SYSTEM_USER_MODE_EMULATION_DEFAULT = "default";
    public static final String SYSTEM_USER_MODE_EMULATION_FULL = "full";
    public static final String SYSTEM_USER_MODE_EMULATION_HEADLESS = "headless";
    public static final String DEV_CREATE_OVERRIDE_PROPERTY = "debug.user.creation_override";
    private static final String ACTION_CREATE_USER = "android.os.action.CREATE_USER";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public static final String ACTION_CREATE_SUPERVISED_USER = "android.os.action.CREATE_SUPERVISED_USER";
    public static final String EXTRA_USER_NAME = "android.os.extra.USER_NAME";
    public static final String EXTRA_USER_ACCOUNT_NAME = "android.os.extra.USER_ACCOUNT_NAME";
    public static final String EXTRA_USER_ACCOUNT_TYPE = "android.os.extra.USER_ACCOUNT_TYPE";
    public static final String EXTRA_USER_ACCOUNT_OPTIONS = "android.os.extra.USER_ACCOUNT_OPTIONS";
    public static final int PIN_VERIFICATION_FAILED_INCORRECT = -3;
    public static final int PIN_VERIFICATION_FAILED_NOT_SET = -2;
    public static final int PIN_VERIFICATION_SUCCESS = -1;
    @SystemApi
    public static final String ACTION_USER_RESTRICTIONS_CHANGED = "android.os.action.USER_RESTRICTIONS_CHANGED";
    public static final int USER_CREATION_FAILED_NOT_PERMITTED = 1;
    public static final int USER_CREATION_FAILED_NO_MORE_USERS = 2;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_OK = 0;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_USER_IN_CALL = 1;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_USER_SWITCH_DISALLOWED = 2;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_SYSTEM_USER_LOCKED = 4;
    public static final int LOGOUTABILITY_STATUS_OK = 0;
    public static final int LOGOUTABILITY_STATUS_CANNOT_LOGOUT_SYSTEM_USER = 1;
    public static final int LOGOUTABILITY_STATUS_CANNOT_SWITCH = 2;
    public static final int LOGOUTABILITY_STATUS_DEVICE_NOT_SUPPORTED = 3;
    @SystemApi
    public static final int REMOVE_RESULT_REMOVED = 0;
    @SystemApi
    public static final int REMOVE_RESULT_DEFERRED = 1;
    @SystemApi
    public static final int REMOVE_RESULT_ALREADY_BEING_REMOVED = 2;
    public static final int REMOVE_RESULT_USER_IS_REMOVABLE = 3;
    @SystemApi
    public static final int REMOVE_RESULT_ERROR_UNKNOWN = -1;
    @SystemApi
    public static final int REMOVE_RESULT_ERROR_USER_RESTRICTION = -2;
    @SystemApi
    public static final int REMOVE_RESULT_ERROR_USER_NOT_FOUND = -3;
    @SystemApi
    public static final int REMOVE_RESULT_ERROR_SYSTEM_USER = -4;
    @SystemApi
    public static final int REMOVE_RESULT_ERROR_MAIN_USER_PERMANENT_ADMIN = -5;
    @SystemApi
    @FlaggedApi(value="android.multiuser.disallow_removing_last_admin_user")
    public static final int REMOVE_RESULT_ERROR_LAST_ADMIN_USER = -6;
    public static final int USER_OPERATION_SUCCESS = 0;
    public static final int USER_OPERATION_ERROR_UNKNOWN = 1;
    public static final int USER_OPERATION_ERROR_MANAGED_PROFILE = 2;
    public static final int USER_OPERATION_ERROR_MAX_RUNNING_USERS = 3;
    public static final int USER_OPERATION_ERROR_CURRENT_USER = 4;
    public static final int USER_OPERATION_ERROR_LOW_STORAGE = 5;
    public static final int USER_OPERATION_ERROR_MAX_USERS = 6;
    @SystemApi
    public static final int USER_OPERATION_ERROR_USER_ACCOUNT_ALREADY_EXISTS = 7;
    public static final int USER_OPERATION_ERROR_DISABLED_USER = 8;
    public static final int USER_OPERATION_ERROR_FEATURE_UNSUPPORTED = 9;
    public static final int USER_OPERATION_ERROR_USER_RESTRICTED = 10;
    public static final long ALWAYS_USE_CONTEXT_USER = 183155436L;
    private static final String CACHE_KEY_STATIC_USER_PROPERTIES = PropertyInvalidatedCache.createPropertyName("system_server", "static_user_props");
    private final PropertyInvalidatedCache<Integer, String> mProfileTypeCache = new PropertyInvalidatedCache<Integer, String>(32, CACHE_KEY_STATIC_USER_PROPERTIES){

        @Override
        public String recompute(Integer query) {
            try {
                String profileType = UserManager.this.mService.getProfileType(query);
                if (profileType != null) {
                    profileType = profileType.intern();
                }
                return profileType;
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }

        @Override
        public boolean bypass(Integer query) {
            return query < 0;
        }
    };

    private <T> T returnNullOrThrowUserOperationException(ServiceSpecificException exception, boolean throwInsteadOfNull) throws UserOperationException {
        if (throwInsteadOfNull) {
            throw UserOperationException.from(exception);
        }
        return null;
    }

    private int getContextUserIfAppropriate() {
        if (CompatChanges.isChangeEnabled(183155436L)) {
            return this.mUserId;
        }
        int callingUser = UserHandle.myUserId();
        if (callingUser != this.mUserId) {
            Log.w(TAG, "Using the calling user " + callingUser + ", rather than the specified context user " + this.mUserId + ", because API is only UserHandleAware on higher targetSdkVersions.", new Throwable());
        }
        return callingUser;
    }

    @UnsupportedAppUsage
    public static UserManager get(Context context) {
        return (UserManager)context.getSystemService("user");
    }

    public UserManager(Context context, IUserManager service) {
        this.mService = service;
        Context appContext = context.getApplicationContext();
        this.mContext = appContext == null ? context : appContext;
        this.mUserId = context.getUserId();
    }

    public static boolean supportsMultipleUsers() {
        return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", Resources.getSystem().getBoolean(17891717));
    }

    public static boolean isGuestUserAlwaysEphemeral() {
        return Resources.getSystem().getBoolean(17891775);
    }

    public static boolean isGuestUserAllowEphemeralStateChange() {
        return Resources.getSystem().getBoolean(17891773);
    }

    public static boolean isCommunalProfileEnabled() {
        return SystemProperties.getBoolean("persist.fw.omnipresent_communal_user", Resources.getSystem().getBoolean(17891853));
    }

    public static boolean isPrivateProfileEnabled() {
        if (Flags.blockPrivateSpaceCreation()) {
            return !ActivityManager.isLowRamDeviceStatic();
        }
        return true;
    }

    public static boolean isMultipleAdminEnabled() {
        return Resources.getSystem().getBoolean(17891718);
    }

    public static boolean isHeadlessSystemUserMode() {
        if (sIsHeadlessSystemUser == null) {
            try {
                IUserManager service = IUserManager.Stub.asInterface(ServiceManager.getService("user"));
                sIsHeadlessSystemUser = service.isHeadlessSystemUserMode();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return sIsHeadlessSystemUser;
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean canSwitchUsers() {
        try {
            return this.mService.getUserSwitchability(this.mUserId) == 0;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    public int getUserSwitchability() {
        return this.getUserSwitchability(UserHandle.of(this.getContextUserIfAppropriate()));
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    public int getUserSwitchability(UserHandle userHandle) {
        try {
            return this.mService.getUserSwitchability(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public int getUserLogoutability(int userId) {
        try {
            return this.mService.getUserLogoutability(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public int getUserHandle() {
        return this.getContextUserIfAppropriate();
    }

    @Deprecated
    public int getProcessUserId() {
        return UserHandle.myUserId();
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    @NonNull
    public String getUserType() {
        UserInfo userInfo = this.getUserInfo(this.mUserId);
        return userInfo == null ? "" : userInfo.userType;
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    @NonNull
    public String getUserName() {
        if (UserHandle.myUserId() == this.mUserId) {
            try {
                return this.mService.getUserName();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        UserInfo userInfo = this.getUserInfo(this.mUserId);
        if (userInfo != null && userInfo.name != null) {
            return userInfo.name;
        }
        return "";
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    public boolean isUserNameSet() {
        try {
            return this.mService.isUserNameSet(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isUserAGoat() {
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 30) {
            return false;
        }
        return this.mContext.getPackageManager().isPackageAvailable("com.coffeestainstudios.goatsimulator");
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isPrimaryUser() {
        UserInfo user = this.getUserInfo(this.getContextUserIfAppropriate());
        return user != null && user.isPrimary();
    }

    public boolean isSystemUser() {
        return this.getContextUserIfAppropriate() == 0;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isMainUser() {
        UserInfo user = this.getUserInfo(this.mUserId);
        return user != null && user.isMain();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    @Nullable
    public UserHandle getMainUser() {
        try {
            int mainUserId = this.mService.getMainUserId();
            if (mainUserId == -10000) {
                return null;
            }
            return UserHandle.of(mainUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.multiuser.support_communal_profile")
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    @Nullable
    public UserHandle getCommunalProfile() {
        try {
            int userId = this.mService.getCommunalProfileId();
            if (userId == -10000) {
                return null;
            }
            return UserHandle.of(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.multiuser.support_communal_profile")
    public boolean isCommunalProfile() {
        return this.isCommunalProfile(this.mUserId);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    private boolean isCommunalProfile(int userId) {
        return UserManager.isUserTypeCommunalProfile(this.getProfileType(userId));
    }

    public boolean isAdminUser() {
        try {
            return this.mService.isAdminUser(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isUserAdmin(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isAdmin();
    }

    @FlaggedApi(value="android.multiuser.support_communal_profile_nextgen")
    public boolean isForegroundUserAdmin() {
        try {
            return this.mService.isForegroundUserAdmin();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isUserOfType(@NonNull String userType) {
        try {
            return this.mService.isUserOfType(this.mUserId, userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RavenwoodKeep
    public static boolean isUserTypeManagedProfile(@Nullable String userType) {
        return USER_TYPE_PROFILE_MANAGED.equals(userType);
    }

    @RavenwoodKeep
    public static boolean isUserTypeGuest(@Nullable String userType) {
        return USER_TYPE_FULL_GUEST.equals(userType);
    }

    @RavenwoodKeep
    public static boolean isUserTypeRestricted(@Nullable String userType) {
        return USER_TYPE_FULL_RESTRICTED.equals(userType);
    }

    @RavenwoodKeep
    public static boolean isUserTypeDemo(@Nullable String userType) {
        return USER_TYPE_FULL_DEMO.equals(userType);
    }

    @RavenwoodKeep
    public static boolean isUserTypeCloneProfile(@Nullable String userType) {
        return USER_TYPE_PROFILE_CLONE.equals(userType);
    }

    @RavenwoodKeep
    public static boolean isUserTypeCommunalProfile(@Nullable String userType) {
        return USER_TYPE_PROFILE_COMMUNAL.equals(userType);
    }

    @RavenwoodKeep
    public static boolean isUserTypePrivateProfile(@Nullable String userType) {
        return USER_TYPE_PROFILE_PRIVATE.equals(userType);
    }

    @FlaggedApi(value="android.multiuser.allow_supervising_profile")
    @RavenwoodKeep
    public static boolean isUserTypeSupervisingProfile(@Nullable String userType) {
        return USER_TYPE_PROFILE_SUPERVISING.equals(userType);
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean isLinkedUser() {
        return this.isRestrictedProfile();
    }

    @SystemApi
    public boolean isRestrictedProfile() {
        try {
            return this.mService.isRestricted(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    public boolean isRestrictedProfile(@NonNull UserHandle user) {
        try {
            return this.mService.isRestricted(user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean canHaveRestrictedProfile() {
        try {
            return this.mService.canHaveRestrictedProfile(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.allow_private_profile")
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean canAddPrivateProfile() {
        if (!Flags.enablePrivateSpaceFeatures()) {
            return false;
        }
        if (Flags.blockPrivateSpaceCreation()) {
            try {
                return this.mService.canAddPrivateProfile(this.mUserId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean hasRestrictedProfiles() {
        try {
            return this.mService.hasRestrictedProfiles(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    @Nullable
    public UserHandle getRestrictedProfileParent() {
        UserInfo info = this.getUserInfo(this.mUserId);
        if (info == null) {
            return null;
        }
        if (!info.isRestricted()) {
            return null;
        }
        int parent = info.restrictedProfileParentId;
        if (parent == -10000) {
            return null;
        }
        return UserHandle.of(parent);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isGuestUser(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isGuest();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isGuestUser() {
        UserInfo user = this.getUserInfo(this.getContextUserIfAppropriate());
        return user != null && user.isGuest();
    }

    public boolean isDemoUser() {
        try {
            return this.mService.isDemoUser(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isProfile() {
        return this.isProfile(this.mUserId);
    }

    public boolean isProfile(int userId) {
        String profileType = this.getProfileType(userId);
        return profileType != null && !profileType.equals("");
    }

    @Nullable
    private String getProfileType() {
        return this.getProfileType(this.mUserId);
    }

    @Nullable
    private String getProfileType(int userId) {
        if (userId == UserHandle.myUserId()) {
            if (this.mProfileTypeOfProcessUser != null) {
                return this.mProfileTypeOfProcessUser;
            }
            try {
                String profileType = this.mService.getProfileType(userId);
                if (profileType != null) {
                    this.mProfileTypeOfProcessUser = profileType.intern();
                    return this.mProfileTypeOfProcessUser;
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return this.mProfileTypeCache.query(userId);
    }

    public boolean isManagedProfile() {
        return this.isManagedProfile(this.getContextUserIfAppropriate());
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isManagedProfile(int userId) {
        return UserManager.isUserTypeManagedProfile(this.getProfileType(userId));
    }

    @SystemApi
    public boolean isCloneProfile() {
        return UserManager.isUserTypeCloneProfile(this.getProfileType());
    }

    @SystemApi
    @FlaggedApi(value="android.os.allow_private_profile")
    public boolean isPrivateProfile() {
        return UserManager.isUserTypePrivateProfile(this.getProfileType());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isEphemeralUser() {
        return this.isUserEphemeral(this.mUserId);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean isUserEphemeral(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isEphemeral();
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserRunning(UserHandle user) {
        return this.isUserRunning(user.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserRunning(int userId) {
        try {
            return this.mService.isUserRunning(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserRunningOrStopping(UserHandle user) {
        try {
            return ActivityManager.getService().isUserRunning(user.getIdentifier(), 1);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isUserForeground() {
        try {
            return this.mService.isUserForeground(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static boolean isVisibleBackgroundUsersEnabled() {
        return SystemProperties.getBoolean("fw.visible_bg_users", Resources.getSystem().getBoolean(17891837));
    }

    public boolean isVisibleBackgroundUsersSupported() {
        return UserManager.isVisibleBackgroundUsersEnabled();
    }

    public static boolean isVisibleBackgroundUsersOnDefaultDisplayEnabled() {
        return SystemProperties.getBoolean("fw.visible_bg_users_on_default_display", Resources.getSystem().getBoolean(17891838));
    }

    public boolean isVisibleBackgroundUsersOnDefaultDisplaySupported() {
        return UserManager.isVisibleBackgroundUsersOnDefaultDisplayEnabled();
    }

    @SystemApi
    public boolean isUserVisible() {
        try {
            return this.mService.isUserVisible(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.MANAGE_USERS"})
    @NonNull
    public Set<UserHandle> getVisibleUsers() {
        ArraySet<UserHandle> result = new ArraySet<UserHandle>();
        try {
            int[] visibleUserIds = this.mService.getVisibleUsers();
            if (visibleUserIds != null) {
                for (int userId : visibleUserIds) {
                    result.add(UserHandle.of(userId));
                }
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return result;
    }

    public int getMainDisplayIdAssignedToUser() {
        try {
            return this.mService.getMainDisplayIdAssignedToUser(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isUserUnlocked() {
        return this.isUserUnlocked(this.getContextUserIfAppropriate());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlocked(UserHandle user) {
        return this.isUserUnlocked(user.getIdentifier());
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlocked(int userId) {
        return UserManagerCache.isUserUnlocked(this.mService::isUserUnlocked, userId);
    }

    public static void invalidateIsUserUnlockedCache() {
        UserManagerCache.invalidateUserUnlocked();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlockingOrUnlocked(@NonNull UserHandle user) {
        return this.isUserUnlockingOrUnlocked(user.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlockingOrUnlocked(int userId) {
        return UserManagerCache.isUserUnlockingOrUnlocked(this.mService::isUserUnlockingOrUnlocked, userId);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getUserStartRealtime() {
        if (this.getContextUserIfAppropriate() != UserHandle.myUserId()) {
            throw new IllegalArgumentException("Calling from a context differing from the calling user is not currently supported.");
        }
        try {
            return this.mService.getUserStartRealtime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getUserUnlockRealtime() {
        if (this.getContextUserIfAppropriate() != UserHandle.myUserId()) {
            throw new IllegalArgumentException("Calling from a context differing from the calling user is not currently supported.");
        }
        try {
            return this.mService.getUserUnlockRealtime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public UserInfo getUserInfo(int userId) {
        if (Flags.cacheUserInfoReadOnly()) {
            return UserManagerCache.getUserInfo(this.mService::getUserInfo, userId);
        }
        try {
            return this.mService.getUserInfo(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    @NonNull
    public UserProperties getUserProperties(@NonNull UserHandle userHandle) {
        int userId = userHandle.getIdentifier();
        if (userId < 0) {
            throw new IllegalArgumentException("Cannot access properties for user " + userId);
        }
        int callingUid = Binder.getCallingUid();
        int processUid = Process.myUid();
        if (processUid == 1000 && callingUid != processUid) {
            Log.w(TAG, "The System (uid " + processUid + ") is fetching a copy of UserProperties on behalf of callingUid " + callingUid + ". Possibly it should carefully first clearCallingIdentity or perhaps use UserManagerInternal.getUserProperties() instead?", new Throwable());
        }
        return this.getUserPropertiesFromQuery(new QueryUserId(userId));
    }

    public static void invalidateUserPropertiesCache() {
        UserManagerCache.invalidateUserPropertiesFromQuery();
    }

    @NonNull
    private UserProperties getUserPropertiesFromQuery(QueryUserId query) {
        UserManagerCache cfr_ignored_0 = (UserManagerCache)this.mIpcDataCache;
        return UserManagerCache.getUserPropertiesFromQuery(q -> this.mService.getUserPropertiesCopy(q.getUserId()), query);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public int getUserRestrictionSource(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictionSource(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public List<EnforcingUser> getUserRestrictionSources(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictionSources(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getUserRestrictions() {
        try {
            return this.mService.getUserRestrictions(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public Bundle getUserRestrictions(UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictions(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean hasBaseUserRestriction(@NonNull String restrictionKey, @NonNull UserHandle userHandle) {
        try {
            return this.mService.hasBaseUserRestriction(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void setUserRestrictions(Bundle restrictions) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Deprecated
    public void setUserRestrictions(Bundle restrictions, UserHandle userHandle) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserRestriction(String key, boolean value) {
        try {
            this.mService.setUserRestriction(key, value, this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserRestriction(String key, boolean value, UserHandle userHandle) {
        try {
            this.mService.setUserRestriction(key, value, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasUserRestriction(String restrictionKey) {
        return this.hasUserRestrictionForUser(restrictionKey, this.getContextUserIfAppropriate());
    }

    @Deprecated
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        return this.hasUserRestrictionForUser(restrictionKey, userHandle);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean hasUserRestrictionForUser(@NonNull String restrictionKey, @NonNull UserHandle userHandle) {
        return this.hasUserRestrictionForUser(restrictionKey, userHandle.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    private boolean hasUserRestrictionForUser(@NonNull String restrictionKey, @NonNull int userId) {
        return this.getUserRestrictionFromQuery(new Pair<String, Integer>(restrictionKey, userId));
    }

    private boolean getUserRestrictionFromQuery(@NonNull Pair<String, Integer> restrictionPerUser) {
        return UserManagerCache.getUserRestrictionFromQuery(q -> this.mService.hasUserRestriction((String)q.first, (Integer)q.second), q -> !Flags.cacheUserRestrictionsReadOnly(), restrictionPerUser);
    }

    public static void invalidateUserRestriction() {
        if (Flags.cacheUserRestrictionsReadOnly()) {
            UserManagerCache.invalidateUserRestrictionFromQuery();
        }
    }

    public boolean hasUserRestrictionOnAnyUser(String restrictionKey) {
        try {
            return this.mService.hasUserRestrictionOnAnyUser(restrictionKey);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isSettingRestrictedForUser(String setting, int userId, String value, int callingUid) {
        try {
            return this.mService.isSettingRestrictedForUser(setting, userId, value, callingUid);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void addUserRestrictionsListener(IUserRestrictionsListener listener) {
        try {
            this.mService.addUserRestrictionsListener(listener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getSerialNumberForUser(UserHandle user) {
        return this.getUserSerialNumber(user.getIdentifier());
    }

    public UserHandle getUserForSerialNumber(long serialNumber) {
        int ident = this.getUserHandle((int)serialNumber);
        return ident >= 0 ? new UserHandle(ident) : null;
    }

    @Deprecated
    @UnsupportedAppUsage
    @Nullable
    public UserInfo createUser(@Nullable String name, int flags) {
        return this.createUser(name, UserInfo.getDefaultUserType(flags), flags);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserInfo createUser(@Nullable String name, @NonNull String userType, int flags) {
        try {
            return this.mService.createUserWithThrow(name, userType, flags);
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public NewUserResponse createUser(@NonNull NewUserRequest newUserRequest) {
        try {
            UserHandle userHandle = this.mService.createUserWithAttributes(newUserRequest.getName(), newUserRequest.getUserType(), newUserRequest.getFlags(), newUserRequest.getUserIcon(), newUserRequest.getAccountName(), newUserRequest.getAccountType(), newUserRequest.getAccountOptions());
            return new NewUserResponse(userHandle, 0);
        }
        catch (ServiceSpecificException e) {
            Log.w(TAG, "Exception while creating user " + newUserRequest, e);
            return new NewUserResponse(null, e.errorCode);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public UserInfo preCreateUser(@NonNull String userType) throws UserOperationException {
        Log.w(TAG, "preCreateUser(): Pre-created user is deprecated.");
        try {
            return this.mService.preCreateUserWithThrow(userType);
        }
        catch (ServiceSpecificException e) {
            throw UserOperationException.from(e);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserInfo createGuest(Context context) {
        try {
            UserInfo guest = this.mService.createUserWithThrow(null, USER_TYPE_FULL_GUEST, 0);
            Settings.Secure.putStringForUser(context.getContentResolver(), "skip_first_use_hints", "1", guest.id);
            if (UserManager.isGuestUserAllowEphemeralStateChange()) {
                boolean resetGuestOnExit;
                boolean bl = resetGuestOnExit = Settings.Global.getInt(context.getContentResolver(), "remove_guest_on_exit", 1) == 1;
                if (resetGuestOnExit && !guest.isEphemeral()) {
                    this.setUserEphemeral(guest.id, true);
                }
            }
            return guest;
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public UserInfo findCurrentGuestUser() {
        try {
            List<UserInfo> guestUsers = this.mService.getGuestUsers();
            if (guestUsers.size() == 0) {
                return null;
            }
            return guestUsers.get(0);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    @NonNull
    public List<UserInfo> getGuestUsers() {
        try {
            return this.mService.getGuestUsers();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserHandle createProfile(@NonNull String name, @NonNull String userType, @NonNull Set<String> disallowedPackages) throws UserOperationException {
        try {
            return this.mService.createProfileForUserWithThrow(name, userType, 0, this.mUserId, disallowedPackages.toArray(new String[disallowedPackages.size()])).getUserHandle();
        }
        catch (ServiceSpecificException e) {
            return (UserHandle)this.returnNullOrThrowUserOperationException(e, this.mContext.getApplicationInfo().targetSdkVersion >= 30);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createProfileForUser(String name, int flags, int userId) {
        return this.createProfileForUser(name, UserInfo.getDefaultUserType(flags), flags, userId, null);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserInfo createProfileForUser(String name, @NonNull String userType, int flags, int userId) {
        return this.createProfileForUser(name, userType, flags, userId, null);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserInfo createProfileForUser(@Nullable String name, @NonNull String userType, int flags, int userId, @Nullable String[] disallowedPackages) {
        try {
            return this.mService.createProfileForUserWithThrow(name, userType, flags, userId, disallowedPackages);
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserInfo createProfileForUserEvenWhenDisallowed(String name, @NonNull String userType, int flags, int userId, String[] disallowedPackages) {
        try {
            return this.mService.createProfileForUserEvenWhenDisallowedWithThrow(name, userType, flags, userId, disallowedPackages);
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public UserInfo createRestrictedProfile(@Nullable String name) {
        try {
            int parentUserId = this.mUserId;
            UserInfo profile = this.mService.createRestrictedProfileWithThrow(name, parentUserId);
            UserHandle parentUserHandle = UserHandle.of(parentUserId);
            AccountManager.get(this.mContext).addSharedAccountsFromParentUser(parentUserHandle, UserHandle.of(profile.id));
            return profile;
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static Intent createUserCreationIntent(@Nullable String userName, @Nullable String accountName, @Nullable String accountType, @Nullable PersistableBundle accountOptions) {
        Intent intent = new Intent(ACTION_CREATE_USER);
        if (userName != null) {
            intent.putExtra(EXTRA_USER_NAME, userName);
        }
        if (accountName != null && accountType == null) {
            throw new IllegalArgumentException("accountType must be specified if accountName is specified");
        }
        if (accountName != null) {
            intent.putExtra(EXTRA_USER_ACCOUNT_NAME, accountName);
        }
        if (accountType != null) {
            intent.putExtra(EXTRA_USER_ACCOUNT_TYPE, accountType);
        }
        if (accountOptions != null) {
            intent.putExtra(EXTRA_USER_ACCOUNT_OPTIONS, accountOptions);
        }
        return intent;
    }

    @SuppressLint(value={"NullableCollection"})
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @Nullable
    public Set<String> getPreInstallableSystemPackages(@NonNull String userType) {
        try {
            String[] installableSystemPackages = this.mService.getPreInstallableSystemPackages(userType);
            if (installableSystemPackages == null) {
                return null;
            }
            return new ArraySet<String>(installableSystemPackages);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getSeedAccountName() {
        try {
            return this.mService.getSeedAccountName(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getSeedAccountType() {
        try {
            return this.mService.getSeedAccountType(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public PersistableBundle getSeedAccountOptions() {
        try {
            return this.mService.getSeedAccountOptions(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setSeedAccountData(int userId, String accountName, String accountType, PersistableBundle accountOptions) {
        try {
            this.mService.setSeedAccountData(userId, accountName, accountType, accountOptions, true);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void clearSeedAccountData() {
        try {
            this.mService.clearSeedAccountData(this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean markGuestForDeletion(int userId) {
        try {
            return this.mService.markGuestForDeletion(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserEnabled(int userId) {
        try {
            this.mService.setUserEnabled(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    public void setUserAdmin(int userId) {
        try {
            this.mService.setUserAdmin(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    public void revokeUserAdmin(int userId) {
        try {
            this.mService.revokeUserAdmin(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void evictCredentialEncryptionKey(int userId) {
        try {
            this.mService.evictCredentialEncryptionKey(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public int getUserCount() {
        List<UserInfo> users = this.getUsers();
        return users != null ? users.size() : 1;
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public List<UserInfo> getUsers() {
        return this.getUsers(false);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public List<UserInfo> getAliveUsers() {
        return this.getUsers(true);
    }

    @Deprecated
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public List<UserInfo> getUsers(boolean excludeDying) {
        try {
            return this.mService.getUsers(excludeDying);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public List<UserHandle> getUserHandles(boolean excludeDying) {
        List<UserInfo> users = this.getUsers(excludeDying);
        ArrayList<UserHandle> result = new ArrayList<UserHandle>(users.size());
        for (UserInfo user : users) {
            result.add(user.getUserHandle());
        }
        return result;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public long[] getSerialNumbersOfUsers(boolean excludeDying) {
        List<UserInfo> users = this.getUsers(excludeDying);
        long[] result = new long[users.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = users.get((int)i).serialNumber;
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    @Nullable
    public String getUserAccount(int userId) {
        try {
            return this.mService.getUserAccount(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    public void setUserAccount(int userId, @Nullable String accountName) {
        try {
            this.mService.setUserAccount(userId, accountName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    @Nullable
    public UserInfo getPrimaryUser() {
        try {
            return this.mService.getPrimaryUser();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    @Nullable
    public UserHandle getPreviousForegroundUser() {
        try {
            int previousUser = this.mService.getPreviousUserToEnterForeground();
            if (previousUser == -10000) {
                return null;
            }
            return UserHandle.of(previousUser);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean canAddMoreUsers(@NonNull String userType) {
        if (!Flags.consistentMaxUsers()) {
            return this.canAddMoreUsersLegacy(userType);
        }
        try {
            return this.mService.canAddMoreUsersOfType(userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public int getRemainingCreatableUserCount(@NonNull String userType) {
        Objects.requireNonNull(userType, "userType must not be null");
        try {
            return this.mService.getRemainingCreatableUserCount(userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public int getRemainingCreatableProfileCount(@NonNull String userType) {
        Objects.requireNonNull(userType, "userType must not be null");
        try {
            return this.mService.getRemainingCreatableProfileCount(userType, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean canAddMoreManagedProfiles(int userId, boolean allowedToRemoveOne) {
        try {
            return this.mService.canAddMoreProfilesToUser(USER_TYPE_PROFILE_MANAGED, userId, allowedToRemoveOne);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public boolean canAddMoreProfilesToUser(@NonNull String userType, int userId) {
        try {
            return this.mService.canAddMoreProfilesToUser(userType, userId, false);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public int getCurrentAllowedNumberOfUsers(@NonNull String userType) {
        if (!Flags.consistentMaxUsers()) {
            throw new UnsupportedOperationException("This method requires flag consistentMaxUsers");
        }
        try {
            return this.mService.getCurrentAllowedNumberOfUsers(userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isUserTypeEnabled(@NonNull String userType) {
        try {
            return this.mService.isUserTypeEnabled(userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    public List<UserInfo> getProfiles(int userId) {
        return UserManagerCache.getProfiles(userIdentifier -> this.mService.getProfiles((int)userIdentifier, false), userId);
    }

    @FlaggedApi(value="android.multiuser.support_communal_profile")
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"})
    public List<UserInfo> getProfilesIncludingCommunal(int userId) {
        UserInfo communalInfo;
        List<UserInfo> profiles = this.getProfiles(userId);
        UserHandle communalProfile = this.getCommunalProfile();
        if (communalProfile != null && (communalInfo = this.getUserInfo(communalProfile.getIdentifier())) != null) {
            profiles.add(communalInfo);
        }
        return profiles;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public boolean isSameProfileGroup(@NonNull UserHandle user, @NonNull UserHandle otherUser) {
        return this.isSameProfileGroup(user.getIdentifier(), otherUser.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public boolean isSameProfileGroup(int userId, int otherUserId) {
        try {
            return this.mService.isSameProfileGroup(userId, otherUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    public List<UserInfo> getEnabledProfiles(int userId) {
        try {
            return this.mService.getProfiles(userId, true);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<UserHandle> getUserProfiles() {
        int[] userIds = this.getProfileIds(this.getContextUserIfAppropriate(), true);
        return this.convertUserIdsToUserHandles(userIds);
    }

    @SystemApi
    @NonNull
    public List<UserHandle> getEnabledProfiles() {
        return this.getProfiles(true);
    }

    @SystemApi
    @NonNull
    public List<UserHandle> getAllProfiles() {
        return this.getProfiles(false);
    }

    @NonNull
    private List<UserHandle> getProfiles(boolean enabledOnly) {
        int[] userIds = this.getProfileIds(this.mUserId, enabledOnly);
        return this.convertUserIdsToUserHandles(userIds);
    }

    @NonNull
    private List<UserHandle> convertUserIdsToUserHandles(@NonNull int[] userIds) {
        ArrayList<UserHandle> result = new ArrayList<UserHandle>(userIds.length);
        for (int userId : userIds) {
            result.add(UserHandle.of(userId));
        }
        return result;
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    @NonNull
    public int[] getProfileIds(int userId, boolean enabledOnly) {
        return enabledOnly ? this.getEnabledProfileIds(userId) : this.getProfileIdsWithDisabled(userId);
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    public int[] getProfileIdsWithDisabled(int userId) {
        return UserManagerCache.getProfileIdsWithDisabled(userIdentifier -> this.mService.getProfileIds((int)userIdentifier, false), userId);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    public int[] getEnabledProfileIds(int userId) {
        return UserManagerCache.getEnabledProfileIds(userIdentifier -> this.mService.getProfileIds((int)userIdentifier, true), userId);
    }

    public static void invalidateEnabledProfileIds() {
        UserManagerCache.invalidateEnabledProfileIds();
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS", "android.permission.QUERY_USERS"}, conditional=true)
    public int[] getProfileIdsExcludingHidden(int userId, boolean enabled) {
        try {
            return this.mService.getProfileIdsExcludingHidden(userId, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public int getCredentialOwnerProfile(int userId) {
        try {
            return this.mService.getCredentialOwnerProfile(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    public UserInfo getProfileParent(int userId) {
        try {
            return this.mService.getProfileParent(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    @Nullable
    public UserHandle getProfileParent(@NonNull UserHandle user) {
        UserHandle userHandle = UserManagerCache.getProfileParent(query -> {
            UserInfo info = this.getProfileParent(query.getIdentifier());
            if (info == null) {
                return UserHandle.of(-10000);
            }
            return UserHandle.of(info.id);
        }, user);
        if (userHandle.getIdentifier() == -10000) {
            return null;
        }
        return userHandle;
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.MODIFY_QUIET_MODE"}, conditional=true)
    public boolean requestQuietModeEnabled(boolean enableQuietMode, @NonNull UserHandle userHandle) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle, null);
    }

    public boolean requestQuietModeEnabled(boolean enableQuietMode, @NonNull UserHandle userHandle, int flags) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle, null, flags);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean requestQuietModeEnabled(boolean enableQuietMode, @NonNull UserHandle userHandle, IntentSender target) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle, target, 0);
    }

    public boolean requestQuietModeEnabled(boolean enableQuietMode, @NonNull UserHandle userHandle, IntentSender target, int flags) {
        try {
            return this.mService.requestQuietModeEnabled(this.mContext.getPackageName(), enableQuietMode, userHandle.getIdentifier(), target, flags);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static void invalidateQuietModeEnabledCache() {
        UserManagerCache.invalidateQuietModeEnabled();
    }

    public boolean isQuietModeEnabled(UserHandle userHandle) {
        int userId = userHandle.getIdentifier();
        if (userId < 0) {
            return false;
        }
        return ((UserManagerCache)this.mIpcDataCache).isQuietModeEnabled(uh -> this.mService.isQuietModeEnabled(uh.getIdentifier()), userHandle);
    }

    public boolean hasBadge(int userId) {
        if (!this.isProfile(userId)) {
            return false;
        }
        try {
            return this.mService.hasBadge(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasBadge() {
        return this.hasBadge(this.mUserId);
    }

    public int getUserBadgeColor(int userId) {
        try {
            int resourceId = this.mService.getUserBadgeColorResId(userId);
            return Resources.getSystem().getColor(resourceId, null);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserBadgeDarkColor(int userId) {
        try {
            int resourceId = this.mService.getUserBadgeDarkColorResId(userId);
            return Resources.getSystem().getColor(resourceId, null);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserIconBadgeResId(int userId) {
        try {
            return this.mService.getUserIconBadgeResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserBadgeResId(int userId) {
        try {
            return this.mService.getUserBadgeResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserBadgeNoBackgroundResId(int userId) {
        try {
            return this.mService.getUserBadgeNoBackgroundResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserStatusBarIconResId(int userId) {
        try {
            return this.mService.getUserStatusBarIconResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Drawable getBadgedIconForUser(Drawable icon, UserHandle user) {
        return this.mContext.getPackageManager().getUserBadgedIcon(icon, user);
    }

    public Drawable getBadgedDrawableForUser(Drawable badgedDrawable, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return this.mContext.getPackageManager().getUserBadgedDrawableForDensity(badgedDrawable, user, badgeLocation, badgeDensity);
    }

    @SystemApi
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public Drawable getUserBadge() {
        if (!this.isProfile(this.mUserId)) {
            throw new Resources.NotFoundException("No badge found for this user.");
        }
        if (this.isManagedProfile(this.mUserId)) {
            DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
            return dpm.getResources().getDrawable("WORK_PROFILE_ICON_BADGE", "SOLID_COLORED", () -> this.getDefaultUserBadge(this.mUserId));
        }
        return this.getDefaultUserBadge(this.mUserId);
    }

    private Drawable getDefaultUserBadge(int userId) {
        return this.mContext.getResources().getDrawable(this.getUserBadgeResId(userId), this.mContext.getTheme());
    }

    public CharSequence getBadgedLabelForUser(CharSequence label, UserHandle user) {
        int userId = user.getIdentifier();
        if (!this.hasBadge(userId)) {
            return label;
        }
        DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
        return dpm.getResources().getString(this.getUpdatableUserBadgedLabelId(userId), () -> this.getDefaultUserBadgedLabel(label, userId), label);
    }

    private String getUpdatableUserBadgedLabelId(int userId) {
        return this.isManagedProfile(userId) ? "Core.WORK_PROFILE_BADGED_LABEL" : "UNDEFINED";
    }

    private String getDefaultUserBadgedLabel(CharSequence label, int userId) {
        try {
            int resourceId = this.mService.getUserBadgeLabelResId(userId);
            return Resources.getSystem().getString(resourceId, label);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public String getProfileLabel() {
        if (this.isManagedProfile(this.mUserId)) {
            DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
            return dpm.getResources().getString("Core.RESOLVER_WORK_TAB", () -> this.getDefaultProfileLabel(this.mUserId));
        }
        return this.getDefaultProfileLabel(this.mUserId);
    }

    private String getDefaultProfileLabel(int userId) {
        try {
            int resourceId = this.mService.getProfileLabelResId(userId);
            return Resources.getSystem().getString(resourceId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public String getProfileAccessibilityString(int userId) {
        if (this.isManagedProfile(this.mUserId)) {
            DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
            dpm.getResources().getString("SystemUi.STATUS_BAR_WORK_ICON_ACCESSIBILITY", () -> this.getProfileAccessibilityLabel(userId));
        }
        return this.getProfileAccessibilityLabel(userId);
    }

    private String getProfileAccessibilityLabel(int userId) {
        try {
            int resourceId = this.mService.getProfileAccessibilityLabelResId(userId);
            return Resources.getSystem().getString(resourceId);
        }
        catch (Resources.NotFoundException nfe) {
            Log.e(TAG, "Accessibility label not defined for user " + userId);
            throw nfe;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @Deprecated
    public boolean isMediaSharedWithParent() {
        try {
            return this.getUserProperties(UserHandle.of(this.mUserId)).isMediaSharedWithParent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @SystemApi
    @Deprecated
    public boolean isCredentialSharableWithParent() {
        try {
            return this.getUserProperties(UserHandle.of(this.mUserId)).isCredentialShareableWithParent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean removeUser(int userId) {
        try {
            return this.mService.removeUser(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean removeUser(@NonNull UserHandle user) {
        if (user == null) {
            throw new IllegalArgumentException("user cannot be null");
        }
        return this.removeUser(user.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean removeUserEvenWhenDisallowed(int userId) {
        try {
            return this.mService.removeUserEvenWhenDisallowed(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public int removeUserWhenPossible(@NonNull UserHandle user, boolean overrideDevicePolicy) {
        try {
            return this.mService.removeUserWhenPossible(user.getIdentifier(), overrideDevicePolicy);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static boolean isRemoveResultSuccessful(int result) {
        return result >= 0;
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserName(int userId, String name) {
        try {
            this.mService.setUserName(userId, name);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean setUserEphemeral(int userId, boolean enableEphemeral) {
        try {
            return this.mService.setUserEphemeral(userId, enableEphemeral);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserName(@Nullable String name) {
        this.setUserName(this.mUserId, name);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserIcon(int userId, @NonNull Bitmap icon) {
        try {
            this.mService.setUserIcon(userId, icon);
        }
        catch (ServiceSpecificException e) {
            return;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserIcon(@NonNull Bitmap icon) throws UserOperationException {
        this.setUserIcon(this.mUserId, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    public Bitmap getUserIcon(int userId) {
        block9: {
            Bitmap bitmap;
            ParcelFileDescriptor fd = this.mService.getUserIcon(userId);
            if (fd == null) break block9;
            try {
                bitmap = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (RemoteException re) {
                    throw re.rethrowFromSystemServer();
                }
            }
            try {
                fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bitmap;
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    @Nullable
    public Bitmap getUserIcon() {
        return this.getUserIcon(this.mUserId);
    }

    @UnsupportedAppUsage
    public static int getMaxSupportedUsers() {
        return Math.max(1, SystemProperties.getInt("fw.max_users", Resources.getSystem().getInteger(17694949)));
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isUserSwitcherEnabled() {
        return this.isUserSwitcherEnabled(true);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isUserSwitcherEnabled(boolean showEvenIfNotActionable) {
        try {
            return this.mService.isUserSwitcherEnabled(showEvenIfNotActionable, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean isDeviceInDemoMode(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "device_demo_mode", 0) > 0;
    }

    public static void invalidateCacheOnUserListChange() {
        UserManagerCache.invalidateUserSerialNumber();
        UserManagerCache.invalidateProfileParent();
        UserManager.invalidateCacheOnUserDataChanged();
        UserManager.invalidateEnabledProfileIds();
        UserManager.invalidateUserRestriction();
    }

    public static void invalidateOnUserInfoFlagChange(int flags) {
        if ((flags & 0x40) > 0) {
            UserManager.invalidateEnabledProfileIds();
        }
    }

    public static void invalidateCacheOnUserDataChanged() {
        if (Flags.cacheUserInfoReadOnly()) {
            UserManagerCache.invalidateProfiles();
        }
    }

    @UnsupportedAppUsage
    public int getUserSerialNumber(int userId) {
        if (userId == 0) {
            return 0;
        }
        return ((UserManagerCache)this.mIpcDataCache).getUserSerialNumber(this.mService::getUserSerialNumber, userId);
    }

    @UnsupportedAppUsage
    public int getUserHandle(int userSerialNumber) {
        try {
            return this.mService.getUserHandle(userSerialNumber);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getApplicationRestrictions(String packageName) {
        try {
            return this.mService.getApplicationRestrictionsForUser(packageName, this.getContextUserIfAppropriate());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getApplicationRestrictions(String packageName, UserHandle user) {
        try {
            return this.mService.getApplicationRestrictionsForUser(packageName, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setApplicationRestrictions(String packageName, Bundle restrictions, UserHandle user) {
        try {
            this.mService.setApplicationRestrictions(packageName, restrictions, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean setRestrictionsChallenge(String newPin) {
        return false;
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setDefaultGuestRestrictions(Bundle restrictions) {
        try {
            this.mService.setDefaultGuestRestrictions(restrictions);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public Bundle getDefaultGuestRestrictions() {
        try {
            return this.mService.getDefaultGuestRestrictions();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getUserCreationTime(UserHandle userHandle) {
        try {
            return this.mService.getUserCreationTime(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean someUserHasSeedAccount(String accountName, String accountType) {
        try {
            return this.mService.someUserHasSeedAccount(accountName, accountType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean someUserHasAccount(@NonNull String accountName, @NonNull String accountType) {
        Objects.requireNonNull(accountName, "accountName must not be null");
        Objects.requireNonNull(accountType, "accountType must not be null");
        try {
            return this.mService.someUserHasAccount(accountName, accountType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public void setBootUser(@NonNull UserHandle bootUser) {
        try {
            this.mService.setBootUser(bootUser.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean canAddMoreUsersLegacy() {
        if (Flags.consistentMaxUsers() && Flags.maxUsersInCarIsForSecondary()) {
            throw new UnsupportedOperationException("This method is no longer supported");
        }
        List<UserInfo> users = this.getAliveUsers();
        int totalUserCount = users.size();
        int aliveUserCount = 0;
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = users.get(i);
            if (user.isGuest()) continue;
            ++aliveUserCount;
        }
        return aliveUserCount < UserManager.getMaxSupportedUsers();
    }

    private boolean canAddMoreUsersLegacy(@NonNull String userType) {
        if (Flags.consistentMaxUsers()) {
            throw new UnsupportedOperationException("This method is no longer supported");
        }
        try {
            if (userType.equals(USER_TYPE_FULL_GUEST)) {
                return this.mService.canAddMoreUsersOfType(userType);
            }
            return this.canAddMoreUsersLegacy() && this.mService.canAddMoreUsersOfType(userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    @NonNull
    public UserHandle getBootUser() {
        try {
            return UserHandle.of(this.mService.getBootUser());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static void invalidateStaticUserProperties() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_STATIC_USER_PROPERTIES);
    }

    public static class UserOperationException
    extends RuntimeException {
        private final int mUserOperationResult;

        public UserOperationException(String message, int userOperationResult) {
            super(message);
            this.mUserOperationResult = userOperationResult;
        }

        public int getUserOperationResult() {
            return this.mUserOperationResult;
        }

        public static UserOperationException from(ServiceSpecificException exception) {
            return new UserOperationException(exception.getMessage(), exception.errorCode);
        }
    }

    static class QueryUserId
    extends Pair<Integer, Integer> {
        public QueryUserId(int userId) {
            super(Binder.getCallingUid(), userId);
        }

        public int getUserId() {
            return (Integer)this.second;
        }
    }

    @SystemApi
    public static class EnforcingUser
    implements Parcelable {
        private final int userId;
        private final int userRestrictionSource;
        @NonNull
        public static final Parcelable.Creator<EnforcingUser> CREATOR = new Parcelable.Creator<EnforcingUser>(){

            @Override
            public EnforcingUser createFromParcel(Parcel in) {
                return new EnforcingUser(in);
            }

            public EnforcingUser[] newArray(int size) {
                return new EnforcingUser[size];
            }
        };

        public EnforcingUser(int userId, int userRestrictionSource) {
            this.userId = userId;
            this.userRestrictionSource = userRestrictionSource;
        }

        private EnforcingUser(Parcel in) {
            this.userId = in.readInt();
            this.userRestrictionSource = in.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.userId);
            dest.writeInt(this.userRestrictionSource);
        }

        public UserHandle getUserHandle() {
            return UserHandle.of(this.userId);
        }

        public int getUserRestrictionSource() {
            return this.userRestrictionSource;
        }
    }

    public static class CheckedUserOperationException
    extends AndroidException {
        private final int mUserOperationResult;

        public CheckedUserOperationException(String message, int userOperationResult) {
            super(message);
            this.mUserOperationResult = userOperationResult;
        }

        public int getUserOperationResult() {
            return this.mUserOperationResult;
        }

        public ServiceSpecificException toServiceSpecificException() {
            return new ServiceSpecificException(this.mUserOperationResult, this.getMessage());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserOperationResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RemoveResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserLogoutability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserSwitchabilityResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserRestrictionKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserRestrictionSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QuietModeFlag {
    }
}

