/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.NioUtils_Delegate;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;

public class SharedMemory
implements Parcelable,
Closeable {
    private final FileDescriptor mFileDescriptor;
    private final int mSize;
    private final MemoryRegistration mMemoryRegistration;
    private Cleaner mCleaner;
    private static final int PROT_MASK = OsConstants.PROT_READ | OsConstants.PROT_WRITE | OsConstants.PROT_EXEC | OsConstants.PROT_NONE;
    @NonNull
    public static final Parcelable.Creator<SharedMemory> CREATOR = new Parcelable.Creator<SharedMemory>(){

        @Override
        public SharedMemory createFromParcel(Parcel source) {
            FileDescriptor descriptor = source.readRawFileDescriptor();
            return new SharedMemory(descriptor);
        }

        public SharedMemory[] newArray(int size) {
            return new SharedMemory[size];
        }
    };

    private SharedMemory(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("Unable to create SharedMemory from a null FileDescriptor");
        }
        if (!fd.valid()) {
            throw new IllegalArgumentException("Unable to create SharedMemory from closed FileDescriptor");
        }
        this.mFileDescriptor = fd;
        this.mSize = SharedMemory.nGetSize(this.mFileDescriptor);
        if (this.mSize <= 0) {
            throw new IllegalArgumentException("FileDescriptor is not a valid ashmem fd");
        }
        this.mMemoryRegistration = new MemoryRegistration(this.mSize);
        this.mCleaner = Cleaner.create(this.mFileDescriptor, new Closer(this.mFileDescriptor.getInt$(), this.mMemoryRegistration));
    }

    @NonNull
    public static SharedMemory create(@Nullable String name, int size) throws ErrnoException {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        return new SharedMemory(SharedMemory.nCreate(name, size));
    }

    private void checkOpen() {
        if (!this.mFileDescriptor.valid()) {
            throw new IllegalStateException("SharedMemory is closed");
        }
    }

    @NonNull
    public static SharedMemory fromFileDescriptor(@NonNull ParcelFileDescriptor fd) {
        FileDescriptor f = new FileDescriptor();
        f.setInt$(fd.detachFd());
        return new SharedMemory(f);
    }

    private static void validateProt(int prot) {
        if ((prot & ~PROT_MASK) != 0) {
            throw new IllegalArgumentException("Invalid prot value");
        }
    }

    public boolean setProtect(int prot) {
        this.checkOpen();
        SharedMemory.validateProt(prot);
        int errno = SharedMemory.nSetProt(this.mFileDescriptor, prot);
        return errno == 0;
    }

    @NonNull
    public FileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    @UnsupportedAppUsage(trackingBug=171971817L)
    public int getFd() {
        return this.mFileDescriptor.getInt$();
    }

    public int getSize() {
        this.checkOpen();
        return this.mSize;
    }

    @NonNull
    public ByteBuffer mapReadWrite() throws ErrnoException {
        return this.map(OsConstants.PROT_READ | OsConstants.PROT_WRITE, 0, this.mSize);
    }

    @NonNull
    public ByteBuffer mapReadOnly() throws ErrnoException {
        return this.map(OsConstants.PROT_READ, 0, this.mSize);
    }

    @NonNull
    public ByteBuffer map(int prot, int offset, int length) throws ErrnoException {
        this.checkOpen();
        SharedMemory.validateProt(prot);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be >= 0");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        if (offset + length > this.mSize) {
            throw new IllegalArgumentException("offset + length must not exceed getSize()");
        }
        long address = Os.mmap(0L, length, prot, OsConstants.MAP_SHARED, this.mFileDescriptor, offset);
        boolean readOnly = (prot & OsConstants.PROT_WRITE) == 0;
        Unmapper unmapper = new Unmapper(address, length, this.mMemoryRegistration.acquire());
        return new DirectByteBuffer(length, address, this.mFileDescriptor, (Runnable)unmapper, readOnly);
    }

    public static void unmap(@NonNull ByteBuffer buffer) {
        if (!(buffer instanceof DirectByteBuffer)) {
            throw new IllegalArgumentException("ByteBuffer wasn't created by #map(int, int, int); can't unmap");
        }
        NioUtils_Delegate.freeDirectBuffer(buffer);
    }

    @Override
    public void close() {
        this.mFileDescriptor.setInt$(-1);
        if (this.mCleaner != null) {
            this.mCleaner.clean();
            this.mCleaner = null;
        }
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.checkOpen();
        dest.writeFileDescriptor(this.mFileDescriptor);
    }

    public ParcelFileDescriptor getFdDup() throws IOException {
        return ParcelFileDescriptor.dup(this.mFileDescriptor);
    }

    private static FileDescriptor nCreate(String string2, int n) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.SharedMemory#nCreate(Ljava/lang/String;I)Ljava/io/FileDescriptor;", true, null);
    }

    private static int nGetSize(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.os.SharedMemory#nGetSize(Ljava/io/FileDescriptor;)I", true, null);
    }

    private static int nSetProt(FileDescriptor fileDescriptor, int n) {
        return OverrideMethod.invokeI("android.os.SharedMemory#nSetProt(Ljava/io/FileDescriptor;I)I", true, null);
    }

    private static class MemoryRegistration {
        private int mSize;
        private int mReferenceCount;

        private MemoryRegistration(int size) {
            int remainder;
            int PAGE_SIZE = OsConstants._SC_PAGE_SIZE;
            if (PAGE_SIZE > 0 && (remainder = size % PAGE_SIZE) != 0) {
                size += PAGE_SIZE - remainder;
            }
            this.mSize = size;
            this.mReferenceCount = 1;
            VMRuntime.getRuntime().registerNativeAllocation(this.mSize);
        }

        public synchronized MemoryRegistration acquire() {
            ++this.mReferenceCount;
            return this;
        }

        public synchronized void release() {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                VMRuntime.getRuntime().registerNativeFree(this.mSize);
            }
        }
    }

    private static class Closer
    implements Runnable {
        private int mFd;
        private MemoryRegistration mMemoryReference;

        private Closer(int fd, MemoryRegistration memoryReference) {
            this.mFd = fd;
            this.mMemoryReference = memoryReference;
        }

        @Override
        public void run() {
            try {
                FileDescriptor fd = new FileDescriptor();
                fd.setInt$(this.mFd);
                Os.close(fd);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mMemoryReference.release();
            this.mMemoryReference = null;
        }
    }

    private static class Unmapper
    implements Runnable {
        private long mAddress;
        private int mSize;
        private MemoryRegistration mMemoryReference;

        private Unmapper(long address, int size, MemoryRegistration memoryReference) {
            this.mAddress = address;
            this.mSize = size;
            this.mMemoryReference = memoryReference;
        }

        @Override
        public void run() {
            try {
                Os.munmap(this.mAddress, this.mSize);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mMemoryReference.release();
            this.mMemoryReference = null;
        }
    }
}

