/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.PowerMonitor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Comparator;

@FlaggedApi(value="com.android.server.power.optimization.power_monitor_api")
public class PowerMonitorReadings {
    @FlaggedApi(value="com.android.server.power.optimization.power_monitor_api")
    public static final int ENERGY_UNAVAILABLE = -1;
    @NonNull
    private final PowerMonitor[] mPowerMonitors;
    @NonNull
    private final long[] mEnergyUws;
    @NonNull
    private final long[] mTimestampsMs;
    @SystemApi
    @FlaggedApi(value="android.permission.flags.fine_power_monitor_permission")
    public static final int GRANULARITY_UNSPECIFIED = 0;
    @SystemApi
    @FlaggedApi(value="android.permission.flags.fine_power_monitor_permission")
    public static final int GRANULARITY_FINE = 1;
    private final int mGranularity;
    private static final Comparator<PowerMonitor> POWER_MONITOR_COMPARATOR = Comparator.comparingInt(pm -> pm.index);

    public PowerMonitorReadings(@NonNull PowerMonitor[] powerMonitors, @NonNull long[] energyUws, @NonNull long[] timestampsMs, int granularity) {
        this.mPowerMonitors = powerMonitors;
        this.mEnergyUws = energyUws;
        this.mTimestampsMs = timestampsMs;
        this.mGranularity = granularity;
    }

    @FlaggedApi(value="com.android.server.power.optimization.power_monitor_api")
    public long getConsumedEnergy(@NonNull PowerMonitor powerMonitor) {
        int offset = Arrays.binarySearch(this.mPowerMonitors, powerMonitor, POWER_MONITOR_COMPARATOR);
        if (offset >= 0) {
            return this.mEnergyUws[offset];
        }
        return -1L;
    }

    @FlaggedApi(value="com.android.server.power.optimization.power_monitor_api")
    public long getTimestampMillis(@NonNull PowerMonitor powerMonitor) {
        int offset = Arrays.binarySearch(this.mPowerMonitors, powerMonitor, POWER_MONITOR_COMPARATOR);
        if (offset >= 0) {
            return this.mTimestampsMs[offset];
        }
        return 0L;
    }

    @SystemApi
    @FlaggedApi(value="android.permission.flags.fine_power_monitor_permission")
    public int getGranularity() {
        return this.mGranularity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" monitors: [");
        for (int i = 0; i < this.mPowerMonitors.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.mPowerMonitors[i].getName()).append(" = ").append(this.mEnergyUws[i]).append(" (").append(this.mTimestampsMs[i]).append(')');
        }
        sb.append("]");
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerMonitorGranularity {
    }
}

