/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.proto.ProtoOutputStream;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
class PowerComponents {
    private final BatteryConsumer.BatteryConsumerData mData;
    private static final String XML_TAG_CUSTOM_COMPONENT_COMPAT = "custom_component";

    PowerComponents(@NonNull Builder builder) {
        this.mData = builder.mData;
    }

    PowerComponents(BatteryConsumer.BatteryConsumerData data) {
        this.mData = data;
    }

    public double getConsumedPower(@NonNull BatteryConsumer.Dimensions dimensions) {
        return this.getConsumedPower(dimensions.powerComponentId, dimensions.processState, dimensions.screenState, dimensions.powerState);
    }

    public double getConsumedPower(int powerComponent, int processState, int screenState, int powerState) {
        if (powerComponent == -1 && processState == -1 && screenState == 0 && powerState == 0) {
            return this.mData.getDouble(this.mData.layout.totalConsumedPowerColumnIndex);
        }
        if (!this.mData.layout.processStateDataIncluded && processState != 0 && processState != -1) {
            return 0.0;
        }
        BatteryConsumer.Key key = this.mData.layout.getKey(powerComponent, this.mData.layout.processStateDataIncluded && processState != -1 ? processState : 0, this.mData.layout.screenStateDataIncluded && screenState != 0 ? screenState : 0, this.mData.layout.powerStateDataIncluded && powerState != 0 ? powerState : 0);
        if (key != null && this.mData.hasValue(key.mPowerColumnIndex)) {
            return this.mData.getDouble(key.mPowerColumnIndex);
        }
        double total = 0.0;
        for (BatteryConsumer.Key k : this.mData.layout.keys) {
            if (!k.matches(powerComponent, processState, screenState, powerState)) continue;
            total += this.mData.getDouble(k.mPowerColumnIndex);
        }
        return total;
    }

    public long getUsageDurationMillis(@NonNull BatteryConsumer.Dimensions dimensions) {
        return this.getUsageDurationMillis(dimensions.powerComponentId, dimensions.processState, dimensions.screenState, dimensions.powerState);
    }

    public long getUsageDurationMillis(int powerComponent, int processState, int screenState, int powerState) {
        BatteryConsumer.Key key = this.mData.layout.getKey(powerComponent, this.mData.layout.processStateDataIncluded && processState != -1 ? processState : 0, this.mData.layout.screenStateDataIncluded && screenState != 0 ? screenState : 0, this.mData.layout.powerStateDataIncluded && powerState != 0 ? powerState : 0);
        if (key != null && this.mData.hasValue(key.mDurationColumnIndex)) {
            return this.mData.getLong(key.mDurationColumnIndex);
        }
        long total = 0L;
        for (BatteryConsumer.Key k : this.mData.layout.keys) {
            if (!k.matches(powerComponent, processState, screenState, powerState)) continue;
            total += this.mData.getLong(k.mDurationColumnIndex);
        }
        return total;
    }

    public double getConsumedPower(@NonNull BatteryConsumer.Key key) {
        if (this.mData.hasValue(key.mPowerColumnIndex)) {
            return this.mData.getDouble(key.mPowerColumnIndex);
        }
        return this.getConsumedPower(key.powerComponentId, key.processState, key.screenState, key.powerState);
    }

    public String getCustomPowerComponentName(int componentId) {
        return this.mData.layout.getPowerComponentName(componentId);
    }

    public long getUsageDurationMillis(BatteryConsumer.Key key) {
        if (this.mData.hasValue(key.mDurationColumnIndex)) {
            return this.mData.getLong(key.mDurationColumnIndex);
        }
        return this.getUsageDurationMillis(key.powerComponentId, key.processState, key.screenState, key.powerState);
    }

    void dump(PrintWriter pw, int screenState, int powerState, boolean skipEmptyComponents) {
        StringBuilder sb = new StringBuilder();
        for (int id2 : this.mData.layout.powerComponentIds) {
            if (id2 == 18) continue;
            this.dump(sb, id2, -1, screenState, powerState, skipEmptyComponents);
            if (!this.mData.layout.processStateDataIncluded) continue;
            for (int processState = 0; processState < 5; ++processState) {
                if (processState == 0) continue;
                this.dump(sb, id2, processState, screenState, powerState, skipEmptyComponents);
            }
        }
        while (!sb.isEmpty() && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.setLength(sb.length() - 1);
        }
        pw.println(sb);
    }

    private void dump(StringBuilder sb, int powerComponent, int processState, int screenState, int powerState, boolean skipEmptyComponents) {
        double power = this.getConsumedPower(powerComponent, processState, screenState, powerState);
        long durationMs = this.getUsageDurationMillis(powerComponent, processState, screenState, powerState);
        if (skipEmptyComponents && power == 0.0 && durationMs == 0L) {
            return;
        }
        sb.append(this.mData.layout.getPowerComponentName(powerComponent));
        if (processState != -1) {
            sb.append(':');
            sb.append(BatteryConsumer.processStateToString(processState));
        }
        sb.append("=");
        sb.append(BatteryStats.formatCharge(power));
        if (durationMs != 0L) {
            sb.append(" (");
            BatteryStats.formatTimeMsNoSpace(sb, durationMs);
            sb.append(")");
        }
        sb.append(' ');
    }

    boolean hasStatsProtoData() {
        return this.writeStatsProtoImpl(null);
    }

    void writeStatsProto(@NonNull ProtoOutputStream proto) {
        this.writeStatsProtoImpl(proto);
    }

    private boolean writeStatsProtoImpl(@Nullable ProtoOutputStream proto) {
        boolean interestingData = false;
        for (int componentId : this.mData.layout.powerComponentIds) {
            BatteryConsumer.Key[] keys;
            for (BatteryConsumer.Key key : keys = this.mData.layout.getKeys(componentId)) {
                long powerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.getConsumedPower(key.powerComponentId, key.processState, key.screenState, key.powerState));
                long durationMs = this.getUsageDurationMillis(key.powerComponentId, key.processState, key.screenState, key.powerState);
                if (powerDeciCoulombs == 0L && durationMs == 0L) continue;
                interestingData = true;
                if (proto == null) {
                    return true;
                }
                if (key.processState == 0) {
                    this.writePowerComponentUsage(proto, 0x20B00000002L, componentId, powerDeciCoulombs, durationMs);
                    continue;
                }
                this.writePowerUsageSlice(proto, componentId, powerDeciCoulombs, durationMs, key.processState);
            }
        }
        return interestingData;
    }

    private void writePowerUsageSlice(ProtoOutputStream proto, int componentId, long powerDeciCoulombs, long durationMs, int processState) {
        int procState;
        long slicesToken = proto.start(2246267895811L);
        this.writePowerComponentUsage(proto, 0x10B00000001L, componentId, powerDeciCoulombs, durationMs);
        switch (processState) {
            case 1: {
                procState = 1;
                break;
            }
            case 2: {
                procState = 2;
                break;
            }
            case 3: {
                procState = 3;
                break;
            }
            case 4: {
                procState = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown process state: " + processState);
            }
        }
        proto.write(1159641169922L, procState);
        proto.end(slicesToken);
    }

    private void writePowerComponentUsage(ProtoOutputStream proto, long tag, int componentId, long powerDeciCoulombs, long durationMs) {
        long token = proto.start(tag);
        proto.write(0x10500000001L, componentId);
        proto.write(1112396529666L, powerDeciCoulombs);
        proto.write(0x10300000003L, durationMs);
        proto.end(token);
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(null, "power_components");
        for (BatteryConsumer.Key key : this.mData.layout.keys) {
            if (!this.mData.hasValue(key.mPowerColumnIndex) && !this.mData.hasValue(key.mDurationColumnIndex)) continue;
            double powerMah = this.getConsumedPower(key);
            long durationMs = this.getUsageDurationMillis(key);
            if (powerMah == 0.0 && durationMs == 0L) continue;
            serializer.startTag(null, "component");
            serializer.attributeInt(null, "id", key.powerComponentId);
            if (key.processState != 0) {
                serializer.attributeInt(null, "process_state", key.processState);
            }
            if (key.screenState != 0) {
                serializer.attributeInt(null, "screen_state", key.screenState);
            }
            if (key.powerState != 0) {
                serializer.attributeInt(null, "power_state", key.powerState);
            }
            if (powerMah != 0.0) {
                serializer.attributeDouble(null, "power", powerMah);
            }
            if (durationMs != 0L) {
                serializer.attributeLong(null, "duration", durationMs);
            }
            serializer.endTag(null, "component");
        }
        serializer.endTag(null, "power_components");
    }

    static void parseXml(TypedXmlPullParser parser, Builder builder) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("power_components")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        while (!(eventType == 3 && parser.getName().equals("power_components") || eventType == 1)) {
            if (eventType == 2) {
                switch (parser.getName()) {
                    case "component": 
                    case "custom_component": {
                        int componentId = -1;
                        int processState = 0;
                        int screenState = 0;
                        int powerState = 0;
                        double powerMah = 0.0;
                        long durationMs = 0L;
                        block24: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            switch (parser.getAttributeName(i)) {
                                case "id": {
                                    componentId = parser.getAttributeInt(i);
                                    continue block24;
                                }
                                case "process_state": {
                                    processState = parser.getAttributeInt(i);
                                    continue block24;
                                }
                                case "screen_state": {
                                    screenState = parser.getAttributeInt(i);
                                    continue block24;
                                }
                                case "power_state": {
                                    powerState = parser.getAttributeInt(i);
                                    continue block24;
                                }
                                case "power": {
                                    powerMah = parser.getAttributeDouble(i);
                                    continue block24;
                                }
                                case "duration": {
                                    durationMs = parser.getAttributeLong(i);
                                }
                            }
                        }
                        BatteryConsumer.Key key = builder.mData.layout.getKey(componentId, processState, screenState, powerState);
                        builder.addConsumedPower(key, powerMah);
                        builder.addUsageDurationMillis(key, durationMs);
                        break;
                    }
                }
            }
            eventType = parser.next();
        }
    }

    static class Builder {
        private final BatteryConsumer.BatteryConsumerData mData;
        private final double mMinConsumedPowerThreshold;

        Builder(BatteryConsumer.BatteryConsumerData data, double minConsumedPowerThreshold) {
            this.mData = data;
            this.mMinConsumedPowerThreshold = minConsumedPowerThreshold;
        }

        @Deprecated
        @NonNull
        public Builder setConsumedPower(BatteryConsumer.Key key, double componentPower) {
            this.mData.putDouble(key.mPowerColumnIndex, componentPower);
            return this;
        }

        @NonNull
        public Builder addConsumedPower(BatteryConsumer.Key key, double componentPower) {
            this.mData.putDouble(key.mPowerColumnIndex, this.mData.getDouble(key.mPowerColumnIndex) + componentPower);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setUsageDurationMillis(BatteryConsumer.Key key, long componentUsageDurationMillis) {
            this.mData.putLong(key.mDurationColumnIndex, componentUsageDurationMillis);
            return this;
        }

        @NonNull
        public Builder addUsageDurationMillis(BatteryConsumer.Key key, long componentUsageDurationMillis) {
            this.mData.putLong(key.mDurationColumnIndex, this.mData.getLong(key.mDurationColumnIndex) + componentUsageDurationMillis);
            return this;
        }

        public void addPowerAndDuration(Builder other) {
            this.addPowerAndDuration(other.mData);
        }

        public void addPowerAndDuration(PowerComponents other) {
            this.addPowerAndDuration(other.mData);
        }

        private void addPowerAndDuration(BatteryConsumer.BatteryConsumerData otherData) {
            if (this.mData.layout.customPowerComponentCount != otherData.layout.customPowerComponentCount) {
                throw new IllegalArgumentException("Number of custom power components does not match: " + otherData.layout.customPowerComponentCount + ", expected: " + this.mData.layout.customPowerComponentCount);
            }
            for (BatteryConsumer.Key key : this.mData.layout.keys) {
                BatteryConsumer.Key otherKey = otherData.layout.getKey(key.powerComponentId, key.processState, key.screenState, key.powerState);
                if (otherKey == null) continue;
                if (this.mData.hasValue(key.mPowerColumnIndex) || otherData.hasValue(otherKey.mPowerColumnIndex)) {
                    this.mData.putDouble(key.mPowerColumnIndex, this.mData.getDouble(key.mPowerColumnIndex) + otherData.getDouble(otherKey.mPowerColumnIndex));
                }
                if (!this.mData.hasValue(key.mDurationColumnIndex) && !otherData.hasValue(otherKey.mDurationColumnIndex)) continue;
                this.mData.putLong(key.mDurationColumnIndex, this.mData.getLong(key.mDurationColumnIndex) + otherData.getLong(otherKey.mDurationColumnIndex));
            }
        }

        public double getTotalPower() {
            double totalPowerMah = 0.0;
            for (BatteryConsumer.Key key : this.mData.layout.keys) {
                if (key.processState != 0 || key.screenState != 0 || key.powerState != 0) continue;
                totalPowerMah += this.mData.getDouble(key.mPowerColumnIndex);
            }
            return totalPowerMah;
        }

        @NonNull
        public PowerComponents build() {
            for (BatteryConsumer.Key key : this.mData.layout.keys) {
                if (this.mMinConsumedPowerThreshold == 0.0 || !(this.mData.getDouble(key.mPowerColumnIndex) < this.mMinConsumedPowerThreshold)) continue;
                this.mData.putDouble(key.mPowerColumnIndex, 0.0);
            }
            this.mData.putDouble(this.mData.layout.totalConsumedPowerColumnIndex, this.getTotalPower());
            return new PowerComponents(this);
        }
    }
}

