/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.app.AppOpsManager;
import android.content.AttributionSource;
import android.content.Context;
import android.content.PermissionChecker;
import android.permission.PermissionManager;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;

@RavenwoodKeepWholeClass
public class PermissionEnforcer {
    private final Context mContext;
    private static final String ACCESS_DENIED = "Access denied, requires: ";

    protected PermissionEnforcer() {
        this.mContext = null;
    }

    @RavenwoodThrow(blockedBy={PermissionManager.class}, reason="Use subclass for unit tests, such as FakePermissionEnforcer")
    public PermissionEnforcer(@NonNull Context context) {
        this.mContext = context;
    }

    protected int checkPermission(@NonNull String permission2, @NonNull AttributionSource source) {
        return PermissionChecker.checkPermissionForDataDelivery(this.mContext, permission2, -1, source, "");
    }

    protected int checkPermission(@NonNull String permission2, int pid, int uid) {
        if (this.mContext.checkPermission(permission2, pid, uid) == 0) {
            return 0;
        }
        return 2;
    }

    @RavenwoodReplace(blockedBy={AppOpsManager.class}, reason="Blocked on Mainline dependencies")
    private static int permissionToOpCode(String permission2) {
        return AppOpsManager.permissionToOpCode(permission2);
    }

    private static int permissionToOpCode$ravenwood(String permission2) {
        return -1;
    }

    private boolean anyAppOps(@NonNull String[] permissions) {
        for (String permission2 : permissions) {
            if (PermissionEnforcer.permissionToOpCode(permission2) == -1) continue;
            return true;
        }
        return false;
    }

    public void enforcePermission(@NonNull String permission2, @NonNull AttributionSource source) throws SecurityException {
        int result = this.checkPermission(permission2, source);
        if (result != 0) {
            throw new SecurityException(ACCESS_DENIED + permission2);
        }
    }

    public void enforcePermission(@NonNull String permission2, int pid, int uid) throws SecurityException {
        if (PermissionEnforcer.permissionToOpCode(permission2) != -1) {
            AttributionSource source = new AttributionSource(uid, null, null);
            this.enforcePermission(permission2, source);
            return;
        }
        int result = this.checkPermission(permission2, pid, uid);
        if (result != 0) {
            throw new SecurityException(ACCESS_DENIED + permission2);
        }
    }

    public void enforcePermissionAllOf(@NonNull String[] permissions, @NonNull AttributionSource source) throws SecurityException {
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, source);
            if (result == 0) continue;
            throw new SecurityException("Access denied, requires: allOf={" + String.join((CharSequence)", ", permissions) + "}");
        }
    }

    public void enforcePermissionAllOf(@NonNull String[] permissions, int pid, int uid) throws SecurityException {
        if (this.anyAppOps(permissions)) {
            AttributionSource source = new AttributionSource(uid, null, null);
            this.enforcePermissionAllOf(permissions, source);
            return;
        }
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, pid, uid);
            if (result == 0) continue;
            throw new SecurityException("Access denied, requires: allOf={" + String.join((CharSequence)", ", permissions) + "}");
        }
    }

    public void enforcePermissionAnyOf(@NonNull String[] permissions, @NonNull AttributionSource source) throws SecurityException {
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, source);
            if (result != 0) continue;
            return;
        }
        throw new SecurityException("Access denied, requires: anyOf={" + String.join((CharSequence)", ", permissions) + "}");
    }

    public void enforcePermissionAnyOf(@NonNull String[] permissions, int pid, int uid) throws SecurityException {
        if (this.anyAppOps(permissions)) {
            AttributionSource source = new AttributionSource(uid, null, null);
            this.enforcePermissionAnyOf(permissions, source);
            return;
        }
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, pid, uid);
            if (result != 0) continue;
            return;
        }
        throw new SecurityException("Access denied, requires: anyOf={" + String.join((CharSequence)", ", permissions) + "}");
    }

    public static PermissionEnforcer fromContext(@NonNull Context context) {
        return (PermissionEnforcer)context.getSystemService("permission_enforcer");
    }
}

