/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.PerfettoTrace_Category_Delegate;
import android.os.PerfettoTrackEventExtra;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import com.android.internal.hidden_from_bootclasspath.android.os.Flags;
import com.android.internal.ravenwood.RavenwoodEnvironment;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class PerfettoTrace {
    private static final String TAG = "PerfettoTrace";
    private static final int PERFETTO_TE_TYPE_SLICE_BEGIN = 1;
    private static final int PERFETTO_TE_TYPE_SLICE_END = 2;
    private static final int PERFETTO_TE_TYPE_INSTANT = 3;
    private static final int PERFETTO_TE_TYPE_COUNTER = 4;
    private static final boolean IS_FLAG_ENABLED = Flags.perfettoSdkTracingV2();
    private static final AtomicInteger sFlowEventId = new AtomicInteger();
    public static final Category MQ_CATEGORY = new Category("mq");

    @CriticalNative
    private static long native_get_process_track_uuid() {
        return OverrideMethod.invokeL("android.os.PerfettoTrace#native_get_process_track_uuid()J", true, null);
    }

    @CriticalNative
    private static long native_get_thread_track_uuid(long l) {
        return OverrideMethod.invokeL("android.os.PerfettoTrace#native_get_thread_track_uuid(J)J", true, null);
    }

    @FastNative
    private static void native_activate_trigger(String string2, int n) {
        OverrideMethod.invokeV("android.os.PerfettoTrace#native_activate_trigger(Ljava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void native_register(boolean bl) {
        OverrideMethod.invokeV("android.os.PerfettoTrace#native_register(Z)V", true, null);
    }

    private static long native_start_session(boolean bl, byte[] byArray) {
        return OverrideMethod.invokeL("android.os.PerfettoTrace#native_start_session(Z[B)J", true, null);
    }

    private static byte[] native_stop_session(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.PerfettoTrace#native_stop_session(J)[B", true, null);
    }

    public static PerfettoTrackEventExtra.Builder instant(Category category, String eventName) {
        return PerfettoTrackEventExtra.builder(category.isEnabled()).init(3, category).setEventName(eventName);
    }

    public static PerfettoTrackEventExtra.Builder begin(Category category, String eventName) {
        return PerfettoTrackEventExtra.builder(category.isEnabled()).init(1, category).setEventName(eventName);
    }

    public static PerfettoTrackEventExtra.Builder end(Category category) {
        return PerfettoTrackEventExtra.builder(category.isEnabled()).init(2, category);
    }

    public static PerfettoTrackEventExtra.Builder counter(Category category, long value) {
        return PerfettoTrackEventExtra.builder(category.isEnabled()).init(4, category).setCounter(value);
    }

    public static PerfettoTrackEventExtra.Builder counter(Category category, long value, String trackName) {
        return PerfettoTrace.counter(category, value).usingProcessCounterTrack(trackName);
    }

    public static PerfettoTrackEventExtra.Builder counter(Category category, double value) {
        return PerfettoTrackEventExtra.builder(category.isEnabled()).init(4, category).setCounter(value);
    }

    public static PerfettoTrackEventExtra.Builder counter(Category category, double value, String trackName) {
        return PerfettoTrace.counter(category, value).usingProcessCounterTrack(trackName);
    }

    public static int getFlowId() {
        return sFlowEventId.incrementAndGet();
    }

    public static long getGlobalTrackUuid() {
        return 0L;
    }

    public static long getProcessTrackUuid() {
        if (!IS_FLAG_ENABLED) {
            return 0L;
        }
        return PerfettoTrace.native_get_process_track_uuid();
    }

    public static long getThreadTrackUuid(long tid) {
        if (!IS_FLAG_ENABLED) {
            return 0L;
        }
        return PerfettoTrace.native_get_thread_track_uuid(tid);
    }

    public static void activateTrigger(String triggerName, int ttlMs) {
        if (!IS_FLAG_ENABLED) {
            return;
        }
        PerfettoTrace.native_activate_trigger(triggerName, ttlMs);
    }

    public static void register(boolean isBackendInProcess) {
        PerfettoTrace.native_register(isBackendInProcess);
    }

    public static void registerCategories() {
        MQ_CATEGORY.register();
    }

    @RavenwoodKeepWholeClass
    public static class Category
    implements PerfettoTrackEventExtra.PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Category.class.getClassLoader(), Category.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;
        private final String mTag;
        private final String mSeverity;
        private boolean mIsRegistered;

        public Category(String name) {
            this(name, "", "");
        }

        public Category(String name, String tag) {
            this(name, tag, "");
        }

        public Category(String name, String tag, String severity) {
            this.mName = name;
            this.mTag = tag;
            this.mSeverity = severity;
            this.mPtr = Category.native_init(name, tag, severity);
            this.mExtraPtr = Category.native_get_extra_ptr(this.mPtr);
            if (!RavenwoodEnvironment.getInstance().isRunningOnRavenwood()) {
                sRegistry.registerNativeAllocation(this, this.mPtr);
            }
        }

        @LayoutlibDelegate
        @FastNative
        @RavenwoodReplace
        private static long native_init(String string2, String string3, String string4) {
            return PerfettoTrace_Category_Delegate.native_init(string2, string3, string4);
        }

        @LayoutlibDelegate
        @CriticalNative
        @RavenwoodReplace
        private static long native_delete() {
            return PerfettoTrace_Category_Delegate.native_delete();
        }

        @CriticalNative
        private static void native_register(long l) {
            OverrideMethod.invokeV("android.os.PerfettoTrace$Category#native_register(J)V", true, null);
        }

        @CriticalNative
        private static void native_unregister(long l) {
            OverrideMethod.invokeV("android.os.PerfettoTrace$Category#native_unregister(J)V", true, null);
        }

        @CriticalNative
        private static boolean native_is_enabled(long l) {
            return OverrideMethod.invokeI("android.os.PerfettoTrace$Category#native_is_enabled(J)Z", true, null) != 0;
        }

        @CriticalNative
        @RavenwoodReplace
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrace$Category#native_get_extra_ptr(J)J", true, null);
        }

        private static long native_init$ravenwood(String name, String tag, String severity) {
            return 0L;
        }

        private static long native_delete$ravenwood() {
            return 0L;
        }

        private static long native_get_extra_ptr$ravenwood(long ptr) {
            return 0L;
        }

        public Category register() {
            Category.native_register(this.mPtr);
            this.mIsRegistered = true;
            return this;
        }

        public Category unregister() {
            Category.native_unregister(this.mPtr);
            this.mIsRegistered = false;
            return this;
        }

        @RavenwoodReplace
        public boolean isEnabled() {
            return IS_FLAG_ENABLED && Category.native_is_enabled(this.mPtr);
        }

        public boolean isEnabled$ravenwood() {
            return false;
        }

        public boolean isRegistered() {
            return this.mIsRegistered;
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }
    }

    public static class Session {
        private final long mPtr;

        public Session(boolean isBackendInProcess, byte[] config) {
            this.mPtr = PerfettoTrace.native_start_session(isBackendInProcess, config);
        }

        public byte[] close() {
            return PerfettoTrace.native_stop_session(this.mPtr);
        }
    }
}

