/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.CombinedVibration;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.IVibratorStateListener;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.VibrationAttributes;
import android.os.VibratorInfo;
import android.os.vibrator.IVibrationSessionCallback;

public interface IVibratorManagerService
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IVibratorManagerService";

    public int[] getVibratorIds() throws RemoteException;

    public int getCapabilities() throws RemoteException;

    public VibratorInfo getVibratorInfo(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public boolean isVibrating(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public boolean registerVibratorStateListener(int var1, IVibratorStateListener var2) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public boolean unregisterVibratorStateListener(int var1, IVibratorStateListener var2) throws RemoteException;

    public boolean setAlwaysOnEffect(int var1, String var2, int var3, CombinedVibration var4, VibrationAttributes var5) throws RemoteException;

    public void vibrate(int var1, int var2, String var3, CombinedVibration var4, VibrationAttributes var5, String var6, IBinder var7) throws RemoteException;

    public void cancelVibrate(int var1, IBinder var2) throws RemoteException;

    public void performHapticFeedback(int var1, int var2, String var3, int var4, int var5, String var6, int var7, int var8) throws RemoteException;

    public void performHapticFeedbackForInputDevice(int var1, int var2, String var3, int var4, int var5, int var6, String var7, int var8, int var9) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.VIBRATE", "android.permission.VIBRATE_VENDOR_EFFECTS", "android.permission.START_VIBRATION_SESSIONS"})
    public ICancellationSignal startVendorVibrationSession(int var1, int var2, String var3, int[] var4, VibrationAttributes var5, String var6, IVibrationSessionCallback var7) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVibratorManagerService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_getVibratorIds = 1;
        static final int TRANSACTION_getCapabilities = 2;
        static final int TRANSACTION_getVibratorInfo = 3;
        static final int TRANSACTION_isVibrating = 4;
        static final int TRANSACTION_registerVibratorStateListener = 5;
        static final int TRANSACTION_unregisterVibratorStateListener = 6;
        static final int TRANSACTION_setAlwaysOnEffect = 7;
        static final int TRANSACTION_vibrate = 8;
        static final int TRANSACTION_cancelVibrate = 9;
        static final int TRANSACTION_performHapticFeedback = 10;
        static final int TRANSACTION_performHapticFeedbackForInputDevice = 11;
        static final int TRANSACTION_startVendorVibrationSession = 12;
        static final String[] PERMISSIONS_startVendorVibrationSession = new String[]{"android.permission.VIBRATE", "android.permission.VIBRATE_VENDOR_EFFECTS", "android.permission.START_VIBRATION_SESSIONS"};

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IVibratorManagerService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IVibratorManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVibratorManagerService.DESCRIPTOR);
            if (iin != null && iin instanceof IVibratorManagerService) {
                return (IVibratorManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getVibratorIds";
                }
                case 2: {
                    return "getCapabilities";
                }
                case 3: {
                    return "getVibratorInfo";
                }
                case 4: {
                    return "isVibrating";
                }
                case 5: {
                    return "registerVibratorStateListener";
                }
                case 6: {
                    return "unregisterVibratorStateListener";
                }
                case 7: {
                    return "setAlwaysOnEffect";
                }
                case 8: {
                    return "vibrate";
                }
                case 9: {
                    return "cancelVibrate";
                }
                case 10: {
                    return "performHapticFeedback";
                }
                case 11: {
                    return "performHapticFeedbackForInputDevice";
                }
                case 12: {
                    return "startVendorVibrationSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVibratorManagerService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int[] _result = this.getVibratorIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 2: {
                    int _result = this.getCapabilities();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    VibratorInfo _result = this.getVibratorInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVibrating(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    IVibratorStateListener _arg1 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerVibratorStateListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    IVibratorStateListener _arg1 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterVibratorStateListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    CombinedVibration _arg3 = data.readTypedObject(CombinedVibration.CREATOR);
                    VibrationAttributes _arg4 = data.readTypedObject(VibrationAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setAlwaysOnEffect(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    CombinedVibration _arg3 = data.readTypedObject(CombinedVibration.CREATOR);
                    VibrationAttributes _arg4 = data.readTypedObject(VibrationAttributes.CREATOR);
                    String _arg5 = data.readString();
                    IBinder _arg6 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.vibrate(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.cancelVibrate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.performHapticFeedback(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    int _arg7 = data.readInt();
                    int _arg8 = data.readInt();
                    data.enforceNoDataAvail();
                    this.performHapticFeedbackForInputDevice(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int[] _arg3 = data.createIntArray();
                    VibrationAttributes _arg4 = data.readTypedObject(VibrationAttributes.CREATOR);
                    String _arg5 = data.readString();
                    IVibrationSessionCallback _arg6 = IVibrationSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.startVendorVibrationSession(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void isVibrating_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VIBRATOR_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerVibratorStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VIBRATOR_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterVibratorStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VIBRATOR_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startVendorVibrationSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_startVendorVibrationSession, Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IVibratorManagerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVibratorManagerService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getVibratorIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCapabilities() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VibratorInfo getVibratorInfo(int vibratorId) throws RemoteException {
                VibratorInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(vibratorId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VibratorInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVibrating(int vibratorId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(vibratorId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerVibratorStateListener(int vibratorId, IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(vibratorId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterVibratorStateListener(int vibratorId, IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(vibratorId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, CombinedVibration vibration, VibrationAttributes attributes) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(opPkg);
                    _data.writeInt(alwaysOnId);
                    _data.writeTypedObject(vibration, 0);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrate(int uid, int deviceId, String opPkg, CombinedVibration vibration, VibrationAttributes attributes, String reason, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(deviceId);
                    _data.writeString(opPkg);
                    _data.writeTypedObject(vibration, 0);
                    _data.writeTypedObject(attributes, 0);
                    _data.writeString(reason);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelVibrate(int usageFilter, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(usageFilter);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performHapticFeedback(int uid, int deviceId, String opPkg, int constant, int usage, String reason, int flags, int privFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(deviceId);
                    _data.writeString(opPkg);
                    _data.writeInt(constant);
                    _data.writeInt(usage);
                    _data.writeString(reason);
                    _data.writeInt(flags);
                    _data.writeInt(privFlags);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performHapticFeedbackForInputDevice(int uid, int deviceId, String opPkg, int constant, int inputDeviceId, int inputSource, String reason, int flags, int privFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(deviceId);
                    _data.writeString(opPkg);
                    _data.writeInt(constant);
                    _data.writeInt(inputDeviceId);
                    _data.writeInt(inputSource);
                    _data.writeString(reason);
                    _data.writeInt(flags);
                    _data.writeInt(privFlags);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal startVendorVibrationSession(int uid, int deviceId, String opPkg, int[] vibratorIds, VibrationAttributes attributes, String reason, IVibrationSessionCallback callback) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibratorManagerService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(deviceId);
                    _data.writeString(opPkg);
                    _data.writeIntArray(vibratorIds);
                    _data.writeTypedObject(attributes, 0);
                    _data.writeString(reason);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IVibratorManagerService {
        @Override
        public int[] getVibratorIds() throws RemoteException {
            return null;
        }

        @Override
        public int getCapabilities() throws RemoteException {
            return 0;
        }

        @Override
        public VibratorInfo getVibratorInfo(int vibratorId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isVibrating(int vibratorId) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerVibratorStateListener(int vibratorId, IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterVibratorStateListener(int vibratorId, IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, CombinedVibration vibration, VibrationAttributes attributes) throws RemoteException {
            return false;
        }

        @Override
        public void vibrate(int uid, int deviceId, String opPkg, CombinedVibration vibration, VibrationAttributes attributes, String reason, IBinder token) throws RemoteException {
        }

        @Override
        public void cancelVibrate(int usageFilter, IBinder token) throws RemoteException {
        }

        @Override
        public void performHapticFeedback(int uid, int deviceId, String opPkg, int constant, int usage, String reason, int flags, int privFlags) throws RemoteException {
        }

        @Override
        public void performHapticFeedbackForInputDevice(int uid, int deviceId, String opPkg, int constant, int inputDeviceId, int inputSource, String reason, int flags, int privFlags) throws RemoteException {
        }

        @Override
        public ICancellationSignal startVendorVibrationSession(int uid, int deviceId, String opPkg, int[] vibratorIds, VibrationAttributes attributes, String reason, IVibrationSessionCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

