/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IProfilingResultCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IProfilingResultCallback";

    public void sendResult(String var1, long var2, long var4, int var6, String var7, String var8, int var9) throws RemoteException;

    public void generateFile(String var1, String var2, long var3, long var5) throws RemoteException;

    public void deleteFile(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IProfilingResultCallback {
        static final int TRANSACTION_sendResult = 1;
        static final int TRANSACTION_generateFile = 2;
        static final int TRANSACTION_deleteFile = 3;

        public Stub() {
            this.attachInterface(this, IProfilingResultCallback.DESCRIPTOR);
        }

        public static IProfilingResultCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IProfilingResultCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IProfilingResultCallback) {
                return (IProfilingResultCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendResult";
                }
                case 2: {
                    return "generateFile";
                }
                case 3: {
                    return "deleteFile";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IProfilingResultCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendResult(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.generateFile(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteFile(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IProfilingResultCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IProfilingResultCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResult(String resultFile, long keyMostSigBits, long keyLeastSigBits, int status, String tag, String error, int triggerType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingResultCallback.DESCRIPTOR);
                    _data.writeString(resultFile);
                    _data.writeLong(keyMostSigBits);
                    _data.writeLong(keyLeastSigBits);
                    _data.writeInt(status);
                    _data.writeString(tag);
                    _data.writeString(error);
                    _data.writeInt(triggerType);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateFile(String filePathRelative, String fileName, long keyMostSigBits, long keyLeastSigBits) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingResultCallback.DESCRIPTOR);
                    _data.writeString(filePathRelative);
                    _data.writeString(fileName);
                    _data.writeLong(keyMostSigBits);
                    _data.writeLong(keyLeastSigBits);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteFile(String relativeFilePathAndName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingResultCallback.DESCRIPTOR);
                    _data.writeString(relativeFilePathAndName);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IProfilingResultCallback {
        @Override
        public void sendResult(String resultFile, long keyMostSigBits, long keyLeastSigBits, int status, String tag, String error, int triggerType) throws RemoteException {
        }

        @Override
        public void generateFile(String filePathRelative, String fileName, long keyMostSigBits, long keyLeastSigBits) throws RemoteException {
        }

        @Override
        public void deleteFile(String relativeFilePathAndName) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

