/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.IntArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@RavenwoodKeepWholeClass
public class BatteryUsageStatsQuery
implements Parcelable {
    @NonNull
    public static final BatteryUsageStatsQuery DEFAULT = new Builder().build();
    public static final int FLAG_BATTERY_USAGE_STATS_POWER_PROFILE_MODEL = 1;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_HISTORY = 2;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_PROCESS_STATE_DATA = 8;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_VIRTUAL_UIDS = 16;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_SCREEN_STATE = 32;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_POWER_STATE = 64;
    public static final int FLAG_BATTERY_USAGE_STATS_ACCUMULATED = 128;
    private static final long DEFAULT_MAX_STATS_AGE_MS = 300000L;
    private static final long DEFAULT_PREFERRED_HISTORY_DURATION_MS = TimeUnit.HOURS.toMillis(2L);
    private final int mFlags;
    @NonNull
    private final int[] mUserIds;
    private final long mMaxStatsAgeMs;
    private final long mAggregatedFromTimestamp;
    private final long mAggregatedToTimestamp;
    private long mMonotonicStartTime;
    private long mMonotonicEndTime;
    private final double mMinConsumedPowerThreshold;
    private final int[] mPowerComponents;
    private final long mPreferredHistoryDurationMs;
    @NonNull
    public static final Parcelable.Creator<BatteryUsageStatsQuery> CREATOR = new Parcelable.Creator<BatteryUsageStatsQuery>(){

        @Override
        public BatteryUsageStatsQuery createFromParcel(Parcel in) {
            return new BatteryUsageStatsQuery(in);
        }

        public BatteryUsageStatsQuery[] newArray(int size) {
            return new BatteryUsageStatsQuery[size];
        }
    };

    private BatteryUsageStatsQuery(@NonNull Builder builder) {
        int[] nArray;
        this.mFlags = builder.mFlags;
        if (builder.mUserIds != null) {
            nArray = builder.mUserIds.toArray();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        }
        this.mUserIds = nArray;
        this.mMaxStatsAgeMs = builder.mMaxStatsAgeMs;
        this.mMinConsumedPowerThreshold = builder.mMinConsumedPowerThreshold;
        this.mAggregatedFromTimestamp = builder.mAggregateFromTimestamp;
        this.mAggregatedToTimestamp = builder.mAggregateToTimestamp;
        this.mMonotonicStartTime = builder.mMonotonicStartTime;
        this.mMonotonicEndTime = builder.mMonotonicEndTime;
        this.mPowerComponents = builder.mPowerComponents;
        this.mPreferredHistoryDurationMs = builder.mPreferredHistoryDurationMs;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @NonNull
    public int[] getUserIds() {
        return this.mUserIds;
    }

    public boolean shouldForceUsePowerProfileModel() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isProcessStateDataNeeded() {
        return (this.mFlags & 8) != 0;
    }

    public boolean isScreenStateDataNeeded() {
        return (this.mFlags & 0x20) != 0;
    }

    public boolean isPowerStateDataNeeded() {
        return (this.mFlags & 0x40) != 0;
    }

    public int[] getPowerComponents() {
        return this.mPowerComponents;
    }

    public long getMaxStatsAge() {
        return this.mMaxStatsAgeMs;
    }

    public double getMinConsumedPowerThreshold() {
        return this.mMinConsumedPowerThreshold;
    }

    public long getMonotonicStartTime() {
        return this.mMonotonicStartTime;
    }

    public long getMonotonicEndTime() {
        return this.mMonotonicEndTime;
    }

    public long getAggregatedFromTimestamp() {
        return this.mAggregatedFromTimestamp;
    }

    public long getAggregatedToTimestamp() {
        return this.mAggregatedToTimestamp;
    }

    public long getPreferredHistoryDurationMs() {
        return this.mPreferredHistoryDurationMs;
    }

    public String toString() {
        return "BatteryUsageStatsQuery{mFlags=" + Integer.toHexString(this.mFlags) + ", mUserIds=" + Arrays.toString(this.mUserIds) + ", mMaxStatsAgeMs=" + this.mMaxStatsAgeMs + ", mAggregatedFromTimestamp=" + this.mAggregatedFromTimestamp + ", mAggregatedToTimestamp=" + this.mAggregatedToTimestamp + ", mMonotonicStartTime=" + this.mMonotonicStartTime + ", mMonotonicEndTime=" + this.mMonotonicEndTime + ", mMinConsumedPowerThreshold=" + this.mMinConsumedPowerThreshold + ", mPowerComponents=" + Arrays.toString(this.mPowerComponents) + ", mMaxHistoryDurationMs=" + this.mPreferredHistoryDurationMs + '}';
    }

    private BatteryUsageStatsQuery(Parcel in) {
        this.mMonotonicStartTime = in.readLong();
        this.mMonotonicEndTime = in.readLong();
        this.mFlags = in.readInt();
        this.mUserIds = new int[in.readInt()];
        in.readIntArray(this.mUserIds);
        this.mMaxStatsAgeMs = in.readLong();
        this.mMinConsumedPowerThreshold = in.readDouble();
        this.mAggregatedFromTimestamp = in.readLong();
        this.mAggregatedToTimestamp = in.readLong();
        this.mPowerComponents = in.createIntArray();
        this.mPreferredHistoryDurationMs = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mMonotonicStartTime);
        dest.writeLong(this.mMonotonicEndTime);
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mUserIds.length);
        dest.writeIntArray(this.mUserIds);
        dest.writeLong(this.mMaxStatsAgeMs);
        dest.writeDouble(this.mMinConsumedPowerThreshold);
        dest.writeLong(this.mAggregatedFromTimestamp);
        dest.writeLong(this.mAggregatedToTimestamp);
        dest.writeIntArray(this.mPowerComponents);
        dest.writeLong(this.mPreferredHistoryDurationMs);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private int mFlags;
        private IntArray mUserIds;
        private long mMaxStatsAgeMs = 300000L;
        private long mMonotonicStartTime = -1L;
        private long mMonotonicEndTime = -1L;
        private long mAggregateFromTimestamp;
        private long mAggregateToTimestamp;
        private double mMinConsumedPowerThreshold = 0.0;
        private int[] mPowerComponents;
        private long mPreferredHistoryDurationMs = DEFAULT_PREFERRED_HISTORY_DURATION_MS;

        public BatteryUsageStatsQuery build() {
            return new BatteryUsageStatsQuery(this);
        }

        public Builder monotonicTimeRange(long monotonicStartTime, long monotonicEndTime) {
            this.mMonotonicStartTime = monotonicStartTime;
            this.mMonotonicEndTime = monotonicEndTime;
            return this;
        }

        public Builder addUser(@NonNull UserHandle userHandle) {
            if (this.mUserIds == null) {
                this.mUserIds = new IntArray(1);
            }
            this.mUserIds.add(userHandle.getIdentifier());
            return this;
        }

        public Builder includeBatteryHistory() {
            this.mFlags |= 2;
            return this;
        }

        public Builder setPreferredHistoryDurationMs(long preferredHistoryDurationMs) {
            this.mPreferredHistoryDurationMs = preferredHistoryDurationMs;
            return this;
        }

        public Builder includeProcessStateData() {
            this.mFlags |= 8;
            return this;
        }

        @Deprecated
        public Builder powerProfileModeledOnly() {
            this.mFlags |= 1;
            return this;
        }

        @Deprecated
        public Builder includePowerModels() {
            return this;
        }

        public Builder includePowerComponents(int[] powerComponents) {
            this.mPowerComponents = powerComponents;
            return this;
        }

        public Builder includeVirtualUids() {
            this.mFlags |= 0x10;
            return this;
        }

        public Builder includeScreenStateData() {
            this.mFlags |= 0x20;
            return this;
        }

        public Builder includePowerStateData() {
            this.mFlags |= 0x40;
            return this;
        }

        public Builder accumulated() {
            this.mFlags |= 0xE8;
            return this;
        }

        public Builder aggregateSnapshots(long fromTimestamp, long toTimestamp) {
            this.mAggregateFromTimestamp = fromTimestamp;
            this.mAggregateToTimestamp = toTimestamp;
            return this;
        }

        public Builder setMaxStatsAgeMs(long maxStatsAgeMs) {
            this.mMaxStatsAgeMs = maxStatsAgeMs;
            return this;
        }

        public Builder setMinConsumedPowerThreshold(double minConsumedPowerThreshold) {
            this.mMinConsumedPowerThreshold = minConsumedPowerThreshold;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BatteryUsageStatsFlags {
    }
}

