/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.database.CursorWindow;
import android.os.AggregateBatteryConsumer;
import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UidBatteryConsumer;
import android.os.UserBatteryConsumer;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Range;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BatteryStatsHistory;
import com.android.internal.os.BatteryStatsHistoryIterator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public class BatteryUsageStats
implements Parcelable,
Closeable {
    public static final int AGGREGATE_BATTERY_CONSUMER_SCOPE_DEVICE = 0;
    public static final int AGGREGATE_BATTERY_CONSUMER_SCOPE_ALL_APPS = 1;
    public static final int AGGREGATE_BATTERY_CONSUMER_SCOPE_COUNT = 2;
    static final String XML_TAG_BATTERY_USAGE_STATS = "battery_usage_stats";
    static final String XML_TAG_AGGREGATE = "aggregate";
    static final String XML_TAG_UID = "uid";
    static final String XML_TAG_USER = "user";
    static final String XML_TAG_POWER_COMPONENTS = "power_components";
    static final String XML_TAG_COMPONENT = "component";
    static final String XML_ATTR_ID = "id";
    static final String XML_ATTR_UID = "uid";
    static final String XML_ATTR_USER_ID = "user_id";
    static final String XML_ATTR_SCOPE = "scope";
    static final String XML_ATTR_PREFIX_CUSTOM_COMPONENT = "custom_component_";
    static final String XML_ATTR_PREFIX_INCLUDES_PROC_STATE_DATA = "includes_proc_state_data";
    static final String XML_ATTR_PREFIX_INCLUDES_SCREEN_STATE_DATA = "includes_screen_state_data";
    static final String XML_ATTR_PREFIX_INCLUDES_POWER_STATE_DATA = "includes_power_state_data";
    static final String XML_ATTR_START_TIMESTAMP = "start_timestamp";
    static final String XML_ATTR_END_TIMESTAMP = "end_timestamp";
    static final String XML_ATTR_PROCESS_STATE = "process_state";
    static final String XML_ATTR_SCREEN_STATE = "screen_state";
    static final String XML_ATTR_POWER_STATE = "power_state";
    static final String XML_ATTR_POWER = "power";
    static final String XML_ATTR_DURATION = "duration";
    static final String XML_ATTR_BATTERY_CAPACITY = "battery_capacity";
    static final String XML_ATTR_DISCHARGE_PERCENT = "discharge_pct";
    static final String XML_ATTR_DISCHARGE_LOWER = "discharge_lower";
    static final String XML_ATTR_DISCHARGE_UPPER = "discharge_upper";
    static final String XML_ATTR_DISCHARGE_DURATION = "discharge_duration";
    static final String XML_ATTR_BATTERY_REMAINING = "battery_remaining";
    static final String XML_ATTR_CHARGE_REMAINING = "charge_remaining";
    static final String XML_ATTR_HIGHEST_DRAIN_PACKAGE = "highest_drain_package";
    static final String XML_ATTR_TIME_IN_FOREGROUND = "time_in_foreground";
    static final String XML_ATTR_TIME_IN_BACKGROUND = "time_in_background";
    static final String XML_ATTR_TIME_IN_FOREGROUND_SERVICE = "time_in_foreground_service";
    private static final long BATTERY_CONSUMER_CURSOR_WINDOW_SIZE = 20000000L;
    private static final int STATSD_PULL_ATOM_MAX_BYTES = 45000;
    private static final int[] UID_USAGE_TIME_PROCESS_STATES = new int[]{1, 2, 3};
    private final int mDischargePercentage;
    private final double mBatteryCapacityMah;
    private final long mStatsStartTimestampMs;
    private final long mStatsEndTimestampMs;
    private final long mStatsDurationMs;
    private final double mDischargedPowerLowerBound;
    private final double mDischargedPowerUpperBound;
    private final long mDischargeDurationMs;
    private final long mBatteryTimeRemainingMs;
    private final long mChargeTimeRemainingMs;
    private final String[] mCustomPowerComponentNames;
    private final boolean mIncludesProcessStateData;
    private final boolean mIncludesScreenStateData;
    private final boolean mIncludesPowerStateData;
    private final List<UidBatteryConsumer> mUidBatteryConsumers;
    private final List<UserBatteryConsumer> mUserBatteryConsumers;
    private final AggregateBatteryConsumer[] mAggregateBatteryConsumers;
    private final BatteryStatsHistory mBatteryStatsHistory;
    private final long mPreferredHistoryDurationMs;
    private final BatteryConsumer.BatteryConsumerDataLayout mBatteryConsumerDataLayout;
    private CursorWindow mBatteryConsumersCursorWindow;
    @NonNull
    public static final Parcelable.Creator<BatteryUsageStats> CREATOR = new Parcelable.Creator<BatteryUsageStats>(){

        @Override
        public BatteryUsageStats createFromParcel(@NonNull Parcel source) {
            return new BatteryUsageStats(source);
        }

        public BatteryUsageStats[] newArray(int size) {
            return new BatteryUsageStats[size];
        }
    };
    private static final double WEIGHT_CONSUMED_POWER = 1.0;
    private static final double WEIGHT_FOREGROUND_STATE = 2.777777777777778E-5;
    private static final double WEIGHT_BACKGROUND_STATE = 8.333333333333333E-5;
    private static volatile boolean sInstanceLeakDetectionEnabled;
    @GuardedBy(value={"BatteryUsageStats.class"})
    private static Map<CursorWindow, Exception> sInstances;

    private BatteryUsageStats(@NonNull Builder builder) {
        int i;
        BatteryConsumer consumer;
        this.mStatsStartTimestampMs = builder.mStatsStartTimestampMs;
        this.mStatsEndTimestampMs = builder.mStatsEndTimestampMs;
        this.mStatsDurationMs = builder.getStatsDuration();
        this.mBatteryCapacityMah = builder.mBatteryCapacityMah;
        this.mDischargePercentage = builder.mDischargePercentage;
        this.mDischargedPowerLowerBound = builder.mDischargedPowerLowerBoundMah;
        this.mDischargedPowerUpperBound = builder.mDischargedPowerUpperBoundMah;
        this.mDischargeDurationMs = builder.mDischargeDurationMs;
        this.mBatteryStatsHistory = builder.mBatteryStatsHistory;
        this.mPreferredHistoryDurationMs = builder.mPreferredHistoryDurationMs;
        this.mBatteryTimeRemainingMs = builder.mBatteryTimeRemainingMs;
        this.mChargeTimeRemainingMs = builder.mChargeTimeRemainingMs;
        this.mCustomPowerComponentNames = builder.mCustomPowerComponentNames;
        this.mIncludesProcessStateData = builder.mIncludesProcessStateData;
        this.mIncludesScreenStateData = builder.mIncludesScreenStateData;
        this.mIncludesPowerStateData = builder.mIncludesPowerStateData;
        this.mBatteryConsumerDataLayout = builder.mBatteryConsumerDataLayout;
        this.mBatteryConsumersCursorWindow = builder.mBatteryConsumersCursorWindow;
        double totalPowerMah = 0.0;
        int uidBatteryConsumerCount = builder.mUidBatteryConsumerBuilders.size();
        this.mUidBatteryConsumers = new ArrayList<UidBatteryConsumer>(uidBatteryConsumerCount);
        for (int i2 = 0; i2 < uidBatteryConsumerCount; ++i2) {
            UidBatteryConsumer.Builder uidBatteryConsumerBuilder = builder.mUidBatteryConsumerBuilders.valueAt(i2);
            if (uidBatteryConsumerBuilder.isExcludedFromBatteryUsageStats()) continue;
            consumer = uidBatteryConsumerBuilder.build();
            totalPowerMah += consumer.getConsumedPower();
            this.mUidBatteryConsumers.add((UidBatteryConsumer)consumer);
        }
        int userBatteryConsumerCount = builder.mUserBatteryConsumerBuilders.size();
        this.mUserBatteryConsumers = new ArrayList<UserBatteryConsumer>(userBatteryConsumerCount);
        for (i = 0; i < userBatteryConsumerCount; ++i) {
            consumer = builder.mUserBatteryConsumerBuilders.valueAt(i).build();
            totalPowerMah += consumer.getConsumedPower();
            this.mUserBatteryConsumers.add((UserBatteryConsumer)consumer);
        }
        builder.getAggregateBatteryConsumerBuilder(1).addConsumedPower(totalPowerMah);
        this.mAggregateBatteryConsumers = new AggregateBatteryConsumer[2];
        for (i = 0; i < 2; ++i) {
            this.mAggregateBatteryConsumers[i] = builder.mAggregateBatteryConsumersBuilders[i].build();
        }
    }

    public long getStatsStartTimestamp() {
        return this.mStatsStartTimestampMs;
    }

    public long getStatsEndTimestamp() {
        return this.mStatsEndTimestampMs;
    }

    public long getStatsDuration() {
        return this.mStatsDurationMs;
    }

    public double getConsumedPower() {
        return this.mAggregateBatteryConsumers[0].getConsumedPower();
    }

    public double getBatteryCapacity() {
        return this.mBatteryCapacityMah;
    }

    public int getDischargePercentage() {
        return this.mDischargePercentage;
    }

    public Range<Double> getDischargedPowerRange() {
        return Range.create(this.mDischargedPowerLowerBound, this.mDischargedPowerUpperBound);
    }

    public long getDischargeDurationMs() {
        return this.mDischargeDurationMs;
    }

    public long getBatteryTimeRemainingMs() {
        return this.mBatteryTimeRemainingMs;
    }

    public long getChargeTimeRemainingMs() {
        return this.mChargeTimeRemainingMs;
    }

    public AggregateBatteryConsumer getAggregateBatteryConsumer(int scope) {
        return this.mAggregateBatteryConsumers[scope];
    }

    @NonNull
    public List<UidBatteryConsumer> getUidBatteryConsumers() {
        return this.mUidBatteryConsumers;
    }

    @NonNull
    public List<UserBatteryConsumer> getUserBatteryConsumers() {
        return this.mUserBatteryConsumers;
    }

    @NonNull
    public String[] getCustomPowerComponentNames() {
        return this.mCustomPowerComponentNames;
    }

    public boolean isProcessStateDataIncluded() {
        return this.mIncludesProcessStateData;
    }

    @NonNull
    public BatteryStatsHistoryIterator iterateBatteryStatsHistory() {
        if (this.mBatteryStatsHistory == null) {
            throw new IllegalStateException("Battery history was not requested in the BatteryUsageStatsQuery");
        }
        return new BatteryStatsHistoryIterator(this.mBatteryStatsHistory, 0L, -1L);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private BatteryUsageStats(@NonNull Parcel source) {
        this.mStatsStartTimestampMs = source.readLong();
        this.mStatsEndTimestampMs = source.readLong();
        this.mStatsDurationMs = source.readLong();
        this.mBatteryCapacityMah = source.readDouble();
        this.mDischargePercentage = source.readInt();
        this.mDischargedPowerLowerBound = source.readDouble();
        this.mDischargedPowerUpperBound = source.readDouble();
        this.mDischargeDurationMs = source.readLong();
        this.mBatteryTimeRemainingMs = source.readLong();
        this.mChargeTimeRemainingMs = source.readLong();
        this.mCustomPowerComponentNames = source.readStringArray();
        this.mIncludesProcessStateData = source.readBoolean();
        this.mIncludesScreenStateData = source.readBoolean();
        this.mIncludesPowerStateData = source.readBoolean();
        this.mBatteryConsumersCursorWindow = CursorWindow.newFromParcel(source);
        this.mBatteryConsumerDataLayout = BatteryConsumer.createBatteryConsumerDataLayout(this.mCustomPowerComponentNames, this.mIncludesProcessStateData, this.mIncludesScreenStateData, this.mIncludesPowerStateData);
        int numRows = this.mBatteryConsumersCursorWindow.getNumRows();
        this.mAggregateBatteryConsumers = new AggregateBatteryConsumer[2];
        this.mUidBatteryConsumers = new ArrayList<UidBatteryConsumer>(numRows);
        this.mUserBatteryConsumers = new ArrayList<UserBatteryConsumer>();
        block5: for (int i = 0; i < numRows; ++i) {
            BatteryConsumer.BatteryConsumerData data = new BatteryConsumer.BatteryConsumerData(this.mBatteryConsumersCursorWindow, i, this.mBatteryConsumerDataLayout);
            int consumerType = this.mBatteryConsumersCursorWindow.getInt(i, 0);
            switch (consumerType) {
                case 0: {
                    AggregateBatteryConsumer consumer;
                    this.mAggregateBatteryConsumers[consumer.getScope()] = consumer = new AggregateBatteryConsumer(data);
                    continue block5;
                }
                case 1: {
                    this.mUidBatteryConsumers.add(new UidBatteryConsumer(data));
                    continue block5;
                }
                case 2: {
                    this.mUserBatteryConsumers.add(new UserBatteryConsumer(data));
                }
            }
        }
        if (source.readBoolean()) {
            this.mBatteryStatsHistory = BatteryStatsHistory.createFromBatteryUsageStatsParcel(source);
            this.mPreferredHistoryDurationMs = source.readLong();
        } else {
            this.mBatteryStatsHistory = null;
            this.mPreferredHistoryDurationMs = 0L;
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mStatsStartTimestampMs);
        dest.writeLong(this.mStatsEndTimestampMs);
        dest.writeLong(this.mStatsDurationMs);
        dest.writeDouble(this.mBatteryCapacityMah);
        dest.writeInt(this.mDischargePercentage);
        dest.writeDouble(this.mDischargedPowerLowerBound);
        dest.writeDouble(this.mDischargedPowerUpperBound);
        dest.writeLong(this.mDischargeDurationMs);
        dest.writeLong(this.mBatteryTimeRemainingMs);
        dest.writeLong(this.mChargeTimeRemainingMs);
        dest.writeStringArray(this.mCustomPowerComponentNames);
        dest.writeBoolean(this.mIncludesProcessStateData);
        dest.writeBoolean(this.mIncludesScreenStateData);
        dest.writeBoolean(this.mIncludesPowerStateData);
        this.mBatteryConsumersCursorWindow.writeToParcel(dest, flags);
        if (this.mBatteryStatsHistory != null) {
            dest.writeBoolean(true);
            this.mBatteryStatsHistory.writeToBatteryUsageStatsParcel(dest, this.mPreferredHistoryDurationMs);
        } else {
            dest.writeBoolean(false);
        }
    }

    public byte[] getStatsProto() {
        int maxRawSize = 78750;
        for (int i = 0; i < 3; ++i) {
            ProtoOutputStream proto = new ProtoOutputStream();
            this.writeStatsProto(proto, maxRawSize);
            int rawSize = proto.getRawSize();
            byte[] protoOutput = proto.getBytes();
            if (protoOutput.length <= 45000) {
                return protoOutput;
            }
            maxRawSize = (int)(45000L * (long)rawSize / (long)protoOutput.length - 1024L);
        }
        ProtoOutputStream proto = new ProtoOutputStream();
        this.writeStatsProto(proto, 45000);
        return proto.getBytes();
    }

    public void dumpToProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        this.writeStatsProto(proto, Integer.MAX_VALUE);
        proto.flush();
    }

    @NonNull
    private void writeStatsProto(ProtoOutputStream proto, int maxRawSize) {
        AggregateBatteryConsumer deviceBatteryConsumer = this.getAggregateBatteryConsumer(0);
        proto.write(0x10300000001L, this.getStatsStartTimestamp());
        proto.write(1112396529666L, this.getStatsEndTimestamp());
        proto.write(0x10300000003L, this.getStatsDuration());
        proto.write(1120986464262L, this.getDischargePercentage());
        proto.write(1112396529671L, this.getDischargeDurationMs());
        deviceBatteryConsumer.writeStatsProto(proto, 1146756268036L);
        this.writeUidBatteryConsumersProto(proto, maxRawSize);
    }

    private void writeUidBatteryConsumersProto(ProtoOutputStream proto, int maxRawSize) {
        List<UidBatteryConsumer> consumers = this.getUidBatteryConsumers();
        consumers.sort(Comparator.comparingDouble(this::getUidBatteryConsumerWeight).reversed());
        int size = consumers.size();
        for (int i = 0; i < size; ++i) {
            UidBatteryConsumer consumer = consumers.get(i);
            long fgMs = consumer.getTimeInStateMs(0);
            long bgMs = consumer.getTimeInStateMs(1);
            boolean hasBaseData = consumer.hasStatsProtoData();
            if (fgMs == 0L && bgMs == 0L && !hasBaseData) continue;
            long token = proto.start(2246267895813L);
            proto.write(0x10500000001L, consumer.getUid());
            if (hasBaseData) {
                consumer.writeStatsProto(proto, 1146756268034L);
            }
            proto.write(0x10300000003L, fgMs);
            proto.write(1112396529668L, bgMs);
            for (int processState : UID_USAGE_TIME_PROCESS_STATES) {
                long timeInStateMillis = consumer.getTimeInProcessStateMs(processState);
                if (timeInStateMillis <= 0L) continue;
                long timeInStateToken = proto.start(2246267895813L);
                proto.write(0x10E00000001L, processState);
                proto.write(1112396529666L, timeInStateMillis);
                proto.end(timeInStateToken);
            }
            proto.end(token);
            if (proto.getRawSize() >= maxRawSize) break;
        }
    }

    private double getUidBatteryConsumerWeight(UidBatteryConsumer uidBatteryConsumer) {
        double consumedPower = uidBatteryConsumer.getConsumedPower();
        long timeInForeground = uidBatteryConsumer.getTimeInStateMs(0);
        long timeInBackground = uidBatteryConsumer.getTimeInStateMs(1);
        return consumedPower * 1.0 + (double)timeInForeground * 2.777777777777778E-5 + (double)timeInBackground * 8.333333333333333E-5;
    }

    public void dump(PrintWriter pw, String prefix) {
        int powerState;
        pw.print(prefix);
        pw.println("  Estimated power use (mAh):");
        pw.print(prefix);
        pw.print("    Capacity: ");
        pw.print(BatteryStats.formatCharge(this.getBatteryCapacity()));
        pw.print(", Computed drain: ");
        pw.print(BatteryStats.formatCharge(this.getConsumedPower()));
        Range<Double> dischargedPowerRange = this.getDischargedPowerRange();
        pw.print(", actual drain: ");
        pw.print(BatteryStats.formatCharge(dischargedPowerRange.getLower()));
        if (!((Object)dischargedPowerRange.getLower()).equals(dischargedPowerRange.getUpper())) {
            pw.print("-");
            pw.print(BatteryStats.formatCharge(dischargedPowerRange.getUpper()));
        }
        pw.println();
        pw.println("    Global");
        AggregateBatteryConsumer deviceConsumer = this.getAggregateBatteryConsumer(0);
        AggregateBatteryConsumer appsConsumer = this.getAggregateBatteryConsumer(1);
        for (int powerComponent : this.mBatteryConsumerDataLayout.powerComponentIds) {
            double devicePowerMah = deviceConsumer.getConsumedPower(powerComponent);
            double appsPowerMah = appsConsumer.getConsumedPower(powerComponent);
            if (devicePowerMah == 0.0 && appsPowerMah == 0.0) continue;
            this.printPowerComponent(pw, prefix, this.mBatteryConsumerDataLayout.getPowerComponentName(powerComponent), devicePowerMah, appsPowerMah, deviceConsumer.getUsageDurationMillis(powerComponent));
        }
        String prefixPlus = prefix + "  ";
        if (this.mIncludesPowerStateData && !this.mIncludesScreenStateData) {
            for (powerState = 0; powerState < 3; ++powerState) {
                if (powerState == 0) continue;
                this.dumpPowerComponents(pw, 0, powerState, prefixPlus);
            }
        } else if (!this.mIncludesPowerStateData && this.mIncludesScreenStateData) {
            for (int screenState = 0; screenState < 3; ++screenState) {
                if (screenState == 0) continue;
                this.dumpPowerComponents(pw, screenState, 0, prefixPlus);
            }
        } else if (this.mIncludesPowerStateData && this.mIncludesScreenStateData) {
            for (powerState = 0; powerState < 3; ++powerState) {
                if (powerState == 0) continue;
                for (int screenState = 0; screenState < 3; ++screenState) {
                    if (screenState == 0) continue;
                    this.dumpPowerComponents(pw, screenState, powerState, prefixPlus);
                }
            }
        }
        this.dumpSortedBatteryConsumers(pw, prefix, this.getUidBatteryConsumers());
        this.dumpSortedBatteryConsumers(pw, prefix, this.getUserBatteryConsumers());
        pw.println();
    }

    private void dumpPowerComponents(PrintWriter pw, int screenState, int powerState, String prefix) {
        AggregateBatteryConsumer deviceConsumer = this.getAggregateBatteryConsumer(0);
        AggregateBatteryConsumer appsConsumer = this.getAggregateBatteryConsumer(1);
        boolean labelPrinted = false;
        for (int powerComponent : this.mBatteryConsumerDataLayout.powerComponentIds) {
            BatteryConsumer.Dimensions dimensions = new BatteryConsumer.Dimensions(powerComponent, -1, screenState, powerState);
            double devicePowerMah = deviceConsumer.getConsumedPower(dimensions);
            double appsPowerMah = appsConsumer.getConsumedPower(dimensions);
            if (devicePowerMah == 0.0 && appsPowerMah == 0.0) continue;
            if (!labelPrinted) {
                boolean empty = true;
                StringBuilder stateLabel = new StringBuilder();
                stateLabel.append("      (");
                if (powerState != 0) {
                    stateLabel.append(BatteryConsumer.powerStateToString(powerState));
                    empty = false;
                }
                if (screenState != 0) {
                    if (!empty) {
                        stateLabel.append(", ");
                    }
                    stateLabel.append("screen ").append(BatteryConsumer.screenStateToString(screenState));
                    empty = false;
                }
                if (!empty) {
                    stateLabel.append(")");
                    pw.println(stateLabel);
                    labelPrinted = true;
                }
            }
            this.printPowerComponent(pw, prefix, this.mBatteryConsumerDataLayout.getPowerComponentName(powerComponent), devicePowerMah, appsPowerMah, deviceConsumer.getUsageDurationMillis(dimensions));
        }
    }

    private void printPowerComponent(PrintWriter pw, String prefix, String label, double devicePowerMah, double appsPowerMah, long durationMs) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("    ").append(label).append(": ").append(BatteryStats.formatCharge(devicePowerMah));
        sb.append(" apps: ").append(BatteryStats.formatCharge(appsPowerMah));
        if (durationMs != 0L) {
            sb.append(" duration: ");
            BatteryStats.formatTimeMs(sb, durationMs);
        }
        pw.println(sb);
    }

    private void dumpSortedBatteryConsumers(PrintWriter pw, String prefix, List<? extends BatteryConsumer> batteryConsumers) {
        batteryConsumers.sort(Comparator.comparingDouble(BatteryConsumer::getConsumedPower).reversed());
        for (BatteryConsumer batteryConsumer : batteryConsumers) {
            if (batteryConsumer.getConsumedPower() == 0.0) continue;
            pw.print(prefix);
            pw.print("  ");
            batteryConsumer.dump(pw);
        }
    }

    public void writeXml(TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(null, XML_TAG_BATTERY_USAGE_STATS);
        for (int i = 0; i < this.mCustomPowerComponentNames.length; ++i) {
            serializer.attribute(null, XML_ATTR_PREFIX_CUSTOM_COMPONENT + i, this.mCustomPowerComponentNames[i]);
        }
        serializer.attributeBoolean(null, XML_ATTR_PREFIX_INCLUDES_PROC_STATE_DATA, this.mIncludesProcessStateData);
        serializer.attributeBoolean(null, XML_ATTR_PREFIX_INCLUDES_SCREEN_STATE_DATA, this.mIncludesScreenStateData);
        serializer.attributeBoolean(null, XML_ATTR_PREFIX_INCLUDES_POWER_STATE_DATA, this.mIncludesPowerStateData);
        serializer.attributeLong(null, XML_ATTR_START_TIMESTAMP, this.mStatsStartTimestampMs);
        serializer.attributeLong(null, XML_ATTR_END_TIMESTAMP, this.mStatsEndTimestampMs);
        serializer.attributeLong(null, XML_ATTR_DURATION, this.mStatsDurationMs);
        serializer.attributeDouble(null, XML_ATTR_BATTERY_CAPACITY, this.mBatteryCapacityMah);
        serializer.attributeInt(null, XML_ATTR_DISCHARGE_PERCENT, this.mDischargePercentage);
        serializer.attributeDouble(null, XML_ATTR_DISCHARGE_LOWER, this.mDischargedPowerLowerBound);
        serializer.attributeDouble(null, XML_ATTR_DISCHARGE_UPPER, this.mDischargedPowerUpperBound);
        serializer.attributeLong(null, XML_ATTR_DISCHARGE_DURATION, this.mDischargeDurationMs);
        serializer.attributeLong(null, XML_ATTR_BATTERY_REMAINING, this.mBatteryTimeRemainingMs);
        serializer.attributeLong(null, XML_ATTR_CHARGE_REMAINING, this.mChargeTimeRemainingMs);
        for (int scope = 0; scope < 2; ++scope) {
            this.mAggregateBatteryConsumers[scope].writeToXml(serializer, scope);
        }
        for (UidBatteryConsumer uidBatteryConsumer : this.mUidBatteryConsumers) {
            uidBatteryConsumer.writeToXml(serializer);
        }
        for (UserBatteryConsumer userBatteryConsumer : this.mUserBatteryConsumers) {
            userBatteryConsumer.writeToXml(serializer);
        }
        serializer.endTag(null, XML_TAG_BATTERY_USAGE_STATS);
    }

    public static BatteryUsageStats createFromXml(TypedXmlPullParser parser) throws XmlPullParserException, IOException {
        return BatteryUsageStats.createBuilderFromXml(parser).build();
    }

    public static Builder createBuilderFromXml(TypedXmlPullParser parser) throws XmlPullParserException, IOException {
        Builder builder = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2 && parser.getName().equals(XML_TAG_BATTERY_USAGE_STATS)) {
                int index;
                ArrayList<String> customComponentNames = new ArrayList<String>();
                int i = 0;
                while ((index = parser.getAttributeIndex(null, XML_ATTR_PREFIX_CUSTOM_COMPONENT + i)) != -1) {
                    customComponentNames.add(parser.getAttributeValue(index));
                    ++i;
                }
                boolean includesProcStateData = parser.getAttributeBoolean(null, XML_ATTR_PREFIX_INCLUDES_PROC_STATE_DATA, false);
                boolean includesScreenStateData = parser.getAttributeBoolean(null, XML_ATTR_PREFIX_INCLUDES_SCREEN_STATE_DATA, false);
                boolean includesPowerStateData = parser.getAttributeBoolean(null, XML_ATTR_PREFIX_INCLUDES_POWER_STATE_DATA, false);
                builder = new Builder(customComponentNames.toArray(new String[0]), includesProcStateData, includesScreenStateData, includesPowerStateData, 0.0);
                builder.setStatsStartTimestamp(parser.getAttributeLong(null, XML_ATTR_START_TIMESTAMP));
                builder.setStatsEndTimestamp(parser.getAttributeLong(null, XML_ATTR_END_TIMESTAMP));
                builder.setStatsDuration(parser.getAttributeLong(null, XML_ATTR_DURATION));
                builder.setBatteryCapacity(parser.getAttributeDouble(null, XML_ATTR_BATTERY_CAPACITY));
                builder.addDischargePercentage(parser.getAttributeInt(null, XML_ATTR_DISCHARGE_PERCENT));
                builder.addDischargedPowerRange(parser.getAttributeDouble(null, XML_ATTR_DISCHARGE_LOWER), parser.getAttributeDouble(null, XML_ATTR_DISCHARGE_UPPER));
                builder.addDischargeDurationMs(parser.getAttributeLong(null, XML_ATTR_DISCHARGE_DURATION));
                builder.setBatteryTimeRemainingMs(parser.getAttributeLong(null, XML_ATTR_BATTERY_REMAINING));
                builder.setChargeTimeRemainingMs(parser.getAttributeLong(null, XML_ATTR_CHARGE_REMAINING));
                eventType = parser.next();
                break;
            }
            eventType = parser.next();
        }
        if (builder == null) {
            throw new XmlPullParserException("No root element");
        }
        while (eventType != 1) {
            if (eventType == 2) {
                switch (parser.getName()) {
                    case "aggregate": {
                        AggregateBatteryConsumer.parseXml(parser, builder);
                        break;
                    }
                    case "uid": {
                        UidBatteryConsumer.createFromXml(parser, builder);
                        break;
                    }
                    case "user": {
                        UserBatteryConsumer.createFromXml(parser, builder);
                    }
                }
            }
            eventType = parser.next();
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
        BatteryUsageStats.onCursorWindowReleased(this.mBatteryConsumersCursorWindow);
        this.mBatteryConsumersCursorWindow.close();
        this.mBatteryConsumersCursorWindow = null;
    }

    protected void finalize() throws Throwable {
        if (this.mBatteryConsumersCursorWindow != null) {
            this.mBatteryConsumersCursorWindow.close();
        }
        super.finalize();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dump(pw, "");
        pw.flush();
        return ((Object)sw).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onCursorWindowAllocated(CursorWindow window) {
        if (!sInstanceLeakDetectionEnabled) {
            return;
        }
        Class<BatteryUsageStats> clazz = BatteryUsageStats.class;
        synchronized (BatteryUsageStats.class) {
            if (sInstances == null) {
                sInstances = new HashMap<CursorWindow, Exception>();
            }
            sInstances.put(window, new Exception());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onCursorWindowReleased(CursorWindow window) {
        if (!sInstanceLeakDetectionEnabled) {
            return;
        }
        Class<BatteryUsageStats> clazz = BatteryUsageStats.class;
        synchronized (BatteryUsageStats.class) {
            sInstances.remove(window);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void enableInstanceLeakDetection() {
        sInstanceLeakDetectionEnabled = true;
        Class<BatteryUsageStats> clazz = BatteryUsageStats.class;
        synchronized (BatteryUsageStats.class) {
            if (sInstances != null) {
                sInstances.clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void assertAllInstancesClosed() {
        if (!sInstanceLeakDetectionEnabled) {
            throw new IllegalStateException("Instance leak detection is not enabled");
        }
        Class<BatteryUsageStats> clazz = BatteryUsageStats.class;
        synchronized (BatteryUsageStats.class) {
            if (sInstances != null && !sInstances.isEmpty()) {
                Exception callSite = sInstances.entrySet().iterator().next().getValue();
                int count = sInstances.size();
                sInstances.clear();
                throw new IllegalStateException("Instances of BatteryUsageStats not closed: " + count, callSite);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static class Builder {
        private final CursorWindow mBatteryConsumersCursorWindow;
        @NonNull
        private final String[] mCustomPowerComponentNames;
        private final boolean mIncludesProcessStateData;
        private final boolean mIncludesScreenStateData;
        private final boolean mIncludesPowerStateData;
        private final double mMinConsumedPowerThreshold;
        private final BatteryConsumer.BatteryConsumerDataLayout mBatteryConsumerDataLayout;
        private long mStatsStartTimestampMs;
        private long mStatsEndTimestampMs;
        private long mStatsDurationMs = -1L;
        private double mBatteryCapacityMah;
        private int mDischargePercentage;
        private double mDischargedPowerLowerBoundMah;
        private double mDischargedPowerUpperBoundMah;
        private long mDischargeDurationMs;
        private long mBatteryTimeRemainingMs = -1L;
        private long mChargeTimeRemainingMs = -1L;
        private final AggregateBatteryConsumer.Builder[] mAggregateBatteryConsumersBuilders = new AggregateBatteryConsumer.Builder[2];
        private final SparseArray<UidBatteryConsumer.Builder> mUidBatteryConsumerBuilders = new SparseArray();
        private final SparseArray<UserBatteryConsumer.Builder> mUserBatteryConsumerBuilders = new SparseArray();
        private BatteryStatsHistory mBatteryStatsHistory;
        private long mPreferredHistoryDurationMs;

        public Builder(@NonNull String[] customPowerComponentNames) {
            this(customPowerComponentNames, false, false, false, 0.0);
        }

        public Builder(@NonNull String[] customPowerComponentNames, boolean includeProcessStateData, boolean includeScreenStateData, boolean includesPowerStateData, double minConsumedPowerThreshold) {
            this.mBatteryConsumersCursorWindow = new CursorWindow(null, 20000000L);
            BatteryUsageStats.onCursorWindowAllocated(this.mBatteryConsumersCursorWindow);
            this.mBatteryConsumerDataLayout = BatteryConsumer.createBatteryConsumerDataLayout(customPowerComponentNames, includeProcessStateData, includeScreenStateData, includesPowerStateData);
            this.mBatteryConsumersCursorWindow.setNumColumns(this.mBatteryConsumerDataLayout.columnCount);
            this.mCustomPowerComponentNames = customPowerComponentNames;
            this.mIncludesProcessStateData = includeProcessStateData;
            this.mIncludesScreenStateData = includeScreenStateData;
            this.mIncludesPowerStateData = includesPowerStateData;
            this.mMinConsumedPowerThreshold = minConsumedPowerThreshold;
            for (int scope = 0; scope < 2; ++scope) {
                BatteryConsumer.BatteryConsumerData data = BatteryConsumer.BatteryConsumerData.create(this.mBatteryConsumersCursorWindow, this.mBatteryConsumerDataLayout);
                this.mAggregateBatteryConsumersBuilders[scope] = new AggregateBatteryConsumer.Builder(data, scope, this.mMinConsumedPowerThreshold);
            }
        }

        public boolean isProcessStateDataNeeded() {
            return this.mIncludesProcessStateData;
        }

        public boolean isScreenStateDataNeeded() {
            return this.mIncludesScreenStateData;
        }

        public boolean isPowerStateDataNeeded() {
            return this.mIncludesPowerStateData;
        }

        public boolean isSupportedPowerComponent(int componentId) {
            return componentId < 19 || componentId >= 1000 && componentId < 1000 + this.mBatteryConsumerDataLayout.customPowerComponentCount;
        }

        @NonNull
        public BatteryUsageStats build() {
            if (this.mBatteryConsumersCursorWindow == null) {
                throw new IllegalStateException("Builder has been discarded");
            }
            return new BatteryUsageStats(this);
        }

        public void discard() {
            this.mBatteryConsumersCursorWindow.close();
            BatteryUsageStats.onCursorWindowReleased(this.mBatteryConsumersCursorWindow);
        }

        public Builder setBatteryCapacity(double batteryCapacityMah) {
            this.mBatteryCapacityMah = batteryCapacityMah;
            return this;
        }

        public Builder setStatsStartTimestamp(long statsStartTimestampMs) {
            this.mStatsStartTimestampMs = statsStartTimestampMs;
            return this;
        }

        public Builder setStatsEndTimestamp(long statsEndTimestampMs) {
            this.mStatsEndTimestampMs = statsEndTimestampMs;
            return this;
        }

        public Builder setStatsDuration(long statsDurationMs) {
            this.mStatsDurationMs = statsDurationMs;
            return this;
        }

        public long getStatsDuration() {
            if (this.mStatsDurationMs != -1L) {
                return this.mStatsDurationMs;
            }
            return this.mStatsEndTimestampMs - this.mStatsStartTimestampMs;
        }

        @NonNull
        public Builder addDischargePercentage(int dischargePercentage) {
            this.mDischargePercentage += dischargePercentage;
            return this;
        }

        @NonNull
        public Builder addDischargedPowerRange(double dischargedPowerLowerBoundMah, double dischargedPowerUpperBoundMah) {
            this.mDischargedPowerLowerBoundMah += dischargedPowerLowerBoundMah;
            this.mDischargedPowerUpperBoundMah += dischargedPowerUpperBoundMah;
            return this;
        }

        @NonNull
        public Builder addDischargeDurationMs(long durationMs) {
            this.mDischargeDurationMs += durationMs;
            return this;
        }

        @NonNull
        public Builder setBatteryTimeRemainingMs(long batteryTimeRemainingMs) {
            this.mBatteryTimeRemainingMs = batteryTimeRemainingMs;
            return this;
        }

        @NonNull
        public Builder setChargeTimeRemainingMs(long chargeTimeRemainingMs) {
            this.mChargeTimeRemainingMs = chargeTimeRemainingMs;
            return this;
        }

        @NonNull
        public Builder setBatteryHistory(BatteryStatsHistory batteryStatsHistory, long preferredHistoryDurationMs) {
            this.mBatteryStatsHistory = batteryStatsHistory;
            this.mPreferredHistoryDurationMs = preferredHistoryDurationMs;
            return this;
        }

        @NonNull
        public AggregateBatteryConsumer.Builder getAggregateBatteryConsumerBuilder(int scope) {
            return this.mAggregateBatteryConsumersBuilders[scope];
        }

        @NonNull
        public UidBatteryConsumer.Builder getOrCreateUidBatteryConsumerBuilder(@NonNull BatteryStats.Uid batteryStatsUid) {
            int uid = batteryStatsUid.getUid();
            UidBatteryConsumer.Builder builder = this.mUidBatteryConsumerBuilders.get(uid);
            if (builder == null) {
                BatteryConsumer.BatteryConsumerData data = BatteryConsumer.BatteryConsumerData.create(this.mBatteryConsumersCursorWindow, this.mBatteryConsumerDataLayout);
                builder = new UidBatteryConsumer.Builder(data, batteryStatsUid, this.mMinConsumedPowerThreshold);
                this.mUidBatteryConsumerBuilders.put(uid, builder);
            }
            return builder;
        }

        @NonNull
        public UidBatteryConsumer.Builder getOrCreateUidBatteryConsumerBuilder(int uid) {
            UidBatteryConsumer.Builder builder = this.mUidBatteryConsumerBuilders.get(uid);
            if (builder == null) {
                BatteryConsumer.BatteryConsumerData data = BatteryConsumer.BatteryConsumerData.create(this.mBatteryConsumersCursorWindow, this.mBatteryConsumerDataLayout);
                builder = new UidBatteryConsumer.Builder(data, uid, this.mMinConsumedPowerThreshold);
                this.mUidBatteryConsumerBuilders.put(uid, builder);
            }
            return builder;
        }

        @NonNull
        public UserBatteryConsumer.Builder getOrCreateUserBatteryConsumerBuilder(int userId) {
            UserBatteryConsumer.Builder builder = this.mUserBatteryConsumerBuilders.get(userId);
            if (builder == null) {
                BatteryConsumer.BatteryConsumerData data = BatteryConsumer.BatteryConsumerData.create(this.mBatteryConsumersCursorWindow, this.mBatteryConsumerDataLayout);
                builder = new UserBatteryConsumer.Builder(data, userId, this.mMinConsumedPowerThreshold);
                this.mUserBatteryConsumerBuilders.put(userId, builder);
            }
            return builder;
        }

        @NonNull
        public SparseArray<UidBatteryConsumer.Builder> getUidBatteryConsumerBuilders() {
            return this.mUidBatteryConsumerBuilders;
        }

        @NonNull
        public Builder add(BatteryUsageStats stats) {
            boolean addingLaterSnapshot;
            if (!Arrays.equals(this.mCustomPowerComponentNames, stats.mCustomPowerComponentNames)) {
                throw new IllegalArgumentException("BatteryUsageStats have different custom power components");
            }
            if (this.mIncludesProcessStateData && !stats.mIncludesProcessStateData) {
                throw new IllegalArgumentException("Added BatteryUsageStats does not include process state data");
            }
            if (this.mUserBatteryConsumerBuilders.size() != 0 || !stats.getUserBatteryConsumers().isEmpty()) {
                throw new UnsupportedOperationException("Combining UserBatteryConsumers is not supported");
            }
            this.mDischargedPowerLowerBoundMah += stats.mDischargedPowerLowerBound;
            this.mDischargedPowerUpperBoundMah += stats.mDischargedPowerUpperBound;
            this.mDischargePercentage += stats.mDischargePercentage;
            this.mDischargeDurationMs += stats.mDischargeDurationMs;
            this.mStatsDurationMs = this.getStatsDuration() + stats.getStatsDuration();
            if (this.mStatsStartTimestampMs == 0L || stats.mStatsStartTimestampMs < this.mStatsStartTimestampMs) {
                this.mStatsStartTimestampMs = stats.mStatsStartTimestampMs;
            }
            boolean bl = addingLaterSnapshot = stats.mStatsEndTimestampMs > this.mStatsEndTimestampMs;
            if (addingLaterSnapshot) {
                this.mStatsEndTimestampMs = stats.mStatsEndTimestampMs;
            }
            for (int scope = 0; scope < 2; ++scope) {
                this.getAggregateBatteryConsumerBuilder(scope).add(stats.mAggregateBatteryConsumers[scope]);
            }
            for (UidBatteryConsumer consumer : stats.getUidBatteryConsumers()) {
                this.getOrCreateUidBatteryConsumerBuilder(consumer.getUid()).add(consumer);
            }
            if (addingLaterSnapshot) {
                this.mBatteryCapacityMah = stats.mBatteryCapacityMah;
                this.mBatteryTimeRemainingMs = stats.mBatteryTimeRemainingMs;
                this.mChargeTimeRemainingMs = stats.mChargeTimeRemainingMs;
            }
            return this;
        }

        void dump(PrintWriter writer) {
            int numRows = this.mBatteryConsumersCursorWindow.getNumRows();
            int numColumns = this.mBatteryConsumerDataLayout.columnCount;
            for (int i = 0; i < numRows; ++i) {
                StringBuilder sb = new StringBuilder();
                block8: for (int j = 0; j < numColumns; ++j) {
                    int type = this.mBatteryConsumersCursorWindow.getType(i, j);
                    switch (type) {
                        case 0: {
                            sb.append("null, ");
                            continue block8;
                        }
                        case 1: {
                            sb.append(this.mBatteryConsumersCursorWindow.getInt(i, j)).append(", ");
                            continue block8;
                        }
                        case 2: {
                            sb.append(this.mBatteryConsumersCursorWindow.getFloat(i, j)).append(", ");
                            continue block8;
                        }
                        case 3: {
                            sb.append(this.mBatteryConsumersCursorWindow.getString(i, j)).append(", ");
                            continue block8;
                        }
                        case 4: {
                            sb.append("BLOB, ");
                        }
                    }
                }
                sb.setLength(sb.length() - 2);
                writer.println(sb);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AggregateBatteryConsumerScope {
    }
}

