/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.IBinder;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class ArtModuleServiceManager {
    @NonNull
    public ServiceRegisterer getArtdServiceRegisterer() {
        return new ServiceRegisterer("artd", true);
    }

    @NonNull
    @FlaggedApi(value="android.content.pm.use_art_service_v2")
    public ServiceRegisterer getArtdPreRebootServiceRegisterer() {
        return new ServiceRegisterer("artd_pre_reboot", false);
    }

    @NonNull
    @FlaggedApi(value="android.content.pm.use_art_service_v2")
    public ServiceRegisterer getDexoptChrootSetupServiceRegisterer() {
        return new ServiceRegisterer("dexopt_chroot_setup", true);
    }

    public static class ServiceRegisterer {
        @NonNull
        private final String mServiceName;
        private final boolean mRetry;

        public ServiceRegisterer(@NonNull String serviceName, boolean retry) {
            this.mServiceName = serviceName;
            this.mRetry = retry;
        }

        @Nullable
        public IBinder waitForService() {
            if (this.mRetry) {
                return ServiceManager.waitForService((String)this.mServiceName);
            }
            IBinder binder = ServiceManager.getService(this.mServiceName);
            for (int remainingTimeMs = 5000; binder == null && remainingTimeMs > 0; remainingTimeMs -= 100) {
                SystemProperties.set("ctl.start", this.mServiceName);
                SystemClock.sleep(100L);
                binder = ServiceManager.getService(this.mServiceName);
            }
            return binder;
        }
    }
}

