/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.FormatException;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.MifareClassic;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class NdefFormatable
extends BasicTagTechnology {
    private static final String TAG = "NFC";

    public static NdefFormatable get(Tag tag) {
        if (!tag.hasTech(7)) {
            return null;
        }
        try {
            return new NdefFormatable(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NdefFormatable(Tag tag) throws RemoteException {
        super(tag, 7);
    }

    public void format(NdefMessage firstMessage) throws IOException, FormatException {
        this.format(firstMessage, false);
    }

    public void formatReadOnly(NdefMessage firstMessage) throws IOException, FormatException {
        this.format(firstMessage, true);
    }

    void format(NdefMessage firstMessage, boolean makeReadOnly) throws IOException, FormatException {
        this.checkConnected();
        try {
            int serviceHandle = this.mTag.getServiceHandle();
            INfcTag tagService = this.mTag.getTagService();
            if (tagService == null) {
                throw new IOException();
            }
            int errorCode = tagService.formatNdef(serviceHandle, MifareClassic.KEY_DEFAULT);
            switch (errorCode) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new IOException();
                }
                case -8: {
                    throw new FormatException();
                }
                default: {
                    throw new IOException();
                }
            }
            if (!tagService.isNdef(serviceHandle)) {
                throw new IOException();
            }
            if (firstMessage != null) {
                errorCode = tagService.ndefWrite(serviceHandle, firstMessage);
                switch (errorCode) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        throw new IOException();
                    }
                    case -8: {
                        throw new FormatException();
                    }
                    default: {
                        throw new IOException();
                    }
                }
            }
            if (makeReadOnly) {
                errorCode = tagService.ndefMakeReadOnly(serviceHandle);
                switch (errorCode) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        throw new IOException();
                    }
                    case -8: {
                        throw new IOException();
                    }
                    default: {
                        throw new IOException();
                    }
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
        }
    }
}

